/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection.semantic.extension;

import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.utils.DVTIdentityArrayList;

public class HidOperatorVisitor
implements IHidVisitor<HidOperator> {
    private List<IHidOperator> objects = new DVTIdentityArrayList<IHidOperator>();
    private int operatorType;
    private long qualifierSet;
    private Set<ParserPath> changedFiles;
    protected ParserPath parserPath;
    protected IRfNamedElement scope;

    public HidOperatorVisitor(int operatorType) {
        this(null, null);
        this.operatorType = operatorType;
    }

    public HidOperatorVisitor(HidOperatorQualifier[] qualifiers) {
        this(qualifiers, null);
    }

    public HidOperatorVisitor(HidOperatorQualifier[] qualifiers, Set<ParserPath> changedFiles) {
        this.changedFiles = changedFiles;
        if (qualifiers != null) {
            HidOperatorQualifier[] hidOperatorQualifierArray = qualifiers;
            int n = qualifiers.length;
            int n2 = 0;
            while (n2 < n) {
                HidOperatorQualifier qualifier = hidOperatorQualifierArray[n2];
                if (qualifier != null) {
                    this.qualifierSet |= qualifier.value();
                }
                ++n2;
            }
        }
    }

    @Override
    public void setHolder(IHidHolder holder) {
        if (holder instanceof HidHolder) {
            this.scope = ((HidHolder)holder).getScope();
        }
    }

    @Override
    public void setParserPath(ParserPath parserPath) {
        this.parserPath = parserPath;
    }

    @Override
    public boolean visit(HidOperator operator) {
        if (this.changedFiles != null && !this.changedFiles.contains(this.parserPath)) {
            return true;
        }
        return (this.qualifierSet == 0L || !operator.hasOccurrence(this.qualifierSet)) && (this.operatorType == 0 || this.operatorType != operator.getOperatorType()) || this.visitHit(operator, this.scope);
    }

    public boolean visitHit(HidOperator operator, IRfNamedElement scope) {
        this.objects.add(operator);
        return true;
    }

    @NotNull
    public List<IHidOperator> getObjects() {
        return this.objects;
    }

    @Override
    public Class<HidOperator> getType() {
        return HidOperator.class;
    }
}

