/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection.semantic.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.Predicate;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IReparseInfo;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IDataType;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidAccessArgs;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidBuilders;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicitConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISContext;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataUtils;
import ro.amiq.dvt.model.reflection.util.AssociationUtils;
import ro.amiq.dvt.model.reflection.util.GenericValueUtils;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.model.reflection.util.PortConnectionUtils;
import ro.amiq.dvt.optimized.collections.ArrayListContainer;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTUnpackedArray;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.dvt.utils.VlogBitVector;

public interface HidUtils {
    public static final int MAX_TO_STRING_DEPTH = 512;
    public static final IHidBuilders DEFAULT_BUILDERS = new IHidBuilders(){

        @Override
        public Hid buildHid(String name, IRfNamedElement resolved, HidOccurrence occurrence, long hidQualifiers) {
            return HidUtils.makeStandInHid(name, resolved, occurrence, hidQualifiers);
        }

        @Override
        public HidAccess buildAccess(Hid first, Hid second, int access) {
            return HidUtils.makeStandInAccess(first, second, access);
        }

        @Override
        public HidAccess buildAccess(Hid parent, Hid child, List<IHidObject> selects, int access) {
            return null;
        }

        @Override
        public HidOperator buildOperator(IHidObject lhSide, List<IHidObject> rhSide, int type, IHidOperatorConstants.OperatorKind kind, String text, HidOperatorOccurrence occurrence, long operatorQualifiers) {
            return HidUtils.makeStandInOperator(lhSide, rhSide, type, kind, text, occurrence, operatorQualifiers);
        }

        @Override
        public HidImplicit buildImplicit(String name, int type) {
            return HidUtils.makeStandInImplicit(name, type);
        }

        @Override
        public HidOperator buildDefparamOperator(ElementPath hierarchyPath, IRfScopeElement param, String value, int offset) {
            return null;
        }

        @Override
        public HidOperator buildNotOperator(IHidObject condition, HidOperatorOccurrence occurrence) {
            return null;
        }

        @Override
        public HidOperator buildCycleDelayConstOperator(IHidObject lhSide, List<IHidObject> rhSide, IHidOperatorConstants.OperatorKind kind, HidOperatorOccurrence occurrence) {
            return null;
        }

        @Override
        public HidOperator buildCycleDelayRangeOperator(IHidObject lhSide, List<IHidObject> rhSide, IHidOperatorConstants.OperatorKind kind, HidOperatorOccurrence occurrence) {
            return null;
        }
    };
    public static final /* synthetic */ int[] $SWITCH_TABLE$ro$amiq$dvt$model$reflection$semantic$extension$IHidObject$HidKind;

    static {
        $SWITCH_TABLE$ro$amiq$dvt$model$reflection$semantic$extension$IHidObject$HidKind = HidUtils.$SWITCH_TABLE$ro$amiq$dvt$model$reflection$semantic$extension$IHidObject$HidKind();
    }

    public static boolean hasHidKind(IHidObject object, IHidObject.HidKind kind) {
        return object != null && object.getHidKind() == kind;
    }

    public static boolean isHid(IHidObject object) {
        return HidUtils.hasHidKind(object, IHidObject.HidKind.HID);
    }

    public static boolean isSimpleHid(IHidObject object) {
        return HidUtils.isHid(object) && ((Hid)object).getParentAccess() == null;
    }

    public static boolean isHidAccess(IHidObject object) {
        return HidUtils.hasHidKind(object, IHidObject.HidKind.ACCESS);
    }

    public static boolean isHidAccessArgs(IHidObject object) {
        return object instanceof IHidAccessArgs && ((HidAccess)object).parentHid != null && ((HidAccess)object).parentHid.getElement() instanceof IRfMethodElement;
    }

    public static boolean isHidAccessWithRangeSelect(IHidObject object) {
        return HidUtils.hasHidKind(object, IHidObject.HidKind.ACCESS) && ((HidAccess)object).isRangeSelect();
    }

    public static boolean isHidAccessWithBitSelect(IHidObject object) {
        return HidUtils.hasHidKind(object, IHidObject.HidKind.ACCESS) && ((HidAccess)object).isBitSelect();
    }

    public static boolean isHidImplicit(IHidObject object) {
        return HidUtils.hasHidKind(object, IHidObject.HidKind.IMPLICIT);
    }

    public static boolean isOperator(IHidObject object) {
        return HidUtils.hasHidKind(object, IHidObject.HidKind.OPERATOR);
    }

    public static boolean isOperator(IHidObject object, long qualifiers) {
        return HidUtils.hasHidKind(object, IHidObject.HidKind.OPERATOR) && ((HidOperator)object).hasOccurrence(qualifiers);
    }

    public static boolean isOperatorOfType(IHidObject object, IHidOperatorConstants.OperatorType type) {
        return HidUtils.hasHidKind(object, IHidObject.HidKind.OPERATOR) && ((HidOperator)object).getOperatorType() == type.id;
    }

    public static boolean isOperatorOfAnyType(IHidObject object, IHidOperatorConstants.OperatorType ... type) {
        if (!HidUtils.hasHidKind(object, IHidObject.HidKind.OPERATOR)) {
            return false;
        }
        IHidOperatorConstants.OperatorType[] operatorTypeArray = type;
        int n = type.length;
        int n2 = 0;
        while (n2 < n) {
            IHidOperatorConstants.OperatorType operatorType = operatorTypeArray[n2];
            if (((HidOperator)object).getOperatorType() == operatorType.id) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isOperatorOfKind(IHidObject object, IHidOperatorConstants.OperatorKind operatorKind) {
        return HidUtils.hasHidKind(object, IHidObject.HidKind.OPERATOR) && ((HidOperator)object).getOperatorKind() == operatorKind;
    }

    public static boolean isHidHolder(IHidObject object) {
        return HidUtils.hasHidKind(object, IHidObject.HidKind.HOLDER);
    }

    public static boolean isVariadicOperand(IHidObject object) {
        return HidUtils.isHidImplicit(object) && ((IHidImplicit)object).isVariadicOperand();
    }

    @NotNull
    public static String toString(IHidObject value, boolean showCompletePath, boolean showCompleteOperator) {
        return HidUtils.toStringBuilder(value, showCompletePath, showCompleteOperator, false, false, true, true).toString();
    }

    public static String toConstraintString(IHidObject hidObject) {
        return hidObject.toConstraintString();
    }

    @NotNull
    public static String toNiceString(IHidObject value) {
        return HidUtils.toStringBuilder(value, true, true, true, true, true, false).toString();
    }

    @NotNull
    public static String toNiceStringVHDL(IHidObject value) {
        return HidUtils.toStringBuilder(value, true, true, true, true, true, false, LanguageKind.VHDL).toString();
    }

    public static int nofBits(IHidObject value, boolean isItemSelect) {
        if (value == null) {
            return -1;
        }
        switch (value.getHidKind()) {
            case HID: {
                BitVectorContext context;
                IRfNamedElement element = ((Hid)value).getElement();
                if (element instanceof IRfFieldElement && (context = ((IRfFieldElement)element).getDataTypeBitVectorContext(new IHidEvaluator.NullHidEvaluator(), false, null, null)) != null) {
                    DVTNumber number = context.getContextNumber();
                    if (isItemSelect & number instanceof DVTUnpackedArray) {
                        return ((DVTUnpackedArray)number).getBaseElementSize();
                    }
                    if (isItemSelect & number instanceof VlogBitVector) {
                        return 1;
                    }
                    if (number != null) {
                        return number.getSize();
                    }
                }
                return -1;
            }
            case ACCESS: {
                List<IHidObject> selects = ((HidAccess)value).getSelects();
                if (selects != null && !selects.isEmpty()) {
                    IHidObject select = selects.get(0);
                    boolean isRangeSelect = HidUtils.isOperator(select) && ((HidOperator)select).isRangeOrPartSelect();
                    return HidUtils.nofBits(((HidAccess)value).parentHid, !isRangeSelect);
                }
                return -1;
            }
            case OPERATOR: {
                int nofBits = 0;
                if (((IHidOperator)value).hasOccurrence(HidQualifierCache.IS_CONCATENATION_QUALIFIER)) {
                    ListContainer<IHidObject> rhValues = ((IHidOperator)value).getRHValues();
                    for (IHidObject rhValue : rhValues) {
                        int subNofBits = HidUtils.nofBits(rhValue, false);
                        if (subNofBits <= 0) {
                            return -1;
                        }
                        nofBits += subNofBits;
                    }
                }
                return nofBits;
            }
        }
        return -1;
    }

    public static StringBuilder toStringBuilder(IHidObject value, boolean showCompletePath, boolean showCompleteOperator, boolean addOperatorParentheses, boolean translateAssociations, boolean showMethodCallArguments, boolean showInvisibleAccess, LanguageKind languageKind) {
        StringBuilder rez = HidUtils.toStringBuilderInternal(value, showCompletePath, showCompleteOperator, addOperatorParentheses, translateAssociations, showMethodCallArguments, showInvisibleAccess, languageKind, 0);
        return rez;
    }

    public static StringBuilder toStringBuilder(IHidObject value, boolean showCompletePath, boolean showCompleteOperator, boolean addOperatorParentheses, boolean translateAssociations, boolean showMethodCallArguments, boolean showInvisibleAccess) {
        StringBuilder rez = HidUtils.toStringBuilderInternal(value, showCompletePath, showCompleteOperator, addOperatorParentheses, translateAssociations, showMethodCallArguments, showInvisibleAccess, null, 0);
        return rez;
    }

    public static StringBuilder toStringBuilderInternal(IHidObject value, boolean showCompletePath, boolean showCompleteOperator, boolean addOperatorParentheses, boolean translateAssociations, boolean showMethodCallArguments, boolean showInvisibleAccess, LanguageKind languageKind, int callcount) {
        int n = ++callcount;
        ++callcount;
        if (n > 512) {
            return new StringBuilder("...");
        }
        if (value == null) {
            return new StringBuilder("");
        }
        StringBuilder text = new StringBuilder();
        switch (value.getHidKind()) {
            case HID: {
                Hid hid = (Hid)value;
                if (hid.isExternalName() && hid.hasAccesses()) {
                    return HidUtils.toStringBuilderInternal(hid.getAccesses().get(0), showCompletePath, showCompleteOperator, addOperatorParentheses, translateAssociations, showMethodCallArguments, showInvisibleAccess, languageKind, callcount);
                }
                HidAccess parentAccess = hid.getParentAccess();
                if (showCompletePath && parentAccess != null && (showInvisibleAccess || !HidUtils.isInvisibleAccess(parentAccess))) {
                    text.append((CharSequence)HidUtils.toStringBuilderInternal(parentAccess, showCompletePath, showCompleteOperator, addOperatorParentheses, translateAssociations, showMethodCallArguments, showInvisibleAccess, languageKind, callcount));
                }
                text.append(hid.getName());
                break;
            }
            case ACCESS: {
                int accessKind;
                IDataType dataType;
                HidAccess access = (HidAccess)value;
                Hid parentHid = access.getParentHid();
                if (showCompletePath && parentHid != null && !access.isExternalName()) {
                    text.append((CharSequence)HidUtils.toStringBuilderInternal(parentHid, showCompletePath, showCompleteOperator, addOperatorParentheses, translateAssociations, showMethodCallArguments, showInvisibleAccess, languageKind, callcount));
                }
                if ((dataType = access.getDataType()) != null) {
                    if (dataType.getSign() == 1) {
                        text.append(" signed");
                    } else if (dataType.getSign() == 2) {
                        text.append(" unsigned");
                    }
                }
                boolean hasArgumentValues = false;
                if (access instanceof IHidAccessArgs) {
                    List<? extends IHidObject> argumentValues = ((IHidAccessArgs)((Object)access)).getArgumentValues();
                    if (((IHidAccessArgs)((Object)access)).hasEmptyParentheses()) {
                        text.append("()");
                    } else if (argumentValues != null && !argumentValues.isEmpty()) {
                        hasArgumentValues = true;
                        if (showMethodCallArguments) {
                            StringJoiner sj = new StringJoiner(", ");
                            for (IHidObject iHidObject : argumentValues) {
                                sj.add(HidUtils.toStringBuilderInternal(iHidObject, showCompletePath, true, addOperatorParentheses, translateAssociations, showMethodCallArguments, showInvisibleAccess, languageKind, callcount));
                            }
                            text.append("(").append(sj.toString()).append(")");
                        } else {
                            text.append("()");
                        }
                    }
                    IHidOperator withClause = ((IHidAccessArgs)((Object)access)).getWithClause();
                    if (withClause != null) {
                        text.append(" ").append((CharSequence)HidUtils.toStringBuilderInternal(withClause, showCompletePath, true, addOperatorParentheses, translateAssociations, showMethodCallArguments, showInvisibleAccess, languageKind, callcount));
                    }
                }
                if (access.isSelect()) {
                    if (languageKind == null) {
                        languageKind = access.getLanguageKind();
                    }
                    if (LanguageKind.VHDL != languageKind || !hasArgumentValues) {
                        String selectsSymbol = LanguageKind.VHDL == languageKind ? "()" : "[]";
                        for (IHidObject select : access.getSelects()) {
                            boolean isRangeSelect = select instanceof HidOperator && ((HidOperator)select).isRangeOrPartSelect();
                            boolean isExternalName = HidUtils.isOperatorOfType(select, IHidOperatorConstants.OperatorType.EXTERNAL_NAME);
                            if (!isRangeSelect && !isExternalName) {
                                text.append(selectsSymbol.charAt(0));
                            }
                            text.append((CharSequence)HidUtils.toStringBuilderInternal(select, showCompletePath, true, false, translateAssociations, showMethodCallArguments, showInvisibleAccess, languageKind, callcount));
                            if (isRangeSelect || isExternalName) continue;
                            text.append(selectsSymbol.charAt(1));
                        }
                    }
                }
                if ((accessKind = access.getAccessKind()) == Integer.MIN_VALUE) break;
                if (!(accessKind != 0 && accessKind != 3 && accessKind != 4 || parentHid != null && parentHid.hasQualifier(HidQualifierCache.EXTERNAL_PATH_NAME) && "@".equals(parentHid.getName()))) {
                    text.append(".");
                }
                if (accessKind == 1) {
                    text.append(":");
                }
                if (accessKind == 2) {
                    text.append("::");
                }
                if (accessKind != 5) break;
                text.append("'");
                break;
            }
            case OPERATOR: {
                HidOperator operator = (HidOperator)value;
                IHidOperatorConstants.OperatorKind operatorKind = operator.getOperatorKind();
                if (!showCompleteOperator) {
                    text.append(operator.getOperatorText());
                    break;
                }
                if (translateAssociations) {
                    if (operator.hasOccurrence(HidOperatorQualifier.IS_ARGUMENT_VALUE)) {
                        text.append(MethodCallUtils.toStringBuilder(operator, showCompletePath, showCompleteOperator, addOperatorParentheses, translateAssociations, showMethodCallArguments, showInvisibleAccess, languageKind));
                        break;
                    }
                    if (operator.hasOccurrence(HidOperatorQualifier.IS_GENERIC_VALUE)) {
                        text.append(GenericValueUtils.toStringBuilder(operator, showCompletePath, showCompleteOperator, addOperatorParentheses, translateAssociations, showMethodCallArguments, showInvisibleAccess, languageKind));
                        break;
                    }
                    if (operator.hasOccurrence(HidOperatorQualifier.IS_PORT_CONNECTION)) {
                        text.append(PortConnectionUtils.toStringBuilder(operator, showCompletePath, showCompleteOperator, addOperatorParentheses, translateAssociations, showMethodCallArguments, showInvisibleAccess, languageKind));
                        break;
                    }
                    if (operator.hasOccurrence(HidOperatorQualifier.IS_PATTERN_VALUE)) {
                        text.append(AssociationUtils.patternToStringBuilder(operator, HidQualifierCache.IS_PATTERN_VALUE_QUALIFIER, showCompletePath, showCompleteOperator, addOperatorParentheses, translateAssociations, showMethodCallArguments, showInvisibleAccess, languageKind));
                        break;
                    }
                }
                if (value instanceof XInstValueHolder.XSelectOperator) {
                    text.append((CharSequence)HidUtils.toStringBuilderInternal(((XInstValueHolder.XSelectOperator)value).getLHValue(), showCompletePath, showCompleteOperator, addOperatorParentheses, translateAssociations, showMethodCallArguments, showInvisibleAccess, languageKind, callcount));
                    text.append("[").append(((XInstValueHolder.XSelectOperator)value).getLeft()).append(":").append(((XInstValueHolder.XSelectOperator)value).getRight()).append("]");
                    break;
                }
                if (operator.getOperatorType() == IHidOperatorConstants.OperatorType.IF_ELSE_STATEMENT.id) {
                    ListContainer<IHidObject> rhValues = operator.getRHValues();
                    StringBuilder leftHandSide = HidUtils.toStringBuilderInternal(operator.getLHValue(), showCompletePath, showCompleteOperator, addOperatorParentheses, translateAssociations, showMethodCallArguments, showInvisibleAccess, languageKind, callcount);
                    if (rhValues.size() == 1) {
                        text.append((CharSequence)leftHandSide).append(" -> ");
                        text.append((CharSequence)HidUtils.toStringBuilderInternal(rhValues.get(0), showCompletePath, showCompleteOperator, addOperatorParentheses, translateAssociations, showMethodCallArguments, showInvisibleAccess, languageKind, callcount));
                    } else if (rhValues.size() == 2) {
                        text.append("if ( ").append((CharSequence)leftHandSide).append(" ) { ");
                        text.append((CharSequence)HidUtils.toStringBuilderInternal(rhValues.get(0), showCompletePath, showCompleteOperator, addOperatorParentheses, translateAssociations, showMethodCallArguments, showInvisibleAccess, languageKind, callcount));
                        text.append(" } else { ");
                        text.append((CharSequence)HidUtils.toStringBuilderInternal(rhValues.get(1), showCompletePath, showCompleteOperator, addOperatorParentheses, translateAssociations, showMethodCallArguments, showInvisibleAccess, languageKind, callcount));
                        text.append(" }");
                    }
                    return text;
                }
                ListContainer<IHidObject> rhValues = operator.getRHValues();
                if (rhValues != null) {
                    int size = rhValues.size();
                    if (HidUtils.isOperatorOfType(operator, IHidOperatorConstants.OperatorType.EXTERNAL_NAME)) {
                        text.append((CharSequence)HidUtils.toStringBuilderInternal(rhValues.get(2), showCompletePath, showCompleteOperator, addOperatorParentheses, translateAssociations, showMethodCallArguments, showInvisibleAccess, languageKind, callcount));
                        text.append(" ");
                        text.append((CharSequence)HidUtils.toStringBuilderInternal(rhValues.get(1), showCompletePath, showCompleteOperator, addOperatorParentheses, translateAssociations, showMethodCallArguments, showInvisibleAccess, languageKind, callcount));
                        text.append(" : ");
                        text.append((CharSequence)HidUtils.toStringBuilderInternal(rhValues.get(0), showCompletePath, showCompleteOperator, addOperatorParentheses, translateAssociations, showMethodCallArguments, showInvisibleAccess, languageKind, callcount));
                    } else {
                        int i = size - 1;
                        while (i >= 0) {
                            IHidObject rhValue = rhValues.get(i);
                            text.append((CharSequence)HidUtils.toStringBuilderInternal(rhValue, showCompletePath, showCompleteOperator, addOperatorParentheses, translateAssociations, showMethodCallArguments, showInvisibleAccess, languageKind, callcount));
                            if (i > 0) {
                                if (operatorKind == IHidOperatorConstants.OperatorKind.TERNARY_OPERATOR) {
                                    text.append(operator.isConditionalTernary() ? " : " : " ");
                                } else if (operatorKind == IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR) {
                                    boolean isNvConcatReplic;
                                    IHidObject nextValue = rhValues.get(i - 1);
                                    boolean isRhConcatReplic = rhValue instanceof HidImplicit && ((HidImplicit)rhValue).isConcatenationReplication();
                                    boolean bl = isNvConcatReplic = nextValue instanceof HidImplicit && ((HidImplicit)nextValue).isConcatenationReplication();
                                    if (!isRhConcatReplic && !isNvConcatReplic) {
                                        text.append(", ");
                                    }
                                }
                            }
                            --i;
                        }
                    }
                }
                String operatorText = operator.getOperatorText();
                String spaceBefore = "";
                if (operatorKind == IHidOperatorConstants.OperatorKind.BINARY_OPERATOR || operatorKind == IHidOperatorConstants.OperatorKind.TERNARY_OPERATOR) {
                    spaceBefore = " ";
                    if (operatorText == null || operatorText.isEmpty() || operator.isSequenceCycleDelayRange()) {
                        text = new StringBuilder().append((CharSequence)text);
                    } else {
                        boolean isAssigmentPatternWithTick;
                        boolean bl = isAssigmentPatternWithTick = operatorText.charAt(0) == '\'' && text.length() > 1 && text.charAt(0) == '\'' && text.charAt(1) == '{';
                        if (!isAssigmentPatternWithTick) {
                            text = new StringBuilder().append(operatorText).append(" ").append((CharSequence)text);
                        }
                    }
                }
                char leftHandCharacter = '\u0000';
                StringBuilder leftHandSide = HidUtils.toStringBuilderInternal(operator.getLHValue(), showCompletePath, showCompleteOperator, addOperatorParentheses, translateAssociations, showMethodCallArguments, showInvisibleAccess, languageKind, callcount);
                String string = spaceBefore = text.length() == 0 ? "" : spaceBefore;
                if (leftHandSide.length() > 1) {
                    text = leftHandSide.append(spaceBefore).append((CharSequence)text);
                } else if (leftHandSide.length() == 1 && ',' != (leftHandCharacter = leftHandSide.charAt(0)) && '|' != leftHandCharacter) {
                    text = leftHandSide.append(spaceBefore).append((CharSequence)text);
                }
                if (operator.isConcatOrAssignPatternOperator() || operator.isSeqBlockStatement() || operator.isConstraintSeqBlock() && '{' == leftHandCharacter || operator.isInsideSet() || operator.isDistSet()) {
                    text.append("}");
                } else if (operator.isAggregate()) {
                    text.append(")");
                } else if (operator.isExternalName()) {
                    text.append(" >>");
                } else if (operator.isSignature()) {
                    addOperatorParentheses = false;
                    text = new StringBuilder().append("[").append((CharSequence)text).append("]");
                } else if (operator.isTypeReference()) {
                    addOperatorParentheses = false;
                    text = new StringBuilder().append("(").append((CharSequence)text).append(")");
                } else if (operator.isRangeOrPartSelect()) {
                    addOperatorParentheses = false;
                    String selectsSymbol = LanguageKind.VHDL == languageKind ? "()" : "[]";
                    text = new StringBuilder().append(selectsSymbol.charAt(0)).append((CharSequence)text).append(selectsSymbol.charAt(1));
                }
                if (operatorKind == IHidOperatorConstants.OperatorKind.UNARY_OPERATOR) {
                    if (operatorText != null && !operatorText.isEmpty()) {
                        if (operator.isIncrementOrDecrement() && operator.hasOccurrence(HidQualifierCache.IS_DEFERRED_UPDATE_QUALIFIER)) {
                            text.append(" ").append(operatorText);
                        } else {
                            text = new StringBuilder().append(operatorText).append(text.length() == 0 ? "" : " ").append((CharSequence)text);
                        }
                    }
                    if (operator.isSequenceRepetition()) {
                        text.append("]");
                    }
                }
                if (!addOperatorParentheses || operatorKind != IHidOperatorConstants.OperatorKind.BINARY_OPERATOR && operatorKind != IHidOperatorConstants.OperatorKind.TERNARY_OPERATOR) break;
                text = new StringBuilder("(").append((CharSequence)text).append(")");
                break;
            }
            case IMPLICIT: {
                HidImplicit hidImplicit = (HidImplicit)value;
                String name = hidImplicit.getName();
                if (name != null) {
                    text.append(name.startsWith("struct/") ? "struct" : (name.startsWith("enum/") ? "enum" : (name.startsWith("union/") ? "union" : name)));
                    break;
                }
                text.append("(").append(hidImplicit.getType()).append(")");
                break;
            }
        }
        return text;
    }

    public static boolean isInvisibleAccess(HidAccess access) {
        return access.getAccessKind() == 3 || access.getAccessKind() == 4 || access.getParentHid() != null && access.getParentHid().hasQualifier(HidQualifierCache.HIDDEN);
    }

    public static boolean isResolved(IHidObject value) {
        if (value == null) {
            return false;
        }
        switch (value.getHidKind()) {
            case HID: {
                return ((Hid)value).getElement() != null;
            }
            case ACCESS: {
                HidAccess access = (HidAccess)value;
                return access.getParentHid() != null && access.getParentHid().getElement() != null || access.getAssociatedType() != null;
            }
            case OPERATOR: {
                return ((HidOperator)value).getOperatorResolvedType() != null;
            }
        }
        return false;
    }

    public static IRfNamedElement getResolvedElement(IHidObject hidObject) {
        if (hidObject == null) {
            return null;
        }
        switch (hidObject.getHidKind()) {
            case HID: {
                return ((Hid)hidObject).getElement();
            }
            case OPERATOR: {
                ISDataAbstract operatorResolvedType = ((HidOperator)hidObject).getOperatorResolvedType();
                ISDataType dataType = SDataUtils.getDataType(operatorResolvedType);
                return dataType != null ? dataType.getType() : null;
            }
        }
        return null;
    }

    @NotNull
    public static Set<IHid> flattenToUniqueHids(List<IHidObject> values, Set<HidFlatteningOption> options) {
        if (values == null || values.isEmpty()) {
            return Collections.emptySet();
        }
        Set<IHid> hids = Collections.newSetFromMap(new IdentityHashMap());
        Predicate<IHidObject> result = element -> {
            IHid hid = HidUtils.getHidFrom(element);
            if (hid != null) {
                hids.add(hid);
            }
            return true;
        };
        for (IHidObject value : values) {
            HidUtils.flattenToObjects(result, value, options);
        }
        return hids;
    }

    @NotNull
    public static Set<IHid> flattenToHids(List<IHidObject> values, Set<HidFlatteningOption> options) {
        if (values == null || values.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<IHid> hids = new LinkedHashSet<IHid>();
        Predicate<IHidObject> result = element -> {
            IHid hid = HidUtils.getHidFrom(element);
            if (hid != null) {
                hids.add(hid);
            }
            return true;
        };
        for (IHidObject value : values) {
            HidUtils.flattenToObjects(result, value, options);
        }
        return hids;
    }

    @NotNull
    public static Set<IHid> flattenToUniqueHids(IHidObject value, Set<HidFlatteningOption> options) {
        if (value == null) {
            return Collections.emptySet();
        }
        Set<IHid> hids = Collections.newSetFromMap(new IdentityHashMap());
        Predicate<IHidObject> result = element -> {
            IHid hid = HidUtils.getHidFrom(element);
            if (hid != null) {
                hids.add(hid);
            }
            return true;
        };
        HidUtils.flattenToObjects(result, value, options);
        return hids;
    }

    @NotNull
    public static Set<IHid> flattenToHids(IHidObject value, Set<HidFlatteningOption> options) {
        if (value == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<IHid> hids = new LinkedHashSet<IHid>();
        Predicate<IHidObject> result = element -> {
            IHid hid = HidUtils.getHidFrom(element);
            if (hid != null) {
                hids.add(hid);
            }
            return true;
        };
        HidUtils.flattenToObjects(result, value, options);
        return hids;
    }

    @NotNull
    public static void flattenToObjects(Predicate<IHidObject> result, IHidObject value, Set<HidFlatteningOption> options) {
        if (value == null) {
            return;
        }
        IHidObject.HidKind hidKind = value.getHidKind();
        switch (hidKind) {
            case HID: {
                if (options.contains((Object)HidFlatteningOption.IGNORE_HIDS)) break;
                if (!options.contains((Object)HidFlatteningOption.IGNORE_SELECTS) && !options.contains((Object)HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS)) {
                    Hid parentHid = (Hid)value;
                    HidAccess parentHidAccess = null;
                    while (parentHid != null && (parentHidAccess = parentHid.getParentAccess()) != null) {
                        if (parentHidAccess.isSelect()) {
                            if (options.contains((Object)HidFlatteningOption.IGNORE_IMPLICITS_IN_SELECTS)) {
                                HidUtils.flattenToObjectsIgnoringImplicitsInSelects(result, parentHidAccess, options);
                            } else {
                                HidUtils.flattenToObjects(result, parentHidAccess.getSelects(), options);
                            }
                        }
                        parentHid = parentHidAccess.getParentHid();
                    }
                }
                if (((Hid)value).isMethodCall(false) && options.contains((Object)HidFlatteningOption.IGNORE_METHOD_CALLS) || result.test(value)) break;
                break;
            }
            case ACCESS: {
                Hid parentHid;
                if (options.contains((Object)HidFlatteningOption.IGNORE_HIDS)) break;
                HidAccess access = (HidAccess)value;
                if (!options.contains((Object)HidFlatteningOption.IGNORE_SELECTS) && !options.contains((Object)HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS)) {
                    parentHid = access.getParentHid();
                    HidAccess parentHidAccess = null;
                    while (parentHid != null && (parentHidAccess = parentHid.getParentAccess()) != null) {
                        if (parentHidAccess.isSelect()) {
                            if (options.contains((Object)HidFlatteningOption.IGNORE_IMPLICITS_IN_SELECTS)) {
                                HidUtils.flattenToObjectsIgnoringImplicitsInSelects(result, parentHidAccess, options);
                            } else {
                                HidUtils.flattenToObjects(result, parentHidAccess.getSelects(), options);
                            }
                        }
                        parentHid = parentHidAccess.getParentHid();
                    }
                }
                if (access.isMethodCall(false)) {
                    if (options.contains((Object)HidFlatteningOption.IGNORE_METHOD_CALLS) || !result.test(value) || options.contains((Object)HidFlatteningOption.IGNORE_METHOD_CALL_ARGUMENTS) || options.contains((Object)HidFlatteningOption.IGNORE_NON_VAMS_ACCESS_FUNCTION_ARGUMENTS) && !(parentHid = access.getParentHid()).hasOccurrence(HidQualifierCache.NATURE_ATTR_QUALIFIER | HidQualifierCache.POTENTIAL_NATURE_ATTR_QUALIFIER)) break;
                    if (options.contains((Object)HidFlatteningOption.IGNORE_IMPLICITS_IN_METHOD_CALLS)) {
                        HidUtils.flattenToObjectsIgnoringImplicitsInMethodCalls(result, access, options);
                        break;
                    }
                    HidUtils.flattenToObjects(result, ((IHidAccessArgs)((Object)access)).getArgumentValues(), options);
                    break;
                }
                if (access.isNoAccess()) {
                    if (result.test(value)) break;
                    break;
                }
                if (!access.isSelect() || options.contains((Object)HidFlatteningOption.IGNORE_SELECTS) || !result.test(value) || options.contains((Object)HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS)) break;
                if (options.contains((Object)HidFlatteningOption.IGNORE_IMPLICITS_IN_SELECTS)) {
                    HidUtils.flattenToObjectsIgnoringImplicitsInSelects(result, access, options);
                    break;
                }
                HidUtils.flattenToObjects(result, access.getSelects(), options);
                break;
            }
            case IMPLICIT: {
                if (options.contains((Object)HidFlatteningOption.IGNORE_IMPLICITS) || !((IHidImplicit)value).isID() && options.contains((Object)HidFlatteningOption.IGNORE_CONSTANTS) || result.test(value)) break;
                break;
            }
            case OPERATOR: {
                HidOperator operator = (HidOperator)value;
                if (!result.test(operator) || options.contains((Object)HidFlatteningOption.IGNORE_CONCAT_AND_ASSIGN_PATTERNS) && operator.isConcatOrAssignPatternOperator()) break;
                if (operator.getOperatorKind() != IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR) {
                    HidUtils.flattenToObjects(result, operator.getLHValue(), options);
                }
                if (options.contains((Object)HidFlatteningOption.IGNORE_IFF_EXPRESSION) && operator.isIffExpression()) break;
                HidUtils.flattenToObjects(result, OptimizedUtils.asList(operator.getRHValues(), false), options);
                break;
            }
        }
    }

    public static void flattenToObjectsIgnoringImplicitsInSelects(Predicate<IHidObject> result, HidAccess access, Set<HidFlatteningOption> options) {
        List<IHidObject> selects = access.getSelects();
        if (selects == null) {
            selects = Collections.emptyList();
        }
        for (IHidObject select : selects) {
            if (select.getHidKind() == IHidObject.HidKind.IMPLICIT || select.getHidKind() == IHidObject.HidKind.OPERATOR) continue;
            HidUtils.flattenToObjects(result, select, options);
        }
    }

    public static void flattenToObjectsIgnoringImplicitsInMethodCalls(Predicate<IHidObject> result, HidAccess access, Set<HidFlatteningOption> options) {
        List<? extends IHidObject> argValues = ((IHidAccessArgs)((Object)access)).getArgumentValues();
        if (argValues != null) {
            for (IHidObject iHidObject : argValues) {
                if (iHidObject.getHidKind() == IHidObject.HidKind.IMPLICIT) continue;
                if (iHidObject.getHidKind() == IHidObject.HidKind.OPERATOR) {
                    boolean hasImplicitsInOperator = ((HidOperator)iHidObject).getLHValue() instanceof HidImplicit;
                    Iterator<IHidObject> iterator = null;
                    ListContainer<IHidObject> rhValues = ((HidOperator)iHidObject).getRHValues();
                    if (rhValues != null) {
                        iterator = rhValues.iterator();
                    }
                    while (iterator != null && iterator.hasNext()) {
                        IHidObject hidObject = iterator.next();
                        if (hidObject.getHidKind() != IHidObject.HidKind.IMPLICIT) continue;
                        hasImplicitsInOperator = true;
                    }
                    if (hasImplicitsInOperator) continue;
                }
                HidUtils.flattenToObjects(result, iHidObject, options);
            }
        }
    }

    public static void flattenToObjects(Predicate<IHidObject> result, Collection<? extends IHidObject> values, Set<HidFlatteningOption> options) {
        if (values == null || values.isEmpty()) {
            return;
        }
        for (IHidObject iHidObject : values) {
            HidUtils.flattenToObjects(result, iHidObject, options);
        }
    }

    public static void flattenToOperators(Consumer<IHidOperator> result, IHidOperator operator, Set<HidFlatteningOption> options) {
        ListContainer<IHidObject> rhValues;
        IHidObject lhValue;
        if (operator == null) {
            return;
        }
        if (options.contains((Object)HidFlatteningOption.IGNORE_CONCAT_AND_ASSIGN_PATTERNS) && operator.isConcatOrAssignPatternOperator()) {
            return;
        }
        if (operator.getOperatorKind() != IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR && HidUtils.isOperator(lhValue = operator.getLHValue())) {
            HidUtils.flattenToOperators(result, (IHidOperator)lhValue, options);
        }
        if ((rhValues = operator.getRHValues()) != null) {
            for (IHidObject rhValue : rhValues) {
                if (!HidUtils.isOperator(rhValue)) continue;
                HidUtils.flattenToOperators(result, (IHidOperator)rhValue, options);
            }
        }
        result.accept(operator);
    }

    @NotNull
    public static Set<IHidOperator> flattenToOperators(IHidOperator operator) {
        if (operator == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<IHidOperator> operators = new LinkedHashSet<IHidOperator>();
        Consumer<IHidOperator> result = element -> operators.add((IHidOperator)element);
        HidUtils.flattenToOperators(result, operator, HidFlatteningOption.NONE_EXCLUDED);
        return operators;
    }

    public static IHid getHidFrom(IHidObject object) {
        if (object == null) {
            return null;
        }
        switch (object.getHidKind()) {
            case HID: {
                return (Hid)object;
            }
            case IMPLICIT: {
                return (HidImplicit)object;
            }
            case ACCESS: {
                return ((HidAccess)object).getParentHid();
            }
        }
        return null;
    }

    public static IHid getAncestorHidFrom(IHidObject object) {
        IHid hid = HidUtils.getHidFrom(object);
        return hid instanceof Hid ? ((Hid)hid).getAncestorHid() : null;
    }

    public static IHidOperator getOperatorFrom(IHidObject object) {
        if (object == null) {
            return null;
        }
        return object.getHidKind() == IHidObject.HidKind.OPERATOR ? (IHidOperator)object : null;
    }

    public static long toQualifiersSet(HidOperatorQualifier ... qualifiers) {
        if (qualifiers == null) {
            return 0L;
        }
        long result = 0L;
        HidOperatorQualifier[] hidOperatorQualifierArray = qualifiers;
        int n = qualifiers.length;
        int n2 = 0;
        while (n2 < n) {
            HidOperatorQualifier qualifier = hidOperatorQualifierArray[n2];
            result |= qualifier.value();
            ++n2;
        }
        return result;
    }

    public static long toQualifiersSet(HidQualifier ... qualifiers) {
        if (qualifiers == null) {
            return 0L;
        }
        long result = 0L;
        HidQualifier[] hidQualifierArray = qualifiers;
        int n = qualifiers.length;
        int n2 = 0;
        while (n2 < n) {
            HidQualifier qualifier = hidQualifierArray[n2];
            result |= qualifier.value();
            ++n2;
        }
        return result;
    }

    public static List<HidQualifier> toHidQualifiers(long qualifiers) {
        HidQualifier[] values;
        ArrayList<HidQualifier> result = new ArrayList<HidQualifier>();
        HidQualifier[] hidQualifierArray = values = HidQualifier.values();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            HidQualifier qualifier = hidQualifierArray[n2];
            if ((qualifiers & qualifier.value()) != 0L) {
                result.add(qualifier);
            }
            ++n2;
        }
        return result;
    }

    public static List<HidOperatorQualifier> toOperatorQualifiers(long qualifiers) {
        HidOperatorQualifier[] values;
        ArrayList<HidOperatorQualifier> result = new ArrayList<HidOperatorQualifier>();
        HidOperatorQualifier[] hidOperatorQualifierArray = values = HidOperatorQualifier.values();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            HidOperatorQualifier qualifier = hidOperatorQualifierArray[n2];
            if ((qualifiers & qualifier.value()) != 0L) {
                result.add(qualifier);
            }
            ++n2;
        }
        return result;
    }

    public static Hid getHidToResolveInContext(IHidObject hidObject, IHidEvaluationGuardian guardian) {
        if (hidObject == null) {
            return null;
        }
        Hid parent = null;
        switch (hidObject.getHidKind()) {
            case HID: {
                Hid hid = (Hid)hidObject;
                HidAccess parentAccess = hid.getParentAccess();
                IRfNamedElement element = hid.getElement();
                if (parentAccess == null && element != null) {
                    return null;
                }
                if (parentAccess != null && parentAccess.isPackageScopeAccess() && ELUtils.isVLOGConstant(element)) {
                    return null;
                }
                parent = hid;
                break;
            }
            case ACCESS: {
                Hid parentHid = ((HidAccess)hidObject).getParentHid();
                HidAccess parentHidAccess = parentHid.getParentAccess();
                IRfNamedElement parentElement = parentHid.getElement();
                if (guardian.useHidAccessResolved()) {
                    if (parentHidAccess == null && parentElement != null) {
                        return ((HidAccess)hidObject).associatedType == null ? parentHid : null;
                    }
                    if (parentHidAccess != null && parentHidAccess.isPackageScopeAccess() && ELUtils.isVLOGConstant(parentElement)) {
                        return null;
                    }
                }
                parent = parentHid;
                break;
            }
            default: {
                return null;
            }
        }
        HidAccess parentAccess = null;
        while (parent.getParentAccess() != null) {
            parentAccess = parent.getParentAccess();
            if (parentAccess.associatedType != null && parentAccess.getAccessKind() == 3 && guardian.isInRangeEvalZone()) break;
            parent = parentAccess.getParentHid();
        }
        return parent;
    }

    @NotNull
    public static List<IHidOperator> filterOperators(IHidHolder holder, final long qualifiers) {
        if (holder == null || qualifiers == 0L) {
            return Collections.emptyList();
        }
        final ArrayList<IHidOperator> result = new ArrayList<IHidOperator>();
        holder.visitHidObject(null, new IHidVisitor<HidOperator>(){

            @Override
            public void setHolder(IHidHolder holder) {
            }

            @Override
            public void setParserPath(ParserPath parserPath) {
            }

            @Override
            public boolean visit(HidOperator operator) {
                if (operator.hasOccurrence(qualifiers)) {
                    result.add(operator);
                }
                return true;
            }

            @Override
            public Class<HidOperator> getType() {
                return HidOperator.class;
            }
        });
        return result;
    }

    public static boolean isSimpleHidAccessWithSelects(IHidObject obj) {
        if (!HidUtils.isHidAccess(obj)) {
            return false;
        }
        HidAccess access = (HidAccess)obj;
        Hid hid = null;
        if (access.isSelect()) {
            hid = access.getParentHid();
        }
        return hid != null && hid.getParentAccess() == null;
    }

    public static void addFormalPartQualifierToHidAndOccurrence(IHid hidObject, boolean overwriteActualPartQualifier) {
        if (!HidUtils.isHid(hidObject)) {
            return;
        }
        Hid hid = (Hid)hidObject;
        while (hid != null) {
            hid.addQualifier(HidQualifierCache.FORMAL_PART_QUALIFIER);
            if (overwriteActualPartQualifier) {
                hid.removeQualifier(HidQualifierCache.ACTUAL_PART_QUALIFIER);
            }
            hid = hid.getParentHid();
        }
    }

    public static void addQualifierToHid(IHid hidObject, long qualifier) {
        if (!HidUtils.isHid(hidObject) || qualifier == 0L) {
            return;
        }
        Hid hid = (Hid)hidObject;
        hid.addQualifier(qualifier);
    }

    public static List<IHidObject> getSelects(IHidObject hidObject) {
        if (!HidUtils.isHidAccess(hidObject)) {
            return Collections.emptyList();
        }
        HidAccess hidAccess = (HidAccess)hidObject;
        return HidUtils.flattenSelects(hidAccess.getSelects());
    }

    public static List<IHidObject> flattenSelects(List<IHidObject> selects) {
        if (selects == null || selects.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IHidObject> result = new ArrayList<IHidObject>();
        for (IHidObject sel : selects) {
            if (sel == null) continue;
            result.addAll(HidUtils.flattenSelect(sel));
        }
        return result;
    }

    public static List<IHidObject> flattenSelect(IHidObject sel) {
        if (sel instanceof HidOperator && ((HidOperator)sel).isSelectList()) {
            ListContainer<IHidObject> rhValues = ((HidOperator)sel).getRHValues();
            ArrayListContainer<IHidObject> select = new ArrayListContainer<IHidObject>(rhValues.size());
            select.addAll(OptimizedUtils.asList(rhValues, false));
            Collections.reverse(select);
            return select;
        }
        return Collections.singletonList(sel);
    }

    public static int getLine(HidOccurrence occurrence) {
        return occurrence != null ? occurrence.getLine() : -1;
    }

    public static int getStartOffset(HidOccurrence occurrence) {
        if (occurrence == null) {
            return -1;
        }
        return occurrence instanceof HidOperatorOccurrence ? ((HidOperatorOccurrence)occurrence).getOpenBoundary() : occurrence.getOffset();
    }

    public static int getEndOffset(IHidObject hidObject, int startOffset, HidOccurrence occurrence) {
        if (hidObject == null) {
            return startOffset;
        }
        switch (hidObject.getHidKind()) {
            case ACCESS: {
                Hid parentHid = ((HidAccess)hidObject).getParentHid();
                if (parentHid == null) {
                    return -1;
                }
                String name = parentHid.getName();
                if (name == null) {
                    return -1;
                }
                return startOffset + name.length();
            }
            case HID: {
                Hid hid = (Hid)hidObject;
                String name = hid.getName();
                if (name == null) {
                    return -1;
                }
                return startOffset + name.length();
            }
            case OPERATOR: {
                return occurrence instanceof HidOperatorOccurrence ? ((HidOperatorOccurrence)occurrence).getCloseBoundary() : -1;
            }
        }
        return -1;
    }

    public static HidOccurrence getOccurrence(IHidObject hidObject) {
        switch (hidObject.getHidKind()) {
            case OPERATOR: {
                return ((HidOperator)hidObject).getOccurrence();
            }
            case ACCESS: {
                return ((HidAccess)hidObject).getOccurrence();
            }
            case HID: {
                return ((Hid)hidObject).getOccurrence();
            }
        }
        return null;
    }

    public static boolean transformAssociation(Hid assignLHSideHid, IHidObject associationObject, int index, ISContext context, IRfNamedElement initialScope, HidOperatorOccurrence enclosingOperatorOccurrence, long qualifiers, boolean changeOriginalLHSide, List<HidOperator> collected, IHidBuilders builders) {
        boolean isPatternValue;
        IHidObject actualPart = AssociationUtils.getActualPartRaw(associationObject, HidQualifierCache.IS_ASSOCIATION_QUALIFIER);
        boolean isPortConnection = (qualifiers & HidQualifierCache.IS_PORT_CONNECTION_QUALIFIER) != 0L;
        boolean bl = isPatternValue = (qualifiers & HidQualifierCache.IS_PATTERN_VALUE_QUALIFIER) != 0L;
        if (AssociationUtils.isOrdered(associationObject, HidQualifierCache.IS_ASSOCIATION_QUALIFIER)) {
            String correspondentHidName;
            IHidObject formalPart;
            HidOperator result;
            HidOperator association;
            IRfNamedElement correspondent = context.calculateCorrespondentByPosition(index);
            HidOccurrence formalPartOccurrence = null;
            long hidQualifiers = isPatternValue ? HidQualifierCache.PATTERN_KEY_QUALIFIER | HidQualifierCache.FORMAL_PART_QUALIFIER : 0L;
            HidOperatorOccurrence assocOccurrence = null;
            long assocQualifiers = 0L;
            HidOperator hidOperator = association = HidUtils.isOperator(associationObject, HidQualifierCache.IS_ASSOCIATION_QUALIFIER) ? (HidOperator)associationObject : null;
            if (association != null) {
                assocOccurrence = new HidOperatorOccurrence(association.getOccurrence());
                assocQualifiers = association.getQualifiers();
                offset = assocOccurrence.getOffset();
                virtualOffset = assocOccurrence.getVirtualOffset();
                line = assocOccurrence.getLine();
                formalPartOccurrence = new HidOccurrence(offset, virtualOffset, line, hidQualifiers, null);
                if (changeOriginalLHSide) {
                    IHid originalFormalPartHid;
                    IHidObject originalFormalPart = AssociationUtils.getFormalPartRaw(associationObject, HidQualifierCache.IS_ASSOCIATION_QUALIFIER);
                    IHid iHid = originalFormalPartHid = originalFormalPart instanceof IHid ? (IHid)originalFormalPart : null;
                    if (originalFormalPartHid != null && !HidUtils.isResolved(originalFormalPartHid) && originalFormalPartHid.getParentHid() == null) {
                        originalFormalPartHid = builders.buildHid(originalFormalPartHid.getName(), correspondent, formalPartOccurrence, hidQualifiers);
                        ((HidOperator)associationObject).setLHValue(originalFormalPartHid);
                    }
                }
            } else {
                offset = enclosingOperatorOccurrence.getOffset();
                virtualOffset = enclosingOperatorOccurrence.getVirtualOffset();
                line = enclosingOperatorOccurrence.getLine();
                formalPartOccurrence = new HidOccurrence(offset, virtualOffset, line, hidQualifiers, null);
                assocQualifiers = qualifiers;
                assocOccurrence = new HidOperatorOccurrence(offset, virtualOffset, line, enclosingOperatorOccurrence.getOpenBoundary(), enclosingOperatorOccurrence.getOpenVirtualBoundary(), enclosingOperatorOccurrence.getCloseBoundary(), enclosingOperatorOccurrence.getCloseVirtualBoundary(), assocQualifiers, null);
            }
            if ((result = builders.buildOperator(formalPart = HidUtils.makeAssociationSide(isPatternValue ? assignLHSideHid : null, null, correspondent, correspondentHidName = AssociationUtils.isOrderedUnconnected(associationObject, HidQualifierCache.IS_ASSOCIATION_QUALIFIER) ? IHidImplicitConstants.ImplicitType.IMPLICIT_UNCONNECTED_STRING : IHidImplicitConstants.ImplicitType.IMPLICIT_CONNECTED_STRING, builders, formalPartOccurrence, hidQualifiers), Collections.singletonList(actualPart), IHidOperatorConstants.OperatorType.ASSOCIATION.id, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, ":", assocOccurrence, assocQualifiers)) == null) {
                return false;
            }
            collected.add(result);
        } else {
            HidOperator association = (HidOperator)associationObject;
            HidOperatorOccurrence assocOccurrence = new HidOperatorOccurrence(association.getOccurrence());
            long assocQualifiers = association.getQualifiers();
            int offset = assocOccurrence.getOffset();
            int virtualOffset = assocOccurrence.getVirtualOffset();
            int line = assocOccurrence.getLine();
            IHidObject originalFormalPart = AssociationUtils.getFormalPartRaw(association, HidQualifierCache.IS_ASSOCIATION_QUALIFIER);
            boolean structContext = context.isStruct();
            if (isPatternValue && HidUtils.isOperator(originalFormalPart) && ((IHidOperator)originalFormalPart).isChoicesOR()) {
                ListContainer<IHidObject> listOfCorrespondents = ((IHidOperator)originalFormalPart).getRHValues();
                for (IHidObject correspondent : listOfCorrespondents) {
                    ISContext newContext;
                    HidOperator intermediaryAssociation;
                    boolean success;
                    IRfNamedElement correspondentElement;
                    IRfNamedElement iRfNamedElement = correspondentElement = HidUtils.isHid(correspondent) ? context.calculateCorrespondentByName(((Hid)correspondent).getName(), originalFormalPart, initialScope) : context.calculateCorrespondentByPosition(0);
                    if (correspondentElement == null || (success = HidUtils.transformAssociation(assignLHSideHid, intermediaryAssociation = builders.buildOperator(correspondent, Collections.singletonList(actualPart), IHidOperatorConstants.OperatorType.ASSOCIATION.id, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, ":", assocOccurrence, assocQualifiers), -1, newContext = new ISContext(){

                        @Override
                        public IRfNamedElement calculateCorrespondentByPosition(int position) {
                            return correspondentElement;
                        }

                        @Override
                        public IRfNamedElement calculateCorrespondentByName(String name, IHidObject originalFormalPart, IRfNamedElement initialScope) {
                            return correspondentElement;
                        }
                    }, initialScope, assocOccurrence, assocQualifiers, false, collected, builders))) continue;
                    return false;
                }
            } else if (HidUtils.isHid(originalFormalPart) || HidUtils.isHidImplicit(originalFormalPart) && ((IHidImplicit)originalFormalPart).isID()) {
                IHidObject formalPart;
                HidOperator result;
                IHid originalFormalPartHid;
                HidOccurrence occurrence = ((IHid)originalFormalPart).getOccurrence();
                if (occurrence != null) {
                    offset = occurrence.getOffset();
                    virtualOffset = occurrence.getVirtualOffset();
                    line = occurrence.getLine();
                }
                String correspondentName = ((IHid)originalFormalPart).getName();
                IRfNamedElement correspondent = null;
                if (!isPatternValue || structContext) {
                    correspondent = context.calculateCorrespondentByName(correspondentName, originalFormalPart, initialScope);
                } else if (HidUtils.isHid(originalFormalPart)) {
                    Hid originalFormalPartHid2 = (Hid)originalFormalPart;
                    if (correspondent == null && HidUtils.isResolved(originalFormalPart) && originalFormalPartHid2.getParentAccess() != null) {
                        correspondent = originalFormalPartHid2.getElement();
                    }
                    if (correspondent == null && originalFormalPartHid2.getParentAccess() == null && initialScope != null) {
                        correspondent = initialScope.semanticGetMember(correspondentName, (Hid)originalFormalPart, initialScope != null && initialScope.getDeclaration() != null ? initialScope.getDeclaration().getParserPath() : null, initialScope, null, true, true, false);
                    }
                }
                long formalPartQualifiers = structContext ? HidQualifierCache.PATTERN_KEY_QUALIFIER | HidQualifierCache.FORMAL_PART_QUALIFIER : 0L;
                HidOccurrence formalPartOccurrence = new HidOccurrence(offset, virtualOffset, line, formalPartQualifiers, null);
                if (changeOriginalLHSide && !HidUtils.isResolved(originalFormalPartHid = (IHid)originalFormalPart) && (originalFormalPartHid.getParentHid() == null || correspondent != null && HidUtils.isHid(originalFormalPartHid) && ((Hid)originalFormalPartHid).getParentAccess().getAccessKind() == 2)) {
                    originalFormalPartHid = builders.buildHid(originalFormalPartHid.getName(), correspondent, formalPartOccurrence, formalPartQualifiers);
                    association.setLHValue(originalFormalPartHid);
                    IRfNamedElement element = originalFormalPartHid.getElement();
                    if (element != null && initialScope != null && originalFormalPartHid.getParentHid() == null) {
                        IRfLibraryElement initialScopeEnclosingLibrary = initialScope.getEnclosingLibrary();
                        if (initialScopeEnclosingLibrary != null && element.getEnclosingScope() != null) {
                            initialScopeEnclosingLibrary.addReferenceInClosestContainer(element.getEnclosingScope().getName(), initialScope);
                        }
                        initialScope.addReferenceToIdentifierNameInClosestContainer(element.getName());
                    }
                }
                if ((result = builders.buildOperator(formalPart = HidUtils.makeAssociationSide(structContext ? assignLHSideHid : null, HidUtils.isHid(originalFormalPart) ? (Hid)originalFormalPart : null, correspondent, correspondentName, builders, formalPartOccurrence, formalPartQualifiers), Collections.singletonList(actualPart), IHidOperatorConstants.OperatorType.ASSOCIATION.id, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, ":", assocOccurrence, assocQualifiers)) == null) {
                    return false;
                }
                collected.add(result);
            } else if (isPatternValue && originalFormalPart instanceof IHidAccessArgs) {
                Hid methodHid = ((HidAccess)originalFormalPart).getParentHid();
                if (methodHid != null) {
                    HidOccurrence occurrence = methodHid.getOccurrence();
                    if (occurrence != null) {
                        offset = occurrence.getOffset();
                        virtualOffset = occurrence.getVirtualOffset();
                        line = occurrence.getLine();
                    }
                    String correspondentName = methodHid.getName();
                    IRfNamedElement correspondent = null;
                    if (HidUtils.isResolved(methodHid)) {
                        correspondent = methodHid.getElement();
                    } else if (initialScope != null) {
                        correspondent = initialScope.semanticGetMember(correspondentName, methodHid, initialScope.getDeclaration().getParserPath(), initialScope, null, true, true, false);
                    }
                    long formalPartQualifiers = HidQualifierCache.PATTERN_KEY_QUALIFIER | HidQualifierCache.FORMAL_PART_QUALIFIER;
                    HidOccurrence formalPartOccurrence = new HidOccurrence(offset, virtualOffset, line, formalPartQualifiers, null);
                    IHidObject formalPart = HidUtils.makeAssociationSide(assignLHSideHid, methodHid, correspondent, correspondentName, builders, formalPartOccurrence, formalPartQualifiers);
                    HidOperator result = builders.buildOperator(formalPart, Collections.singletonList(actualPart), IHidOperatorConstants.OperatorType.ASSOCIATION.id, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, ":", assocOccurrence, assocQualifiers);
                    if (result == null) {
                        return false;
                    }
                    collected.add(result);
                }
            } else {
                if (isPortConnection && HidUtils.isHidAccess(originalFormalPart)) {
                    collected.add(association);
                    return true;
                }
                collected.add(association);
                return true;
            }
        }
        return true;
    }

    public static boolean transformImplicitAssociation(HidOperator implicitConnection, String correspondentName, ISContext context, HidOperatorOccurrence operatorOccurrence, long operatorQualifiers, boolean changeOriginalLHSide, List<HidOperator> collected, IHidBuilders builders) {
        IHidObject formalPart;
        int line;
        int virtualOffset;
        int offset;
        HidOccurrence actualPartOccurrence;
        IRfNamedElement rhSide = context.getImplicitConnectionValue();
        IHidObject actualPart = HidUtils.makeAssociationSide(null, null, rhSide, correspondentName, builders, actualPartOccurrence = new HidOccurrence(offset = operatorOccurrence.getOffset(), virtualOffset = operatorOccurrence.getVirtualOffset(), line = operatorOccurrence.getLine(), 0L, null), 0L);
        if (actualPart == null) {
            return false;
        }
        IRfNamedElement correspondent = context.calculateCorrespondentByName(correspondentName, null, null);
        HidOccurrence formalPartOccurrence = new HidOccurrence(offset, virtualOffset, line, 0L, null);
        if (changeOriginalLHSide && implicitConnection != null) {
            IHid originalFormalPartHid;
            IHidObject originalFormalPart = AssociationUtils.getFormalPartRaw(implicitConnection, HidQualifierCache.IS_ASSOCIATION_QUALIFIER);
            IHid iHid = originalFormalPartHid = HidUtils.isHid(originalFormalPart) || HidUtils.isHidImplicit(originalFormalPart) ? (IHid)originalFormalPart : null;
            if (originalFormalPartHid != null && !HidUtils.isResolved(originalFormalPartHid) && originalFormalPartHid.getParentHid() == null) {
                originalFormalPartHid = builders.buildHid(originalFormalPartHid.getName(), correspondent, formalPartOccurrence, 0L);
                implicitConnection.setLHValue(originalFormalPartHid);
            }
        }
        if ((formalPart = HidUtils.makeAssociationSide(null, null, correspondent, correspondentName, builders, formalPartOccurrence, 0L)) == null) {
            return false;
        }
        long assocQualifiers = operatorQualifiers;
        HidOperatorOccurrence assocOccurrence = new HidOperatorOccurrence(operatorOccurrence);
        HidOperator result = builders.buildOperator(formalPart, Collections.singletonList(actualPart), IHidOperatorConstants.OperatorType.ASSOCIATION.id, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, ":", assocOccurrence, assocQualifiers);
        if (result == null) {
            return false;
        }
        collected.add(result);
        return true;
    }

    public static HidOperator transformAssignmentPattern(HidOperator assignPattern, ISContext context, IRfNamedElement initialScope, boolean changeOriginalLHSide, IHidBuilders builders) {
        IHidObject candidate;
        if (assignPattern == null || context == null || builders == null) {
            return assignPattern;
        }
        ListContainer<IHidObject> rhValues = assignPattern.getRHValues();
        if (rhValues == null) {
            return assignPattern;
        }
        int size = rhValues.size();
        ArrayList<HidOperator> newRHValues = new ArrayList<HidOperator>(size);
        if (size > 2 && HidUtils.isHidImplicit(candidate = rhValues.get(size - 2)) && ((HidImplicit)candidate).isConcatenationReplication()) {
            return assignPattern;
        }
        if (size == 1 && HidUtils.isHidImplicit(candidate = rhValues.get(0)) && ((HidImplicit)candidate).isEmptyType()) {
            return assignPattern;
        }
        Hid lhSideHid = context.getAssignPatternLHSideHid();
        int i = 0;
        while (i < size) {
            IHidObject originalAssociation = rhValues.get(i);
            boolean success = HidUtils.transformAssociation(lhSideHid, originalAssociation, size - i - 1, context, initialScope, assignPattern.getOccurrence(), HidQualifierCache.IS_PATTERN_VALUE_QUALIFIER, changeOriginalLHSide, newRHValues, builders);
            if (!success) {
                return assignPattern;
            }
            ++i;
        }
        HidOperator newAssignPattern = builders.buildOperator(assignPattern.getLHValue(), new ArrayList<IHidObject>(newRHValues), assignPattern.getOperatorType(), assignPattern.getOperatorKind(), assignPattern.getOperatorText(), new HidOperatorOccurrence(assignPattern.getOccurrence()), assignPattern.getQualifiers());
        return newAssignPattern;
    }

    public static IHidObject makeAssociationSide(Hid assignLHSide, Hid correspondentHid, IRfNamedElement correspondent, String correspondentName, IHidBuilders builders, HidOccurrence occurrence, long qualifiers) {
        if (correspondentHid == null || correspondentHid.getParentAccess() == null || correspondentHid.getParentAccess().getAccessKind() == 4 || correspondent != null && correspondentHid.getParentAccess().getAccessKind() == 2) {
            Hid patternKeyHid = builders.buildHid(correspondentName, correspondent, occurrence, qualifiers | HidQualifierCache.HIDDEN);
            if (assignLHSide != null && (correspondent == null || correspondent instanceof IRfFieldElement && HidUtils.getResolvedElement(assignLHSide) != correspondent)) {
                builders.buildAccess(assignLHSide, patternKeyHid, 4);
            }
            return patternKeyHid;
        }
        Hid patternKeyHid = correspondentHid.upwardsCopy(true);
        HidUtils.addQualifierToHid(patternKeyHid, HidQualifierCache.HIDDEN);
        Hid ancestorHid = patternKeyHid.getAncestorHid();
        if (assignLHSide != null) {
            builders.buildAccess(assignLHSide, ancestorHid, 4);
        } else {
            ancestorHid.parentAccess = null;
        }
        return patternKeyHid;
    }

    public static Hid makeStandInHid(String name, IRfNamedElement resolved, HidOccurrence occurrence, long hidQualifiers) {
        StandInHid hid = StandInHid.create(name, null, resolved, occurrence);
        hid.addQualifier(hidQualifiers);
        return hid;
    }

    public static HidAccess makeStandInAccess(Hid prev, Hid next, int accessKind) {
        StandInHidAccess access = new StandInHidAccess(accessKind, null, null);
        prev.addAccess(access);
        access.addHid(next);
        return access;
    }

    public static HidOperator makeStandInOperator(IHidObject lhSide, List<IHidObject> rhSide, int type, IHidOperatorConstants.OperatorKind kind, String text, HidOperatorOccurrence occurrence, long operatorQualifiers) {
        if (lhSide == null || rhSide == null) {
            return null;
        }
        StandInOperator operator = StandInOperator.create(type, kind, text, occurrence, LanguageKind.UNKNOWN);
        operator.addLHValue(lhSide);
        for (IHidObject rhValue : rhSide) {
            operator.addRHValue(rhValue);
        }
        operator.addQualifier(operatorQualifiers);
        return operator;
    }

    public static HidImplicit makeStandInImplicit(String name, int type) {
        if (name == null) {
            return null;
        }
        return new StandInHidImplicit(name, type);
    }

    public static void performNullCheck(IHidObject hidObject, IHidEvaluationGuardian guardian) {
        Hid parentHid = null;
        if (HidUtils.isHidAccess(hidObject)) {
            parentHid = ((HidAccess)hidObject).getParentHid();
        } else if (HidUtils.isHid(hidObject)) {
            parentHid = (Hid)hidObject;
        }
        if (parentHid == null) {
            return;
        }
        HidAccess parentAccess = parentHid.getParentAccess();
        if (parentAccess == null) {
            return;
        }
        int accessKind = parentAccess.getAccessKind();
        if (accessKind == 2) {
            return;
        }
        try {
            parentAccess.setAccessKind(Integer.MIN_VALUE);
            guardian.logError("Null pointer access ('" + parentAccess + "' is null)!");
        }
        finally {
            parentAccess.setAccessKind(accessKind);
        }
    }

    public static IRfFieldElement getUnresolvedTypeParameter(IHidObject hidObject) {
        if (hidObject == null || hidObject.getHidKind() != IHidObject.HidKind.HID && hidObject.getHidKind() != IHidObject.HidKind.ACCESS) {
            return null;
        }
        HidAccess hidAccess = null;
        if (hidObject.getHidKind() == IHidObject.HidKind.HID) {
            Hid hid = (Hid)hidObject;
            if (hid.getElement() instanceof IRfFieldElement && ((IRfFieldElement)hid.getElement()).isTypeParameter()) {
                return (IRfFieldElement)hid.getElement();
            }
            if (hid.getParentAccess() == null) {
                return null;
            }
            hidAccess = hid.getParentAccess();
        } else {
            if (hidObject.getHidKind() != IHidObject.HidKind.ACCESS) {
                return null;
            }
            hidAccess = (HidAccess)hidObject;
        }
        do {
            if (!(hidAccess.getAssociatedType() instanceof IRfFieldElement) || !((IRfFieldElement)hidAccess.getAssociatedType()).isTypeParameter()) continue;
            return (IRfFieldElement)hidAccess.getAssociatedType();
        } while ((hidAccess = hidAccess.getParentHid().getParentAccess()) != null);
        return null;
    }

    public static ElementPath getElementPathForHid(IHidObject hidOject, ElementPath elementPath) {
        if (hidOject instanceof HidAccess var3_3) {
            currentHid = hidAccess.getParentHid();
        } else if (hidOject instanceof Hid) {
            currentHid = (Hid)hidOject;
        } else {
            return null;
        }
        int hidLength = 0;
        do {
            ++hidLength;
        } while ((currentHid = currentHid.getParentHid()) != null);
        return ElementPath.relativize(elementPath, hidLength);
    }

    public static class StandInHid
    extends Hid {
        private static final long serialVersionUID = 1L;

        public static StandInHid create(String name, IRfNamedElement secondaryScope, IRfNamedElement element, HidOccurrence occurrence) {
            StandInHid result = null;
            result = occurrence.getVirtualOffset() == -1 && occurrence.getReparseInfo() == default_RI ? new StandInHid(name, secondaryScope, occurrence.getOffset(), occurrence.getVirtualOffset(), occurrence.getLine(), occurrence.getQualifiers(), occurrence.getReparseInfo()) : (occurrence.getVirtualOffset() != -1 && occurrence.getReparseInfo() == default_RI ? new StandInHid_VO___(name, secondaryScope, occurrence.getOffset(), occurrence.getVirtualOffset(), occurrence.getLine(), occurrence.getQualifiers(), occurrence.getReparseInfo()) : (occurrence.getVirtualOffset() == -1 && occurrence.getReparseInfo() != default_RI ? new StandInHid____RI(name, secondaryScope, occurrence.getOffset(), occurrence.getVirtualOffset(), occurrence.getLine(), occurrence.getQualifiers(), occurrence.getReparseInfo()) : new StandInHid_VO_RI(name, secondaryScope, occurrence.getOffset(), occurrence.getVirtualOffset(), occurrence.getLine(), occurrence.getQualifiers(), occurrence.getReparseInfo())));
            result.element = element;
            return result;
        }

        private StandInHid(String name, IRfNamedElement secondaryScope, int offset, int virtualOffset, int line, long qualifiers, IReparseInfo reparseInfo) {
            super(name, secondaryScope, offset, line, qualifiers);
        }

        @Override
        public StandInHid shallowCopy(boolean addResolved) {
            StandInHid result = StandInHid.create(this.name, this.secondaryScope, addResolved ? this.element : null, this.getOccurrence());
            result.qualifierSet = this.qualifierSet;
            return result;
        }

        @Override
        public StandInHid deepCopy() {
            StandInHid result = this.shallowCopy(false);
            if (this.hasAccesses()) {
                for (HidAccess access : this.getAccesses()) {
                    result.addAccess(access.deepCopy());
                }
            }
            return result;
        }

        @Override
        public StandInHid upwardsCopy(boolean addResolved) {
            StandInHid result = this.shallowCopy(addResolved);
            if (this.parentAccess != null) {
                result.parentAccess = this.parentAccess.upwardsCopy(addResolved);
                result.parentAccess.addHid(result);
            }
            return result;
        }

        private static class StandInHid_VO_RI
        extends StandInHid_VO___ {
            private static final long serialVersionUID = 1L;
            private IReparseInfo reparseInfo;

            public StandInHid_VO_RI(String name, IRfNamedElement secondaryScope, int offset, int virtualOffset, int line, long qualifiers, IReparseInfo reparseInfo) {
                super(name, secondaryScope, offset, virtualOffset, line, qualifiers, reparseInfo);
                this.reparseInfo = reparseInfo;
            }

            @Override
            public IReparseInfo getReparseInfo() {
                return this.reparseInfo;
            }
        }

        private static class StandInHid_VO___
        extends StandInHid {
            private static final long serialVersionUID = 1L;
            private int virtualOffset;

            public StandInHid_VO___(String name, IRfNamedElement secondaryScope, int offset, int virtualOffset, int line, long qualifiers, IReparseInfo reparseInfo) {
                super(name, secondaryScope, offset, virtualOffset, line, qualifiers, reparseInfo);
                this.virtualOffset = virtualOffset;
            }

            @Override
            public int getVirtualOffset() {
                return this.virtualOffset;
            }
        }

        private static class StandInHid____RI
        extends StandInHid {
            private static final long serialVersionUID = 1L;
            private IReparseInfo reparseInfo;

            public StandInHid____RI(String name, IRfNamedElement secondaryScope, int offset, int virtualOffset, int line, long qualifiers, IReparseInfo reparseInfo) {
                super(name, secondaryScope, offset, virtualOffset, line, qualifiers, reparseInfo);
                this.reparseInfo = reparseInfo;
            }

            @Override
            public IReparseInfo getReparseInfo() {
                return this.reparseInfo;
            }
        }
    }

    public static class StandInHidAccess
    extends HidAccess {
        private static final long serialVersionUID = 1L;

        public StandInHidAccess(int accessKind, List<IHidObject> selects, IRfNamedElement associatedType) {
            super(accessKind, selects);
            this.associatedType = associatedType;
        }

        @Override
        public final StandInHidAccess deepCopy() {
            StandInHidAccess result = new StandInHidAccess(this.accessKind, OptimizedUtils.asList(this.selectsContainer, false), null);
            if (!this.isHidObjectsEmpty()) {
                for (Hid hid : this.hidsContainer) {
                    result.addHid(hid.deepCopy());
                }
            }
            return result;
        }

        @Override
        public StandInHidAccess upwardsCopy(boolean addResolved) {
            StandInHidAccess result = new StandInHidAccess(this.accessKind, OptimizedUtils.asList(this.selectsContainer, false), null);
            if (addResolved) {
                result.associatedType = this.associatedType;
            }
            if (this.parentHid != null) {
                result.parentHid = this.parentHid.upwardsCopy(addResolved);
                result.parentHid.addAccess(result);
            }
            return result;
        }

        @Override
        public LanguageKind getLanguageKind() {
            return LanguageKind.UNKNOWN;
        }
    }

    public static class StandInHidImplicit
    extends HidImplicit {
        private static final long serialVersionUID = 1L;

        public StandInHidImplicit(String name, int type) {
            super(name, type);
        }
    }

    public static class StandInOperator
    extends HidOperator {
        private LanguageKind languageKind;
        private static final long serialVersionUID = 1L;

        public static StandInOperator create(int operatorType, IHidOperatorConstants.OperatorKind operatorKind, String operatorText, HidOperatorOccurrence occurrence, LanguageKind languageKind) {
            StandInOperator result = null;
            result = occurrence.getVirtualOffset() == -1 && occurrence.getReparseInfo() == default_RI && occurrence.getOpenVirtualBoundary() == -1 && occurrence.getCloseVirtualBoundary() == -1 ? new StandInOperator(operatorType, operatorKind, operatorText, occurrence.getOffset(), occurrence.getVirtualOffset(), occurrence.getLine(), occurrence.getOpenBoundary(), occurrence.getOpenVirtualBoundary(), occurrence.getCloseBoundary(), occurrence.getCloseVirtualBoundary(), occurrence.getQualifiers(), occurrence.getReparseInfo()) : (occurrence.getVirtualOffset() == -1 && occurrence.getReparseInfo() == default_RI && occurrence.getOpenVirtualBoundary() == -1 && occurrence.getCloseVirtualBoundary() != -1 ? new StandInOperator__________CV(operatorType, operatorKind, operatorText, occurrence.getOffset(), occurrence.getVirtualOffset(), occurrence.getLine(), occurrence.getOpenBoundary(), occurrence.getOpenVirtualBoundary(), occurrence.getCloseBoundary(), occurrence.getCloseVirtualBoundary(), occurrence.getQualifiers(), occurrence.getReparseInfo()) : (occurrence.getVirtualOffset() == -1 && occurrence.getReparseInfo() == default_RI && occurrence.getOpenVirtualBoundary() != -1 && occurrence.getCloseVirtualBoundary() == -1 ? new StandInOperator_______OV___(operatorType, operatorKind, operatorText, occurrence.getOffset(), occurrence.getVirtualOffset(), occurrence.getLine(), occurrence.getOpenBoundary(), occurrence.getOpenVirtualBoundary(), occurrence.getCloseBoundary(), occurrence.getCloseVirtualBoundary(), occurrence.getQualifiers(), occurrence.getReparseInfo()) : (occurrence.getVirtualOffset() == -1 && occurrence.getReparseInfo() == default_RI && occurrence.getOpenVirtualBoundary() != -1 && occurrence.getCloseVirtualBoundary() != -1 ? new StandInOperator_______OV_CV(operatorType, operatorKind, operatorText, occurrence.getOffset(), occurrence.getVirtualOffset(), occurrence.getLine(), occurrence.getOpenBoundary(), occurrence.getOpenVirtualBoundary(), occurrence.getCloseBoundary(), occurrence.getCloseVirtualBoundary(), occurrence.getQualifiers(), occurrence.getReparseInfo()) : (occurrence.getVirtualOffset() == -1 && occurrence.getReparseInfo() != default_RI && occurrence.getOpenVirtualBoundary() == -1 && occurrence.getCloseVirtualBoundary() == -1 ? new StandInOperator____RI______(operatorType, operatorKind, operatorText, occurrence.getOffset(), occurrence.getVirtualOffset(), occurrence.getLine(), occurrence.getOpenBoundary(), occurrence.getOpenVirtualBoundary(), occurrence.getCloseBoundary(), occurrence.getCloseVirtualBoundary(), occurrence.getQualifiers(), occurrence.getReparseInfo()) : (occurrence.getVirtualOffset() == -1 && occurrence.getReparseInfo() != default_RI && occurrence.getOpenVirtualBoundary() == -1 && occurrence.getCloseVirtualBoundary() != -1 ? new StandInOperator____RI____CV(operatorType, operatorKind, operatorText, occurrence.getOffset(), occurrence.getVirtualOffset(), occurrence.getLine(), occurrence.getOpenBoundary(), occurrence.getOpenVirtualBoundary(), occurrence.getCloseBoundary(), occurrence.getCloseVirtualBoundary(), occurrence.getQualifiers(), occurrence.getReparseInfo()) : (occurrence.getVirtualOffset() == -1 && occurrence.getReparseInfo() != default_RI && occurrence.getOpenVirtualBoundary() != -1 && occurrence.getCloseVirtualBoundary() == -1 ? new StandInOperator____RI_OV___(operatorType, operatorKind, operatorText, occurrence.getOffset(), occurrence.getVirtualOffset(), occurrence.getLine(), occurrence.getOpenBoundary(), occurrence.getOpenVirtualBoundary(), occurrence.getCloseBoundary(), occurrence.getCloseVirtualBoundary(), occurrence.getQualifiers(), occurrence.getReparseInfo()) : (occurrence.getVirtualOffset() == -1 && occurrence.getReparseInfo() != default_RI && occurrence.getOpenVirtualBoundary() != -1 && occurrence.getCloseVirtualBoundary() != -1 ? new StandInOperator____RI_OV_CV(operatorType, operatorKind, operatorText, occurrence.getOffset(), occurrence.getVirtualOffset(), occurrence.getLine(), occurrence.getOpenBoundary(), occurrence.getOpenVirtualBoundary(), occurrence.getCloseBoundary(), occurrence.getCloseVirtualBoundary(), occurrence.getQualifiers(), occurrence.getReparseInfo()) : (occurrence.getVirtualOffset() != -1 && occurrence.getReparseInfo() == default_RI && occurrence.getOpenVirtualBoundary() == -1 && occurrence.getCloseVirtualBoundary() == -1 ? new StandInOperator_VO_________(operatorType, operatorKind, operatorText, occurrence.getOffset(), occurrence.getVirtualOffset(), occurrence.getLine(), occurrence.getOpenBoundary(), occurrence.getOpenVirtualBoundary(), occurrence.getCloseBoundary(), occurrence.getCloseVirtualBoundary(), occurrence.getQualifiers(), occurrence.getReparseInfo()) : (occurrence.getVirtualOffset() != -1 && occurrence.getReparseInfo() == default_RI && occurrence.getOpenVirtualBoundary() == -1 && occurrence.getCloseVirtualBoundary() != -1 ? new StandInOperator_VO_______CV(operatorType, operatorKind, operatorText, occurrence.getOffset(), occurrence.getVirtualOffset(), occurrence.getLine(), occurrence.getOpenBoundary(), occurrence.getOpenVirtualBoundary(), occurrence.getCloseBoundary(), occurrence.getCloseVirtualBoundary(), occurrence.getQualifiers(), occurrence.getReparseInfo()) : (occurrence.getVirtualOffset() != -1 && occurrence.getReparseInfo() == default_RI && occurrence.getOpenVirtualBoundary() != -1 && occurrence.getCloseVirtualBoundary() == -1 ? new StandInOperator_VO____OV___(operatorType, operatorKind, operatorText, occurrence.getOffset(), occurrence.getVirtualOffset(), occurrence.getLine(), occurrence.getOpenBoundary(), occurrence.getOpenVirtualBoundary(), occurrence.getCloseBoundary(), occurrence.getCloseVirtualBoundary(), occurrence.getQualifiers(), occurrence.getReparseInfo()) : (occurrence.getVirtualOffset() != -1 && occurrence.getReparseInfo() == default_RI && occurrence.getOpenVirtualBoundary() != -1 && occurrence.getCloseVirtualBoundary() != -1 ? new StandInOperator_VO____OV_CV(operatorType, operatorKind, operatorText, occurrence.getOffset(), occurrence.getVirtualOffset(), occurrence.getLine(), occurrence.getOpenBoundary(), occurrence.getOpenVirtualBoundary(), occurrence.getCloseBoundary(), occurrence.getCloseVirtualBoundary(), occurrence.getQualifiers(), occurrence.getReparseInfo()) : (occurrence.getVirtualOffset() != -1 && occurrence.getReparseInfo() != default_RI && occurrence.getOpenVirtualBoundary() == -1 && occurrence.getCloseVirtualBoundary() == -1 ? new StandInOperator_VO_RI______(operatorType, operatorKind, operatorText, occurrence.getOffset(), occurrence.getVirtualOffset(), occurrence.getLine(), occurrence.getOpenBoundary(), occurrence.getOpenVirtualBoundary(), occurrence.getCloseBoundary(), occurrence.getCloseVirtualBoundary(), occurrence.getQualifiers(), occurrence.getReparseInfo()) : (occurrence.getVirtualOffset() != -1 && occurrence.getReparseInfo() != default_RI && occurrence.getOpenVirtualBoundary() == -1 && occurrence.getCloseVirtualBoundary() != -1 ? new StandInOperator_VO_RI____CV(operatorType, operatorKind, operatorText, occurrence.getOffset(), occurrence.getVirtualOffset(), occurrence.getLine(), occurrence.getOpenBoundary(), occurrence.getOpenVirtualBoundary(), occurrence.getCloseBoundary(), occurrence.getCloseVirtualBoundary(), occurrence.getQualifiers(), occurrence.getReparseInfo()) : (occurrence.getVirtualOffset() != -1 && occurrence.getReparseInfo() != default_RI && occurrence.getOpenVirtualBoundary() != -1 && occurrence.getCloseVirtualBoundary() == -1 ? new StandInOperator_VO_RI_OV___(operatorType, operatorKind, operatorText, occurrence.getOffset(), occurrence.getVirtualOffset(), occurrence.getLine(), occurrence.getOpenBoundary(), occurrence.getOpenVirtualBoundary(), occurrence.getCloseBoundary(), occurrence.getCloseVirtualBoundary(), occurrence.getQualifiers(), occurrence.getReparseInfo()) : new StandInOperator_VO_RI_OV_CV(operatorType, operatorKind, operatorText, occurrence.getOffset(), occurrence.getVirtualOffset(), occurrence.getLine(), occurrence.getOpenBoundary(), occurrence.getOpenVirtualBoundary(), occurrence.getCloseBoundary(), occurrence.getCloseVirtualBoundary(), occurrence.getQualifiers(), occurrence.getReparseInfo())))))))))))))));
            result.languageKind = languageKind != null ? languageKind : LanguageKind.UNKNOWN;
            return result;
        }

        private StandInOperator(int operatorType, IHidOperatorConstants.OperatorKind operatorKind, String operatorText, int offset, int virtualOffset, int line, int openBoundary, int openVirtualBoundary, int closeBoundary, int closeVirtualBoundary, long qualifiers, IReparseInfo reparseInfo) {
            super(operatorType, operatorKind, operatorText, offset, line, openBoundary, closeBoundary, qualifiers);
        }

        @Override
        public int getUsageIndex() {
            return -1;
        }

        @Override
        public LanguageKind getLanguageKind() {
            return this.languageKind;
        }

        private static class StandInOperator_VO_RI_OV_CV
        extends StandInOperator____RI_OV_CV {
            private static final long serialVersionUID = 1L;
            private int virtualOffset;

            public StandInOperator_VO_RI_OV_CV(int operatorType, IHidOperatorConstants.OperatorKind operatorKind, String operatorText, int offset, int virtualOffset, int line, int openBoundary, int openVirtualBoundary, int closeBoundary, int closeVirtualBoundary, long qualifiers, IReparseInfo reparseInfo) {
                super(operatorType, operatorKind, operatorText, offset, virtualOffset, line, openBoundary, openVirtualBoundary, closeBoundary, closeVirtualBoundary, qualifiers, reparseInfo);
                this.virtualOffset = virtualOffset;
            }

            @Override
            public int getVirtualOffset() {
                return this.virtualOffset;
            }
        }

        private static class StandInOperator_VO_RI_OV___
        extends StandInOperator____RI_OV___ {
            private static final long serialVersionUID = 1L;
            private int virtualOffset;

            public StandInOperator_VO_RI_OV___(int operatorType, IHidOperatorConstants.OperatorKind operatorKind, String operatorText, int offset, int virtualOffset, int line, int openBoundary, int openVirtualBoundary, int closeBoundary, int closeVirtualBoundary, long qualifiers, IReparseInfo reparseInfo) {
                super(operatorType, operatorKind, operatorText, offset, virtualOffset, line, openBoundary, openVirtualBoundary, closeBoundary, closeVirtualBoundary, qualifiers, reparseInfo);
                this.virtualOffset = virtualOffset;
            }

            @Override
            public int getVirtualOffset() {
                return this.virtualOffset;
            }
        }

        private static class StandInOperator_VO_RI____CV
        extends StandInOperator____RI____CV {
            private static final long serialVersionUID = 1L;
            private int virtualOffset;

            public StandInOperator_VO_RI____CV(int operatorType, IHidOperatorConstants.OperatorKind operatorKind, String operatorText, int offset, int virtualOffset, int line, int openBoundary, int openVirtualBoundary, int closeBoundary, int closeVirtualBoundary, long qualifiers, IReparseInfo reparseInfo) {
                super(operatorType, operatorKind, operatorText, offset, virtualOffset, line, openBoundary, openVirtualBoundary, closeBoundary, closeVirtualBoundary, qualifiers, reparseInfo);
                this.virtualOffset = virtualOffset;
            }

            @Override
            public int getVirtualOffset() {
                return this.virtualOffset;
            }
        }

        private static class StandInOperator_VO_RI______
        extends StandInOperator____RI______ {
            private static final long serialVersionUID = 1L;
            private int virtualOffset;

            public StandInOperator_VO_RI______(int operatorType, IHidOperatorConstants.OperatorKind operatorKind, String operatorText, int offset, int virtualOffset, int line, int openBoundary, int openVirtualBoundary, int closeBoundary, int closeVirtualBoundary, long qualifiers, IReparseInfo reparseInfo) {
                super(operatorType, operatorKind, operatorText, offset, virtualOffset, line, openBoundary, openVirtualBoundary, closeBoundary, closeVirtualBoundary, qualifiers, reparseInfo);
                this.virtualOffset = virtualOffset;
            }

            @Override
            public int getVirtualOffset() {
                return this.virtualOffset;
            }
        }

        private static class StandInOperator_VO____OV_CV
        extends StandInOperator_______OV_CV {
            private static final long serialVersionUID = 1L;
            private int virtualOffset;

            public StandInOperator_VO____OV_CV(int operatorType, IHidOperatorConstants.OperatorKind operatorKind, String operatorText, int offset, int virtualOffset, int line, int openBoundary, int openVirtualBoundary, int closeBoundary, int closeVirtualBoundary, long qualifiers, IReparseInfo reparseInfo) {
                super(operatorType, operatorKind, operatorText, offset, virtualOffset, line, openBoundary, openVirtualBoundary, closeBoundary, closeVirtualBoundary, qualifiers, reparseInfo);
                this.virtualOffset = virtualOffset;
            }

            @Override
            public int getVirtualOffset() {
                return this.virtualOffset;
            }
        }

        private static class StandInOperator_VO____OV___
        extends StandInOperator_______OV___ {
            private static final long serialVersionUID = 1L;
            private int virtualOffset;

            public StandInOperator_VO____OV___(int operatorType, IHidOperatorConstants.OperatorKind operatorKind, String operatorText, int offset, int virtualOffset, int line, int openBoundary, int openVirtualBoundary, int closeBoundary, int closeVirtualBoundary, long qualifiers, IReparseInfo reparseInfo) {
                super(operatorType, operatorKind, operatorText, offset, virtualOffset, line, openBoundary, openVirtualBoundary, closeBoundary, closeVirtualBoundary, qualifiers, reparseInfo);
                this.virtualOffset = virtualOffset;
            }

            @Override
            public int getVirtualOffset() {
                return this.virtualOffset;
            }
        }

        private static class StandInOperator_VO_______CV
        extends StandInOperator__________CV {
            private static final long serialVersionUID = 1L;
            private int virtualOffset;

            public StandInOperator_VO_______CV(int operatorType, IHidOperatorConstants.OperatorKind operatorKind, String operatorText, int offset, int virtualOffset, int line, int openBoundary, int openVirtualBoundary, int closeBoundary, int closeVirtualBoundary, long qualifiers, IReparseInfo reparseInfo) {
                super(operatorType, operatorKind, operatorText, offset, virtualOffset, line, openBoundary, openVirtualBoundary, closeBoundary, closeVirtualBoundary, qualifiers, reparseInfo);
                this.virtualOffset = virtualOffset;
            }

            @Override
            public int getVirtualOffset() {
                return this.virtualOffset;
            }
        }

        private static class StandInOperator_VO_________
        extends StandInOperator {
            private static final long serialVersionUID = 1L;
            private int virtualOffset;

            public StandInOperator_VO_________(int operatorType, IHidOperatorConstants.OperatorKind operatorKind, String operatorText, int offset, int virtualOffset, int line, int openBoundary, int openVirtualBoundary, int closeBoundary, int closeVirtualBoundary, long qualifiers, IReparseInfo reparseInfo) {
                super(operatorType, operatorKind, operatorText, offset, virtualOffset, line, openBoundary, openVirtualBoundary, closeBoundary, closeVirtualBoundary, qualifiers, reparseInfo);
                this.virtualOffset = virtualOffset;
            }

            @Override
            public int getVirtualOffset() {
                return this.virtualOffset;
            }
        }

        private static class StandInOperator____RI_OV_CV
        extends StandInOperator_______OV_CV {
            private static final long serialVersionUID = 1L;
            private IReparseInfo reparseInfo;

            public StandInOperator____RI_OV_CV(int operatorType, IHidOperatorConstants.OperatorKind operatorKind, String operatorText, int offset, int virtualOffset, int line, int openBoundary, int openVirtualBoundary, int closeBoundary, int closeVirtualBoundary, long qualifiers, IReparseInfo reparseInfo) {
                super(operatorType, operatorKind, operatorText, offset, virtualOffset, line, openBoundary, openVirtualBoundary, closeBoundary, closeVirtualBoundary, qualifiers, reparseInfo);
                this.reparseInfo = reparseInfo;
            }

            @Override
            public IReparseInfo getReparseInfo() {
                return this.reparseInfo;
            }
        }

        private static class StandInOperator____RI_OV___
        extends StandInOperator_______OV___ {
            private static final long serialVersionUID = 1L;
            private IReparseInfo reparseInfo;

            public StandInOperator____RI_OV___(int operatorType, IHidOperatorConstants.OperatorKind operatorKind, String operatorText, int offset, int virtualOffset, int line, int openBoundary, int openVirtualBoundary, int closeBoundary, int closeVirtualBoundary, long qualifiers, IReparseInfo reparseInfo) {
                super(operatorType, operatorKind, operatorText, offset, virtualOffset, line, openBoundary, openVirtualBoundary, closeBoundary, closeVirtualBoundary, qualifiers, reparseInfo);
                this.reparseInfo = reparseInfo;
            }

            @Override
            public IReparseInfo getReparseInfo() {
                return this.reparseInfo;
            }
        }

        private static class StandInOperator____RI____CV
        extends StandInOperator__________CV {
            private static final long serialVersionUID = 1L;
            private IReparseInfo reparseInfo;

            public StandInOperator____RI____CV(int operatorType, IHidOperatorConstants.OperatorKind operatorKind, String operatorText, int offset, int virtualOffset, int line, int openBoundary, int openVirtualBoundary, int closeBoundary, int closeVirtualBoundary, long qualifiers, IReparseInfo reparseInfo) {
                super(operatorType, operatorKind, operatorText, offset, virtualOffset, line, openBoundary, openVirtualBoundary, closeBoundary, closeVirtualBoundary, qualifiers, reparseInfo);
                this.reparseInfo = reparseInfo;
            }

            @Override
            public IReparseInfo getReparseInfo() {
                return this.reparseInfo;
            }
        }

        private static class StandInOperator____RI______
        extends StandInOperator {
            private static final long serialVersionUID = 1L;
            private IReparseInfo reparseInfo;

            public StandInOperator____RI______(int operatorType, IHidOperatorConstants.OperatorKind operatorKind, String operatorText, int offset, int virtualOffset, int line, int openBoundary, int openVirtualBoundary, int closeBoundary, int closeVirtualBoundary, long qualifiers, IReparseInfo reparseInfo) {
                super(operatorType, operatorKind, operatorText, offset, virtualOffset, line, openBoundary, openVirtualBoundary, closeBoundary, closeVirtualBoundary, qualifiers, reparseInfo);
                this.reparseInfo = reparseInfo;
            }

            @Override
            public IReparseInfo getReparseInfo() {
                return this.reparseInfo;
            }
        }

        private static class StandInOperator_______OV_CV
        extends StandInOperator__________CV {
            private static final long serialVersionUID = 1L;
            private int openVirtualBoundary;

            public StandInOperator_______OV_CV(int operatorType, IHidOperatorConstants.OperatorKind operatorKind, String operatorText, int offset, int virtualOffset, int line, int openBoundary, int openVirtualBoundary, int closeBoundary, int closeVirtualBoundary, long qualifiers, IReparseInfo reparseInfo) {
                super(operatorType, operatorKind, operatorText, offset, virtualOffset, line, openBoundary, openVirtualBoundary, closeBoundary, closeVirtualBoundary, qualifiers, reparseInfo);
                this.openVirtualBoundary = openVirtualBoundary;
            }

            @Override
            public int getOpenVirtualBoundary() {
                return this.openVirtualBoundary;
            }
        }

        private static class StandInOperator_______OV___
        extends StandInOperator {
            private static final long serialVersionUID = 1L;
            private int openVirtualBoundary;

            public StandInOperator_______OV___(int operatorType, IHidOperatorConstants.OperatorKind operatorKind, String operatorText, int offset, int virtualOffset, int line, int openBoundary, int openVirtualBoundary, int closeBoundary, int closeVirtualBoundary, long qualifiers, IReparseInfo reparseInfo) {
                super(operatorType, operatorKind, operatorText, offset, virtualOffset, line, openBoundary, openVirtualBoundary, closeBoundary, closeVirtualBoundary, qualifiers, reparseInfo);
                this.openVirtualBoundary = openVirtualBoundary;
            }

            @Override
            public int getOpenVirtualBoundary() {
                return this.openVirtualBoundary;
            }
        }

        private static class StandInOperator__________CV
        extends StandInOperator {
            private static final long serialVersionUID = 1L;
            private int closeVirtualBoundary;

            public StandInOperator__________CV(int operatorType, IHidOperatorConstants.OperatorKind operatorKind, String operatorText, int offset, int virtualOffset, int line, int openBoundary, int openVirtualBoundary, int closeBoundary, int closeVirtualBoundary, long qualifiers, IReparseInfo reparseInfo) {
                super(operatorType, operatorKind, operatorText, offset, virtualOffset, line, openBoundary, openVirtualBoundary, closeBoundary, closeVirtualBoundary, qualifiers, reparseInfo);
                this.closeVirtualBoundary = closeVirtualBoundary;
            }

            @Override
            public int getCloseVirtualBoundary() {
                return this.closeVirtualBoundary;
            }
        }
    }
}

