/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection.semantic.extension;

import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.utils.DVTIdentityArrayList;

public class HidVisitor
implements IHidVisitor<Hid> {
    protected List<Hid> objects;
    protected HidQualifier[] qualifiers;
    protected long qualifierSet;
    private ParserPath parserPath;
    private Set<ParserPath> changedFiles;

    public HidVisitor(HidQualifier[] qualifiers) {
        this.qualifiers = qualifiers;
        this.qualifierSet = 0L;
        this.objects = new DVTIdentityArrayList<Hid>();
        if (qualifiers != null && qualifiers.length != 0) {
            HidQualifier[] hidQualifierArray = qualifiers;
            int n = qualifiers.length;
            int n2 = 0;
            while (n2 < n) {
                HidQualifier qualifier = hidQualifierArray[n2];
                if (qualifier != null) {
                    this.qualifierSet |= qualifier.value();
                }
                ++n2;
            }
        }
    }

    @Override
    public void setHolder(IHidHolder holder) {
    }

    @Override
    public void setParserPath(ParserPath parserPath) {
        this.parserPath = parserPath;
    }

    public void changedFiles(Set<ParserPath> changedFiles) {
        this.changedFiles = changedFiles;
    }

    @Override
    public boolean visit(Hid operator) {
        if (this.qualifiers == null || this.qualifiers.length == 0) {
            return false;
        }
        if (this.changedFiles != null && !this.changedFiles.contains(this.parserPath)) {
            return true;
        }
        if (this.qualifierSet > 0L && operator.hasOccurrence(this.qualifierSet) || this.qualifierSet == 0L && operator.hasOccurrence(null)) {
            this.objects.add(operator);
        }
        return true;
    }

    public List<Hid> getObjects() {
        return this.objects;
    }

    @Override
    public Class<Hid> getType() {
        return Hid.class;
    }
}

