/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection.semantic.extension;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELEnumTypeWrapper;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.DVTXVariableInfo;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.utils.BitVectorContext;

public interface IHidEvaluator {
    public ELManager getManager();

    default public boolean isInterpreter() {
        return false;
    }

    default public AtomicBoolean hasParamReferences() {
        return new AtomicBoolean(false);
    }

    default public boolean noDataTypeCache() {
        return false;
    }

    default public IELParamValue getValueDirectly(String name) {
        return IELParamValue.UNDEFINED_VALUE;
    }

    default public void putValueDirectly(String name, IELParamValue value) {
    }

    default public ELParamValueScope getValue(IHid hid, BitVectorContext context, IHidEvaluationGuardian guardian) {
        return ELParamValueScope.UNDEFINED_VALUE;
    }

    default public ELParamValueScope getValue(IHid hid, IHidEvaluator hidEnclosing, BitVectorContext context, boolean isMethod, IHidEvaluationGuardian guardian) {
        return this.getValue(hid, context, guardian);
    }

    default public void updateValue(String name, IRfNamedElement element, IELParamValue newResult, boolean asDeclaration) {
    }

    default public void pushScope(boolean isCaseSensitive) {
    }

    default public void popScope() {
    }

    default public IELParamValue getResult(BitVectorContext context) {
        return IELParamValue.UNDEFINED_VALUE;
    }

    default public IELParamValue createEnclosedValueHolder(IRfNamedElement namedElement) {
        return IELParamValue.UNDEFINED_VALUE;
    }

    default public ELEnumTypeWrapper createEnumTypeWrapper(IRfNamedElement namedElement) {
        return null;
    }

    default public Map<DVTXVariableInfo, IELParamValue> debuggerGetVariables(boolean isFirstStackFrame, boolean isBreakOnFirst) {
        return null;
    }

    default public Map<DVTXVariableInfo, IELParamValue> debuggerGetVariables(boolean isFirstStackFrame) {
        return this.debuggerGetVariables(isFirstStackFrame, false);
    }

    default public boolean debuggerHasVariables(boolean isFirstStackFrame) {
        Map<DVTXVariableInfo, IELParamValue> variables = this.debuggerGetVariables(false, true);
        return variables != null && !variables.isEmpty();
    }

    default public IELParamValue debuggerGetVariable(String variableName, IRfNamedElement element) {
        return null;
    }

    default public String debuggerGetValueString(String variableName, IELParamValue variableValue) {
        if (variableValue == null) {
            return "[null]";
        }
        if (variableValue instanceof ELParamValues.ParamValueNumber.ArraySliceHolder) {
            return "";
        }
        if (variableValue instanceof XArrayValueHolder && ((XArrayValueHolder)variableValue).isMapEntry()) {
            return "";
        }
        if (variableValue instanceof XValueHolder) {
            XValueHolder xVariableValueHolder = (XValueHolder)variableValue;
            if (xVariableValueHolder.isStruct(false)) {
                return xVariableValueHolder.toNiceString(null, 10, false, false);
            }
            return xVariableValueHolder.toUniqueString(false);
        }
        if (variableValue instanceof ELParamValues.ParamValueNumber && variableValue.getDVTNumber().isStruct(false)) {
            return ((ELParamValues.ParamValueNumber)variableValue).toNiceStringStructs();
        }
        if (variableName.startsWith("[repeat index @")) {
            return variableValue.bigIntegerValue().toString();
        }
        String niceString = variableValue.toNiceString(null, 16, false, false);
        if (niceString.length() > 10000) {
            return niceString.substring(0, 7500).concat(" ...");
        }
        return niceString;
    }

    default public int debuggerCollectionSize() {
        return -1;
    }

    default public IRfNamedElement getNamedElement() {
        return null;
    }

    default public IRfNamedElement getElement() {
        return null;
    }

    default public ELEnumTypeWrapper getEnumTypeWrapper() {
        return null;
    }

    default public void prepareHotSwap() {
        ELManager manager = this.getManager();
        if (manager != null) {
            manager.prepareHotSwap();
        }
    }

    default public ELParamValues getLastValueContainer() {
        return null;
    }

    default public void copyValues(IHidEvaluator source) {
    }

    default public void putAllValues(IHidEvaluator source) {
    }

    default public void resolveHidInContext(IHidObject hidObject, IHidEvaluationGuardian guardian, boolean lintCall) {
        if (hidObject == null || guardian == null) {
            return;
        }
        Hid hidToResolve = HidUtils.getHidToResolveInContext(hidObject, guardian);
        if (hidToResolve != null) {
            hidToResolve.resolveInContext(this, guardian, null, lintCall);
        }
    }

    default public IHidEvaluationGuardian getCachedSimGuardian(boolean createCopy) {
        return null;
    }

    default public boolean isBBox() {
        return false;
    }

    default public boolean isTypeResolver() {
        return false;
    }

    public static class NullHidEvaluator
    implements IHidEvaluator {
        @Override
        public ELManager getManager() {
            return null;
        }
    }
}

