/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection.semantic.extension;

import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;

public interface IHidHolderConstants {
    public static final int NO_ACCESS = Integer.MIN_VALUE;
    public static final int DOT_ACCESS = 0;
    public static final int COLON_ACCESS = 1;
    public static final int ARGUMENT_ACCESS = 4;
    public static final int COLON_COLON_ACCESS = 2;
    public static final int RANDOMIZE_ACCESS = 3;
    public static final int ATTRIBUTE_ACCESS = 5;

    public static class HidRequest {
        public final Hid hid;
        public final ParserPath parserPath;
        public final HidOccurrence occurrence;
        public final int openBoundary;

        private HidRequest(Hid hid, ParserPath parserPath, HidOccurrence occurrence, int openBoundary) {
            this.hid = hid;
            this.parserPath = parserPath;
            this.occurrence = occurrence;
            this.openBoundary = openBoundary;
        }

        public static final HidRequest of(Hid hid, ParserPath parserPath, HidOccurrence occurrence, int openBoundary) {
            if (hid == null || parserPath == null || occurrence == null) {
                return null;
            }
            return new HidRequest(hid, parserPath, occurrence, openBoundary);
        }

        public String toString() {
            return String.valueOf(this.hid.name) + "@[" + this.occurrence.getOffset() + "]";
        }
    }

    public static class OperatorRequest {
        public final HidOperator operator;
        public final ParserPath parserPath;
        public final HidOperatorOccurrence occurrence;

        private OperatorRequest(HidOperator operator, ParserPath parserPath, HidOperatorOccurrence occurrence) {
            this.operator = operator;
            this.parserPath = parserPath;
            this.occurrence = occurrence;
        }

        public static final OperatorRequest of(HidOperator operator, ParserPath parserPath, HidOperatorOccurrence occurrence) {
            if (operator == null || parserPath == null || occurrence == null) {
                return null;
            }
            return new OperatorRequest(operator, parserPath, occurrence);
        }

        public String toString() {
            return String.valueOf(HidUtils.toString(this.operator, true, true)) + "@[" + this.occurrence.getOffset() + "]";
        }
    }
}

