/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection.semantic.extension;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.model.reflection.IRfAssertExpectElement;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfClassElement;
import ro.amiq.dvt.model.reflection.IRfCompositeTypeElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.assertion.AssertTM;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidAccessArgs;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOccurrenceHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.util.AssociationUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.MaskType;
import ro.amiq.dvt.utils.VlogBitVector;

public interface IHidOperator
extends IHidObject,
IHidOperatorConstants,
IHidOccurrenceHolder {
    default public boolean addLHValue(IHidObject lhValue) {
        return this.addLHValue(lhValue, true);
    }

    default public boolean addRHValue(IHidObject rhValue) {
        return this.addRHValue(rhValue, true);
    }

    public boolean addLHValue(IHidObject var1, boolean var2);

    public boolean addRHValue(IHidObject var1, boolean var2);

    public IHidObject getLHValue();

    public ListContainer<IHidObject> getRHValues();

    default public boolean hasRHValues() {
        ListContainer<IHidObject> rhValues = this.getRHValues();
        return rhValues != null && !rhValues.isEmpty();
    }

    default public IHidObject getFirstRHValue() {
        ListContainer<IHidObject> rhValues = this.getRHValues();
        return rhValues != null && !rhValues.isEmpty() ? rhValues.get(0) : null;
    }

    @Override
    public void deepClean();

    public IHidOperatorConstants.OperatorKind getOperatorKind();

    public int getOperatorType();

    public String getOperatorText();

    public Set<IHid> getLHHids(Set<HidFlatteningOption> var1);

    public Set<IHid> getRHHids(Set<HidFlatteningOption> var1);

    public boolean hasOccurrence(HidOperatorQualifier var1);

    @Override
    @NotNull
    public HidOperatorOccurrence getOccurrence();

    default public ISDataAbstract getOperatorResolvedType() {
        return null;
    }

    default public Map<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> getSpecifiedArgumentValues() {
        return null;
    }

    public boolean isOperatorResolved();

    public boolean isComplete();

    public LanguageKind getLanguageKind();

    default public boolean isRangeOrPartSelect() {
        return false;
    }

    default public boolean isAssociation() {
        return IHidOperatorConstants.OperatorType.ASSOCIATION.id == this.getOperatorType();
    }

    default public boolean isEventControlOR() {
        return IHidOperatorConstants.OperatorType.EVENT_CONTROL_OR.id == this.getOperatorType();
    }

    default public boolean isAssignment() {
        return false;
    }

    default public boolean isImply() {
        return false;
    }

    default public boolean isNBAssignment() {
        return false;
    }

    default public boolean isInequality() {
        return false;
    }

    default public boolean isEqualityOrInequality() {
        return false;
    }

    default public boolean isEquality() {
        return IHidOperatorConstants.OperatorType.QUA_EQUALITY.id == this.getOperatorType();
    }

    default public boolean isMinus() {
        return false;
    }

    default public boolean isPlus() {
        return false;
    }

    default public boolean isArithmetic() {
        return false;
    }

    default public boolean isLogical() {
        return false;
    }

    default public boolean isLogicalNot() {
        return false;
    }

    default public boolean isLogicalShift() {
        return false;
    }

    default public boolean isColon() {
        return false;
    }

    default public boolean isIfCondition() {
        return IHidOperatorConstants.OperatorType.IF_CONDITION.id == this.getOperatorType();
    }

    default public boolean isCaseCondition() {
        return IHidOperatorConstants.OperatorType.CASE_CONDITION.id == this.getOperatorType();
    }

    default public boolean isCaseItemCondition() {
        return IHidOperatorConstants.OperatorType.CASE_ITEM_CONDITION.id == this.getOperatorType();
    }

    default public boolean isForCondition() {
        return IHidOperatorConstants.OperatorType.FOR_CONDITION.id == this.getOperatorType();
    }

    default public boolean isIfElseStatement() {
        return IHidOperatorConstants.OperatorType.IF_ELSE_STATEMENT.id == this.getOperatorType();
    }

    default public boolean isForeachStatement() {
        return IHidOperatorConstants.OperatorType.FOREACH_LOOP_STATEMENT.id == this.getOperatorType();
    }

    default public boolean isActionBlockCondition() {
        return this.isIfCondition() || this.isForCondition() || this.isCaseCondition() || this.isRepeatCondition() || this.isWhileCondition() || this.isCaseItemCondition();
    }

    default public boolean isAssertStatement() {
        return IHidOperatorConstants.OperatorType.ASSERT_STATEMENT.id == this.getOperatorType();
    }

    default public boolean isReturnStatement() {
        return false;
    }

    default public boolean isSeqBlockStatement() {
        return IHidOperatorConstants.OperatorType.SEQ_BLOCK_STATEMENT.id == this.getOperatorType();
    }

    default public boolean isWaitEventControl() {
        return false;
    }

    default public boolean isWaitStatement() {
        return false;
    }

    default public boolean isForce() {
        return this.hasOccurrence(HidQualifierCache.IS_PROCEDURAL_FORCE_ASSIGN_QUALIFIER);
    }

    default public boolean isRelease() {
        return false;
    }

    default public boolean isDeposit() {
        return false;
    }

    default public boolean isExprOrBitSelect() {
        return false;
    }

    default public boolean isAnyEdgeEvent() {
        return false;
    }

    default public boolean isTickCast() {
        return false;
    }

    default public boolean isInside() {
        return false;
    }

    default public boolean isConditionalTernary() {
        return false;
    }

    default public boolean isPlusIndexPartSelect() {
        return false;
    }

    default public boolean isMinusIndexPartSelect() {
        return false;
    }

    default public boolean isSequenceCycleDelayRange() {
        return IHidOperatorConstants.OperatorType.SEQ_CYCLE_DELAY_RANGE.id == this.getOperatorType();
    }

    default public boolean isSequenceRepetition() {
        return IHidOperatorConstants.OperatorType.SEQ_REPETITION.id == this.getOperatorType();
    }

    default public boolean isSequenceAbbrev() {
        return IHidOperatorConstants.OperatorType.SEQ_ABBREV.id == this.getOperatorType();
    }

    default public boolean isVLOGConcatenation(boolean allowNonStandard) {
        if (allowNonStandard && this.isNonStandardAssignmentPattern()) {
            return true;
        }
        return IHidOperatorConstants.OperatorType.CONCATENATION.id == this.getOperatorType();
    }

    default public boolean isStreamConcatenation() {
        return IHidOperatorConstants.OperatorType.STREAM_CONCATENATION_GT.id == this.getOperatorType() || IHidOperatorConstants.OperatorType.STREAM_CONCATENATION_LT.id == this.getOperatorType();
    }

    default public boolean isInsideSet() {
        return IHidOperatorConstants.OperatorType.INSIDE_SET.id == this.getOperatorType();
    }

    default public boolean isDistSet() {
        return IHidOperatorConstants.OperatorType.DIST_SET.id == this.getOperatorType();
    }

    default public boolean isAssignmentPattern() {
        return IHidOperatorConstants.OperatorType.ASSIGNMENT_PATTERN.id == this.getOperatorType();
    }

    default public boolean isNonStandardAssignmentPattern() {
        return IHidOperatorConstants.OperatorType.NON_STANDARD_ASSIGNMENT_PATTERN.id == this.getOperatorType();
    }

    default public boolean isForeachCondition() {
        return IHidOperatorConstants.OperatorType.FOREACH_CONDITION.id == this.getOperatorType();
    }

    default public boolean isWhileCondition() {
        return IHidOperatorConstants.OperatorType.WHILE_CONDITION.id == this.getOperatorType();
    }

    default public boolean isRepeatCondition() {
        return IHidOperatorConstants.OperatorType.REPEAT_CONDITION.id == this.getOperatorType();
    }

    default public boolean isForStep() {
        return IHidOperatorConstants.OperatorType.FOR_STEP.id == this.getOperatorType();
    }

    default public boolean isForInit() {
        return IHidOperatorConstants.OperatorType.FOR_INIT.id == this.getOperatorType();
    }

    default public boolean isConcatOrAssignPatternOperator() {
        return this.isVLOGConcatenation(true) || this.isStreamConcatenation() || this.isAssignmentPattern();
    }

    default public boolean isIffExpression() {
        return false;
    }

    default public boolean isWithCoverpointBinsExpression() {
        return false;
    }

    default public boolean isCovergroupRangeList() {
        return false;
    }

    default public boolean isTransList() {
        return false;
    }

    default public boolean isIllegalBins() {
        return false;
    }

    default public boolean isBins() {
        return false;
    }

    default public boolean isBinsof() {
        return false;
    }

    default public boolean isIntersect() {
        return false;
    }

    default public boolean isIgnoreBins() {
        return false;
    }

    default public boolean isBinAssignment() {
        return false;
    }

    default public boolean isCoverageOptionAssignment() {
        return false;
    }

    default public boolean isCoverpointExpression() {
        return false;
    }

    default public boolean isBreakStatement() {
        return false;
    }

    default public boolean isContinueStatement() {
        return false;
    }

    default public boolean isLetBody() {
        return IHidOperatorConstants.OperatorType.LET_BODY.id == this.getOperatorType();
    }

    default public boolean isVoidCast() {
        return false;
    }

    default public boolean isVlogDelayControlStatement() {
        return false;
    }

    default public boolean isDriveStrength() {
        return false;
    }

    default public boolean isDeassign() {
        return false;
    }

    default public boolean isVlogDisableForkStatement() {
        if (!this.isDisableStatement()) {
            return false;
        }
        IHidObject lhSide = this.getLHValue();
        return lhSide instanceof IHidImplicit && ((IHidImplicit)lhSide).isDisableFork();
    }

    default public boolean isDisableStatement() {
        return false;
    }

    default public boolean isSoftConstraint() {
        return false;
    }

    default public boolean isConstraintSeqBlock() {
        return false;
    }

    default public boolean isIncrementOrDecrement() {
        return false;
    }

    default public boolean isIncrement() {
        return false;
    }

    default public boolean isDecrement() {
        return false;
    }

    default public boolean isBitwise() {
        return false;
    }

    default public boolean isReduction() {
        return false;
    }

    default public boolean isRelational() {
        return false;
    }

    default public boolean isPlusEqual() {
        return false;
    }

    default public boolean isMinusEqual() {
        return false;
    }

    default public boolean isVlogEventControl() {
        return false;
    }

    default public boolean isVlogEventTrigger() {
        return false;
    }

    default public boolean isArithmeticShift() {
        return false;
    }

    default public boolean isWithClause() {
        return false;
    }

    default public boolean isWith() {
        return false;
    }

    default public boolean isLogicalAnd() {
        return false;
    }

    default public boolean isLogicalOr() {
        return false;
    }

    default public boolean isWithClauseConstraint() {
        return false;
    }

    default public boolean isPound() {
        return false;
    }

    default public boolean isPoundPound() {
        return false;
    }

    default public boolean isRepeat() {
        return false;
    }

    default public boolean isMinTypMax() {
        return false;
    }

    default public boolean isTypeReference() {
        return false;
    }

    default public boolean isComma() {
        return false;
    }

    default public boolean isSignalAssignment() {
        return false;
    }

    default public boolean isLiteralRange() {
        return false;
    }

    default public boolean isAggregate() {
        return IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR == this.getOperatorKind() && this.hasOccurrence(HidOperatorQualifier.IS_AGGREGATE);
    }

    default public boolean isSelectList() {
        return IHidOperatorConstants.OperatorType.SELECT_LIST.id == this.getOperatorType();
    }

    default public boolean isVHDLConcatenation() {
        return false;
    }

    default public boolean isVhdlEventControl() {
        return false;
    }

    default public boolean isChoicesOR() {
        return false;
    }

    default public boolean isSignatureArgs() {
        return IHidOperatorConstants.OperatorType.SIGNATURE_ARGS.id == this.getOperatorType();
    }

    default public boolean isSignature() {
        return IHidOperatorConstants.OperatorType.SIGNATURE.id == this.getOperatorType();
    }

    default public boolean isExternalName() {
        return IHidOperatorConstants.OperatorType.EXTERNAL_NAME.id == this.getOperatorType();
    }

    default public boolean isReport() {
        return false;
    }

    default public boolean isNext() {
        return false;
    }

    default public boolean isExit() {
        return false;
    }

    default public boolean isBar() {
        return false;
    }

    default public boolean isDeclarationList() {
        return false;
    }

    default public HidOperator shallowCopy() {
        return (HidOperator)this;
    }

    @Override
    default public HidOperator hidObjectCopy() {
        return (HidOperator)this;
    }

    default public HidOperator shallowCopy(MaskType[] driveStrength) {
        return (HidOperator)this;
    }

    default public List<XEventControl> xEventControls(IHidEvaluationGuardian guardian) {
        return null;
    }

    default public List<XEventControlValue> xEventControlValues(List<XEventControl> eventControls, IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
        return null;
    }

    default public boolean xEventTriggered(List<XEventControlValue> prevValues, List<XEventControlValue> currValues, IHidEvaluationGuardian guardian) {
        return false;
    }

    default public ELParamValueScope xPostMethodExecute(IELParamValue returnResult, BitVectorContext context, IHidEvaluationGuardian guardian) {
        return ELParamValueScope.UNDEFINED_VALUE;
    }

    default public String getLabel() {
        return null;
    }

    default public boolean xIsDriverOnLHS() {
        return false;
    }

    default public IHidObject xGetAssignmentLHS() {
        return this.getLHValue();
    }

    default public String xGetCanonicEventControlKey(IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
        List<XEventControl> eventControls;
        block9: {
            eventControls = this.xEventControls(guardian);
            if (eventControls != null && !eventControls.isEmpty()) break block9;
            return null;
        }
        try {
            XValueHolderFactory factory = guardian.getFactory();
            ArrayList<String> eventControlNames = new ArrayList<String>(eventControls.size());
            for (XEventControl eventControl : eventControls) {
                if (HidUtils.isHid(eventControl.hidObject)) {
                    if (eventControl.hidObject == Hid.EVALUATE_SKIP_HID) continue;
                    IELParamValue value = XUtils.getValue(ELUtils.evaluate(eventControl.hidObject, evaluator, null, guardian.copy()));
                    IELParamValue original = XUtils.getOriginal(value, false);
                    int uniqueId = factory.getUniqueId(original, true);
                    eventControlNames.add(DVTStringUtil.appendString(new Object[]{eventControl.eventKind, "_", uniqueId}));
                    continue;
                }
                if (HidUtils.isHidAccess(eventControl.hidObject)) {
                    Hid parentHid = XUtils.getParentHid(eventControl.hidObject);
                    IELParamValue value = XUtils.getValue(ELUtils.evaluate(parentHid, evaluator, null, guardian.copy()));
                    IELParamValue original = XUtils.getOriginal(value, false);
                    StringBuilder selectsText = new StringBuilder();
                    List<IHidObject> selects = ((HidAccess)eventControl.hidObject).getSelects();
                    if (selects != null && !selects.isEmpty()) {
                        for (IHidObject select : selects) {
                            if (HidUtils.isOperator(select) && ((HidOperator)select).isRangeOrPartSelect()) {
                                String left = IHidOperator.getOperandStringValue(((HidOperator)select).lhValue, evaluator, guardian);
                                String right = IHidOperator.getOperandStringValue(((HidOperator)select).rhValues.get(0), evaluator, guardian);
                                selectsText.append("[").append(left).append(" : ").append(right).append("]");
                                continue;
                            }
                            selectsText.append(IHidOperator.getOperandStringValue(select, evaluator, guardian));
                        }
                    }
                    int uniqueId = factory.getUniqueId(original, true);
                    eventControlNames.add(DVTStringUtil.appendString(new Object[]{eventControl.eventKind, "_", uniqueId, "[", selectsText, "]"}));
                    continue;
                }
                eventControlNames.add(DVTStringUtil.appendString((Object)((Object)eventControl.eventKind) + "_" + HidUtils.toString(eventControl.hidObject, true, true)));
            }
            Collections.sort(eventControlNames);
            return String.join((CharSequence)"|", eventControlNames);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public static String getOperandStringValue(IHidObject hidObject, IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
        boolean isGenerateBlock = XUtils.isGenerateBlockInstance(evaluator);
        if (HidUtils.isHidImplicit(hidObject) || !isGenerateBlock) {
            return HidUtils.toString(hidObject, true, true);
        }
        IELParamValue value = XUtils.getValue(ELUtils.evaluate(hidObject, evaluator, null, guardian.copy()));
        return value.toStringRadix(10);
    }

    default public boolean isNullTest(IHidObject hidObject) {
        return false;
    }

    default public boolean isNotNullTest(IHidObject hidObject) {
        return false;
    }

    default public AssertTM transformConcurrentAssert(HidEvalCenter.ConcurrentAssertStatement concurrentAssertStatement, IHidEvaluator evaluator, IRfAssertExpectElement assertElement, HidOperator alwaysEventControlOperator, IHidEvaluationGuardian guardian) {
        return null;
    }

    default public boolean isAssertBinary() {
        return false;
    }

    default public boolean isAssertSequential() {
        return false;
    }

    default public boolean isDisableIffExpr() {
        return false;
    }

    default public boolean isOverlappingImplication() {
        return false;
    }

    default public boolean isNonOverlappingImplication() {
        return false;
    }

    default public boolean isCycleDelayConst() {
        return false;
    }

    default public boolean isCycleDelayRange() {
        return false;
    }

    default public boolean isNotOperator() {
        return false;
    }

    public static class XEventControl {
        public IHidObject hidObject;
        public XEventControlKind eventKind;
        public IHidObject iffCondOperator;
        public HidAccess cbAccessEval;
        public Set<IHid> hids;

        public XEventControl(IHidObject hidObject, XEventControlKind eventKind, HidAccess cbAccessEval, IHidObject iffCondOperator) {
            this.hidObject = hidObject;
            this.eventKind = eventKind;
            this.iffCondOperator = iffCondOperator;
            this.cbAccessEval = cbAccessEval;
            this.hids = new LinkedHashSet<IHid>();
            this.extractHids(this.hids, hidObject);
        }

        private void extractHids(Set<IHid> result, IHidObject hidObject) {
            if (HidUtils.isHidImplicit(hidObject)) {
                return;
            }
            if (HidUtils.isHid(hidObject)) {
                if (AssociationUtils.isConnectedType(hidObject)) {
                    return;
                }
                result.add((IHid)hidObject);
                IHid parentHid = ((IHid)hidObject).getParentHid();
                while (parentHid != null && parentHid.getElement() instanceof IRfAssociatedTypeElement) {
                    IRfNamedElement iRfNamedElement2 = ((IRfAssociatedTypeElement)parentHid.getElement()).getAssociatedType();
                    iRfNamedElement2 = XValueHolderFactory.unwrapTypeAlias(iRfNamedElement2);
                    if (iRfNamedElement2 instanceof IRfClassElement || iRfNamedElement2 instanceof IRfCompositeTypeElement) {
                        result.add(parentHid);
                    }
                    parentHid = parentHid.getParentHid();
                }
                return;
            }
            if (HidUtils.isHidAccessArgs(hidObject)) {
                this.extractHids(result, ((HidAccess)hidObject).getParentHid());
                List<? extends IHidObject> argValues = ((IHidAccessArgs)((Object)hidObject)).getArgumentValues();
                if (argValues != null) {
                    for (IHidObject iHidObject : argValues) {
                        this.extractHids(result, iHidObject);
                    }
                }
                return;
            }
            if (HidUtils.isOperator(hidObject)) {
                ListContainer<IHidObject> listContainer;
                IHidObject lhValue = ((HidOperator)hidObject).lhValue;
                if (lhValue != null) {
                    this.extractHids(result, lhValue);
                }
                if ((listContainer = ((HidOperator)hidObject).rhValues) != null) {
                    for (IHidObject rhValue : listContainer) {
                        this.extractHids(result, rhValue);
                    }
                }
                return;
            }
            if (HidUtils.isHidAccess(hidObject)) {
                this.extractHids(result, ((HidAccess)hidObject).getParentHid());
                List<IHidObject> selects = ((HidAccess)hidObject).getSelects();
                if (selects != null) {
                    for (IHidObject iHidObject : selects) {
                        this.extractHids(result, iHidObject);
                    }
                }
                return;
            }
        }
    }

    public static enum XEventControlKind {
        POSEDGE,
        NEGEDGE,
        EDGE,
        CHANGE;

    }

    public static class XEventControlValue {
        public IELParamValue value;
        public XEventControlKind eventKind;
        public IELParamValue original;
        public IHidObject hidObject;
        public IHidEvaluator scope;
        public boolean isIffCondTrue;
        public boolean isEvent;
        public boolean isArray;

        public XEventControlValue(IHidObject hidObject, ELParamValueScope valueScope, boolean isIffCondTrue, XEventControlKind eventKind) {
            if (valueScope != null && valueScope.value instanceof XValueHolder.XEventValueHolder) {
                this.value = ELParamValues.ParamValueNumber.of(((XValueHolder.XEventValueHolder)valueScope.value).getDVTNumber());
            } else if (valueScope != null && valueScope.value instanceof XArrayValueHolder) {
                this.value = ((XArrayValueHolder)valueScope.value).copyByValue();
            } else if (valueScope != null && valueScope.value instanceof XValueHolder) {
                int uniqueValuesId = valueScope.value.isNull() ? -1 : ((XValueHolder)valueScope.value).uniqueValuesId();
                this.value = ELParamValues.ParamValueNumber.of(VlogBitVector.createConstant(uniqueValuesId));
            } else if (valueScope != null && valueScope.value != null) {
                this.value = ELParamValues.ParamValueNumber.of(valueScope.value);
            }
            this.hidObject = hidObject;
            this.original = valueScope == null ? null : XUtils.getOriginal(valueScope.value, true);
            this.isIffCondTrue = isIffCondTrue;
            this.eventKind = eventKind;
            this.isEvent = valueScope != null && valueScope.value instanceof XValueHolder.XEventValueHolder;
            this.isArray = valueScope != null && valueScope.value instanceof XArrayValueHolder;
            this.scope = valueScope == null ? null : valueScope.scope;
        }

        public int getUniqueId(IHidEvaluationGuardian guardian) {
            XValueHolderFactory factory = guardian.getFactory();
            return factory.getUniqueId(this.original, false);
        }
    }
}

