/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection.semantic.extension2;

import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.model.ELWidthCheckContext;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.semantic.extension2.DummyDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.DummyElement;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISTransformer;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataTypeAndCategoryPair;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataTypeCategory;

public class SDataAbstracts {
    public static final Map<ISDataType, SDataTypeAndCategoryPair> ALL_KNOWN_SCALARS = new HashMap<ISDataType, SDataTypeAndCategoryPair>();
    private static final Map<LanguageKind, ISTransformer> LANG_SPECIFIC_TRANSFORMERS = new EnumMap<LanguageKind, ISTransformer>(LanguageKind.class);
    public static final DummyElement UNDEFINED_ELEMENT = new DummyElement("undefined");
    public static final DummyElement UNDEFINED_TYPE_ELEMENT = new DummyElement("type_undefined");
    public static final DummyElement ILLEGAL_ELEMENT = new DummyElement("illegal");
    public static final DummyElement NON_STANDARD_ELEMENT = new DummyElement("non_standard");
    public static final DummyElement PARAMETER_UNTYPED_ELEMENT = new DummyElement("parameter_untyped");
    public static final ISDataType ILLEGAL = DummyDataType.of(ILLEGAL_ELEMENT);
    public static final ISDataType NON_STANDARD = DummyDataType.of(NON_STANDARD_ELEMENT);
    public static final ISDataType UNDEFINED = DummyDataType.of(UNDEFINED_ELEMENT);
    public static final ISDataType TYPE_UNDEFINED = DummyDataType.of(UNDEFINED_TYPE_ELEMENT);
    public static final ISDataType PARAMETER_UNTYPED = DummyDataType.of(PARAMETER_UNTYPED_ELEMENT);
    public static final DummyElement NULL_IMPLICIT = new DummyElement("null");
    public static final DummyElement NEW_IMPLICIT = new DummyElement("new");
    public static final DummyElement ANY_AGGREGATE = new DummyElement("any_aggregate");
    public static final DummyElement OTHERS_DUMMY = new DummyElement("OTHERS");
    public static final DummyElement OPEN_DUMMY = new DummyElement("OPEN");
    public static final ISDataType NULL = DummyDataType.of(NULL_IMPLICIT);
    public static final ISDataType NEW = DummyDataType.of(NEW_IMPLICIT);
    public static final String DVT_UNIVERSAL_TYPE_PREFIX = "UNIVERSAL_";
    public static final String DVT_CUSTOM_TYPE_PREFIX = "DVT81b441bd_";
    public static final String DVT_CUSTOM_TYPE_PREFIX_LWCASE = "dvt81b441bd_";

    public static ISDataAbstract get(IRfNamedElement element, IRfNamedElement scope, ELWidthCheckContext elabContext, HashSet<IRfNamedElement> visited, LanguageKind evaluatorLanguage, boolean isFinal, boolean isVariable, boolean dimensionsWithMacros, boolean isNetAlias, boolean isRNMTech) {
        if (element == null) {
            return UNDEFINED;
        }
        LanguageKind elementLanguage = element.getLanguageKind();
        if (elementLanguage == null) {
            elementLanguage = LanguageKind.VLOG;
        }
        if (elementLanguage != evaluatorLanguage) {
            return UNDEFINED;
        }
        ISTransformer transformer = LANG_SPECIFIC_TRANSFORMERS.get((Object)elementLanguage);
        if (transformer == null) {
            return UNDEFINED;
        }
        return transformer.transform(element, scope, elabContext, visited, isFinal, isVariable, dimensionsWithMacros, isNetAlias, isRNMTech);
    }

    public static ISDataAbstract get(Collection<? extends IRfNamedElement> elements, boolean isFinal, boolean isVariable) {
        ISTransformer transformer;
        if (elements == null || elements.isEmpty()) {
            return UNDEFINED;
        }
        LanguageKind languageKind = elements.iterator().next().getLanguageKind();
        if (languageKind == null) {
            languageKind = LanguageKind.VLOG;
        }
        if ((transformer = LANG_SPECIFIC_TRANSFORMERS.get((Object)languageKind)) == null) {
            return UNDEFINED;
        }
        return transformer.transform(elements, isFinal, isVariable);
    }

    @NotNull
    public static SDataTypeCategory getOperandCategory(ISDataAbstract dataAbstract) {
        ISTransformer transformer;
        if (dataAbstract == null) {
            return SDataTypeCategory.UNKNOWN;
        }
        LanguageKind languageKind = dataAbstract.getLanguageKind();
        if (languageKind == null) {
            languageKind = LanguageKind.VLOG;
        }
        if ((transformer = LANG_SPECIFIC_TRANSFORMERS.get((Object)languageKind)) == null) {
            return SDataTypeCategory.NULL;
        }
        return transformer.getCategory(dataAbstract);
    }

    @NotNull
    public static ISDataType getCachedScalarDataType(ISDataType dataType) {
        SDataTypeAndCategoryPair categoryPair = ALL_KNOWN_SCALARS.get(dataType);
        return categoryPair != null ? categoryPair.getDataType() : UNDEFINED;
    }

    @NotNull
    public static SDataTypeCategory getDataTypeCategory(ISDataType dataType) {
        SDataTypeAndCategoryPair categoryPair;
        if (dataType.isUnderAlias()) {
            dataType = dataType.copy(false);
        }
        return (categoryPair = ALL_KNOWN_SCALARS.get(dataType)) != null ? categoryPair.getCategory() : SDataTypeCategory.UNKNOWN;
    }

    public static void putKnownScalar(ISDataType dataType, SDataTypeCategory category) {
        SDataTypeAndCategoryPair categoryPair = new SDataTypeAndCategoryPair(dataType, category);
        ALL_KNOWN_SCALARS.put(dataType, categoryPair);
    }

    public static SDataTypeAndCategoryPair getKnownScalar(ISDataType scalarType) {
        SDataTypeAndCategoryPair categoryPair = ALL_KNOWN_SCALARS.get(scalarType);
        return categoryPair;
    }

    public static void registerTransformer(LanguageKind languageKind, ISTransformer transformer) {
        if (LANG_SPECIFIC_TRANSFORMERS.containsKey((Object)languageKind)) {
            return;
        }
        LANG_SPECIFIC_TRANSFORMERS.put(languageKind, transformer);
    }
}

