/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection.semantic.extension2;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataAbstracts;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataVariable;

public class SDataUtils {
    private SDataUtils() {
    }

    public static final ISDataType getDataType(ISDataAbstract dataAbstract) {
        return dataAbstract instanceof SDataVariable ? ((SDataVariable)dataAbstract).type : (ISDataType)dataAbstract;
    }

    public static final SDataVariable getVariable(ISDataAbstract dataAbstract) {
        return dataAbstract instanceof SDataVariable ? (SDataVariable)dataAbstract : null;
    }

    public static final IRfNamedElement getVariableElement(ISDataAbstract dataAbstract) {
        return dataAbstract instanceof SDataVariable ? ((SDataVariable)dataAbstract).getVariable() : null;
    }

    public static final String getVariableName(ISDataAbstract dataAbstract, IHidObject value) {
        String variableName;
        String string = variableName = dataAbstract instanceof SDataVariable ? ((SDataVariable)dataAbstract).getVariableName() : "unknown";
        if (!"unknown".equals(variableName)) {
            return variableName;
        }
        String exprText = HidUtils.toStringBuilder(value, true, true, true, true, false, false).toString();
        if (exprText.length() > 30) {
            exprText = String.valueOf(exprText.substring(0, 30)) + "...";
        }
        return exprText.isEmpty() ? "unknown" : exprText;
    }

    public static final boolean isIllegalDataType(ISDataAbstract dataType) {
        return dataType == SDataAbstracts.ILLEGAL | dataType == SDataAbstracts.NON_STANDARD;
    }

    public static final ISDataAbstract getUndefinedDataType(ISDataAbstract dataType) {
        return dataType == SDataAbstracts.UNDEFINED | dataType == SDataAbstracts.TYPE_UNDEFINED | dataType == SDataAbstracts.ILLEGAL | dataType == SDataAbstracts.NON_STANDARD | dataType == SDataAbstracts.PARAMETER_UNTYPED ? dataType : null;
    }
}

