/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection.semantic.extension2;

import java.io.Serializable;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataType;

public class SDataVariable
implements ISDataAbstract,
Serializable {
    private static final long serialVersionUID = 1L;
    public final ISDataType type;
    public final boolean isFinal;

    public IRfNamedElement getEnumLiteral() {
        return null;
    }

    public boolean isEnumDeclarationAssign(HidOperator op) {
        return false;
    }

    private SDataVariable(ISDataType type, boolean isFinal) {
        this.type = type;
        this.isFinal = isFinal;
    }

    public static final SDataVariable of(ISDataType type, boolean isFinal) {
        if (type == null) {
            return null;
        }
        return new SDataVariable(type, isFinal);
    }

    public static final SDataVariable of(ISDataType type, IRfNamedElement variable, boolean isFinal) {
        if (type == null || variable == null) {
            return null;
        }
        if (type.getTypes().size() > 1) {
            return new SAmbiguousVariable(type, variable, isFinal);
        }
        return new SDataNamedVariable(type, variable, isFinal, false);
    }

    public IRfNamedElement getVariable() {
        return null;
    }

    public String getVariableName() {
        return "unknown";
    }

    @Override
    public LanguageKind getLanguageKind() {
        return this.type == null ? null : this.type.getLanguageKind();
    }

    public String toString() {
        return "[Variable " + this.getVariableName() + "][type " + this.type.toString() + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.isFinal ? 1231 : 1237);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SDataVariable other = (SDataVariable)obj;
        if (this.isFinal != other.isFinal) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public static class SAmbiguousVariable
    extends SDataNamedVariable {
        private static final long serialVersionUID = 1L;

        private SAmbiguousVariable(ISDataType dataType, IRfNamedElement variableType, boolean isFinal) {
            super(dataType, variableType, isFinal, false);
        }
    }

    private static class SDataNamedVariable
    extends SDataVariable {
        private static final long serialVersionUID = 1L;
        public final IRfNamedElement variable;

        private SDataNamedVariable(ISDataType type, IRfNamedElement variable, boolean isFinal, boolean isRandomize) {
            super(type, isFinal);
            this.variable = variable;
        }

        @Override
        public IRfNamedElement getVariable() {
            return this.variable;
        }

        @Override
        public String getVariableName() {
            return this.variable.getName();
        }

        @Override
        public IRfNamedElement getEnumLiteral() {
            return this.variable instanceof IRfFieldElement && ((IRfFieldElement)this.variable).getFieldKind() == 8 ? this.variable : null;
        }

        @Override
        public boolean isEnumDeclarationAssign(HidOperator operator) {
            if (!operator.hasOccurrence(HidOperatorQualifier.IS_DECLARATION_ASSIGN)) {
                return false;
            }
            return this.variable instanceof IRfFieldElement && ((IRfFieldElement)this.variable).getFieldKind() == 8;
        }
    }
}

