/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection.util;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidAccessArgs;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicitConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;

public class AssociationUtils {
    private static final boolean checkAssociation(IHidObject association, long qualifier) {
        return association instanceof IHidOperator && ((IHidOperator)association).hasOccurrence(qualifier);
    }

    static final boolean internalHasFormalPart(IHidObject association, long qualifier) {
        return AssociationUtils.getNiceFormalPart(association, qualifier) != null;
    }

    public static final IHidObject getNiceFormalPart(IHidObject association, long qualifier) {
        IHidObject internalFormal = AssociationUtils.getFormalPartRaw(association, qualifier);
        return !AssociationUtils.isConnectedType(internalFormal) && !AssociationUtils.isUnconnectedType(internalFormal) && !AssociationUtils.isDotStarConnectedType(internalFormal) ? internalFormal : null;
    }

    public static final IHidObject getFormalPartRaw(IHidObject association, long qualifier) {
        if (!AssociationUtils.checkAssociation(association, qualifier)) {
            return null;
        }
        return ((IHidOperator)association).getLHValue();
    }

    static final IHidObject getHidObjectOfFormalPart(IHidObject formalPart, boolean reduceToHid) {
        if (formalPart == null) {
            return null;
        }
        switch (formalPart.getHidKind()) {
            case HID: {
                return formalPart;
            }
            case ACCESS: {
                Hid parentHid = ((HidAccess)formalPart).getParentHid();
                if (formalPart instanceof IHidAccessArgs && HidUtils.isResolved(parentHid)) {
                    Set<IHid> actualPartHids;
                    List<? extends IHidObject> argumentValues = ((IHidAccessArgs)((Object)formalPart)).getArgumentValues();
                    if (argumentValues != null && argumentValues.size() == 1 && (actualPartHids = MethodCallUtils.getValueHids(argumentValues.get(0), HidFlatteningOption.NONE_EXCLUDED)).size() == 1) {
                        return HidUtils.getHidFrom(actualPartHids.iterator().next());
                    }
                    IHid value = HidUtils.getHidFrom(((HidAccess)formalPart).getTypeConversionValue());
                    if (value != null) {
                        return value;
                    }
                }
                return reduceToHid ? parentHid : formalPart;
            }
            case IMPLICIT: {
                return formalPart;
            }
        }
        return null;
    }

    static final IHid getFormalPartHid(IHidObject association, long qualifier) {
        return (IHid)AssociationUtils.getHidObjectOfFormalPart(AssociationUtils.getFormalPartRaw(association, qualifier), true);
    }

    static final IHidObject getFormalPartHidObject(IHidObject association, long qualifier) {
        return AssociationUtils.getHidObjectOfFormalPart(AssociationUtils.getFormalPartRaw(association, qualifier), false);
    }

    @NotNull
    static final String getFormalPartName(IHidObject association, long qualifier) {
        IHid portHid = (IHid)AssociationUtils.getHidObjectOfFormalPart(AssociationUtils.getNiceFormalPart(association, qualifier), true);
        return portHid == null || portHid.getName() == null ? "" : portHid.getName();
    }

    static final boolean internalHasActualPart(IHidObject association, long qualifier) {
        return AssociationUtils.getActualPart(association, qualifier) != null;
    }

    static final IHidObject getActualPart(IHidObject association, long qualifier) {
        IHidObject internalActualPart = AssociationUtils.getActualPartRaw(association, qualifier);
        return !AssociationUtils.isConnectedType(internalActualPart) && !AssociationUtils.isUnconnectedType(internalActualPart) && !AssociationUtils.isOpenUnconnectedType(internalActualPart) ? internalActualPart : null;
    }

    public static final IHidObject getActualPartRaw(IHidObject association, long qualifier) {
        if (!AssociationUtils.checkAssociation(association, qualifier)) {
            return association;
        }
        ListContainer<IHidObject> rhValues = ((IHidOperator)association).getRHValues();
        if (rhValues == null || rhValues.isEmpty()) {
            return null;
        }
        return rhValues.get(0);
    }

    @NotNull
    public static final Set<IHid> getActualPartHids(IHidObject association, long qualifier, Set<HidFlatteningOption> options) {
        LinkedHashSet<IHid> hids = new LinkedHashSet<IHid>();
        Predicate<IHidObject> result = element -> {
            IHid hid = HidUtils.getHidFrom(element);
            if (!(hid == null || AssociationUtils.isConnectedType(hid) || AssociationUtils.isUnconnectedType(hid) || AssociationUtils.isOpenUnconnectedType(hid))) {
                hids.add(hid);
            }
            return true;
        };
        HidUtils.flattenToObjects(result, AssociationUtils.getActualPart(association, qualifier), options);
        return hids;
    }

    static final int getOffset(IHidObject association, long qualifier) {
        if (!AssociationUtils.checkAssociation(association, qualifier)) {
            return -1;
        }
        return ((IHidOperator)association).getOccurrence().getOffset();
    }

    static final int getOffsetOutsideMacro(IHidObject association, long qualifier) {
        if (!AssociationUtils.checkAssociation(association, qualifier)) {
            return -1;
        }
        return ((IHidOperator)association).getOccurrence().getOffsetOutsideMacro();
    }

    static final int getVirtualOffset(IHidObject association, long qualifier) {
        if (!AssociationUtils.checkAssociation(association, qualifier)) {
            return -1;
        }
        return ((IHidOperator)association).getOccurrence().getVirtualOffset();
    }

    static final int getLine(IHidObject association, long qualifier) {
        if (!AssociationUtils.checkAssociation(association, qualifier)) {
            return -1;
        }
        return ((IHidOperator)association).getOccurrence().getLine();
    }

    static final int getClosedBoundary(IHidObject association, long qualifier) {
        if (!AssociationUtils.checkAssociation(association, qualifier)) {
            return -1;
        }
        return ((IHidOperator)association).getOccurrence().getCloseBoundary();
    }

    static final int getOpenBoundary(IHidObject association, long qualifier) {
        if (!AssociationUtils.checkAssociation(association, qualifier)) {
            return -1;
        }
        return ((IHidOperator)association).getOccurrence().getOpenBoundary();
    }

    public static final String toStringBuilder(HidOperator association, long qualifier, boolean showCompletePath, boolean showCompleteOperator, boolean addOperatorParentheses, boolean translateAssociations, boolean showMethodCallArguments, boolean showInvisibleAccess, LanguageKind languageKind) {
        String associationSymbol = association.getOperatorText();
        if (AssociationUtils.isOpenUnconnected(association, qualifier)) {
            if (AssociationUtils.isOrderedUnconnected(association, qualifier)) {
                return "open";
            }
            if (AssociationUtils.isNamedUnconnected(association, qualifier)) {
                String formalPartText = HidUtils.toStringBuilder(AssociationUtils.getNiceFormalPart(association, qualifier), showCompletePath, showCompleteOperator, addOperatorParentheses, translateAssociations, showMethodCallArguments, showInvisibleAccess, languageKind).toString();
                String valueText = "open";
                return AssociationUtils.namedAssociationToString(associationSymbol, formalPartText, valueText);
            }
        }
        if (AssociationUtils.isOrderedUnconnected(association, qualifier)) {
            return " ";
        }
        if (AssociationUtils.isOrderedConnected(association, qualifier)) {
            return HidUtils.toStringBuilder(AssociationUtils.getActualPart(association, qualifier), showCompletePath, showCompleteOperator, addOperatorParentheses, translateAssociations, showMethodCallArguments, showInvisibleAccess, languageKind).toString();
        }
        if (AssociationUtils.isDotStarConnected(association, qualifier)) {
            return ".*";
        }
        if (AssociationUtils.isImplicitNamedConnected(association, qualifier)) {
            String formalPartText = HidUtils.toStringBuilder(AssociationUtils.getNiceFormalPart(association, qualifier), showCompletePath, showCompleteOperator, addOperatorParentheses, translateAssociations, showMethodCallArguments, showInvisibleAccess, languageKind).toString();
            return "." + formalPartText;
        }
        if (AssociationUtils.isNamedUnconnected(association, qualifier)) {
            String formalPartText = HidUtils.toStringBuilder(AssociationUtils.getNiceFormalPart(association, qualifier), showCompletePath, showCompleteOperator, addOperatorParentheses, translateAssociations, showMethodCallArguments, showInvisibleAccess, languageKind).toString();
            return AssociationUtils.namedAssociationToString(associationSymbol, formalPartText, null);
        }
        if (AssociationUtils.isNamedConnected(association, qualifier)) {
            String formalPartText = HidUtils.toStringBuilder(AssociationUtils.getNiceFormalPart(association, qualifier), showCompletePath, showCompleteOperator, addOperatorParentheses, translateAssociations, showMethodCallArguments, showInvisibleAccess, languageKind).toString();
            String actualPartText = HidUtils.toStringBuilder(AssociationUtils.getActualPart(association, qualifier), showCompletePath, showCompleteOperator, addOperatorParentheses, translateAssociations, showMethodCallArguments, showInvisibleAccess, languageKind).toString();
            return AssociationUtils.namedAssociationToString(associationSymbol, formalPartText, actualPartText);
        }
        return "";
    }

    public static final String patternToStringBuilder(HidOperator association, long qualifier, boolean showCompletePath, boolean showCompleteOperator, boolean addOperatorParentheses, boolean translateAssociations, boolean showMethodCallArguments, boolean showInvisibleAccess, LanguageKind languageKind) {
        String associationSymbol = association.getOperatorText();
        if (AssociationUtils.isOpenUnconnected(association, qualifier)) {
            if (AssociationUtils.isOrderedUnconnected(association, qualifier)) {
                return "open";
            }
            if (AssociationUtils.isNamedUnconnected(association, qualifier)) {
                String formalPartText = HidUtils.toStringBuilder(AssociationUtils.getNiceFormalPart(association, qualifier), showCompletePath, showCompleteOperator, addOperatorParentheses, translateAssociations, showMethodCallArguments, showInvisibleAccess, languageKind).toString();
                String valueText = "open";
                return AssociationUtils.patternNamedAssociationToString(associationSymbol, formalPartText, valueText);
            }
        }
        if (AssociationUtils.isOrderedUnconnected(association, qualifier)) {
            return " ";
        }
        if (AssociationUtils.isOrderedConnected(association, qualifier)) {
            return HidUtils.toStringBuilder(AssociationUtils.getActualPart(association, qualifier), showCompletePath, showCompleteOperator, addOperatorParentheses, translateAssociations, showMethodCallArguments, showInvisibleAccess, languageKind).toString();
        }
        if (AssociationUtils.isNamedUnconnected(association, qualifier)) {
            String formalPartText = HidUtils.toStringBuilder(AssociationUtils.getNiceFormalPart(association, qualifier), showCompletePath, showCompleteOperator, addOperatorParentheses, translateAssociations, showMethodCallArguments, showInvisibleAccess, languageKind).toString();
            return AssociationUtils.patternNamedAssociationToString(associationSymbol, formalPartText, null);
        }
        if (AssociationUtils.isNamedConnected(association, qualifier)) {
            String formalPartText = HidUtils.toStringBuilder(AssociationUtils.getNiceFormalPart(association, qualifier), showCompletePath, showCompleteOperator, addOperatorParentheses, translateAssociations, showMethodCallArguments, showInvisibleAccess, languageKind).toString();
            String actualPartText = HidUtils.toStringBuilder(AssociationUtils.getActualPart(association, qualifier), showCompletePath, showCompleteOperator, addOperatorParentheses, translateAssociations, showMethodCallArguments, showInvisibleAccess, languageKind).toString();
            return AssociationUtils.patternNamedAssociationToString(associationSymbol, formalPartText, actualPartText);
        }
        return "";
    }

    static final String namedAssociationToString(String associationSymbol, String formalPartText, String actualPartText) {
        if ("=>".equals(associationSymbol)) {
            return formalPartText + " " + associationSymbol + " " + (actualPartText != null ? actualPartText : "");
        }
        return associationSymbol + formalPartText + "(" + (actualPartText != null ? actualPartText : "") + ")";
    }

    static final String patternNamedAssociationToString(String associationSymbol, String formalPartText, String actualPartText) {
        if ("=>".equals(associationSymbol)) {
            return formalPartText + " " + associationSymbol + " " + (actualPartText != null ? actualPartText : "");
        }
        return formalPartText + associationSymbol + (actualPartText != null ? actualPartText : "");
    }

    public static final boolean isUnconnectedType(IHidObject value) {
        if (value instanceof IHidImplicit) {
            return ((IHidImplicit)value).isUnconnectedAssociation();
        }
        return value instanceof IHid && IHidImplicitConstants.ImplicitType.IMPLICIT_UNCONNECTED_STRING.equals(((IHid)value).getName());
    }

    public static final boolean isConnectedType(IHidObject value) {
        if (value instanceof IHidImplicit) {
            return ((IHidImplicit)value).isConnectedAssociation();
        }
        return value instanceof IHid && IHidImplicitConstants.ImplicitType.IMPLICIT_CONNECTED_STRING.equals(((IHid)value).getName());
    }

    static final boolean isDotStarConnectedType(IHidObject value) {
        return value instanceof IHidImplicit && ((IHidImplicit)value).isDotStarAssociation();
    }

    public static final boolean isOpenUnconnectedType(IHidObject value) {
        return value instanceof IHidImplicit && ((IHidImplicit)value).isOpenAssociation();
    }

    public static final boolean isOrderedUnconnected(IHidObject association, long qualifier) {
        IHidObject formalPartRaw = AssociationUtils.getFormalPartRaw(association, qualifier);
        return formalPartRaw == null || AssociationUtils.isUnconnectedType(formalPartRaw);
    }

    public static final boolean isOrderedConnected(IHidObject association, long qualifier) {
        IHidObject formalPartRaw = AssociationUtils.getFormalPartRaw(association, qualifier);
        return (formalPartRaw == null || AssociationUtils.isConnectedType(formalPartRaw)) && AssociationUtils.internalHasActualPart(association, qualifier);
    }

    static final boolean isDotStarConnected(IHidObject association, long qualifier) {
        return AssociationUtils.isDotStarConnectedType(AssociationUtils.getFormalPartRaw(association, qualifier));
    }

    static final boolean isOpenUnconnected(IHidObject association, long qualifier) {
        return AssociationUtils.isOpenUnconnectedType(AssociationUtils.getActualPartRaw(association, qualifier));
    }

    static final boolean isImplicitNamedConnected(IHidObject association, long qualifier) {
        return AssociationUtils.internalHasFormalPart(association, qualifier) && AssociationUtils.isConnectedType(AssociationUtils.getActualPartRaw(association, qualifier));
    }

    static final boolean isNamedUnconnected(IHidObject association, long qualifier) {
        IHidObject internalGetActualPart = AssociationUtils.getActualPartRaw(association, qualifier);
        return AssociationUtils.internalHasFormalPart(association, qualifier) && (AssociationUtils.isUnconnectedType(internalGetActualPart) || AssociationUtils.isOpenUnconnectedType(internalGetActualPart));
    }

    static final boolean isNamedConnected(IHidObject association, long qualifier) {
        return AssociationUtils.internalHasFormalPart(association, qualifier) && AssociationUtils.internalHasActualPart(association, qualifier);
    }

    static final boolean isUnconnected(IHidObject association, long qualifier) {
        IHidObject actualPartRaw = AssociationUtils.getActualPartRaw(association, qualifier);
        return AssociationUtils.isUnconnectedType(actualPartRaw) || AssociationUtils.isOpenUnconnectedType(actualPartRaw);
    }

    public static boolean isOrdered(IHidObject association, long qualifier) {
        IHidObject formalPartRaw = AssociationUtils.getFormalPartRaw(association, qualifier);
        return formalPartRaw == null || AssociationUtils.isConnectedType(formalPartRaw) || AssociationUtils.isUnconnectedType(formalPartRaw);
    }
}

