/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection.util;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.netlist.DMemoryAccessor;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.DiagramInstanceWrapper;
import ro.amiq.dvt.logic.form.LFConverter;
import ro.amiq.dvt.logic.form.LFConverterOptions;
import ro.amiq.dvt.logic.form.LFOperatorConverter;
import ro.amiq.dvt.logic.form.LogicForm;
import ro.amiq.dvt.logic.form.model.LFFanIn;
import ro.amiq.dvt.logic.form.model.LFFormula;
import ro.amiq.dvt.logic.form.model.LFProgram;
import ro.amiq.dvt.logic.form.utils.LFUtils;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.DummyField;
import ro.amiq.dvt.model.reflection.DummyPort;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.HierarchicalElement;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfCompositeTypeElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfListType;
import ro.amiq.dvt.model.reflection.IRfModportElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfPredefinedGate;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.IRfSpecializedTypeElement;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RootDesignElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorWrapper;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidAccessArgs;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicitConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISContext;
import ro.amiq.dvt.model.reflection.util.HidOperatorVisitorWithPaths;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.model.reflection.util.PortConnectionOperatorVisitor;
import ro.amiq.dvt.model.reflection.util.PortConnectionUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.trace.connections.model.TCConnSignal;
import ro.amiq.dvt.ui.trace.connections.model.TCLogic;
import ro.amiq.dvt.ui.trace.connections.model.TCStatement;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.utils.OptimizedUtils;

public final class DesignUtils {
    public static final int VLOG_MATCH_SIGNAL = 1;
    public static final int VHDL_MATCH_SIGNAL = 9;
    public static final Set<HidFlatteningOption> PORT_CONNECTION_HID_FLATTENING = Collections.unmodifiableSet(EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS));
    public static final Set<HidFlatteningOption> ASSIGN_HID_FLATTENING = Collections.unmodifiableSet(EnumSet.of(HidFlatteningOption.IGNORE_CONSTANTS));
    private static final Set<HidFlatteningOption> VARIABLE_SELECT_FLATTENING = EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS);
    public static final HidOperatorQualifier[] VLOG_ALWAYS_BLOCK_LOGIC = new HidOperatorQualifier[]{HidOperatorQualifier.IS_EVENT_CONTROL, HidOperatorQualifier.IS_DECLARATION_ASSIGN, HidOperatorQualifier.IS_BLOCKING_ASSIGN, HidOperatorQualifier.IS_NONBLOCKING_ASSIGN, HidOperatorQualifier.IS_CONDITIONAL_EXPRESSION, HidOperatorQualifier.IS_CASE_ITEM_EXPRESSION};
    public static final HidOperatorQualifier[] VHDL_PROCESS_LOGIC = new HidOperatorQualifier[]{HidOperatorQualifier.IS_EVENT_CONTROL, HidOperatorQualifier.IS_DECLARATION_EXPRESSION, HidOperatorQualifier.IS_BLOCKING_ASSIGN, HidOperatorQualifier.IS_NONBLOCKING_ASSIGN, HidOperatorQualifier.IS_SELECT_NONBLOCKING_ASSIGN, HidOperatorQualifier.IS_SELECT_BLOCKING_ASSIGN, HidOperatorQualifier.IS_CASE_ITEM_EXPRESSION, HidOperatorQualifier.IS_CONDITIONAL_EXPRESSION};
    private static final Predicate<LFProgram> FAIL_PROGRAM_WHEN_CLOCK_FOUND = prog -> prog instanceof LFProgram.LFImplication && LFUtils.isBreakImplication((LFProgram.LFImplication)prog);
    private static final Predicate<LFFormula> FAIL_FORMULA_WHEN_CLOCK_FOUND = formula -> DesignUtils.isSequentialAtomicFormula(formula);
    public static final HidOperatorQualifier[] EVENT_CONTROL_QUALIFIERS = new HidOperatorQualifier[]{HidOperatorQualifier.IS_EVENT_CONTROL};
    public static final Set<HidFlatteningOption> PROCESS_HID_FLATTENING = Collections.unmodifiableSet(EnumSet.of(HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS, HidFlatteningOption.IGNORE_NON_VAMS_ACCESS_FUNCTION_ARGUMENTS));
    public static final Comparator<IRfNamedElement> SIGNAL_COMPARATOR = new Comparator<IRfNamedElement>(){

        @Override
        public int compare(IRfNamedElement p1, IRfNamedElement p2) {
            if (p1 == null || p1.getName() == null) {
                return -1;
            }
            if (p2 == null || p2.getName() == null) {
                return 1;
            }
            boolean firstIsPort = p1 instanceof IRfPortElement;
            boolean secondIsPort = p2 instanceof IRfPortElement;
            if (firstIsPort && secondIsPort || !firstIsPort && !secondIsPort) {
                return p1.getName().compareToIgnoreCase(p2.getName());
            }
            return firstIsPort ? -1 : 1;
        }
    };
    public static final Set<String> COMBINATIONAL_PREDEFINED_GATES = new HashSet<String>(Arrays.asList("and", "nand", "or", "nor", "xor", "xnor", "buf", "not", "bufif0", "bufif1", "notif0", "notif1"));

    private static final IRfDesignElement getDesign(IRfNamedElement designOrInstance, ElementPath instancePath, IRfNamedElement designHint, boolean resolveComponent, DMemoryAccessor memAccessor) {
        if (designOrInstance instanceof IRfInstanceElement) {
            IRfDesignElement bindingResult;
            if (designHint == null && memAccessor != null) {
                designHint = memAccessor.getDesign(instancePath, false);
            }
            if (designHint == null) {
                designHint = ((IRfInstanceElement)designOrInstance).getGenericDesign(instancePath);
            }
            if (designHint == null) {
                return null;
            }
            if (resolveComponent && DesignUtils.isVHDLComponent(designHint) && (bindingResult = ((IRfInstanceElement)designOrInstance).computeComponentBinding((IRfDesignElement)designHint)) != null && !DesignUtils.isVHDLComponent(bindingResult)) {
                return DesignUtils.getDesign(bindingResult, null, null, false, null);
            }
            return DesignUtils.getDesign(designHint, null, null, false, null);
        }
        IRfNamedElement.ElementKind designKind = DesignUtils.getDesignKind(designOrInstance = DesignUtils.toGenericDesignElement(designOrInstance));
        if (IRfNamedElement.ElementKind.VHDL_ENTITY == designKind || IRfNamedElement.ElementKind.VHDL_CONFIGURATION == designKind) {
            IRfDesignElement architecture = ((IRfDesignElement)designOrInstance).getArchitecture();
            return architecture != null ? architecture : designOrInstance;
        }
        if (IRfNamedElement.ElementKind.VHDL_COMPONENT == designKind) {
            IRfDesignElement resolvedElement;
            if (designHint == null) {
                designHint = designOrInstance;
            }
            if (designHint == null) {
                return (IRfDesignElement)designOrInstance;
            }
            if (resolveComponent && DesignUtils.isVHDLComponent(designHint) && (resolvedElement = ((IRfDesignElement)designHint).getResolvedElement()) != null && !DesignUtils.isVHDLComponent(resolvedElement)) {
                return DesignUtils.getDesign(resolvedElement, null, null, false, null);
            }
        }
        return designOrInstance instanceof IRfDesignElement ? (IRfDesignElement)designOrInstance : null;
    }

    public static IRfDesignElement getDesignElement(IRfNamedElement namedElement, Object treePath) {
        IRfNamedElement.ElementKind designKind;
        if (namedElement == null) {
            return null;
        }
        IRfDesignElement designElement = null;
        if (namedElement instanceof IRfInstanceElement) {
            ElementPath hierarchyPath = treePath instanceof TreePath ? ElementPath.from(((TreePath)treePath).toString("."), ".") : null;
            IRfNamedElement design = ((IRfInstanceElement)namedElement).getGenericDesign(hierarchyPath);
            if (design instanceof IRfDesignElement) {
                designElement = (IRfDesignElement)design;
            }
        } else if (namedElement instanceof IRfDesignElement) {
            designElement = (IRfDesignElement)namedElement;
        }
        if ((designKind = DesignUtils.getDesignKind(designElement)) == IRfNamedElement.ElementKind.UNKNOWN || designKind == IRfNamedElement.ElementKind.VHDL_BLOCK || designKind == IRfNamedElement.ElementKind.VLOG_GENERATE) {
            return null;
        }
        return designElement;
    }

    public static final IRfDesignElement getDesign(DesignRequest request) {
        return DesignUtils.getDesign(request.instanceOrDesign, request.instancePath, request.designHint, request.resolveComponent, request.memoryAccessor);
    }

    public static final IRfNamedElement toGenericDesignElement(IRfNamedElement candidate) {
        if (candidate instanceof IRfListType) {
            candidate = ((IRfListType)candidate).getAssociatedType();
        }
        if (candidate instanceof IRfSpecializedTypeElement) {
            candidate = ((IRfSpecializedTypeElement)candidate).getGenericElement();
        }
        return candidate;
    }

    public static final boolean isVHDLComponent(Object element) {
        return DesignUtils.getDesignKind(element) == IRfNamedElement.ElementKind.VHDL_COMPONENT;
    }

    @NotNull
    public static final List<IRfPortElement> getPorts(DesignRequest request, boolean onlyPortsInList, Map<IRfInstanceElement, Set<DummyPort>> dummyPortCache) {
        IRfDesignElement design = DesignUtils.getDesign(request);
        if ((design instanceof IRfPredefinedGate || design == null) && request.instanceOrDesign instanceof IRfInstanceElement) {
            Set<DummyPort> dummyPorts;
            IRfInstanceElement instance = (IRfInstanceElement)request.instanceOrDesign;
            Set<DummyPort> set = dummyPorts = dummyPortCache != null ? dummyPortCache.get(instance) : null;
            if (dummyPorts == null) {
                dummyPorts = DesignUtils.getDummyPorts(instance);
            }
            if (dummyPortCache != null) {
                dummyPortCache.put(instance, dummyPorts);
            }
            return new ArrayList<IRfPortElement>(dummyPorts);
        }
        if (design == null) {
            return Collections.emptyList();
        }
        List<? extends IRfPortElement> ports = onlyPortsInList ? design.getLocalPortsNoAliases() : design.getLocalPorts();
        return ports == null ? Collections.emptyList() : new ArrayList<IRfPortElement>(ports);
    }

    @NotNull
    public static final Set<DummyPort> getDummyPorts(IRfInstanceElement instance) {
        List<IHidOperator> portConnections = PortConnectionOperatorVisitor.getPortConnections(instance);
        if (portConnections == null || portConnections.isEmpty()) {
            return Collections.emptySet();
        }
        IRfPredefinedGate predefinedGate = instance.getPredefinedGate();
        return predefinedGate != null ? predefinedGate.getDummyPorts(instance, portConnections) : DesignUtils.getDummyPorts(instance, portConnections);
    }

    @NotNull
    private static final Set<DummyPort> getDummyPorts(IRfInstanceElement instance, List<IHidOperator> portConnections) {
        if (instance == null || portConnections == null || portConnections.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<DummyPort> ports = new LinkedHashSet<DummyPort>();
        int counter = 0;
        for (IHidOperator pc : portConnections) {
            String portName;
            if (PortConnectionUtils.isDotStarConnected(pc)) continue;
            if (PortConnectionUtils.isOrderedConnected(pc) || PortConnectionUtils.isOrderedUnconnected(pc)) {
                portName = "<port_" + counter++ + ">";
                ports.add(new DummyPort(portName, "", DummyPort.DummyPortDirection.INOUT, instance, DVTImages.OUTLINE_INOUT_PORT));
            }
            if (!PortConnectionUtils.isImplicitNamedConnected(pc) && !PortConnectionUtils.isFullNamedConnected(pc) && !PortConnectionUtils.isFullNamedUnconnected(pc)) continue;
            portName = PortConnectionUtils.getPortName(pc);
            ports.add(new DummyPort(portName, portName, DummyPort.DummyPortDirection.INOUT, instance, DVTImages.OUTLINE_INOUT_PORT));
        }
        return ports;
    }

    @NotNull
    public static final Map<IRfPortElement, Set<TCConnSignal>> mapInstancePortConnections(DesignRequest request, Map<IRfInstanceElement, Set<DummyPort>> dummyPortCache, Set<HidFlatteningOption> signalHidFlattening) {
        return DesignUtils.mapInstancePortConnections(request, dummyPortCache, signalHidFlattening, false, false, null);
    }

    @NotNull
    public static final Map<IRfPortElement, Set<TCConnSignal>> mapAllInstancePortConnections(DesignRequest request, Map<IRfInstanceElement, Set<DummyPort>> dummyPortCache, Set<HidFlatteningOption> signalHidFlattening) {
        return DesignUtils.mapInstancePortConnections(request, dummyPortCache, signalHidFlattening, false, true, null);
    }

    @NotNull
    public static final Map<IRfPortElement, Set<TCConnSignal>> mapInstancePortConnections(DesignRequest request, Map<IRfInstanceElement, Set<DummyPort>> dummyPortCache, Set<HidFlatteningOption> signalHidFlattening, boolean reduceVHDLRecordPorts, boolean mapAllModulePorts, LFOperatorConverter assocConverter) {
        if (!(request.instanceOrDesign instanceof IRfInstanceElement)) {
            return Collections.emptyMap();
        }
        IRfInstanceElement instance = (IRfInstanceElement)request.instanceOrDesign;
        List<IHidOperator> portConnections = PortConnectionOperatorVisitor.getPortConnections(instance);
        if (portConnections == null) {
            return Collections.emptyMap();
        }
        List<IRfPortElement> allPorts = DesignUtils.getPorts(request, true, dummyPortCache);
        if (allPorts.isEmpty()) {
            return Collections.emptyMap();
        }
        String filePath = null;
        IRfDefElement defElem = instance.getDeclaration();
        if (defElem != null) {
            ParserPath parserPath = defElem.getParserPath();
            String string = filePath = parserPath != null ? parserPath.path : null;
        }
        if (signalHidFlattening == null) {
            signalHidFlattening = EnumSet.noneOf(HidFlatteningOption.class);
        }
        LinkedHashMap<IRfPortElement, Set<TCConnSignal>> connections = new LinkedHashMap<IRfPortElement, Set<TCConnSignal>>(8);
        boolean hasDotStar = false;
        int index = -1;
        for (IHidOperator pc : portConnections) {
            ++index;
            HidOperatorOccurrence occurrence = pc.getOccurrence();
            int line = PortConnectionUtils.getLine(pc);
            int offset = PortConnectionUtils.getOffset(pc);
            int virtualOffset = PortConnectionUtils.getVirtualOffset(pc);
            LanguageKind languageKind = ((HidOperator)pc).getLanguageKind();
            if (PortConnectionUtils.isDotStarConnected(pc)) {
                hasDotStar = true;
                for (IRfPortElement port : allPorts) {
                    if (connections.containsKey(port)) continue;
                    connections.put(port, new LinkedHashSet());
                    GoToInfo goToInfo = GoToInfo.of(filePath, offset, virtualOffset, line, "", languageKind);
                    ((Set)connections.get(port)).add(TCConnSignal.of(port.getName() != null ? port.getName() : "", TCStatement.of(TCStatement.TCStatementKind.PORT_CONNECTION, goToInfo, pc), null, DesignUtils.getImplicitAssociationsSupplier(assocConverter, null, port, instance, occurrence)));
                }
                continue;
            }
            if (PortConnectionUtils.isOrdered(pc)) {
                IRfPortElement port;
                if (index >= allPorts.size()) continue;
                port = allPorts.get(index);
                LinkedHashSet<TCConnSignal> connSignals = new LinkedHashSet<TCConnSignal>(2);
                connections.put(port, connSignals);
                IHidObject signalHidObject = PortConnectionUtils.getSignal(pc);
                Set<IHid> signalHids = HidUtils.flattenToHids(signalHidObject, signalHidFlattening);
                for (IHid signalHid : signalHids) {
                    GoToInfo goToInfo = GoToInfo.of(filePath, offset, virtualOffset, line, HidUtils.toString(signalHid, true, true), languageKind);
                    connSignals.add(TCConnSignal.of(signalHid, signalHidObject, TCStatement.of(TCStatement.TCStatementKind.PORT_CONNECTION, goToInfo), DesignUtils.getLogicGateOperatorSupplier(signalHidObject, goToInfo), DesignUtils.getAssociationsSupplier(assocConverter, (HidOperator)pc, port, instance, occurrence)));
                }
                continue;
            }
            IHid portHid = PortConnectionUtils.getPortHid(pc);
            if (portHid == null) continue;
            if (reduceVHDLRecordPorts) {
                IHid nextToLastHid = portHid;
                while (nextToLastHid != null && nextToLastHid.getParentHid() != null && nextToLastHid.getParentHid().getParentHid() != null) {
                    nextToLastHid = nextToLastHid.getParentHid();
                }
                if (nextToLastHid != null && nextToLastHid != portHid) {
                    portHid = nextToLastHid;
                }
            }
            String portName = portHid.getName();
            IRfPortElement port = null;
            IRfNamedElement resolvedPort = DesignUtils.resolveSignal(portName, request, null, dummyPortCache);
            if (resolvedPort instanceof IRfPortElement) {
                port = (IRfPortElement)resolvedPort;
            }
            if (port == null) continue;
            LinkedHashSet<TCConnSignal> connSignals = (LinkedHashSet<TCConnSignal>)connections.get(port);
            if (connSignals == null) {
                connSignals = new LinkedHashSet<TCConnSignal>(2);
                connections.put(port, connSignals);
            }
            if (hasDotStar) {
                connSignals.clear();
            }
            if (PortConnectionUtils.isImplicitNamedConnected(pc)) {
                GoToInfo goToInfo = GoToInfo.of(filePath, offset, virtualOffset, line, HidUtils.toString(portHid, true, true), languageKind);
                connSignals.add(TCConnSignal.of(portName, TCStatement.of(TCStatement.TCStatementKind.PORT_CONNECTION, goToInfo, pc), null, DesignUtils.getImplicitAssociationsSupplier(assocConverter, (HidOperator)pc, port, instance, occurrence)));
                continue;
            }
            if (PortConnectionUtils.isFullNamedUnconnected(pc)) continue;
            IHidObject signalHidObject = PortConnectionUtils.getSignal(pc);
            Set<IHid> signalHids = HidUtils.flattenToHids(signalHidObject, signalHidFlattening);
            for (IHid signalHid : signalHids) {
                GoToInfo goToInfo = GoToInfo.of(filePath, offset, virtualOffset, line, HidUtils.toString(signalHid, true, true), languageKind);
                connSignals.add(TCConnSignal.of(signalHid, signalHidObject, TCStatement.of(TCStatement.TCStatementKind.PORT_CONNECTION, goToInfo), DesignUtils.getLogicGateOperatorSupplier(signalHidObject, goToInfo), DesignUtils.getAssociationsSupplier(assocConverter, (HidOperator)pc, port, instance, occurrence)));
            }
        }
        if (mapAllModulePorts) {
            for (IRfPortElement port : allPorts) {
                if (connections.containsKey(port)) continue;
                connections.put(port, null);
            }
        }
        return connections;
    }

    private static SupplierInDesign<LogicForm> getImplicitAssociationsSupplier(final LFOperatorConverter converter, final HidOperator implicitConnection, final IRfPortElement port, final IRfInstanceElement instance, final HidOperatorOccurrence occurrence) {
        if (port == null || converter == null || instance == null) {
            return null;
        }
        return new SupplierInDesign<LogicForm>(){
            LogicForm cache;

            @Override
            public LogicForm get(IRfNamedElement enclosingDesignOrInstance, ELInstance closestAncestorInstance) {
                if (this.cache != null) {
                    return this.cache;
                }
                String name = port.getName();
                IRfNamedElement enclosingScope = instance.isInstanceToBind() ? instance.getBindInstanceScope() : (IRfNamedElement)instance.getEnclosingScope();
                final IRfNamedElement signal = DesignUtils.resolveSignal(name, DesignRequest.of(enclosingScope), null, null);
                ISContext context = new ISContext(){

                    @Override
                    public IRfNamedElement calculateCorrespondentByName(String name, IHidObject originalFormalPart, IRfNamedElement initialScope) {
                        return port;
                    }

                    @Override
                    public IRfNamedElement getImplicitConnectionValue() {
                        return signal;
                    }
                };
                long qualifiers = implicitConnection != null ? implicitConnection.getQualifiers() : occurrence.getQualifiers() | HidQualifierCache.IS_OPERATOR_COMPLETE_QUALIFIER;
                ArrayList<HidOperator> associations = new ArrayList<HidOperator>();
                HidUtils.transformImplicitAssociation(implicitConnection, name, context, occurrence, qualifiers, false, associations, HidUtils.DEFAULT_BUILDERS);
                this.cache = LFConverter.INSTANCE.convertOperatorsAndNormalize(converter, associations, null);
                return this.cache;
            }
        };
    }

    private static SupplierInDesign<LogicForm> getAssociationsSupplier(final LFOperatorConverter converter, final HidOperator pc, final IRfPortElement port, final IRfInstanceElement instance, final HidOperatorOccurrence occurrence) {
        if (port == null || converter == null) {
            return null;
        }
        return new SupplierInDesign<LogicForm>(){
            LogicForm cache;

            @Override
            public LogicForm get(IRfNamedElement enclosingDesignOrInstance, ELInstance closestAncestorInstance) {
                if (this.cache != null) {
                    return this.cache;
                }
                ISContext context = new ISContext(){

                    @Override
                    public IRfNamedElement calculateCorrespondentByPosition(int position) {
                        return port;
                    }

                    @Override
                    public IRfNamedElement calculateCorrespondentByName(String name, IHidObject originalFormalPart, IRfNamedElement initialScope) {
                        return port;
                    }
                };
                int index = 0;
                ArrayList<HidOperator> associations = new ArrayList<HidOperator>();
                HidUtils.transformAssociation(null, pc, index, context, instance, occurrence, pc.getQualifiers(), false, associations, HidUtils.DEFAULT_BUILDERS);
                this.cache = LFConverter.INSTANCE.convertOperatorsAndNormalize(converter, associations, null);
                return this.cache;
            }
        };
    }

    public static final SupplierInDesign<IHidOperator> getLogicGateOperatorSupplier(IHidObject object, GoToInfo goToInfo) {
        if (object == null) {
            return null;
        }
        switch (object.getHidKind()) {
            case ACCESS: {
                return DesignUtils.getLogicGateOperatorSupplier((HidAccess)object, goToInfo);
            }
            case OPERATOR: {
                return DesignUtils.getLogicGateOperatorSupplier((HidOperator)object);
            }
        }
        return null;
    }

    private static final SupplierInDesign<IHidOperator> getLogicGateOperatorSupplier(final HidOperator operator) {
        if (operator == null) {
            return null;
        }
        return new SupplierInDesign<IHidOperator>(){

            @Override
            public IHidOperator get(IRfNamedElement enclosingDesignOrInstance, ELInstance closestAncestorInstance) {
                return operator;
            }
        };
    }

    private static final SupplierInDesign<IHidOperator> getLogicGateOperatorSupplier(final HidAccess accessWithSelect, final GoToInfo goToInfo) {
        if (accessWithSelect == null || !accessWithSelect.isSelect()) {
            return null;
        }
        return new SupplierInDesign<IHidOperator>(){
            private IHidOperator cache;

            @Override
            public IHidOperator get(IRfNamedElement enclosingDesignOrInstance, ELInstance closestAncestorInstance) {
                if (this.cache != null) {
                    return this.cache;
                }
                this.cache = DesignUtils.makeStandInOperator(accessWithSelect, enclosingDesignOrInstance, closestAncestorInstance, goToInfo);
                return this.cache;
            }
        };
    }

    public static final IHidOperator makeStandInOperator(HidAccess accessWithSelect, IRfNamedElement enclosingDesignOrInstance, ELInstance closestAncestorInstance, GoToInfo goToInfo) {
        if (accessWithSelect == null || !accessWithSelect.isSelect() || goToInfo == null) {
            return null;
        }
        IRfNamedElement parentElement = HidUtils.getResolvedElement(accessWithSelect.getParentHid());
        if (!DesignUtils.isValidSignalCandidate(parentElement, null)) {
            return null;
        }
        boolean hasVariableInSelect = DesignUtils.checkHasValidSignalAsMember(accessWithSelect.getSelects(), enclosingDesignOrInstance, closestAncestorInstance);
        if (!hasVariableInSelect) {
            return null;
        }
        HidOperatorOccurrence occurrence = new HidOperatorOccurrence(goToInfo.offset, goToInfo.virtualOffset, goToInfo.line, 0L, null);
        HidUtils.StandInOperator operator = HidUtils.StandInOperator.create(IHidOperatorConstants.OperatorType.NO_TYPE.id, IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, "", occurrence, accessWithSelect.getLanguageKind());
        operator.addLHValue(accessWithSelect);
        return operator;
    }

    public static final IHidOperator makeStandInOperator(List<IHid> lhHids, List<IHid> rhHids, GoToInfo goToInfo) {
        return DesignUtils.makeStandInOperator(lhHids, DesignUtils.makeStandInOperatorSide(rhHids, goToInfo), HidQualifierCache.IS_CONTINUOUS_ASSIGN_QUALIFIER, goToInfo);
    }

    public static final IHidOperator makeStandInOperator(List<IHid> lhHids, IHidObject rhValue, long qualifiers, GoToInfo goToInfo) {
        if (lhHids == null || lhHids.isEmpty() || rhValue == null || goToInfo == null) {
            return null;
        }
        LanguageKind languageKind = goToInfo.languageKind;
        HidOperatorOccurrence occurrence = new HidOperatorOccurrence(goToInfo.offset, goToInfo.virtualOffset, goToInfo.line, qualifiers, null);
        HidUtils.StandInOperator operator = HidUtils.StandInOperator.create(IHidOperatorConstants.OperatorType.NO_TYPE.id, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "", occurrence, languageKind);
        IHidObject lhs = DesignUtils.makeStandInOperatorSide(lhHids, goToInfo);
        if (lhs == null) {
            return null;
        }
        operator.addLHValue(lhs);
        operator.addRHValue(rhValue);
        return operator;
    }

    private static final IHidObject makeStandInOperatorSide(List<IHid> hids, GoToInfo goToInfo) {
        if (hids == null || hids.isEmpty() || goToInfo == null) {
            return null;
        }
        if (hids.size() == 1) {
            return hids.get(0);
        }
        LanguageKind languageKind = goToInfo.languageKind;
        HidOperatorOccurrence occurrence = new HidOperatorOccurrence(goToInfo.offset, goToInfo.virtualOffset, goToInfo.line, HidQualifierCache.IS_CONCATENATION_QUALIFIER, null);
        HidUtils.StandInOperator concatOperator = HidUtils.StandInOperator.create(IHidOperatorConstants.OperatorType.NO_TYPE.id, IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR, "{", occurrence, languageKind);
        concatOperator.addLHValue(new HidUtils.StandInHidImplicit("{", IHidImplicitConstants.ImplicitType.VARIADIC_LIMIT.id));
        for (IHid hid : hids) {
            concatOperator.addRHValue(hid);
        }
        return concatOperator;
    }

    private static final boolean checkHasValidSignalAsMember(Collection<IHidObject> expressions, IRfNamedElement enclosingDesignOrInstance, ELInstance closestAncestorInstance, boolean includeImplicitHids) {
        if (expressions == null) {
            return false;
        }
        for (IHidObject expression : expressions) {
            Set<IHid> hids = HidUtils.flattenToHids(expression, includeImplicitHids ? HidFlatteningOption.IMPLICITS_IN_SELECTS_AND_ARGS_EXCLUDED : VARIABLE_SELECT_FLATTENING);
            if (hids.isEmpty()) continue;
            DesignRequest request = DesignRequest.of(enclosingDesignOrInstance, true);
            for (IHid hid : hids) {
                if (includeImplicitHids && hid instanceof HidImplicit && !hid.getName().isEmpty()) {
                    return true;
                }
                IRfNamedElement resolved = DesignUtils.resolveSignal(hid, request, closestAncestorInstance, null);
                if (!DesignUtils.isValidBlockSignalCandidate(resolved)) continue;
                return true;
            }
        }
        return false;
    }

    private static final boolean checkHasValidSignalAsMember(Collection<IHidObject> expressions, IRfNamedElement enclosingDesignOrInstance, ELInstance closestAncestorInstance) {
        return DesignUtils.checkHasValidSignalAsMember(expressions, enclosingDesignOrInstance, closestAncestorInstance, false);
    }

    public static final SupplierInDesign<TCLogic> getLogicSupplier(final TCLogic logic) {
        if (logic == null) {
            return null;
        }
        return new SupplierInDesign<TCLogic>(){

            @Override
            public TCLogic get(IRfNamedElement enclosingDesignOrInstance, ELInstance closestAncestorInstance) {
                return logic;
            }
        };
    }

    public static final SupplierInDesign<TCLogic> getLogicSupplier(final Set<TCConnSignal> conns, final boolean fromOutputPort) {
        if (conns == null || conns.isEmpty()) {
            return null;
        }
        return new SupplierInDesign<TCLogic>(){
            private TCLogic cache;

            @Override
            public TCLogic get(IRfNamedElement enclosingDesignOrInstance, ELInstance closestAncestorInstance) {
                if (this.cache != null) {
                    return this.cache;
                }
                this.cache = DesignUtils.makeStandInLogic(conns, enclosingDesignOrInstance, closestAncestorInstance, fromOutputPort);
                return this.cache;
            }
        };
    }

    public static final SupplierInDesign<LogicForm> getLogicSupplier2(final LogicForm logic) {
        if (logic == null) {
            return null;
        }
        return new SupplierInDesign<LogicForm>(){

            @Override
            public LogicForm get(IRfNamedElement enclosingDesignOrInstance, ELInstance closestAncestorInstance) {
                return logic;
            }
        };
    }

    public static final SupplierInDesign<LogicForm> getLogicSupplier2(final Set<TCConnSignal> conns, final boolean fromOutputPort, final boolean schematicShowConstants) {
        if (conns == null || conns.isEmpty()) {
            return null;
        }
        return new SupplierInDesign<LogicForm>(){
            private LogicForm cache;

            @Override
            public LogicForm get(IRfNamedElement enclosingDesignOrInstance, ELInstance closestAncestorInstance) {
                if (this.cache != null) {
                    return this.cache;
                }
                this.cache = DesignUtils.makeStandInLogic2(conns, enclosingDesignOrInstance, closestAncestorInstance, fromOutputPort, schematicShowConstants);
                return this.cache;
            }
        };
    }

    public static final SupplierInDesign<LogicForm> getLogicSupplier2(Set<TCConnSignal> conns, boolean fromOutputPort) {
        return DesignUtils.getLogicSupplier2(conns, fromOutputPort, false);
    }

    public static final IRfPortElement getPortByName(String portName, DesignRequest request, Map<IRfInstanceElement, Set<DummyPort>> dummyPortMap) {
        boolean ignoreCaseCondition;
        if (portName == null || portName.isEmpty() || request == null) {
            return null;
        }
        IRfDesignElement design = DesignUtils.getDesign(request);
        boolean bl = ignoreCaseCondition = DesignUtils.isVHDLDesign(request.instanceOrDesign) || DesignUtils.isVHDLDesign(design);
        if (design instanceof IRfDesignElement) {
            return design.getPortWithPrefix(portName, ignoreCaseCondition ? 9 : 1);
        }
        for (IRfPortElement port : DesignUtils.getPorts(request, false, dummyPortMap)) {
            if (!(ignoreCaseCondition ? port.getName().equalsIgnoreCase(portName) : port.getName().equals(portName))) continue;
            return port;
        }
        return null;
    }

    public static final IRfNamedElement getFieldOrInstanceByName(String fieldOrInstanceName, DesignRequest request) {
        if (fieldOrInstanceName == null || fieldOrInstanceName.isEmpty() || request == null) {
            return null;
        }
        IRfDesignElement design = DesignUtils.getDesign(request);
        if (design == null) {
            return null;
        }
        boolean ignoreCaseCondition = DesignUtils.isVHDLDesign(request.instanceOrDesign) || DesignUtils.isVHDLDesign(design);
        IRfNamedElement field = design.getSignalWithPrefix(fieldOrInstanceName, ignoreCaseCondition ? 9 : 1);
        if (field != null) {
            return field;
        }
        return design.getInstanceWithPrefix(fieldOrInstanceName, ignoreCaseCondition ? 9 : 1);
    }

    public static final boolean isVLOGConcurrentActionBlock(IRfActionBlockElement block) {
        return block.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ALWAYS.value() | IRfActionBlockElement.BlockQualifier.ALWAYS_COMB.value());
    }

    public static final boolean isVLOGSequentialActionBlock(IRfActionBlockElement blockType) {
        return blockType.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ALWAYS.value() | IRfActionBlockElement.BlockQualifier.ALWAYS_FF.value() | IRfActionBlockElement.BlockQualifier.ALWAYS_LATCH.value() | IRfActionBlockElement.BlockQualifier.FINAL.value() | IRfActionBlockElement.BlockQualifier.INITIAL.value());
    }

    public static final boolean isVLOGActionBlock(IRfActionBlockElement blockType) {
        return DesignUtils.isVLOGConcurrentActionBlock(blockType) || DesignUtils.isVLOGSequentialActionBlock(blockType);
    }

    public static final boolean isVHDLConcurrentActionBlock(IRfActionBlockElement block) {
        return block.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.PROCESS);
    }

    public static final boolean isVHDLSequentialActionBlock(IRfActionBlockElement block) {
        return block.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.PROCESS);
    }

    public static final boolean isVHDLActionBlock(IRfActionBlockElement block) {
        return block.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.PROCESS);
    }

    public static final void collectLocalOperatorsWithPaths(List<HidOperatorWrapper> assignsAndPortExpressionsLogic, IRfNamedElement searchElementType, HidOperatorQualifier[] assignAndPortExpressionQualifiers) {
        List<HidOperatorWrapper> entityOperators;
        IRfDesignElement searchElementEntity;
        if (assignsAndPortExpressionsLogic == null || assignAndPortExpressionQualifiers == null) {
            return;
        }
        List<HidOperatorWrapper> operators = HidOperatorVisitorWithPaths.getHidOperators(searchElementType, assignAndPortExpressionQualifiers, true);
        if (operators != null) {
            assignsAndPortExpressionsLogic.addAll(operators);
        }
        if (DesignUtils.getDesignKind(searchElementType) == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE && (searchElementEntity = ((IRfBlockElement)searchElementType).getEntity()) != null && (entityOperators = HidOperatorVisitorWithPaths.getHidOperators(searchElementType, assignAndPortExpressionQualifiers, true)) != null) {
            assignsAndPortExpressionsLogic.addAll(entityOperators);
        }
    }

    public static final void collectLocalOperators(List<IHidOperator> assignsAndPortExpressionsLogic, IRfNamedElement searchElementType, HidOperatorQualifier[] assignAndPortExpressionQualifiers) {
        List<IHidOperator> entityOperators;
        IRfDesignElement searchElementEntity;
        if (assignsAndPortExpressionsLogic == null || assignAndPortExpressionQualifiers == null) {
            return;
        }
        List<IHidOperator> operators = searchElementType.getHidOperators(assignAndPortExpressionQualifiers, true);
        if (operators != null) {
            assignsAndPortExpressionsLogic.addAll(operators);
        }
        if (DesignUtils.getDesignKind(searchElementType) == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE && (searchElementEntity = ((IRfBlockElement)searchElementType).getEntity()) != null && (entityOperators = searchElementEntity.getHidOperators(assignAndPortExpressionQualifiers, true)) != null) {
            assignsAndPortExpressionsLogic.addAll(entityOperators);
        }
    }

    public static final void collectConcurrentBlocksWithOperators(IRfNamedElement namedElemType, Map<IRfNamedElement, LogicForm> logicForms, Set<LFConverterOptions> converterOptions, Set<HidFlatteningOption> flatteningOptions, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        if (logicForms == null) {
            return;
        }
        for (IRfActionBlockElement iRfActionBlockElement : DesignUtils.getActionBlocks(namedElemType)) {
            LogicForm form;
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            if (DesignUtils.isVLOGConcurrentActionBlock(iRfActionBlockElement)) {
                form = LFConverter.INSTANCE.convertElementAndNormalize(iRfActionBlockElement, null, converterOptions, flatteningOptions, FAIL_PROGRAM_WHEN_CLOCK_FOUND, null, monitor);
                if (form == null) continue;
                logicForms.put(iRfActionBlockElement, form);
                continue;
            }
            if (!DesignUtils.isVHDLConcurrentActionBlock(iRfActionBlockElement) || (form = LFConverter.INSTANCE.convertElementAndNormalize(iRfActionBlockElement, null, converterOptions, flatteningOptions, FAIL_PROGRAM_WHEN_CLOCK_FOUND, FAIL_FORMULA_WHEN_CLOCK_FOUND, monitor)) == null) continue;
            logicForms.put(iRfActionBlockElement, form);
        }
    }

    public static final void collectSequentialBlocksWithOperators2(IRfNamedElement namedElemType, Map<IRfNamedElement, LogicForm> logicForms, Set<IRfNamedElement> concurrentBlocks, Set<LFConverterOptions> converterOptions, Set<HidFlatteningOption> flatteningOptions, IProgressMonitor monitor) {
        if (logicForms == null) {
            return;
        }
        for (IRfActionBlockElement iRfActionBlockElement : DesignUtils.getActionBlocks(namedElemType)) {
            LogicForm form;
            if (concurrentBlocks.contains(iRfActionBlockElement) || (form = LFConverter.INSTANCE.convertElementAndNormalize(iRfActionBlockElement, null, converterOptions, flatteningOptions, monitor)) == null) continue;
            logicForms.put(iRfActionBlockElement, form);
        }
    }

    public static final void collectActionBlocksWithOperators2(IRfNamedElement namedElemType, Map<IRfNamedElement, LogicForm> logicForms, Set<LFConverterOptions> converterOptions, Set<HidFlatteningOption> flatteningOptions, IProgressMonitor monitor) {
        if (logicForms == null) {
            return;
        }
        for (IRfActionBlockElement iRfActionBlockElement : DesignUtils.getActionBlocks(namedElemType)) {
            LogicForm form = LFConverter.INSTANCE.convertElementAndNormalize(iRfActionBlockElement, null, converterOptions, flatteningOptions, monitor);
            if (form == null) continue;
            logicForms.put(iRfActionBlockElement, form);
        }
    }

    @NotNull
    private static final Collection<? extends IRfActionBlockElement> getActionBlocks(IRfNamedElement namedElemType) {
        Collection<? extends IRfActionBlockElement> actionBlocks = null;
        if (namedElemType instanceof IRfDesignElement) {
            actionBlocks = ((IRfDesignElement)namedElemType).getLocalActionBlocks();
        }
        return actionBlocks == null ? Collections.emptyList() : actionBlocks;
    }

    @NotNull
    public static final Set<IHid> getVLOGClockEventHids(List<IHidOperator> operators, boolean exitWhenClockFound) {
        if (operators == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<IHid> result = new LinkedHashSet<IHid>(4);
        for (IHidOperator operator : operators) {
            DesignUtils.collectVLOGClockEventHids(operator, result, exitWhenClockFound);
            if (!exitWhenClockFound || result.isEmpty()) continue;
            return result;
        }
        return result;
    }

    public static final void collectVLOGClockEventHids(IHidOperator operator, Set<IHid> result, boolean exitWhenClockFound) {
        if (operator == null || result == null) {
            return;
        }
        if (!operator.hasOccurrence(HidOperatorQualifier.IS_EVENT_CONTROL)) {
            return;
        }
        IHidObject lhValue = operator.getLHValue();
        if (HidUtils.isOperator(lhValue) && ((IHidOperator)lhValue).isRepeat()) {
            lhValue = ((IHidOperator)lhValue).getFirstRHValue();
        }
        if (!HidUtils.isOperator(lhValue)) {
            return;
        }
        IHidOperator eventOperator = (IHidOperator)lhValue;
        if (eventOperator.isAnyEdgeEvent()) {
            Set<IHid> hids = HidUtils.flattenToHids(eventOperator.getLHValue(), PROCESS_HID_FLATTENING);
            for (IHid hid : hids) {
                if (hid.getElement() instanceof IRfInstanceElement) continue;
                result.add(hid);
            }
            return;
        }
        Set<IHidOperator> flattened = HidUtils.flattenToOperators(eventOperator);
        for (IHidOperator partOperator : flattened) {
            if (partOperator.isAnyEdgeEvent()) {
                Set<IHid> hids = HidUtils.flattenToHids(partOperator.getLHValue(), PROCESS_HID_FLATTENING);
                for (IHid hid : hids) {
                    if (hid.getElement() instanceof IRfInstanceElement) continue;
                    result.add(hid);
                }
            }
            if (!exitWhenClockFound || result.isEmpty()) continue;
            return;
        }
    }

    @NotNull
    public static final void getVLOGSensitivityListDrivers(IRfNamedElement alwaysBlock, Map<String, IHid> sensitivityList, Collection<HidAccess> sensitivitySelectsList, boolean exitWhenClockFound) {
        if (alwaysBlock == null) {
            return;
        }
        List<IHidOperator> sensitivityLists = alwaysBlock.getHidOperators(EVENT_CONTROL_QUALIFIERS, false);
        if (sensitivityLists == null || sensitivityLists.isEmpty()) {
            return;
        }
        LinkedHashSet<IHid> result = new LinkedHashSet<IHid>();
        for (IHidOperator sensitivityListOperator : sensitivityLists) {
            IHidObject lhValue;
            if (sensitivityListOperator.isWaitEventControl()) continue;
            LinkedHashSet<IHid> hids = new LinkedHashSet<IHid>();
            DesignUtils.collectVLOGClockEventHids(sensitivityListOperator, hids, exitWhenClockFound);
            if (!hids.isEmpty()) {
                result.addAll(hids);
                if (exitWhenClockFound) break;
            }
            if (HidUtils.isOperator(lhValue = sensitivityListOperator.getLHValue()) && ((IHidOperator)lhValue).isRepeat()) {
                lhValue = ((IHidOperator)lhValue).getFirstRHValue();
            }
            Predicate<IHidObject> predicate = element -> {
                IHid hid = HidUtils.getHidFrom(element);
                if (hid != null && (element instanceof IHid || element instanceof HidAccess && ((HidAccess)element).isRangeSelect())) {
                    hids.add(hid);
                }
                return true;
            };
            HidUtils.flattenToObjects(predicate, lhValue, PROCESS_HID_FLATTENING);
            if (hids != null && !hids.isEmpty()) {
                result.addAll(hids);
            }
            ArrayList hidAccesses = new ArrayList();
            predicate = element -> {
                if (element instanceof HidAccess && ((HidAccess)element).isBitSelect()) {
                    hidAccesses.add((HidAccess)element);
                }
                return true;
            };
            HidUtils.flattenToObjects(predicate, lhValue, PROCESS_HID_FLATTENING);
            if (hidAccesses == null || hidAccesses.isEmpty()) continue;
            sensitivitySelectsList.addAll(hidAccesses);
        }
        if (result.isEmpty()) {
            return;
        }
        for (IHid sensitivityHid : result) {
            DesignUtils.collectProcessDriver(alwaysBlock, sensitivityList, sensitivityHid, false);
        }
    }

    @NotNull
    public static final Set<IHid> getVHDLClockEventHids(List<IHidOperator> operators, boolean exitWhenClockFound) {
        if (operators == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<IHid> result = new LinkedHashSet<IHid>(4);
        for (IHidOperator operator : operators) {
            DesignUtils.collectVHDLClockEventHids(operator, result, exitWhenClockFound);
            if (!exitWhenClockFound || result.isEmpty()) continue;
            return result;
        }
        return result;
    }

    public static final void collectVHDLClockEventHids(IHidOperator operator, Set<IHid> result, boolean exitWhenClockFound) {
        if (operator == null || result == null) {
            return;
        }
        if (!operator.hasOccurrence(HidOperatorQualifier.IS_CONDITIONAL_EXPRESSION) && !operator.isWaitEventControl()) {
            return;
        }
        for (IHid hidObject : HidUtils.flattenToHids(operator, PROCESS_HID_FLATTENING)) {
            Hid hid;
            if (!HidUtils.isHid(hidObject) || (hid = (Hid)hidObject).hasOccurrence(HidQualifierCache.TIME_EXPR_QUALIFIER)) continue;
            String hidName = hid.getName().toUpperCase();
            HidAccess parentAccess = hid.getParentAccess();
            if (parentAccess != null && parentAccess.getAccessKind() == 5 && "EVENT".equals(hidName)) {
                result.add(hid.getParentHid());
                if (exitWhenClockFound && !result.isEmpty()) {
                    return;
                }
            }
            if (parentAccess != null || !hid.isMethodCall(false) || !"RISING_EDGE".equals(hidName) && !"FALLING_EDGE".equals(hidName) || !hid.hasAccesses()) continue;
            ListContainer<HidAccess> accesses = hid.getAccesses();
            for (HidAccess access : accesses) {
                List<? extends IHidObject> argumentValues;
                if (!(access instanceof IHidAccessArgs) || (argumentValues = ((IHidAccessArgs)((Object)access)).getArgumentValues()) == null || argumentValues.size() != 1) continue;
                result.addAll(MethodCallUtils.getValueHids(argumentValues.get(0), PROCESS_HID_FLATTENING));
                if (!exitWhenClockFound || result.isEmpty()) continue;
                return;
            }
        }
    }

    @NotNull
    public static final Map<String, IHid> getVHDLSensitivityListDrivers(IRfNamedElement process, boolean exitWhenClockFound) {
        if (process == null) {
            return Collections.emptyMap();
        }
        List<IHidOperator> sensitivityLists = process.getHidOperators(EVENT_CONTROL_QUALIFIERS, false);
        if (sensitivityLists == null || sensitivityLists.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashSet<IHid> result = new LinkedHashSet<IHid>();
        for (IHidOperator sensitivityList : sensitivityLists) {
            Set<IHid> hids = new LinkedHashSet<IHid>();
            DesignUtils.collectVHDLClockEventHids(sensitivityList, hids, exitWhenClockFound);
            if (!hids.isEmpty()) {
                result.addAll(hids);
                if (exitWhenClockFound) break;
            }
            if ((hids = HidUtils.flattenToHids(sensitivityList, PROCESS_HID_FLATTENING)) == null || hids.isEmpty()) continue;
            result.addAll(hids);
        }
        if (result.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, IHid> resultMap = new LinkedHashMap<String, IHid>(result.size());
        for (IHid sensitivityHid : result) {
            DesignUtils.collectProcessDriver(process, resultMap, sensitivityHid, true);
        }
        return resultMap;
    }

    @Deprecated
    private static final TCLogic makeStandInLogic(IRfNamedElement signalExprElement, List<IHid> signalExprHids, boolean fromOutputPort, HidOperatorOccurrence hidOperatorOccurrence) {
        if (signalExprElement == null || signalExprHids == null) {
            return null;
        }
        HidOccurrence occurrence = new HidOccurrence(hidOperatorOccurrence.getOffset(), hidOperatorOccurrence.getVirtualOffset(), hidOperatorOccurrence.getLine(), 0L, null);
        Hid loadHid = HidUtils.makeStandInHid(signalExprElement.getName(), signalExprElement, occurrence, 0L);
        TCLogic logic = new TCLogic();
        if (fromOutputPort) {
            if (signalExprHids.isEmpty()) {
                return null;
            }
            logic.addCommonDrivers(Collections.singletonList(loadHid));
            for (IHid signalExprHid : signalExprHids) {
                logic.addLoad(signalExprHid, Collections.emptyList());
            }
        } else {
            logic.addLoad(loadHid, signalExprHids);
        }
        return logic;
    }

    private static final LogicForm makeStandInLogic2(IRfNamedElement signalExprElement, List<IHid> signalExprHids, boolean fromOutputPort, HidOperatorOccurrence hidOperatorOccurrence) {
        if (signalExprElement == null || signalExprHids == null) {
            return null;
        }
        HidOccurrence occurrence = new HidOccurrence(hidOperatorOccurrence.getOffset(), hidOperatorOccurrence.getVirtualOffset(), hidOperatorOccurrence.getLine(), 0L, null);
        Hid loadHid = HidUtils.makeStandInHid(signalExprElement.getName(), signalExprElement, occurrence, 0L);
        if (fromOutputPort) {
            ArrayList<LFProgram> progs = new ArrayList<LFProgram>(signalExprHids.size());
            for (IHid signalExpr : signalExprHids) {
                LFFanIn fanIn = LFFanIn.of(signalExpr);
                if (fanIn == null) continue;
                fanIn.addAllToBorder(Collections.singleton(loadHid));
                progs.add(LFProgram.p(fanIn));
            }
            return LogicForm.of(progs);
        }
        LFFanIn fanIn = LFFanIn.of(loadHid);
        if (fanIn == null) {
            return null;
        }
        fanIn.addAllToBorder(signalExprHids);
        return LogicForm.of(LFProgram.p(fanIn));
    }

    private static final LogicForm makeStandInLogic2(Set<TCConnSignal> conns, IRfNamedElement enclosingDesignOrInstance, ELInstance closestAncestorInstance, boolean fromOutputPort, boolean schematicShowConstants) {
        if (enclosingDesignOrInstance == null || conns == null || conns.isEmpty()) {
            return null;
        }
        TCConnSignal firstConn = conns.iterator().next();
        TCStatement statement = firstConn.statement;
        if (statement == null) {
            return null;
        }
        IHidOperator operator = firstConn.getEnclosingOperator(enclosingDesignOrInstance, closestAncestorInstance);
        if (operator == null) {
            return null;
        }
        boolean hasValidSignals = DesignUtils.checkHasValidSignalAsMember(Collections.singleton(operator), enclosingDesignOrInstance, closestAncestorInstance, schematicShowConstants);
        if (!hasValidSignals) {
            return null;
        }
        statement.goToInfo.text = "";
        HidOperatorOccurrence occurrence = operator.getOccurrence();
        int offset = occurrence != null ? occurrence.getOffset() : -1;
        String dummyUniqueName = String.valueOf(statement.toString()) + "@" + offset;
        DummyPort dummy = new DummyPort(dummyUniqueName, HidUtils.toNiceString(operator), DummyPort.DummyPortDirection.OUTPUT, enclosingDesignOrInstance, DVTImages.OUTLINE_OUTPUT_PORT);
        boolean ignoreImplicits = DesignUtils.shouldIgnoreImplicits(Collections.singleton(operator));
        List<IHid> driverHids = conns.stream().filter(c -> c.getSignalHid() != null).filter(c -> !ignoreImplicits || !(c.getSignalHid() instanceof HidImplicit)).map(TCConnSignal::getSignalHid).collect(Collectors.toList());
        return DesignUtils.makeStandInLogic2(dummy, driverHids, fromOutputPort, operator.getOccurrence());
    }

    private static boolean shouldIgnoreImplicits(Collection<IHidObject> expressions) {
        if (expressions == null) {
            return false;
        }
        for (IHidObject expr : expressions) {
            Set<IHid> hids = HidUtils.flattenToHids(expr, HidFlatteningOption.IMPLICITS_IN_SELECTS_AND_ARGS_EXCLUDED);
            if (hids.isEmpty()) continue;
            long implicitHidsCount = hids.stream().filter(hid -> hid instanceof HidImplicit).count();
            long otherHidsCount = (long)hids.size() - implicitHidsCount;
            if (implicitHidsCount == 0L) continue;
            if (otherHidsCount == 0L) {
                return implicitHidsCount > 1L;
            }
            return true;
        }
        return false;
    }

    @Deprecated
    private static final TCLogic makeStandInLogic(Set<TCConnSignal> conns, IRfNamedElement enclosingDesignOrInstance, ELInstance closestAncestorInstance, boolean fromOutputPort) {
        if (enclosingDesignOrInstance == null || conns == null || conns.isEmpty()) {
            return null;
        }
        TCConnSignal firstConn = conns.iterator().next();
        TCStatement statement = firstConn.statement;
        if (statement == null) {
            return null;
        }
        IHidOperator operator = firstConn.getEnclosingOperator(enclosingDesignOrInstance, closestAncestorInstance);
        if (operator == null) {
            return null;
        }
        boolean hasVariablesInOperator = DesignUtils.checkHasValidSignalAsMember(Collections.singleton(operator), enclosingDesignOrInstance, closestAncestorInstance);
        if (!hasVariablesInOperator) {
            return null;
        }
        statement.goToInfo.text = "";
        String dummyUniqueName = statement.toString();
        DummyPort dummy = new DummyPort(dummyUniqueName, HidUtils.toNiceString(operator), DummyPort.DummyPortDirection.OUTPUT, enclosingDesignOrInstance, DVTImages.OUTLINE_OUTPUT_PORT);
        List<IHid> driverHids = conns.stream().filter(c -> c.getSignalHid() != null).map(TCConnSignal::getSignalHid).collect(Collectors.toList());
        return DesignUtils.makeStandInLogic(dummy, driverHids, fromOutputPort, operator.getOccurrence());
    }

    @Deprecated
    public static final void collectConcurrentDriversAndLoads(IHidOperator operator, TCLogic loadDrivers, Set<HidFlatteningOption> options) {
        if (operator == null || loadDrivers == null) {
            return;
        }
        if (operator.hasOccurrence(HidQualifierCache.IS_CONDITIONAL_EXPRESSION_QUALIFIER)) {
            loadDrivers.addCommonDrivers(DesignUtils.getLHHids(operator, options));
            return;
        }
        if (operator.hasOccurrence(HidOperatorQualifier.IS_CASE_ITEM_EXPRESSION)) {
            loadDrivers.addCommonDrivers(DesignUtils.getLHHids(operator, options));
            loadDrivers.addCommonDrivers(DesignUtils.getRHHids(operator, options));
            return;
        }
        if (operator.hasOccurrence(HidQualifierCache.ALL_DECLARATION_QUALIFIERS)) {
            List<IHid> rhHids = DesignUtils.getRHHids(operator, options);
            for (IHid load : DesignUtils.getLHHids(operator, options)) {
                loadDrivers.addLoad(load, rhHids);
            }
            return;
        }
        if (operator.hasOccurrence(HidQualifierCache.ALL_SIMPLE_ASSIGN_QUALIFIERS)) {
            DesignUtils.internalCollectConcurrentDriversAndLoads(operator.getLHValue(), OptimizedUtils.asList(operator.getRHValues(), false), loadDrivers, options);
            return;
        }
        if (operator.hasOccurrence(HidQualifierCache.IS_ALIAS_QUALIFIER)) {
            List<IHidObject> aValues = OptimizedUtils.asList(operator.getRHValues(), false);
            for (IHidObject aValue : aValues) {
                ArrayList<IHidObject> other = new ArrayList<IHidObject>(aValues);
                other.remove(aValue);
                DesignUtils.internalCollectConcurrentDriversAndLoads(aValue, other, loadDrivers, options);
            }
            return;
        }
        if (operator.isIncrementOrDecrement()) {
            DesignUtils.internalCollectConcurrentDriversAndLoads(operator.getLHValue(), Collections.singletonList(operator.getLHValue()), loadDrivers, options);
            return;
        }
        if (operator.hasOccurrence(HidQualifierCache.ALL_SELECT_ASSIGN_QUALIFIERS)) {
            IHidObject rfHidObject;
            loadDrivers.addCommonDrivers(DesignUtils.getLHHids(operator, options));
            List<IHidObject> rhValues = OptimizedUtils.asList(operator.getRHValues(), false);
            if (rhValues.size() == 1 && (rfHidObject = rhValues.get(0)).getHidKind() == IHidObject.HidKind.OPERATOR) {
                IHidOperator assignment = (IHidOperator)rfHidObject;
                DesignUtils.internalCollectConcurrentDriversAndLoads(assignment.getLHValue(), OptimizedUtils.asList(assignment.getRHValues(), false), loadDrivers, options);
            }
        }
    }

    private static List<IHid> getLHHids(IHidOperator operator, Set<HidFlatteningOption> options) {
        ArrayList<IHid> hids = new ArrayList<IHid>();
        Predicate<IHidObject> result = element -> {
            IHid hid = HidUtils.getHidFrom(element);
            if (hid != null && !(hid.getElement() instanceof IRfInstanceElement)) {
                hids.add(hid);
            }
            return true;
        };
        HidUtils.flattenToObjects(result, operator.getLHValue(), options);
        return hids;
    }

    private static List<IHid> getRHHids(IHidOperator operator, Set<HidFlatteningOption> options) {
        ArrayList<IHid> hids = new ArrayList<IHid>();
        Predicate<IHidObject> result = element -> {
            IHid hid = HidUtils.getHidFrom(element);
            if (hid != null && !(hid.getElement() instanceof IRfInstanceElement)) {
                hids.add(hid);
            }
            return true;
        };
        HidUtils.flattenToObjects(result, OptimizedUtils.asList(operator.getRHValues(), false), options);
        return hids;
    }

    private static final void internalCollectConcurrentDriversAndLoads(IHidObject lhValue, List<IHidObject> rhValues, TCLogic loadDrivers, Set<HidFlatteningOption> options) {
        if (!options.contains((Object)HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS)) {
            EnumSet<HidFlatteningOption> noSelectOptions = options.isEmpty() ? EnumSet.noneOf(HidFlatteningOption.class) : EnumSet.copyOf(options);
            noSelectOptions.add(HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS);
            Set<IHid> lhHidsNoSelects = HidUtils.flattenToHids(lhValue, noSelectOptions);
            ArrayList<IHid> result = new ArrayList<IHid>();
            Predicate<IHidObject> predicate = element -> {
                IHid hid = HidUtils.getHidFrom(element);
                if (hid != null && !(hid.getElement() instanceof IRfInstanceElement)) {
                    result.add(hid);
                }
                return true;
            };
            HidUtils.flattenToObjects(predicate, rhValues, options);
            AbstractCollection rhHids = result;
            Set<IHid> lhHidsSelects = HidUtils.flattenToHids(lhValue, options);
            if (lhHidsSelects.size() != lhHidsNoSelects.size()) {
                lhHidsSelects.removeAll(lhHidsNoSelects);
                LinkedHashSet<IHid> temp = new LinkedHashSet<IHid>(rhHids);
                temp.addAll(lhHidsSelects);
                rhHids = temp;
            }
            for (IHid load : lhHidsNoSelects) {
                loadDrivers.addLoad(load, rhHids);
            }
        } else {
            Set<IHid> lhHidsNoSelects = HidUtils.flattenToHids(lhValue, options);
            Set<IHid> rhHids = HidUtils.flattenToHids(rhValues, options);
            for (IHid load : lhHidsNoSelects) {
                loadDrivers.addLoad(load, rhHids);
            }
        }
    }

    public static final IRfNamedElement resolveSignalByName(String signalName, DesignRequest request, Map<IRfInstanceElement, Set<DummyPort>> dummyPortCache) {
        if (signalName == null || signalName.isEmpty()) {
            return null;
        }
        IRfPortElement signal = DesignUtils.getPortByName(signalName, request, dummyPortCache);
        if (signal != null) {
            return signal;
        }
        return DesignUtils.getFieldOrInstanceByName(signalName, request);
    }

    public static final IRfNamedElement resolveSignal(Object signal, DesignRequest request, ELInstance closestAncestorInstance, Map<IRfInstanceElement, Set<DummyPort>> dummyPortMap) {
        if (signal instanceof String) {
            return DesignUtils.resolveSignalByName((String)signal, request, dummyPortMap);
        }
        if (signal instanceof HidImplicit && ((HidImplicit)signal).isID()) {
            return DesignUtils.resolveSignalByName(((HidImplicit)signal).getName(), request, dummyPortMap);
        }
        if (signal instanceof Hid) {
            Hid signalHid = (Hid)signal;
            if (signalHid.getElement() instanceof DummyField && signalHid.getParentHid() != null) {
                signalHid = signalHid.getParentHid();
            }
            return signalHid.getDesignSignal(request, closestAncestorInstance, dummyPortMap);
        }
        return null;
    }

    public static final boolean isVHDLDesign(IRfNamedElement element) {
        return element != null && LanguageKind.VHDL == element.getLanguageKind();
    }

    public static final boolean isFieldSignal(Object element) {
        if (!(element instanceof IRfFieldElement)) {
            return false;
        }
        switch (((IRfFieldElement)element).getFieldKind()) {
            case 1: 
            case 32768: {
                return true;
            }
        }
        return false;
    }

    public static final boolean isVHDLVariable(Object element) {
        int kind;
        int n = kind = element instanceof IRfFieldElement && !(element instanceof IRfPortElement) ? ((IRfFieldElement)element).getFieldKind() : 0;
        return kind == 8192;
    }

    public static final boolean isVLOGVariable(Object element) {
        int kind;
        int n = kind = element instanceof IRfFieldElement ? ((IRfFieldElement)element).getFieldKind() : 0;
        return kind == 4;
    }

    public static final boolean isInterfaceInstance(Object element) {
        if (element instanceof DiagramInstanceWrapper) {
            IRfNamedElement design = ((DiagramInstanceWrapper)element).getBinding(false);
            return design instanceof IRfDesignElement && ((IRfDesignElement)design).getKind() == IRfNamedElement.ElementKind.VLOG_INTERFACE;
        }
        if (element instanceof IRfInstanceElement && element instanceof IRfAssociatedTypeElement) {
            IRfDesignElement design = DesignUtils.getDesign(DesignRequest.of((IRfInstanceElement)element));
            return design instanceof IRfDesignElement && design.getKind() == IRfNamedElement.ElementKind.VLOG_INTERFACE;
        }
        return false;
    }

    public static final boolean isMemberOfComposite(Object element) {
        IRfScopeElement enclosingScope = element instanceof IRfFieldElement ? ((IRfFieldElement)element).getEnclosingScope() : null;
        return DesignUtils.isCompositeType(enclosingScope);
    }

    public static final boolean isCompositeSignal(Object element) {
        IRfNamedElement resolvedType = DesignUtils.getResolvedType(element);
        return DesignUtils.isCompositeType(resolvedType);
    }

    public static IRfNamedElement getResolvedType(Object element) {
        IRfNamedElement resolvedType = element instanceof IRfFieldElement ? ((IRfFieldElement)element).getResolvedType(true) : null;
        int count = 0;
        while ((resolvedType instanceof IRfListType || resolvedType instanceof IRfTypeAliasElement) && count++ < 50) {
            if (resolvedType instanceof IRfListType) {
                resolvedType = ((IRfListType)resolvedType).getResolvedType(true);
            }
            if (!(resolvedType instanceof IRfTypeAliasElement)) continue;
            resolvedType = ((IRfTypeAliasElement)resolvedType).getTranslatedType();
        }
        return resolvedType;
    }

    private static final boolean isCompositeType(Object element) {
        return element instanceof IRfCompositeTypeElement && ((IRfCompositeTypeElement)element).isStruct();
    }

    public static final boolean isInterfacePort(Object port) {
        return port instanceof IRfPortElement && ((IRfPortElement)port).isInterfacePort();
    }

    public static final boolean isUnknownDesignPort(Object port) {
        if (port instanceof DummyPort) {
            String label = ((DummyPort)port).getLabel();
            return label == null || label.isEmpty();
        }
        return false;
    }

    public static final boolean isValidBlockSignalCandidate(IRfNamedElement candidate) {
        return DesignUtils.isValidSignalCandidate(candidate, null) || DesignUtils.isVHDLVariable(candidate);
    }

    public static final boolean isValidSignalCandidate(IRfNamedElement candidate, ElementPath instancePath) {
        if (candidate == null) {
            return false;
        }
        if (candidate instanceof HierarchicalElement) {
            HierarchicalElement hierarchicalSignal = (HierarchicalElement)candidate;
            IRfNamedElement firstSegment = hierarchicalSignal.getFirstSegment();
            if (!DesignUtils.isValidSignalCandidate(firstSegment, instancePath)) {
                return false;
            }
            IRfNamedElement lastSegment = hierarchicalSignal.getLastSegment();
            return DesignUtils.isValidSignalCandidate(lastSegment, null) || lastSegment instanceof IRfModportElement;
        }
        if (candidate instanceof IRfTypeAliasElement) {
            candidate = ((IRfTypeAliasElement)candidate).getTranslatedType();
        }
        if (candidate instanceof IRfInstanceElement) {
            ElementPath adjustedInstancePath = instancePath != null ? ElementPath.join(instancePath, candidate.getName()) : null;
            IRfNamedElement design = ((IRfInstanceElement)candidate).getGenericDesign(adjustedInstancePath);
            if (design instanceof IRfDesignElement && ((IRfDesignElement)design).getKind() == IRfNamedElement.ElementKind.VLOG_INTERFACE) {
                return true;
            }
            return DesignUtils.internalCheckArrayOfInstances(adjustedInstancePath, (IRfInstanceElement)candidate);
        }
        return candidate instanceof IRfPortElement || DesignUtils.isFieldSignal(candidate) || DesignUtils.isMemberOfComposite(candidate);
    }

    private static final boolean internalCheckArrayOfInstances(ElementPath instancePath, IRfInstanceElement instance) {
        if (instancePath == null || !instance.isArray()) {
            return false;
        }
        IRfSingleLangProject rfProject = instance.getRfProject();
        if (rfProject == null) {
            return false;
        }
        ELManager elManager = rfProject.getELManager();
        if (elManager == null) {
            return false;
        }
        ElementPath endPath = instancePath.removeLastSegment();
        endPath = ElementPath.join(endPath, String.valueOf(instancePath.lastSegment()) + "{");
        Map<ElementPath, ELInstance> subMap = elManager.getMemory().subMap(instancePath, true, endPath, false, false);
        return subMap != null && !subMap.isEmpty();
    }

    public static final IRfNamedElement.ElementKind getDesignKind(Object element) {
        if (element instanceof IRfDesignElement) {
            return ((IRfDesignElement)element).getKind();
        }
        if (element instanceof IRfInstanceElement) {
            return ((IRfInstanceElement)element).getKind();
        }
        return IRfNamedElement.ElementKind.UNKNOWN;
    }

    public static boolean isVHDLEntity(IRfNamedElement design) {
        return DesignUtils.getDesignKind(design) == IRfNamedElement.ElementKind.VHDL_ENTITY;
    }

    public static final boolean isValidDesignKind(IRfNamedElement.ElementKind elementKind) {
        return elementKind == IRfNamedElement.ElementKind.VLOG_MODULE || elementKind == IRfNamedElement.ElementKind.VLOG_INTERFACE || elementKind == IRfNamedElement.ElementKind.VLOG_GENERATE || elementKind == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE || elementKind == IRfNamedElement.ElementKind.VHDL_ENTITY || elementKind == IRfNamedElement.ElementKind.VHDL_BLOCK || elementKind == IRfNamedElement.ElementKind.VHDL_COMPONENT;
    }

    public static final String getDesignKindInstanceText(IRfScopeElement design) {
        if (!(design instanceof IRfDesignElement)) {
            return "type";
        }
        switch (((IRfDesignElement)design).getKind()) {
            case VLOG_MODULE: {
                return "module";
            }
            case VLOG_INTERFACE: {
                return "interface";
            }
            case VLOG_CHECKER: {
                return "checker";
            }
            case VLOG_PROGRAM: {
                return "program";
            }
            case VLOG_PRIMITIVE: {
                return "primitive";
            }
            case VHDL_ARCHITECTURE: 
            case VHDL_ENTITY: {
                return "entity";
            }
            case VHDL_COMPONENT: {
                return "component";
            }
            case VHDL_CONFIGURATION: {
                return "configuration";
            }
        }
        return "type";
    }

    public static final List<IHid> mapProcessDriversVLOG(IRfNamedElement actionBlock, TCLogic logic, boolean vhdlNotVerilog) {
        Map<IHid, Collection<IHid>> loadDriversMap;
        if (logic == null) {
            return Collections.emptyList();
        }
        ArrayList<IHid> driverNamesList = new ArrayList<IHid>();
        Collection<IHid> commonDrivers = logic.getCommonDrivers();
        if (!commonDrivers.isEmpty()) {
            for (IHid commonDriver : commonDrivers) {
                DesignUtils.collectProcessDriver(actionBlock, driverNamesList, commonDriver);
            }
        }
        if (!(loadDriversMap = logic.getLoadDrivers()).isEmpty()) {
            for (Map.Entry<IHid, Collection<IHid>> loadDrivers : loadDriversMap.entrySet()) {
                for (IHid loadDriver : loadDrivers.getValue()) {
                    DesignUtils.collectProcessDriver(actionBlock, driverNamesList, loadDriver);
                }
            }
        }
        return driverNamesList;
    }

    public static final Map<String, IHid> mapProcessDriversVHDL(IRfNamedElement actionBlock, TCLogic logic, boolean vhdlNotVerilog) {
        Map<IHid, Collection<IHid>> loadDriversMap;
        if (logic == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, IHid> driverNamesMap = new LinkedHashMap<String, IHid>();
        Collection<IHid> commonDrivers = logic.getCommonDrivers();
        if (!commonDrivers.isEmpty()) {
            for (IHid commonDriver : commonDrivers) {
                DesignUtils.collectProcessDriver(actionBlock, driverNamesMap, commonDriver, true);
            }
        }
        if (!(loadDriversMap = logic.getLoadDrivers()).isEmpty()) {
            for (Map.Entry<IHid, Collection<IHid>> loadDrivers : loadDriversMap.entrySet()) {
                for (IHid loadDriver : loadDrivers.getValue()) {
                    DesignUtils.collectProcessDriver(actionBlock, driverNamesMap, loadDriver, vhdlNotVerilog);
                }
            }
        }
        return driverNamesMap;
    }

    public static final void collectProcessDriver(IRfNamedElement enclosingBlock, Collection<IHid> driverNames, IHid driver) {
        if (!(driver instanceof Hid)) {
            return;
        }
        Hid driverHid = (Hid)driver;
        HidAccess parentAccess = driverHid.getParentAccess();
        if (parentAccess != null && parentAccess.getAccessKind() == 5) {
            return;
        }
        if (driverHid.hasOccurrence(HidQualifierCache.TIME_EXPR_QUALIFIER)) {
            return;
        }
        if (driverHid.hasOccurrence(HidQualifierCache.PATTERN_KEY_QUALIFIER)) {
            return;
        }
        Hid ancestorDriver = driverHid.getAncestorHid();
        IRfNamedElement element = ancestorDriver.getElement();
        if (!DesignUtils.isValidSignalCandidate(element, null)) {
            return;
        }
        IRfNamedElement enclosingScope = (IRfNamedElement)element.getEnclosingScope(enclosingBlock.getClass());
        if (enclosingScope == enclosingBlock) {
            return;
        }
        driverNames.add(ancestorDriver);
    }

    public static final void collectProcessDriver(IRfNamedElement enclosingBlock, Map<String, IHid> driverNames, IHid driver, boolean ignoreLetterCase) {
        if (!(driver instanceof Hid)) {
            return;
        }
        Hid driverHid = (Hid)driver;
        HidAccess parentAccess = driverHid.getParentAccess();
        if (parentAccess != null && parentAccess.getAccessKind() == 5) {
            return;
        }
        if (driverHid.hasOccurrence(HidQualifierCache.TIME_EXPR_QUALIFIER)) {
            return;
        }
        if (driverHid.hasOccurrence(HidQualifierCache.PATTERN_KEY_QUALIFIER)) {
            return;
        }
        Hid ancestorDriver = driverHid.getAncestorHid();
        IRfNamedElement element = ancestorDriver.getElement();
        if (!DesignUtils.isValidSignalCandidate(element, null)) {
            return;
        }
        IRfNamedElement enclosingScope = (IRfNamedElement)element.getEnclosingScope(enclosingBlock.getClass());
        if (enclosingScope == enclosingBlock) {
            return;
        }
        String driverName = ancestorDriver.getName();
        if (driverName == null) {
            return;
        }
        if (ignoreLetterCase) {
            driverName = driverName.toUpperCase();
        }
        if (!driverNames.containsKey(driverName)) {
            driverNames.put(driverName, ancestorDriver);
        }
    }

    public static final Image getDesignImage(IRfNamedElement design) {
        if (design == null) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ANY_DESIGN_INSTANCE_WARNING);
        }
        if (design == ELConstants.UNRESOLVED_INSTANCE_TYPE) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ANY_DESIGN_INSTANCE_WARNING);
        }
        if (design == ELConstants.RECURRENCE_INSTANCE_TYPE) {
            return DVTImages.imageCache.getImage(DVTImages.INSTANCE_LOOP);
        }
        if (design == ELConstants.BLACK_BOX_INSTANCE_TYPE) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_BBOX_INSTANCE);
        }
        if (design instanceof RootDesignElement) {
            return DVTImages.imageCache.getImage(DVTImages.DESIGN_HIERARCHY_TOP);
        }
        switch (DesignUtils.getDesignKind(design)) {
            case VLOG_MODULE: {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_MODULE_INSTANCE);
            }
            case VLOG_INTERFACE: {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_INTERFACE_INSTANCE);
            }
            case VLOG_PROGRAM: {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_PROGRAM_INSTANCE);
            }
            case VLOG_CHECKER: {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_CHECKER_INSTANCE);
            }
            case VLOG_PRIMITIVE: {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_PRIMITIVE_INSTANCE);
            }
            case VLOG_GENERATE: {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_CONDITION);
            }
            case VHDL_ARCHITECTURE: 
            case VHDL_ENTITY: {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ENTITY_INSTANCE);
            }
            case VHDL_COMPONENT: {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_COMPONENT_INSTANCE);
            }
            case VHDL_CONFIGURATION: {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_CONFIGURATION_INSTANCE);
            }
            case VHDL_VUNIT: {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_CHECKER_INSTANCE);
            }
            case VHDL_BLOCK: {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_CONDITION);
            }
        }
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ANY_DESIGN_INSTANCE);
    }

    public static final IHidOperator makeOperatorForPredefinedGateInstance(IRfPredefinedGate gateType, IRfInstanceElement instance, GoToInfo goToInfo, Map<IRfInstanceElement, Set<DummyPort>> dummyPortCache, Map<IRfPortElement, Set<TCConnSignal>> instancePortConnectionsCache, Set<HidFlatteningOption> portConnectionsFlattening) {
        if (gateType == null || instance == null || goToInfo == null) {
            return null;
        }
        if (!COMBINATIONAL_PREDEFINED_GATES.contains(gateType.getName())) {
            return null;
        }
        ArrayList<IHid> lhs = new ArrayList<IHid>();
        ArrayList<IHid> rhs = new ArrayList<IHid>();
        if (instancePortConnectionsCache == null) {
            instancePortConnectionsCache = DesignUtils.mapInstancePortConnections(DesignRequest.of(instance), dummyPortCache, portConnectionsFlattening, false, false, null);
        }
        if (instancePortConnectionsCache.isEmpty()) {
            return null;
        }
        for (Map.Entry<IRfPortElement, Set<TCConnSignal>> entry : instancePortConnectionsCache.entrySet()) {
            IRfPortElement dummyPort = entry.getKey();
            HidOccurrence occurrence = new HidOccurrence(goToInfo.offset, goToInfo.virtualOffset, goToInfo.line, 0L, null);
            Hid hid = HidUtils.makeStandInHid(dummyPort.getName(), dummyPort, occurrence, 0L);
            if (dummyPort.isInput()) {
                rhs.add(hid);
                continue;
            }
            if (dummyPort.isOutput()) {
                lhs.add(hid);
                continue;
            }
            if (!dummyPort.isInout()) continue;
            lhs.add(hid);
            rhs.add(hid);
        }
        return DesignUtils.makeStandInOperator(lhs, rhs, goToInfo);
    }

    public static final String getFilePath(IRfNamedElement element) {
        IRfDefElement declaration = element != null ? element.getDeclaration() : null;
        ParserPath fileParserPath = declaration != null ? declaration.getParserPath() : null;
        return fileParserPath != null ? fileParserPath.path : null;
    }

    public static boolean isSequentialAtomicFormula(LFFormula formula) {
        IHidOperator operator;
        if (!(formula instanceof LFFormula.LFAtomicFormula)) {
            return false;
        }
        IHidObject expr = ((LFFormula.LFAtomicFormula)formula).getExpr();
        IHidOperator iHidOperator = operator = HidUtils.isOperator(expr) ? (IHidOperator)expr : null;
        if (operator != null) {
            LinkedHashSet<IHid> hids = new LinkedHashSet<IHid>();
            DesignUtils.collectVLOGClockEventHids(operator, hids, true);
            if (!hids.isEmpty()) {
                return true;
            }
            DesignUtils.collectVHDLClockEventHids(operator, hids, true);
            if (!hids.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public static boolean isSequentialFormula(LFFormula startFormula) {
        List<LFFormula> sequentialParts = LFUtils.flattenFormula(startFormula, formula -> DesignUtils.isSequentialAtomicFormula(formula));
        return !sequentialParts.isEmpty();
    }

    public static void getInstancesIncludingGenerate(Collection<IRfInstanceElement> result, IRfDesignElement design, boolean includeAllArchitectures) {
        if (DesignUtils.isVHDLEntity(design)) {
            List<? extends IRfBlockElement> architectures;
            List<? extends IRfBlockElement> list = architectures = includeAllArchitectures ? design.getArchitectures() : Collections.singletonList((IRfBlockElement)design.getArchitecture());
            if (architectures != null && !architectures.isEmpty()) {
                for (IRfBlockElement iRfBlockElement : architectures) {
                    DesignUtils.internalGetInstancesIncludingGenerates(result, iRfBlockElement);
                }
            }
        } else {
            DesignUtils.internalGetInstancesIncludingGenerates(result, design);
        }
    }

    private static void internalGetInstancesIncludingGenerates(Collection<IRfInstanceElement> result, IRfDesignElement element) {
        Collection<? extends IRfBlockElement> collection;
        if (element == null) {
            return;
        }
        Collection<? extends IRfInstanceElement> instances = element.getLocalInstances();
        if (instances != null && !instances.isEmpty()) {
            for (IRfInstanceElement iRfInstanceElement : instances) {
                result.add(iRfInstanceElement);
            }
        }
        if ((collection = element.getLocalGenerateBlocks()) != null && !collection.isEmpty()) {
            for (IRfBlockElement iRfBlockElement : collection) {
                DesignUtils.internalGetInstancesIncludingGenerates(result, iRfBlockElement);
            }
        }
    }

    public static ElementPath computeInstanceFullName(IRfNamedElement namedElement) {
        if (!(namedElement instanceof IRfBlockElement) && !(namedElement instanceof IRfInstanceElement)) {
            return ElementPath.EMPTY_PATH;
        }
        if (DesignUtils.getDesignKind(namedElement) == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE) {
            return ElementPath.EMPTY_PATH;
        }
        String name = namedElement.getName();
        IRfScopeElement enclosing = namedElement.getEnclosingScope();
        return ElementPath.join(enclosing instanceof IRfNamedElement ? DesignUtils.computeInstanceFullName((IRfNamedElement)enclosing) : null, name);
    }

    public static boolean isBlock(Object element) {
        return element instanceof IRfBlockElement && (((IRfBlockElement)element).getKind() == IRfNamedElement.ElementKind.VLOG_GENERATE || ((IRfBlockElement)element).getKind() == IRfNamedElement.ElementKind.VHDL_BLOCK);
    }

    public static boolean isNullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isUnelaboratedBindInstance(IRfInstanceElement instance) {
        if (instance == null) {
            return true;
        }
        IRfScopeElement enclosingScope = instance.getEnclosingScope(DVTRfUtils.MEMBERS_DESIGN);
        return enclosingScope instanceof IRfDesignElement && ((IRfDesignElement)enclosingScope).getSemanticEnableRaw() == 0;
    }

    public static final class DesignRequest {
        public final IRfNamedElement instanceOrDesign;
        public final ElementPath instancePath;
        public final IRfNamedElement designHint;
        public final boolean resolveComponent;
        public final DMemoryAccessor memoryAccessor;

        private DesignRequest(IRfNamedElement namedElem, ElementPath instancePath, IRfNamedElement designHint, boolean resolveComponent, DMemoryAccessor memoryAccessor) {
            this.instanceOrDesign = namedElem;
            this.instancePath = instancePath;
            this.designHint = designHint;
            this.resolveComponent = resolveComponent;
            this.memoryAccessor = memoryAccessor;
        }

        public static DesignRequest of(IRfNamedElement namedElem) {
            return DesignRequest.of(namedElem, null, null, false, null);
        }

        public static DesignRequest of(IRfNamedElement namedElem, IRfNamedElement designHint) {
            return DesignRequest.of(namedElem, null, designHint, false, null);
        }

        public static DesignRequest of(IRfNamedElement namedElem, boolean resolveComponent) {
            return DesignRequest.of(namedElem, null, null, resolveComponent, null);
        }

        public static DesignRequest of(IRfNamedElement namedElem, ElementPath instancePath, IRfNamedElement designHint, boolean resolveComponent, DMemoryAccessor memoryAccessor) {
            return new DesignRequest(namedElem, instancePath, designHint, resolveComponent, memoryAccessor);
        }
    }

    public static interface SupplierInDesign<T>
    extends Supplier<T> {
        public T get(IRfNamedElement var1, ELInstance var2);

        @Override
        default public T get() {
            return this.get(null, null);
        }
    }
}

