/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidObjectWrapper;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorWrapper;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;

public final class HidOperatorVisitorWithPaths
extends HidOperatorVisitor {
    public static final Comparator<HidObjectWrapper<HidOperator>> OPERATOR_WRAPPER_COMPARATOR = (w1, w2) -> HidOperator.OPERATOR_COMPARATOR.compare((HidOperator)w1.hidObject, (HidOperator)w2.hidObject);
    private List<HidOperatorWrapper> objectsWithPaths = new ArrayList<HidOperatorWrapper>();
    private ParserPath prevParserPath;
    private int prevOffset;
    private boolean hasSortedResults = true;

    public HidOperatorVisitorWithPaths(int operatorType) {
        super(operatorType);
    }

    public HidOperatorVisitorWithPaths(HidOperatorQualifier[] qualifiers) {
        super(qualifiers, null);
    }

    @Override
    public boolean visitHit(HidOperator operator, IRfNamedElement scope) {
        if (this.hasSortedResults) {
            if (this.prevParserPath != null && this.prevParserPath != this.parserPath) {
                this.hasSortedResults = false;
            }
            this.prevParserPath = this.parserPath;
            int offset = operator.getOccurrence().getOffset();
            if (this.prevOffset != -1 && this.prevOffset > offset) {
                this.hasSortedResults = false;
            }
            this.prevOffset = offset;
        }
        this.objectsWithPaths.add(HidOperatorWrapper.of(operator, this.parserPath));
        return true;
    }

    public static List<HidOperatorWrapper> getHidOperators(IRfNamedElement source, HidOperatorQualifier[] qualifiers, boolean local) {
        IHidHolder searchHolder;
        IHidHolder iHidHolder = searchHolder = local ? source.getHidHolder() : (IHidHolder)((Object)source);
        if (searchHolder == null) {
            return null;
        }
        if (qualifiers == null) {
            return null;
        }
        HidOperatorVisitorWithPaths visitor = new HidOperatorVisitorWithPaths(qualifiers);
        searchHolder.visitHidObject(null, visitor);
        return visitor.objectsWithPaths;
    }

    public static List<HidOperatorWrapper> getSortedHidOperators(IRfNamedElement source, HidOperatorQualifier[] qualifiers, boolean local) {
        IHidHolder searchHolder;
        IHidHolder iHidHolder = searchHolder = local ? source.getHidHolder() : (IHidHolder)((Object)source);
        if (searchHolder == null) {
            return null;
        }
        if (qualifiers == null) {
            return null;
        }
        HidOperatorVisitorWithPaths visitor = new HidOperatorVisitorWithPaths(qualifiers);
        searchHolder.visitHidObject(null, visitor);
        if (!visitor.hasSortedResults()) {
            Collections.sort(visitor.objectsWithPaths, OPERATOR_WRAPPER_COMPARATOR);
        }
        return visitor.objectsWithPaths;
    }

    public boolean hasSortedResults() {
        return this.hasSortedResults;
    }

    @NotNull
    public List<HidOperatorWrapper> getObjectsWithPaths() {
        return this.objectsWithPaths;
    }
}

