/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorScopeWrapper;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;

public final class HidOperatorVisitorWithScopes
extends HidOperatorVisitor {
    private List<HidOperatorScopeWrapper> objectsWithPaths = new ArrayList<HidOperatorScopeWrapper>();
    private ParserPath prevParserPath;
    private int prevOffset;
    private boolean hasSortedResults = true;
    public static final Comparator<HidOperatorScopeWrapper> OPERATOR_COMPARATOR = (w1, w2) -> {
        int usageIndex = ((HidOperator)w1.hidObject).getUsageIndex();
        int otherUsageIndex = ((HidOperator)w2.hidObject).getUsageIndex();
        if (usageIndex == -1) {
            if (otherUsageIndex == -1) {
                return ((HidOperator)w1.hidObject).getOccurrence().getOffset() - ((HidOperator)w2.hidObject).getOccurrence().getOffset();
            }
            return -1;
        }
        if (otherUsageIndex == -1) {
            return 1;
        }
        if (usageIndex < otherUsageIndex) {
            return -1;
        }
        if (usageIndex > otherUsageIndex) {
            return 1;
        }
        return ((HidOperator)w1.hidObject).getOccurrence().getOffset() - ((HidOperator)w2.hidObject).getOccurrence().getOffset();
    };

    public HidOperatorVisitorWithScopes(int operatorType) {
        super(operatorType);
    }

    public HidOperatorVisitorWithScopes(HidOperatorQualifier[] qualifiers) {
        super(qualifiers, null);
    }

    @Override
    public boolean visitHit(HidOperator operator, IRfNamedElement scope) {
        if (this.hasSortedResults) {
            if (this.prevParserPath != null && this.prevParserPath != this.parserPath) {
                this.hasSortedResults = false;
            }
            this.prevParserPath = this.parserPath;
            int offset = operator.getOccurrence().getOffset();
            if (this.prevOffset != -1 && this.prevOffset > offset) {
                this.hasSortedResults = false;
            }
            this.prevOffset = offset;
        }
        this.objectsWithPaths.add(HidOperatorScopeWrapper.of(operator, scope, this.parserPath));
        return true;
    }

    public static List<HidOperatorScopeWrapper> getHidOperators(IRfNamedElement source, HidOperatorQualifier[] qualifiers, boolean local) {
        IHidHolder searchHolder;
        IHidHolder iHidHolder = searchHolder = local ? source.getHidHolder() : (IHidHolder)((Object)source);
        if (searchHolder == null) {
            return null;
        }
        if (qualifiers == null) {
            return null;
        }
        HidOperatorVisitorWithScopes visitor = new HidOperatorVisitorWithScopes(qualifiers);
        searchHolder.visitHidObject(null, visitor);
        return visitor.objectsWithPaths;
    }

    public static List<HidOperatorScopeWrapper> getSortedHidOperators(IRfNamedElement source, HidOperatorQualifier[] qualifiers, boolean local) {
        IHidHolder searchHolder;
        IHidHolder iHidHolder = searchHolder = local ? source.getHidHolder() : (IHidHolder)((Object)source);
        if (searchHolder == null) {
            return null;
        }
        if (qualifiers == null) {
            return null;
        }
        HidOperatorVisitorWithScopes visitor = new HidOperatorVisitorWithScopes(qualifiers);
        searchHolder.visitHidObject(null, visitor);
        if (!visitor.hasSortedResults()) {
            Collections.sort(visitor.objectsWithPaths, OPERATOR_COMPARATOR);
        }
        return visitor.objectsWithPaths;
    }

    public boolean hasSortedResults() {
        return this.hasSortedResults;
    }

    @NotNull
    public List<HidOperatorScopeWrapper> getObjectsWithPaths() {
        return this.objectsWithPaths;
    }
}

