/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection.util;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.model.reflection.util.IIdleListener;
import ro.amiq.dvt.model.reflection.util.IdleHandlerCommon;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.utils.DVTExceptionHandler;

public class IdleHandler
extends IdleHandlerCommon {
    protected static final int IDLE_INTERVAL = 300000;

    public static void startIdleMonitor(final Display display) {
        try {
            final IdleListener handler = new IdleListener();
            PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

                public boolean preShutdown(IWorkbench workbench, boolean forced) {
                    Shell shell = Utils.getActiveWorkbenchWindow().getShell();
                    ProgressMonitorDialog pmd = new ProgressMonitorDialog(shell);
                    try {
                        pmd.run(true, true, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                monitor.beginTask("Saving Dictionary ...", -1);
                                for (IIdleListener listener : fIdleListeners) {
                                    try {
                                        listener.platformIsIdle();
                                    }
                                    catch (Throwable e) {
                                        DVTLogger.INSTANCE.logError(e);
                                    }
                                }
                                boolean isDone = false;
                                while (!isDone) {
                                    if (monitor.isCanceled()) break;
                                    isDone = true;
                                    for (IIdleListener listener : fIdleListeners) {
                                        try {
                                            if (listener.isWriteDone()) continue;
                                            isDone = false;
                                        }
                                        catch (Throwable e) {
                                            DVTLogger.INSTANCE.logError(e);
                                        }
                                    }
                                    try {
                                        Thread.sleep(200L);
                                    }
                                    catch (Throwable throwable) {}
                                    monitor.worked(1);
                                }
                                monitor.done();
                            }
                        });
                        return true;
                    }
                    catch (InvocationTargetException e) {
                        DVTExceptionHandler.handle(e, shell, "Saving dirty dictionary", "Error saving the dictionary.");
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                    return true;
                }

                public void postShutdown(IWorkbench workbench) {
                }
            });
            Listener idleListener = new Listener(){

                public void handleEvent(Event event) {
                    if (!fIdleListeners.isEmpty()) {
                        display.timerExec(300000, handler);
                    }
                }
            };
            display.addFilter(2, idleListener);
            display.addFilter(4, idleListener);
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    private static class IdleListener
    implements Runnable {
        private IdleListener() {
        }

        @Override
        public void run() {
            for (IIdleListener listener : fIdleListeners) {
                try {
                    listener.platformIsIdle();
                }
                catch (Throwable e) {
                    DVTLogger.INSTANCE.logError(e);
                }
            }
        }
    }
}

