/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection.util;

import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;

public class MethodCall {
    public final IHidObject methodHidObject;
    public final IRfNamedElement method;
    public final Map<IRfFieldElement, Set<IHid>> argumentValuesMap;
    public final Map<IRfFieldElement, IHidObject> argumentValuesMapRaw;
    public final HidOccurrence occurrence;
    public IHidEvaluator methodValueHolder;

    public MethodCall(IHidObject methodHid, IRfNamedElement method, Map<IRfFieldElement, Set<IHid>> argumentValuesMap, Map<IRfFieldElement, IHidObject> argumentsValueRaw, HidOccurrence occurrence) {
        this.methodHidObject = methodHid;
        this.method = method;
        this.argumentValuesMap = argumentValuesMap;
        this.argumentValuesMapRaw = argumentsValueRaw;
        this.occurrence = occurrence;
    }

    public String toString() {
        return this.getMethodName() + "(" + (this.argumentValuesMapRaw != null ? this.argumentValuesMapRaw.toString() : "") + ")";
    }

    public String getMethodName() {
        switch (this.methodHidObject.getHidKind()) {
            case HID: {
                return ((IHid)this.methodHidObject).getName();
            }
            case OPERATOR: {
                return ((HidOperator)this.methodHidObject).getOperatorText();
            }
        }
        return "";
    }

    public Hid getMethodHid() {
        return HidUtils.isHid(this.methodHidObject) ? (Hid)this.methodHidObject : null;
    }

    public HidOccurrence getOccurrence() {
        return HidUtils.getOccurrence(this.methodHidObject);
    }
}

