/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.DummyPort;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidAccessArgs;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.AssociationUtils;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.OptimizedUtils;

public final class MethodCallUtils
extends AssociationUtils {
    public static final String VHDL_METHOD_SIGNATURE_ARGUMENTS = "@a:";
    public static final String VHDL_METHOD_SIGNATURE_RETURN = "@r:";
    public static final String VHDL_METHOD_SIGNATURE_BODY = "@b:";
    public static final String VLOG_FORMAT_SPECIFIERS_GROUP = "FORMATSPECGROUP";
    public static final Pattern VLOG_FORMAT_SPECIFIER_PATTERN = Pattern.compile("(?<!%)(%%)*%(?<FORMATSPECGROUP>[+-]?[0-9]*(\\.[0-9]+)?[a-zA-Z0-9])");
    public static final Set<String> INTEGER_FORMAT_DISPLAY_SPECIFIERS = new HashSet<String>(Arrays.asList("h", "x", "d", "o", "b", "c", "u", "z"));
    public static final Set<String> REAL_FORMAT_DISPLAY_SPECIFIERS = new HashSet<String>(Arrays.asList("e", "f", "g", "t"));
    public static final String STRING_FORMAT_DISPLAY_SPECIFIER = "s";
    public static final String NET_SIGNAL_STRENGTH_FORMAT_DISPLAY_SPECIFIER = "v";
    public static final String ASSIGNMENT_PATTERN_FORMAT_DISPLAY_SPECIFIER = "p";
    public static final List<String> VLOG_VALID_FORMAT_SPECIFIERS_WITH_ARGUMENTS = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("h");
            this.add("H");
            this.add("x");
            this.add("X");
            this.add("d");
            this.add("D");
            this.add("o");
            this.add("O");
            this.add("b");
            this.add("B");
            this.add("c");
            this.add("C");
            this.add(MethodCallUtils.NET_SIGNAL_STRENGTH_FORMAT_DISPLAY_SPECIFIER);
            this.add("V");
            this.add(MethodCallUtils.ASSIGNMENT_PATTERN_FORMAT_DISPLAY_SPECIFIER);
            this.add("P");
            this.add(MethodCallUtils.STRING_FORMAT_DISPLAY_SPECIFIER);
            this.add("S");
            this.add("t");
            this.add("T");
            this.add("u");
            this.add("U");
            this.add("z");
            this.add("Z");
            this.add("e");
            this.add("E");
            this.add("f");
            this.add("F");
            this.add("g");
            this.add("G");
            this.add("n");
            this.add("N");
        }
    };
    public static final List<String> VLOG_VALID_FORMAT_SPECIFIERS_WITHOUT_ARGUMENTS = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("m");
            this.add("M");
            this.add("l");
            this.add("L");
        }
    };

    public static final IHid getMethodArgumentHid(IHidObject association) {
        return MethodCallUtils.getFormalPartHid(association, HidQualifierCache.IS_ARGUMENT_VALUE_QUALIFIER);
    }

    @NotNull
    public static final String getMethodArgumentName(IHidObject association) {
        return MethodCallUtils.getFormalPartName(association, HidQualifierCache.IS_ARGUMENT_VALUE_QUALIFIER);
    }

    public static final IHidObject getValue(IHidObject association) {
        return MethodCallUtils.getActualPart(association, HidQualifierCache.IS_ARGUMENT_VALUE_QUALIFIER);
    }

    @NotNull
    public static final Set<IHid> getValueHids(IHidObject association, Set<HidFlatteningOption> options) {
        return MethodCallUtils.getActualPartHids(association, HidQualifierCache.IS_ARGUMENT_VALUE_QUALIFIER, options);
    }

    public static final int getOffset(IHidObject association) {
        return MethodCallUtils.getOffset(association, HidQualifierCache.IS_ARGUMENT_VALUE_QUALIFIER);
    }

    public static final int getVirtualOffset(IHidObject association) {
        return MethodCallUtils.getVirtualOffset(association, HidQualifierCache.IS_ARGUMENT_VALUE_QUALIFIER);
    }

    public static final int getLine(IHidObject association) {
        return MethodCallUtils.getLine(association, HidQualifierCache.IS_ARGUMENT_VALUE_QUALIFIER);
    }

    public static final int getClosedBoundary(IHidObject association) {
        return MethodCallUtils.getClosedBoundary(association, HidQualifierCache.IS_ARGUMENT_VALUE_QUALIFIER);
    }

    public static final int getOpenBoundary(IHidObject association) {
        return MethodCallUtils.getOpenBoundary(association, HidQualifierCache.IS_ARGUMENT_VALUE_QUALIFIER);
    }

    public static final String toStringBuilder(HidOperator connection, boolean showCompletePath, boolean showCompleteOperator, boolean addOperatorParentheses, boolean translateAssociations, boolean showMethodCallArguments, boolean showInvisibleAccess, LanguageKind languageKind) {
        return MethodCallUtils.toStringBuilder(connection, HidQualifierCache.IS_ARGUMENT_VALUE_QUALIFIER, showCompletePath, showCompleteOperator, addOperatorParentheses, translateAssociations, showMethodCallArguments, showInvisibleAccess, languageKind);
    }

    public static final List<MethodCall> getMethodCalls(IHid hid) {
        if (!HidUtils.isHid(hid)) {
            return Collections.emptyList();
        }
        Hid methodCallHid = (Hid)hid;
        HidOccurrence occurrence = methodCallHid.getOccurrence();
        LinkedHashSet<HidOccurrence> occurences = new LinkedHashSet<HidOccurrence>(Collections.singletonList(occurrence));
        ArrayList<MethodCall> calls = new ArrayList<MethodCall>(occurences.size());
        Map<IRfNamedElement, List<? extends IRfFieldElement>> methodWithArguments = MethodCallUtils.getMethodsWithFormalArguments(methodCallHid);
        if (methodWithArguments == null || methodWithArguments.isEmpty()) {
            return Collections.emptyList();
        }
        IRfNamedElement method = methodWithArguments.keySet().iterator().next();
        List<? extends IRfFieldElement> methodArguments = methodWithArguments.values().iterator().next();
        if (methodCallHid.hasAccesses()) {
            ListContainer<HidAccess> accesses = methodCallHid.getAccesses();
            List callAccesses = OptimizedUtils.asList(accesses, false).stream().filter(acc -> acc instanceof IHidAccessArgs && !((IHidAccessArgs)((Object)acc)).getArgumentValues().isEmpty()).collect(Collectors.toList());
            for (HidAccess callAccess : callAccesses) {
                HidOccurrence callOccurrence = callAccess.getOccurrence();
                occurences.remove(callOccurrence);
                MethodCall call = MethodCallUtils.getMethodCall(methodCallHid, method, methodArguments, ((IHidAccessArgs)((Object)callAccess)).getArgumentValues(), true, callOccurrence);
                if (call == null) continue;
                calls.add(call);
            }
        }
        for (HidOccurrence occ : occurences) {
            calls.add(MethodCallUtils.getMethodCall(methodCallHid, method, methodArguments, null, false, occ));
        }
        return calls;
    }

    public static final Map<IRfNamedElement, List<? extends IRfFieldElement>> getMethodsWithFormalArguments(IHid methodHid) {
        return HidUtils.isHid(methodHid) ? ((Hid)methodHid).getMethodsWithArguments() : null;
    }

    /*
     * WARNING - void declaration
     */
    public static final MethodCall getMethodCall(IHidObject methodCallHid, IRfNamedElement methodElement, List<? extends IRfFieldElement> methodArguments, List<? extends IHidObject> argumentValues, boolean createDummyPorts, HidOccurrence occurrence) {
        IRfFieldElement methodArgumentElement;
        String methodArgumentName;
        if (methodCallHid == null) {
            return null;
        }
        if (argumentValues == null || argumentValues.isEmpty()) {
            return new MethodCall(methodCallHid, methodElement, null, null, occurrence);
        }
        if (methodArguments == null || methodArguments.size() < argumentValues.size()) {
            boolean isRandomizeFunction;
            boolean isSystemTaskOrFunction = methodCallHid instanceof IHid && ((IHid)methodCallHid).getName().startsWith("$");
            boolean bl = isRandomizeFunction = methodCallHid instanceof IHid && "randomize".equals(((IHid)methodCallHid).getName());
            if (methodElement == null || isSystemTaskOrFunction || isRandomizeFunction || createDummyPorts) {
                int n;
                ArrayList<? extends IRfFieldElement> tmpArguments = new ArrayList<IRfFieldElement>(argumentValues.size());
                IRfFieldElement lastArgument = null;
                boolean bl2 = false;
                if (methodArguments == null || methodArguments.isEmpty()) {
                    lastArgument = new DummyPort("dummy_arg", isRandomizeFunction ? DummyPort.DummyPortDirection.OUTPUT : DummyPort.DummyPortDirection.INPUT);
                } else {
                    tmpArguments.addAll(methodArguments);
                    lastArgument = methodArguments.get(methodArguments.size() - 1);
                    n = methodArguments.size();
                }
                void i = n;
                while (i < argumentValues.size()) {
                    methodArgumentName = String.valueOf(lastArgument.getName()) + "_" + (int)i;
                    methodArgumentElement = lastArgument.clone(methodArgumentName);
                    tmpArguments.add(methodArgumentElement);
                    ++i;
                }
                methodArguments = tmpArguments;
            } else {
                return new MethodCall(methodCallHid, methodElement, null, null, occurrence);
            }
        }
        int argumentsSize = argumentValues.size();
        LinkedHashMap<IRfFieldElement, Set<IHid>> result = new LinkedHashMap<IRfFieldElement, Set<IHid>>(argumentsSize);
        LinkedHashMap<IRfFieldElement, IHidObject> resultRaw = new LinkedHashMap<IRfFieldElement, IHidObject>(argumentValues.size());
        int index = -1;
        for (IHidObject iHidObject : argumentValues) {
            void var14_19;
            Set set;
            ++index;
            if (MethodCallUtils.isOrderedConnected(iHidObject) || MethodCallUtils.isOrderedUnconnected(iHidObject)) {
                if (index >= methodArguments.size()) continue;
                IRfFieldElement methodArgument = methodArguments.get(index);
                result.put(methodArgument, MethodCallUtils.getValueHids(iHidObject, HidFlatteningOption.NONE_EXCLUDED));
                resultRaw.put(methodArgument, MethodCallUtils.getValue(iHidObject));
                continue;
            }
            methodArgumentName = MethodCallUtils.getMethodArgumentName(iHidObject);
            if (methodArgumentName.isEmpty()) continue;
            methodArgumentElement = null;
            for (IRfFieldElement iRfFieldElement : methodArguments) {
                if (!methodArgumentName.equals(iRfFieldElement.getName())) continue;
                methodArgumentElement = iRfFieldElement;
                break;
            }
            if (methodArgumentElement == null) {
                methodArgumentElement = new DummyPort(methodArgumentName, DummyPort.DummyPortDirection.INPUT);
            }
            if ((set = (Set)result.get(methodArgumentElement)) == null) {
                LinkedHashSet linkedHashSet = new LinkedHashSet(2);
                result.put(methodArgumentElement, linkedHashSet);
            }
            if (MethodCallUtils.isNamedUnconnected(iHidObject)) {
                var14_19.clear();
                continue;
            }
            Set<IHid> actualPartHids = MethodCallUtils.getValueHids(iHidObject, HidFlatteningOption.NONE_EXCLUDED);
            var14_19.addAll(actualPartHids);
            resultRaw.put(methodArgumentElement, MethodCallUtils.getValue(iHidObject));
        }
        return new MethodCall(methodCallHid, methodElement, result, resultRaw, occurrence);
    }

    public static final boolean isValidMethodArgument(IRfNamedElement element) {
        if (!(element instanceof IRfFieldElement)) {
            return false;
        }
        return ((IRfFieldElement)element).getFieldKind() == 2 || ((IRfFieldElement)element).getInterfaceKind() == 8;
    }

    public static final void consumeMethodCallArguments(Hid methodHid, BiConsumer<IRfNamedElement, Collection<IHid>> consumer, boolean ignoreEventControlExpr) {
        if (methodHid == null) {
            return;
        }
        if (!methodHid.hasAccesses()) {
            return;
        }
        ListContainer<HidAccess> accesses = methodHid.getAccesses();
        for (HidAccess access : accesses) {
            MethodCall methodCall;
            if (!(access instanceof IHidAccessArgs)) continue;
            Hid parentHid = access.getParentHid();
            if (ignoreEventControlExpr && parentHid != null && parentHid.hasQualifier(HidQualifierCache.EVENT_CONTROL_EXPR_QUALIFIER) || (methodCall = ((IHidAccessArgs)((Object)access)).getMethodCall()) == null || methodCall.argumentValuesMap == null) continue;
            for (Map.Entry<IRfFieldElement, Set<IHid>> entry : methodCall.argumentValuesMap.entrySet()) {
                consumer.accept(entry.getKey(), (Collection<IHid>)entry.getValue());
            }
        }
    }

    public static final boolean isOrderedUnconnected(IHidObject association) {
        return MethodCallUtils.isOrderedUnconnected(association, HidQualifierCache.IS_ARGUMENT_VALUE_QUALIFIER);
    }

    public static final boolean isOrderedConnected(IHidObject association) {
        return MethodCallUtils.isOrderedConnected(association, HidQualifierCache.IS_ARGUMENT_VALUE_QUALIFIER);
    }

    public static final boolean isNamedUnconnected(IHidObject association) {
        return MethodCallUtils.isNamedUnconnected(association, HidQualifierCache.IS_ARGUMENT_VALUE_QUALIFIER);
    }

    public static final boolean isNamedConnected(IHidObject association) {
        return MethodCallUtils.isNamedConnected(association, HidQualifierCache.IS_ARGUMENT_VALUE_QUALIFIER);
    }

    public static boolean isNamed(IHidObject association) {
        return MethodCallUtils.internalHasFormalPart(association, HidQualifierCache.IS_ARGUMENT_VALUE_QUALIFIER);
    }

    public static final boolean isUnconnected(IHidObject association) {
        return MethodCallUtils.isUnconnected(association, HidQualifierCache.IS_ARGUMENT_VALUE_QUALIFIER);
    }

    public static boolean isOrdered(IHidObject association) {
        return MethodCallUtils.isOrdered(association, HidQualifierCache.IS_ARGUMENT_VALUE_QUALIFIER);
    }
}

