/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.design.DRefactoringConnectDiagram;
import ro.amiq.dvt.diagrams.design.DRefactoringDiagram;
import ro.amiq.dvt.diagrams.design.editor.DDesignEditorFactory;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DDiagramEditorInput;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.IBuildDoneListener;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IReportHitsListener;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.semantic.extension2.DummyElement;
import ro.amiq.dvt.model.reflection.util.RfGUISearchUtils;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.RefactoringConnectDiagramDVTNotification;
import ro.amiq.dvt.ui.RefactoringDiagramDVTNotification;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.actions.ProjectSelectionDialog;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTFileStatusContext;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;
import ro.amiq.dvt.ui.refactor.designelement.DVTRefactorDesignElementUtils;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameAcrossDesignHierarchyPreferencesPage;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameDelegate;
import ro.amiq.dvt.ui.refactor.rename.DVTRenamePreferencesPage;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameProcessor;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameRefactorInfo;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameRefactoring;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameWizard;
import ro.amiq.dvt.ui.refactor.rename.NameConflictStatus;
import ro.amiq.dvt.ui.refactor.rename.PreviewDiagramInfo;
import ro.amiq.dvt.ui.refactor.rename.RenameAcrossHierarchyInfo;
import ro.amiq.dvt.ui.refactor.rename.RenameAcrossHierarchyUserSettings;
import ro.amiq.dvt.ui.search.BaseFileMatch;
import ro.amiq.dvt.ui.search.BaseFileSearchQuery;
import ro.amiq.dvt.ui.search.FavoriteSearchQuery;
import ro.amiq.dvt.ui.search.ISearchQueryElement;
import ro.amiq.dvt.ui.search.LeftRightHandSideOfOperatorEnum;
import ro.amiq.dvt.ui.search.SearchHit;
import ro.amiq.dvt.ui.search.favorites.FavoriteQuery;
import ro.amiq.dvt.ui.search.favorites.RfFavoriteUtils;
import ro.amiq.dvt.ui.views.ISearchContributor;
import ro.amiq.dvt.ui.views.inspect.DVTInspectViewUtils;
import ro.amiq.dvt.ui.views.refactoring.RefactoringConnectView;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.benchmark.StopWatch;

public class RfGUIReferencesUtils {
    private static final int TIMEOUT = 40000;
    private static final String DVT_DEBUG_SEARCH = "DVT_DEBUG_SEARCH";
    private static final String DVT_DEBUG_SEARCH_VALUE = System.getenv("DVT_DEBUG_SEARCH");
    public static final boolean DEBUG_SEARCH = DVT_DEBUG_SEARCH_VALUE != null && "true".equalsIgnoreCase(DVT_DEBUG_SEARCH_VALUE);
    public static final String LOG_INSTANCES_PREFIX = "[SEARCH FOR INSTANCES ENGINE BENCHMARK] Time for computing instances of ";
    public static final String INSIDE_MACRO = "Inside Macro";
    public static final GroupCategory INSIDE_MACRO_CALL_MATCH = new GroupCategory("ro.amiq.dvt.ui.refactor.INSIDE_MACRO_MATCH", "Inside Macro", "Inside Macro");
    private static final String GENERATING_PREVIEW_DIAGRAM = "Generating preview diagram...";
    private static final String PREVIEW_DIAGRAM_JOB = "Preview diagram";
    private static final String EMPTY_FAVORITE_QUERY_MESSAGE = "The favorite search doesn't have any elements!";
    private static final List<String> SAVED_SEARCH_NATURES = Arrays.asList("ro.amiq.vlogdt.VlogNature", "ro.amiq.vhdldt.VhdlNature", "ro.amiq.edt.enature", "ro.amiq.slndt.slnnature", "ro.amiq.msdldt.msdlnature", "ro.amiq.pssdt.pssnature");
    public static final Set<Class<? extends IRfScopeElement>> CLOSEST_TYPE_CONTAINER_FOR_REFERENCES = new HashSet<Class<? extends IRfScopeElement>>();
    private static final String MM_FAVORITE_SEARCHES_TAG = "favorite-searches";
    private static final String MM_SEARCH_TAG = "search";
    private static final String MM_NAME_ATTR = "name";
    private static final String MM_LANGUAGE_ATTR = "language";
    private static final String MM_REPORT_UNRESOLVED_ATTR = "report-unresolved";
    private static final String MM_ELEMENT_TAG = "element";
    private static final String MM_ELEMENT_PATH_ATTR = "element-path";

    public static void flushMatches(Set<BaseFileMatch> cachedMatches, AbstractTextSearchResult result) {
        if (cachedMatches != null && !cachedMatches.isEmpty()) {
            result.addMatches(cachedMatches.toArray(new Match[cachedMatches.size()]));
            cachedMatches.clear();
        }
    }

    public static void logComputeInstancesTime(IRfNamedElement namedElement, long startTime) {
        long stopTime = System.currentTimeMillis();
        if (namedElement == null) {
            return;
        }
        DVTLogger.INSTANCE.logInfo(LOG_INSTANCES_PREFIX + namedElement.getKindName() + " " + namedElement.getFullNameLabel() + " = " + StopWatch.formatTime(stopTime - startTime));
    }

    public static boolean isContainedInAnotherIdentifierFromLineContent(IRfNamedElement element, String lineContents, int startSearchOffset, int endSearchOffset, int localOffset) {
        int offsetDiff;
        int n = offsetDiff = element.isEscaped() ? 1 : 0;
        if (localOffset - 1 >= startSearchOffset && localOffset + element.getName().length() + offsetDiff < endSearchOffset) {
            return Character.isJavaIdentifierPart(lineContents.charAt(localOffset - 1)) || Character.isJavaIdentifierPart(lineContents.charAt(localOffset + element.getName().length() + offsetDiff));
        }
        if (localOffset - 1 < startSearchOffset && localOffset + element.getName().length() + offsetDiff < endSearchOffset) {
            return Character.isJavaIdentifierPart(lineContents.charAt(localOffset + element.getName().length() + offsetDiff));
        }
        if (localOffset + element.getName().length() + offsetDiff >= endSearchOffset && localOffset - 1 >= startSearchOffset) {
            return Character.isJavaIdentifierPart(lineContents.charAt(localOffset - 1));
        }
        return false;
    }

    public static void logDebug(String debugMessage) {
        if (!DEBUG_SEARCH) {
            return;
        }
        DVTLogger.INSTANCE.logInfo(debugMessage);
    }

    public static void handleHitInsideMacroCall(DVTTextFileChange textFileChange, InsertEdit insertEdit, String matchString) {
        textFileChange.addEdit((TextEdit)insertEdit);
        GroupCategorySet gcs = new GroupCategorySet(INSIDE_MACRO_CALL_MATCH);
        TextEditChangeGroup textEditChangeGroup = new TextEditChangeGroup((TextChange)textFileChange, (TextEditGroup)new CategorizedTextEditGroup(matchString, (TextEdit)insertEdit, gcs));
        textFileChange.addTextEditChangeGroup(textEditChangeGroup);
    }

    public static IDocument getDocument(IFile file) throws CoreException {
        ITextFileBufferManager iTextFileBufferManager = FileBuffers.getTextFileBufferManager();
        ITextFileBuffer iTextFileBuffer = null;
        iTextFileBufferManager.connect(file.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
        iTextFileBuffer = iTextFileBufferManager.getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
        IDocument doc = iTextFileBuffer.getDocument();
        return doc;
    }

    public static void closeRenameAcrossWizardAndShowPreviewDiagram(DVTRenameAcrossDesignHierarchyPreferencesPage page) {
        final DVTRenameRefactorInfo refactorInfo = page.getRefactorInfo();
        RfGUIReferencesUtils.closeRenameWizard(page);
        final RenameAcrossHierarchyInfo renameADHInfo = refactorInfo.getRenameADHInfo();
        if (renameADHInfo == null) {
            return;
        }
        renameADHInfo.clearConflictingAndDiagramInfo();
        final IProject project = refactorInfo.getProject();
        Job job = new Job(PREVIEW_DIAGRAM_JOB){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(RfGUIReferencesUtils.GENERATING_PREVIEW_DIAGRAM, -1);
                IRfNamedElement element = refactorInfo.getElement();
                final HashSet allMatches = new HashSet();
                IReportHitsListener<SearchHit> renameAcrossHierarchyHitsListener = new IReportHitsListener<SearchHit>(){

                    @Override
                    public void addMatch(SearchHit match) {
                    }

                    @Override
                    public Set<SearchHit> getMatches() {
                        return allMatches;
                    }
                };
                RfSearchUtils.searchAcrossDesignHierarchy(element, renameADHInfo, renameAcrossHierarchyHitsListener, project, monitor, true, true, true);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PreviewDiagramInfo diagramPreview = renameADHInfo.getDiagramPreview();
                        if (diagramPreview == null) {
                            return;
                        }
                        IEditorPart editor = DDesignEditorFactory.getInstance().newRefactoringDiagram(project, diagramPreview).openNewEditor();
                        if (!(editor instanceof DDiagramEditor)) {
                            return;
                        }
                        ((DDiagramEditor)editor).setPinned(true);
                        IEditorInput ddEditorInput = ((DDiagramEditor)editor).getEditorInput();
                        if (!(ddEditorInput instanceof DDiagramEditorInput)) {
                            return;
                        }
                        DDiagram dDiagram = ((DDiagramEditorInput)ddEditorInput).getDiagram();
                        if (!(dDiagram instanceof DRefactoringDiagram)) {
                            return;
                        }
                        ((DRefactoringDiagram)dDiagram).setUserSettings(new RenameAcrossHierarchyUserSettings(refactorInfo));
                        new RefactoringDiagramDVTNotification((DDiagramEditor)editor, 256, "Rename across hierarchy", diagramPreview).create();
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    public static void closeConnectWizardAndShowPreviewDiagram(RefactoringConnectView view) {
        String[] rootNode = DVTRefactorDesignElementUtils.computeCommonAncestor(view.getSrcPath(), view.getDstPath());
        Display.getDefault().asyncExec(() -> {
            DDiagramEditor diagramEditor = view.getEditor();
            if (diagramEditor != null) {
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                activePage.activate((IWorkbenchPart)diagramEditor);
                return;
            }
            IEditorPart editor = DDesignEditorFactory.getInstance().newRefactoringConnectDiagram(view.getProject(), view.getResult(), view.getInfo(), view.getSrcPath(), view.getDstPath(), view.getSrcPort(), view.getDstPort(), rootNode, true).openNewEditor();
            if (!(editor instanceof DDiagramEditor)) {
                return;
            }
            ((DDiagramEditor)editor).setPinned(false);
            IEditorInput ddEditorInput = ((DDiagramEditor)editor).getEditorInput();
            if (!(ddEditorInput instanceof DDiagramEditorInput)) {
                return;
            }
            DDiagram dDiagram = ((DDiagramEditorInput)ddEditorInput).getDiagram();
            if (!(dDiagram instanceof DRefactoringConnectDiagram)) {
                return;
            }
            view.setEditor((DDiagramEditor)editor);
            new RefactoringConnectDiagramDVTNotification((DDiagramEditor)editor, 256, "Refactoring connect preview", view).create();
        });
    }

    public static void closeRenameWizard(DVTRenamePreferencesPage page) {
        IWizard wizard = page.getWizard();
        if (wizard == null) {
            return;
        }
        IWizardContainer container = wizard.getContainer();
        if (container == null) {
            return;
        }
        Shell shell = container.getShell();
        if (shell == null) {
            return;
        }
        shell.close();
    }

    public static void computeConflictingWarnings(RenameAcrossHierarchyInfo renameADHInfo, RefactoringStatus result, IProject project) {
        if (renameADHInfo == null) {
            return;
        }
        Map<IRfNamedElement, List<IRfFieldElement>> conflictingMessages = renameADHInfo.getConflictingMessages();
        if (conflictingMessages == null || conflictingMessages.isEmpty()) {
            return;
        }
        for (Map.Entry<IRfNamedElement, List<IRfFieldElement>> entry : conflictingMessages.entrySet()) {
            IRfNamedElement namedElement = entry.getKey();
            List<IRfFieldElement> conflictingElements = entry.getValue();
            if (conflictingElements == null || conflictingElements.isEmpty()) continue;
            IRfFieldElement conflictingElement = conflictingElements.get(0);
            String warningMessage = RfSearchUtils.getDuplicateElementsMessage(namedElement, project, conflictingElements);
            DVTFileStatusContext status = RfSearchUtils.getFileStatusContext(project, conflictingElement.getLanguageKind());
            int startOffset = conflictingElement.getDeclaration().getStartOffset();
            IResource fileAdapter = conflictingElement.getFileAdapter();
            if (!(fileAdapter instanceof IFile)) continue;
            IFile file = (IFile)fileAdapter;
            status.addFileRegions(file, (IRegion)new Region(startOffset, conflictingElement.getName().length()));
            result.addWarning(warningMessage, (RefactoringStatusContext)status);
        }
    }

    public static boolean run(FavoriteQuery query, IProject project, Shell shell) {
        if (project == null) {
            IProject[] projects = DVTUtilsCommon.getProjects();
            if (projects == null || projects.length == 0) {
                return false;
            }
            project = ProjectSelectionDialog.selectProject();
        }
        if (project == null || !RfGUIReferencesUtils.synchFiles(project)) {
            return false;
        }
        List searchedElements = query.getSearchedElements();
        if (searchedElements == null || searchedElements.isEmpty()) {
            RfGUIReferencesUtils.errorDialog(EMPTY_FAVORITE_QUERY_MESSAGE, shell);
            return false;
        }
        ArrayList<IRfNamedElement> candidates = new ArrayList<IRfNamedElement>();
        ArrayList<String> unresolvedElements = new ArrayList<String>();
        for (String searchedElement : searchedElements) {
            IRfNamedElement namedElementFromString = RfSearchUtils.getNamedElementFromString(project, searchedElement, query.getLanguageKind());
            if (namedElementFromString == null) {
                if ("force_assignments".equals(searchedElement)) {
                    namedElementFromString = new DummyElement(searchedElement);
                } else if ("report_clauses".equals(searchedElement)) {
                    namedElementFromString = new DummyElement(searchedElement);
                } else {
                    unresolvedElements.add(searchedElement);
                }
            }
            if (namedElementFromString == null) continue;
            candidates.add(namedElementFromString);
        }
        FileTextSearchScope scope = FileTextSearchScope.newSearchScope((IResource[])new IResource[]{project}, (String[])DVTFileUtils.getInstance().getExtensionsForContentType("ro.amiq.vlogdt.VlogSource", true), (boolean)false);
        RfGUIReferencesUtils.computeSearch(query, project, candidates, scope, unresolvedElements);
        return true;
    }

    public static RefactoringStatusContext computeContext(NameConflictStatus<IRfNamedElement> nameConflictStatus) {
        if (!nameConflictStatus.hasConflicts()) {
            return null;
        }
        IRfNamedElement candidate = nameConflictStatus.getCandidates().get(0);
        if (candidate == null || candidate.getName() == null) {
            return null;
        }
        IResource resource = candidate.getFileAdapter();
        if (!(resource instanceof IFile)) {
            return null;
        }
        IRfDefElement declaration = candidate.getDeclaration();
        if (declaration == null) {
            return null;
        }
        DVTFileStatusContext status = RfSearchUtils.getFileStatusContext(resource.getProject(), declaration.getLanguageKind());
        status.addFileRegions((IFile)resource, (IRegion)new Region(declaration.getStartOffset(), candidate.getName().length()));
        return status;
    }

    public static void saveQueries(Map<String, List<FavoriteQuery>> queries, String prefConstName) {
        String result = RfFavoriteUtils.getSerializedPredefinedSearchQueries(queries);
        DVTPlugin.getDefault().getPreferenceStore().setValue(prefConstName, result);
    }

    public static void errorDialog(final String message, final Shell shell) {
        if (TestHelper.isTestMode()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(shell, "Error", null, message, 1, new String[]{"OK"}, 0);
                dialog.open();
            }
        });
    }

    private static void computeSearch(FavoriteQuery favQuery, IProject project, List<IRfNamedElement> candidates, FileTextSearchScope scope, List<String> unresolvedElements) {
        if (candidates.isEmpty()) {
            RfGUIReferencesUtils.notResolvedErrorDialog("None of the elements specified by this favorite search are declared in project '" + project.getName() + "':\n\n" + unresolvedElements.stream().limit(10L).map(s -> "    " + s).collect(Collectors.joining("\n")), Utils.getActiveShell());
            return;
        }
        FavoriteSearchQuery result = new FavoriteSearchQuery(scope, favQuery.getQueryLabel(), project);
        for (IRfNamedElement candidate : candidates) {
            BaseFileSearchQuery query = RfGUISearchUtils.getQuery(project, candidate, RfSearchUtils.transformInverseProjectNature(favQuery.getLanguageKind()));
            if (query == null) continue;
            result.addQuery(query);
        }
        boolean shouldRunQuery = true;
        if (!unresolvedElements.isEmpty() && favQuery.isReportUnresolved()) {
            String message = "Some elements of the favorite search are undeclared in project '" + project.getName() + "':\n\n" + unresolvedElements.stream().limit(10L).map(s -> "    " + s).collect(Collectors.joining("\n")) + "\n\n" + "Do you want to proceed?";
            shouldRunQuery = RfGUIReferencesUtils.notResolvedConfirmationDialog(message, Utils.getActiveShell());
        }
        if (!shouldRunQuery) {
            return;
        }
        if (TestHelper.isTestMode()) {
            TestHelper.testRunQuery(result);
        }
        NewSearchUI.runQueryInBackground((ISearchQuery)result);
    }

    public static boolean continueRenameAcrossHierarchyOperation(String signalNotConnectedString, String dialogWarningMessage, String elementType) {
        MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), signalNotConnectedString, null, MessageFormat.format(dialogWarningMessage, elementType), 5, new String[]{"Yes", "No"}, 0);
        int open = dialog.open();
        return open == 0;
    }

    public static void popUpUnsupportedOperation(final String dialogErrorMessage) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Operation Not Supported", null, dialogErrorMessage, 1, new String[]{"OK"}, 0);
                dialog.open();
            }
        });
    }

    private static boolean notResolvedConfirmationDialog(String message, Shell shell) {
        if (TestHelper.isTestMode()) {
            return true;
        }
        int opened = -1;
        MessageDialog dialog = new MessageDialog(shell, "Search elements not resolved", null, message, 5, new String[]{"Yes", "No"}, 0);
        opened = dialog.open();
        return opened == 0;
    }

    public static List<IFile> getUnsynchedFiles(final IProject project) {
        if (!DVTUiUtils.isUiThread()) {
            return RfGUIReferencesUtils.getUnsynchedFiles(project, null);
        }
        final ArrayList<IFile> result = new ArrayList<IFile>();
        Shell activeShell = DVTUiUtils.getActiveWorkbenchShell();
        if (activeShell == null) {
            return result;
        }
        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(activeShell);
        try {
            progressDialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    result.addAll(RfGUIReferencesUtils.getUnsynchedFiles(project, monitor));
                }
            });
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    private static List<IFile> getUnsynchedFiles(IProject project, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ArrayList<IFile> result = new ArrayList<IFile>();
        monitor.beginTask("Checking for source files changed outside DVT...", -1);
        List<IResource> compiledFiles = RfGUIReferencesUtils.getCompiledFiles(project);
        if (compiledFiles == null || compiledFiles.isEmpty()) {
            return result;
        }
        for (IResource file : compiledFiles) {
            if (monitor.isCanceled()) {
                return result;
            }
            if (file == null || file.isSynchronized(0)) continue;
            result.add((IFile)file);
        }
        return result;
    }

    public static List<IResource> getCompiledFiles(IProject project) {
        ArrayList<IResource> result = new ArrayList<IResource>();
        RfMixedLangProject mixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false);
        if (mixedLangProject == null) {
            return result;
        }
        List<ISearchContributor> contributors = RfSearchUtils.getEnabledContributors(project);
        for (ISearchContributor contributor : contributors) {
            Set<IResource> compiledFilesSet;
            IRfSingleLangProject singleLangProject = mixedLangProject.getSingleLangProject(contributor.getNature());
            if (singleLangProject == null || (compiledFilesSet = singleLangProject.getCompiledFileResourcesSet()) == null || compiledFilesSet.isEmpty()) continue;
            result.addAll(new HashSet<IResource>(compiledFilesSet));
        }
        return result;
    }

    private static void notResolvedErrorDialog(String message, Shell shell) {
        if (TestHelper.isTestMode()) {
            return;
        }
        new MessageDialog(shell, "Search elements not resolved", null, message, 1, new String[]{"OK"}, 0).open();
    }

    public static List<FavoriteQuery> getQueries(IProject finalProject) {
        try {
            Map<String, List<FavoriteQuery>> fSearchQueries = RfGUIReferencesUtils.getSearchQueries("favorite.searches");
            ArrayList<FavoriteQuery> queries = new ArrayList<FavoriteQuery>();
            for (String nature : SAVED_SEARCH_NATURES) {
                List<FavoriteQuery> natureQueries;
                if (finalProject != null && finalProject.getNature(nature) == null || (natureQueries = fSearchQueries.get(RfSearchUtils.transformProjectNature(nature))) == null) continue;
                queries.addAll(natureQueries);
            }
            Collections.sort(queries);
            return queries;
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public static Map<String, List<FavoriteQuery>> getQueriesDependingOfProject(IProject finalProject, Map<String, List<FavoriteQuery>> searchQueries) {
        try {
            HashMap<String, List<FavoriteQuery>> queries = new HashMap<String, List<FavoriteQuery>>();
            if (finalProject.getNature("ro.amiq.vlogdt.VlogNature") != null) {
                queries.put(RfSearchUtils.transformProjectNature("ro.amiq.vlogdt.VlogNature"), searchQueries.get(RfSearchUtils.transformProjectNature("ro.amiq.vlogdt.VlogNature")));
            }
            if (finalProject.getNature("ro.amiq.vhdldt.VhdlNature") != null) {
                queries.put(RfSearchUtils.transformProjectNature("ro.amiq.vhdldt.VhdlNature"), searchQueries.get(RfSearchUtils.transformProjectNature("ro.amiq.vlogdt.VlogNature")));
            }
            if (finalProject.getNature("ro.amiq.edt.enature") != null) {
                queries.put(RfSearchUtils.transformProjectNature("ro.amiq.edt.enature"), searchQueries.get(RfSearchUtils.transformProjectNature("ro.amiq.edt.enature")));
            }
            if (finalProject.getNature("ro.amiq.slndt.slnnature") != null) {
                queries.put(RfSearchUtils.transformProjectNature("ro.amiq.slndt.slnnature"), searchQueries.get(RfSearchUtils.transformProjectNature("ro.amiq.slndt.slnnature")));
            }
            if (finalProject.getNature("ro.amiq.msdldt.msdlnature") != null) {
                queries.put(RfSearchUtils.transformProjectNature("ro.amiq.msdldt.msdlnature"), searchQueries.get(RfSearchUtils.transformProjectNature("ro.amiq.msdldt.msdlnature")));
            }
            return queries;
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public static IProject getCurrentProject() {
        IProject[] projects;
        IWorkbenchWindow activeWorkbenchWindow = Utils.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return null;
        }
        IEditorPart activeEditor = activePage.getActiveEditor();
        if (activeEditor instanceof DVTEditor) {
            return ((DVTEditor)activeEditor).getProject();
        }
        IProject project = DVTPlugin.getSelectionManager().getLastSelectedProject();
        if (!(project != null && project.isAccessible() && ro.amiq.dvt.utils.Utils.hasDvtNature(project) && !TestHelper.isTestMode() || (projects = DVTUtilsCommon.getProjects()).length != 0)) {
            return null;
        }
        return project;
    }

    public static List<IRfNamedElement> getDesignInstances(DVTEditor editor, IRfScopeElement scope, IRfNamedElement namedElement) {
        ElementPath elementPath = DesignPathManager.getInstance().getPathFor(editor, editor.getCursor(), namedElement, scope, false, false);
        if (elementPath == null) {
            return Collections.emptyList();
        }
        IProject project = editor.getProject();
        if (project == null) {
            return Collections.emptyList();
        }
        return DesignPathManager.getInstance().getDesignSegmentsFromElementPath(project, elementPath);
    }

    public static DDiagramEditor getActiveRADHEditor() {
        List<IEditorReference> editorReferences = Utils.getCurrentlyOpenEditorReferences();
        for (IEditorReference editorReference : editorReferences) {
            DDiagram dDiagram;
            DDiagramEditorInput editorInput;
            IEditorPart editor = editorReference.getEditor(false);
            if (!(editor instanceof DDiagramEditor) || (editorInput = ((DDiagramEditor)editor).getInput()) == null || !((dDiagram = editorInput.getDiagram()) instanceof DRefactoringDiagram)) continue;
            return (DDiagramEditor)editor;
        }
        return null;
    }

    public static boolean checkAndCancelActiveRADHSession() {
        DDiagramEditor editor = RfGUIReferencesUtils.getActiveRADHEditor();
        if (editor == null) {
            return true;
        }
        final IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return true;
        }
        final int[] result = new int[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(activeWorkbenchWindow.getShell(), "Operation Not Allowed", null, "A 'Rename across Design Hierarchy' diagram preview is already in progress.", 5, new String[]{"Cancel and reveal diagram", "Abort and start a new one"}, 0);
                result[0] = dialog.open();
            }
        });
        if (result[0] == 0) {
            IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
            if (activePage != null) {
                activePage.bringToTop((IWorkbenchPart)editor);
            }
            return false;
        }
        editor.close();
        return true;
    }

    public static RenameAcrossHierarchyUserSettings getActiveRADHUserSettingsFromEditor(DDiagramEditor editor) {
        if (editor == null) {
            return null;
        }
        DDiagramEditorInput editorInput = editor.getInput();
        if (editorInput == null) {
            return null;
        }
        DDiagram dDiagram = editorInput.getDiagram();
        if (!(dDiagram instanceof DRefactoringDiagram)) {
            return null;
        }
        return ((DRefactoringDiagram)dDiagram).getUserSettings();
    }

    public static void switchBackToRenameAcrossHierarchyWizard(RenameAcrossHierarchyUserSettings userSettings) {
        if (userSettings == null) {
            DVTLogger.INSTANCE.logError("Rename across Design Hierarchy: Null user settings when switching back to wizard!");
            return;
        }
        DVTRenameRefactorInfo refactorInfo = userSettings.getRenameInfo();
        if (refactorInfo == null) {
            DVTLogger.INSTANCE.logError("Rename across Design Hierarchy: Null refactor info when switching back to wizard!");
            return;
        }
        refactorInfo.resetMatches();
        if (!refactorInfo.validate()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Source code changed", null, "Unable to resume 'Rename across Design Hierarchy' (elements affected by the refactoring operation have changed).", 1, new String[]{"OK"}, 0);
                    dialog.open();
                }
            });
            return;
        }
        DVTRenameDelegate delegate = RfSearchUtils.getRenameAcrossHierarchyDelegate(refactorInfo);
        DVTRenameProcessor processor = new DVTRenameProcessor(delegate);
        DVTRenameRefactoring refactoring = new DVTRenameRefactoring(processor);
        RenameAcrossHierarchyInfo renameADHInfo = refactorInfo.getRenameADHInfo();
        if (renameADHInfo == null) {
            return;
        }
        int renameDepth = renameADHInfo.getRenameDepth();
        DVTRenameAcrossDesignHierarchyPreferencesPage preferencesPage = new DVTRenameAcrossDesignHierarchyPreferencesPage("Rename Refactoring Across Design Hierarchy Preferences Page", refactorInfo, renameDepth == 0 ? "" : Integer.toString(renameDepth));
        DVTRenameWizard wizard = new DVTRenameWizard((Refactoring)refactoring, preferencesPage);
        wizard.setWindowTitle("Rename Port Across the Design Hierarchy");
        RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
        try {
            op.run(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "");
        }
        catch (InterruptedException interruptedException) {}
    }

    public static List<IRfNamedElement> testGetDesignInstances(DVTEditor editor, DVTRenameRefactorInfo info) {
        if (editor == null || info == null) {
            return null;
        }
        IProject project = info.getProject();
        if (project == null) {
            return null;
        }
        ELManager manager = RfMixedLangManager.getInstance().getELManager(project);
        if (manager == null) {
            return null;
        }
        return RfGUIReferencesUtils.getDesignInstances(editor, info.getScope(), info.getElement());
    }

    public static void checkAmbiguousMatch(Collection<Set<IRfNamedElement>> ambiguousElements, BaseFileMatch baseFileMatch) {
        IRfNamedElement namedElement = baseFileMatch.getLineElement().getNamedElement();
        if (namedElement == null) {
            return;
        }
        for (Set<IRfNamedElement> ambiguousElement : ambiguousElements) {
            if (ambiguousElement == null || ambiguousElement.isEmpty() || !ambiguousElement.contains(namedElement)) continue;
            baseFileMatch.setIsRenamed(false);
        }
    }

    public static void computeAmbiguityWarnings(RenameAcrossHierarchyInfo renameAcrossHierarchyWrapper, RefactoringStatus result, IProject project) {
        if (renameAcrossHierarchyWrapper == null) {
            return;
        }
        Map<IRfScopeElement, Set<IRfNamedElement>> ambiguityCases = renameAcrossHierarchyWrapper.getAmbiguityCases();
        for (Map.Entry<IRfScopeElement, Set<IRfNamedElement>> entry : ambiguityCases.entrySet()) {
            Set<IRfNamedElement> ambiguityElementsPerScope;
            IRfScopeElement scopeElement = entry.getKey();
            if (!(scopeElement instanceof IRfNamedElement) || (ambiguityElementsPerScope = entry.getValue()) == null || ambiguityElementsPerScope.isEmpty()) continue;
            IRfNamedElement scopeNamedElement = (IRfNamedElement)scopeElement;
            String warningMessage = RfSearchUtils.getRenameAcrossHierarchyAmbiguityMessage(project, scopeNamedElement, ambiguityElementsPerScope);
            DVTFileStatusContext status = RfSearchUtils.getFileStatusContext(project, scopeNamedElement.getLanguageKind());
            int startOffset = scopeNamedElement.getDeclaration().getStartOffset();
            IResource fileAdapter = scopeNamedElement.getFileAdapter();
            if (!(fileAdapter instanceof IFile)) continue;
            IFile file = (IFile)fileAdapter;
            status.addFileRegions(file, (IRegion)new Region(startOffset, scopeElement.getName().length()));
            result.addWarning(warningMessage, (RefactoringStatusContext)status);
        }
    }

    public static boolean isSideEffectMatch(RenameAcrossHierarchyInfo renameWrapper, BaseFileMatch fileMatch) {
        if (renameWrapper == null) {
            return false;
        }
        if (!renameWrapper.renameInParentInstaces()) {
            return false;
        }
        IRfDefElement scopeDef = fileMatch.getScopeDef();
        if (scopeDef == null) {
            return false;
        }
        IRfNamedElement scopeElement = scopeDef.getNamedElement();
        if (!(scopeElement instanceof IRfInstanceElement)) {
            return false;
        }
        List<IRfNamedElement> designInstances = renameWrapper.getDesignInstances();
        return fileMatch.getLeftRightHandSideOfConnection() == LeftRightHandSideOfOperatorEnum.LEFT_HAND_MATCH && !designInstances.isEmpty() && !designInstances.contains(scopeElement);
    }

    public static String getSerializedPredefinedSearchQueries(Map<String, List<FavoriteQuery>> queries) {
        if (queries == null) {
            return "";
        }
        XMLMemento memento = XMLMemento.createWriteRoot((String)MM_FAVORITE_SEARCHES_TAG);
        for (List<FavoriteQuery> queriesPerLanguage : queries.values()) {
            if (queriesPerLanguage == null || queries.isEmpty()) continue;
            for (FavoriteQuery predefinedQuery : queriesPerLanguage) {
                IMemento searchMemento = memento.createChild(MM_SEARCH_TAG);
                searchMemento.putString(MM_LANGUAGE_ATTR, predefinedQuery.getLanguageKind());
                searchMemento.putString(MM_NAME_ATTR, predefinedQuery.getQueryLabel());
                searchMemento.putBoolean(MM_REPORT_UNRESOLVED_ATTR, predefinedQuery.isReportUnresolved());
                List searchedElements = predefinedQuery.getSearchedElements();
                if (searchedElements == null || searchedElements.isEmpty()) continue;
                for (String searchedElement : searchedElements) {
                    IMemento elementMemento = searchMemento.createChild(MM_ELEMENT_TAG);
                    elementMemento.putString(MM_ELEMENT_PATH_ATTR, searchedElement);
                }
            }
        }
        StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
        }
        catch (IOException iOException) {}
        return writer.toString();
    }

    public static Map<String, List<FavoriteQuery>> getSearchQueries(String prefConstName) {
        String serializedPredefinedSearchesSets = DVTPlugin.getDefault().getPreferenceStore().getString(prefConstName);
        if (serializedPredefinedSearchesSets == null || serializedPredefinedSearchesSets.isEmpty()) {
            return Collections.emptyMap();
        }
        return RfGUIReferencesUtils.getFavoriteQueries(serializedPredefinedSearchesSets);
    }

    public static Map<String, List<FavoriteQuery>> getFavoriteQueries(String serializedPredefinedSearchesSets) {
        LinkedHashMap<String, List<FavoriteQuery>> result = new LinkedHashMap<String, List<FavoriteQuery>>();
        if (serializedPredefinedSearchesSets == null || serializedPredefinedSearchesSets.isEmpty()) {
            return result;
        }
        StringReader reader = new StringReader(serializedPredefinedSearchesSets);
        try {
            XMLMemento favoriteSearchesMemento = XMLMemento.createReadRoot((Reader)reader);
            if (favoriteSearchesMemento == null) {
                return result;
            }
            IMemento[] searchMementos = favoriteSearchesMemento.getChildren(MM_SEARCH_TAG);
            if (searchMementos == null || searchMementos.length == 0) {
                return result;
            }
            IMemento[] iMementoArray = searchMementos;
            int n = searchMementos.length;
            int n2 = 0;
            while (n2 < n) {
                Boolean reportUnresolved;
                String label;
                IMemento searchMemento = iMementoArray[n2];
                String language = searchMemento.getString(MM_LANGUAGE_ATTR);
                if (language != null && (label = searchMemento.getString(MM_NAME_ATTR)) != null && (reportUnresolved = searchMemento.getBoolean(MM_REPORT_UNRESOLVED_ATTR)) != null) {
                    ArrayList<FavoriteQuery> queriesPerLanguage = (ArrayList<FavoriteQuery>)result.get(language);
                    if (queriesPerLanguage == null) {
                        queriesPerLanguage = new ArrayList<FavoriteQuery>();
                        result.put(language, queriesPerLanguage);
                    }
                    FavoriteQuery query = new FavoriteQuery(language, label, reportUnresolved.booleanValue());
                    queriesPerLanguage.add(query);
                    IMemento[] elementMementos = searchMemento.getChildren(MM_ELEMENT_TAG);
                    if (elementMementos != null && elementMementos.length != 0) {
                        ArrayList<String> searchedElements = new ArrayList<String>();
                        IMemento[] iMementoArray2 = elementMementos;
                        int n3 = elementMementos.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IMemento elementMemento = iMementoArray2[n4];
                            String elementPath = elementMemento.getString(MM_ELEMENT_PATH_ATTR);
                            searchedElements.add(elementPath);
                            ++n4;
                        }
                        query.setSearchedElements(searchedElements);
                    }
                }
                ++n2;
            }
        }
        catch (WorkbenchException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    public static boolean synchFiles(IProject project) {
        return RfGUIReferencesUtils.synchFilesAndValidateElement(project, null, null);
    }

    public static void refreshProjectFiles(IProject project) {
        List<IFile> compiledFiles = RfGUIReferencesUtils.getUnsynchedFiles(project);
        if (compiledFiles == null || compiledFiles.isEmpty()) {
            return;
        }
        RfGUIReferencesUtils.refreshProjectFiles(project, compiledFiles);
    }

    public static boolean synchFilesAndValidateElement(final IProject project, IRfNamedElement startingElement, String fullElementName) {
        List<IFile> compiledFiles = RfGUIReferencesUtils.getUnsynchedFiles(project);
        if (compiledFiles == null || compiledFiles.isEmpty()) {
            return true;
        }
        Collections.sort(compiledFiles, new Comparator<IFile>(){

            @Override
            public int compare(IFile o1, IFile o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        Stream stream = compiledFiles.stream();
        final String message = "The following source files have changed outside DVT:\n\n" + stream.limit(10L).map(s -> "    " + s.getFullPath()).collect(Collectors.joining("\n")) + "\n\n" + "To run the search, DVT needs to refresh the files and analyze changes.";
        final int[] action = new int[]{-1};
        Utils.getActiveShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (TestHelper.isTestMode()) {
                    action[0] = 0;
                    return;
                }
                MessageDialog dialog = new MessageDialog(Utils.getActiveShell(), "Project " + project.getName() + " is out of sync", null, message, 5, new String[]{"OK", "Cancel"}, 0);
                action[0] = dialog.open();
            }
        });
        if (action[0] != 0) {
            return false;
        }
        RfGUIReferencesUtils.refreshProjectFiles(project, compiledFiles);
        if (startingElement == null || startingElement instanceof ISearchQueryElement || startingElement.isPredefined() || fullElementName == null) {
            return true;
        }
        String kindName = startingElement.getKindName();
        IRfNamedElement namedElement = RfElementPath.path(startingElement).toNamedElement(project);
        if (namedElement == null) {
            RfGUIReferencesUtils.errorDialog("The " + kindName + " '" + fullElementName + "' does not exist anymore.", Utils.getActiveShell());
        }
        return namedElement != null;
    }

    private static void refreshProjectFiles(final IProject project, final List<IFile> compiledFiles) {
        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        try {
            progressDialog.run(true, true, new IRunnableWithProgress(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    final AtomicBoolean buildDone = new AtomicBoolean(false);
                    IBuildDoneListener listener = new IBuildDoneListener(){

                        @Override
                        public void buildDone(IBuildDoneListener.BuildFinishReason buildFinishReason, String projectName) {
                            buildDone.set(true);
                        }
                    };
                    DVTMixedLangModelManager.getInstance().addBuildDoneListener(listener);
                    monitor.beginTask("Refreshing the files...", -1);
                    try {
                        boolean needRefresh = false;
                        for (IFile file : compiledFiles) {
                            if (file.isSynchronized(0)) continue;
                            file.refreshLocal(0, monitor);
                            needRefresh = true;
                        }
                        if (!needRefresh) {
                            return;
                        }
                        if (!ResourcesPlugin.getWorkspace().isAutoBuilding()) {
                            project.build(9, monitor);
                            return;
                        }
                        long timeout = System.currentTimeMillis() + 40000L;
                        while (!monitor.isCanceled()) {
                            if (buildDone.get()) return;
                            if (System.currentTimeMillis() >= timeout) {
                                return;
                            }
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        return;
                    }
                    catch (CoreException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        return;
                    }
                    finally {
                        DVTMixedLangModelManager.getInstance().removeBuildDoneListener(listener);
                    }
                }
            });
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static IProject getSelectedProject() {
        IProject project = DVTPlugin.getSelectionManager().getLastSelectedProject();
        if (project == null || !project.isAccessible() || !ro.amiq.dvt.utils.Utils.hasDvtNature(project) || TestHelper.isTestMode()) {
            IProject[] projects = DVTUtilsCommon.getProjects();
            if (projects == null || projects.length == 0) {
                return null;
            }
            project = ProjectSelectionDialog.selectProject();
        }
        return project;
    }

    public static IFile getSelectedFile() {
        IEditorPart activeEditor;
        block3: {
            try {
                activeEditor = DVTInspectViewUtils.getInstance().getActiveEditor();
                if (activeEditor instanceof DVTEditor) break block3;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        return ((DVTEditor)activeEditor).getCurrentFile();
    }
}

