/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.text.StrSubstitutor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.text.edits.InsertEdit;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.ErrorDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.util.RfGUIReferencesUtils;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameRefactorInfo;
import ro.amiq.dvt.ui.search.BaseFileMatch;
import ro.amiq.dvt.ui.search.HitType;
import ro.amiq.dvt.ui.search.LineElement;
import ro.amiq.dvt.ui.search.RWKind;
import ro.amiq.dvt.ui.search.RWSearchTypeEnum;
import ro.amiq.dvt.ui.search.SearchHit;
import ro.amiq.dvt.ui.search.favorites.FavoriteQuery;
import ro.amiq.dvt.ui.search.favorites.RfFavoriteUtils;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.benchmark.StopWatch;

public class RfReferencesUtils {
    public static final String NAME_IN_USE_MESSAGE = "There is already {0} with this name.";
    public static final String NAME_IN_ENCLOSING_SCOPE_IN_USE_MESSAGE = "{0} ''{1}'' shadows {2} ''{3}''.";
    public static final String NAME_IN_ENCLOSED_SCOPE_IN_USE_MESSAGE = "{0} ''{1}'' is shadowed by {2} ''{3}''.";
    public static final String CONFLICTS_MESSAGE = "The rename operation results in name conflicts.";
    public static final String MANDATORY_PREVIEW_CHAGES_MESSAGE = "It is mandatory to preview the changes.";
    private static final String DVT_DEBUG_SEARCH = "DVT_DEBUG_SEARCH";
    private static final String DVT_DEBUG_SEARCH_VALUE = System.getenv("DVT_DEBUG_SEARCH");
    public static final boolean DEBUG_SEARCH = DVT_DEBUG_SEARCH_VALUE != null && "true".equalsIgnoreCase(DVT_DEBUG_SEARCH_VALUE);
    public static final String LOG_INSTANCES_PREFIX = "[SEARCH FOR INSTANCES ENGINE BENCHMARK] Time for computing instances of ";
    public static final String FORCE_ASSIGNMENTS = "Force assignments";
    public static final String REPORT_CLAUSES = "Report clauses";
    public static final String FORCE_ASSIGNMENTS_STRING = "force_assignments";
    public static final String REPORT_ASSIGNMENTS_STRING = "report_clauses";
    public static final String TextSearchVisitor_canceled = "Operation Canceled";
    public static final String SIMULATION_CONTROL_PROCEDURES = "Simulation control procedures";
    private static final String COMMAND_LINE_INPUT_SYSTEM_TASKS = "Command line input system tasks";
    private static final String SIMULATION_CONTROL_TASKS = "Simulation control tasks";
    private static final String DISPLAY_SYSTEM_TASKS = "Display system tasks";
    private static final String UVM_REPORTING_MACROS = "UVM reporting macros";
    public static final String UVM_FACTORY_OVERRIDES = "UVM Factory Overrides";
    public static final String UVM_CONDIF_DB_GETTERS = "UVM Config DB Getters";
    public static final String UVM_CONDIF_DB_SETTERS = "UVM Config DB Setters";
    public static final Set<Class<? extends IRfScopeElement>> CLOSEST_TYPE_CONTAINER_FOR_REFERENCES = new HashSet<Class<? extends IRfScopeElement>>();
    public static final String NEW_NAME_IS_SAME_AS_OLD_NAME = "New name is the same as old name.";
    public static final String YOU_MUST_PROVIDE_A_NEW_NAME = "You must provide a new name.";
    public static final String POTENTIAL_MATCHES_WARNING_MESSAGE = "Found potential matches. It is mandatory to preview the changes.";
    public static final String ELABORATION_MATCHES_WARNING_MESSAGE = "Found post-config matches. It is mandatory to preview the changes.";
    public static final String MATCHES_INSIDE_MACRO_CALL_WARNING_MESSAGE = "Found matches inside macro calls. It is mandatory to preview the changes.";
    public static final String NEW_NAME_IS_NOT_A_VALID_IDENTIFIER_PREFIX_WITH_TO_ESCAPE_IT = "New name{0} is not a valid identifier, prefix with '\\' to escape it.";
    public static final String POTENTIAL_MATCH_ERROR_MESSAGE = " [Not resolved in context - ";
    public static final String INCOMPLETE_SEARCH = " (incomplete)";
    public static final String NEW_NAME_IS_A_KEYWORD = "New name {0} is a keyword.";
    public static final String THE_METHOD_SIGNATURE_HAS_NOT_CHANGED = "The method signature has not changed";
    public static final String METHOD_NAME_CANNOT_BE_EMPTY = "Method name cannot be empty";
    public static final String DUPLICATE_PARAMETERS_NOT_ALLOWED = "Duplicate argument: {0}";
    public static final String PARAMETER_TYPE_CANNOT_BE_EMPTY = "Argument type cannot be empty";
    public static final String A_NEWLY_ADDED_PARAMETER_MUST_HAVE_A_DEFAULT_VALUE = "Value cannot be empty";
    public static final String PARAMETER_NAME_CANNOT_BE_EMPTY = "Argument name cannot be empty";
    public static final String FIXME_CANNOT_PERFORM_OPERATION = " FIXME: Cannot perform the requested operation on the arguments of ''{0}'' in this context";
    public static final String FIXME_CANNOT_PERFORM_OPERATION_DUE_TO_MACROS = " FIXME: Cannot perform the requested operation on the arguments of ''{0}'' in the context below due to the use of preprocessing macros";
    public static final String FIXME_CANNOT_PERFORM_OPERATION_MIXED_CALL = " FIXME: Cannot perform the requested operation on the arguments of ''{0}'' in the context below due to the use of both positional and named arguments";

    public static void flushMatches(Set<BaseFileMatch> cachedMatches, AbstractTextSearchResult result) {
        if (cachedMatches != null && !cachedMatches.isEmpty()) {
            result.addMatches(cachedMatches.toArray(new Match[cachedMatches.size()]));
            cachedMatches.clear();
        }
    }

    public static void logComputeInstancesTime(IRfNamedElement namedElement, long startTime) {
        long stopTime = System.currentTimeMillis();
        if (namedElement == null) {
            return;
        }
        DVTLogger.INSTANCE.logInfo(LOG_INSTANCES_PREFIX + namedElement.getKindName() + " " + namedElement.getFullNameLabel() + " = " + StopWatch.formatTime(stopTime - startTime));
    }

    public static int countStartWS(IDocument openDocument, IRegion startLineInfo) throws BadLocationException {
        String lineText;
        block4: {
            lineText = openDocument.get(startLineInfo.getOffset(), startLineInfo.getLength());
            if (lineText != null && !lineText.isEmpty()) break block4;
            return -1;
        }
        try {
            int counter = 0;
            while (Character.isWhitespace(lineText.charAt(counter))) {
                ++counter;
            }
            return counter;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return -1;
        }
    }

    public static String getFileMatchString(BaseFileMatch fileMatch) {
        if (fileMatch == null) {
            return "";
        }
        LineElement lineElement = fileMatch.getLineElement();
        if (lineElement == null) {
            return "";
        }
        return String.valueOf(fileMatch.isPossibleMatch() ? "Potential " : "Exact ") + "match [" + lineElement.getContents().trim() + "]";
    }

    public static String computeContents(String lineContents) {
        if (lineContents == null || !lineContents.contains("\t")) {
            return lineContents;
        }
        StringBuilder result = new StringBuilder();
        char[] cArray = lineContents.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '\t') {
                result.append(' ');
            } else {
                result.append(c);
            }
            ++n2;
        }
        return result.toString();
    }

    public static int countStartWS(String lineContents) throws BadLocationException {
        block4: {
            if (lineContents != null && !lineContents.isEmpty()) break block4;
            return -1;
        }
        try {
            int counter = 0;
            while (counter < lineContents.length() && Character.isWhitespace(lineContents.charAt(counter))) {
                ++counter;
            }
            return counter;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return -1;
        }
    }

    public static boolean isContainedInAnotherIdentifierFromLineContent(String elementName, String lineContents, int startSearchOffset, int endSearchOffset, int localOffset, boolean isEscaped) {
        int offsetDiff;
        int n = offsetDiff = isEscaped ? 1 : 0;
        if (localOffset - 1 >= startSearchOffset && localOffset + elementName.length() + offsetDiff < endSearchOffset) {
            return Character.isJavaIdentifierPart(lineContents.charAt(localOffset - 1)) || Character.isJavaIdentifierPart(lineContents.charAt(localOffset + elementName.length() + offsetDiff));
        }
        if (localOffset - 1 < startSearchOffset && localOffset + elementName.length() + offsetDiff < endSearchOffset) {
            return Character.isJavaIdentifierPart(lineContents.charAt(localOffset + elementName.length() + offsetDiff));
        }
        if (localOffset + elementName.length() + offsetDiff >= endSearchOffset && localOffset - 1 >= startSearchOffset) {
            return Character.isJavaIdentifierPart(lineContents.charAt(localOffset - 1));
        }
        return false;
    }

    public static void logDebug(String debugMessage) {
        if (!DEBUG_SEARCH) {
            return;
        }
        DVTLogger.INSTANCE.logInfo(debugMessage);
    }

    public static boolean checkFoundElementForReadAndWrite(IRfNamedElement searched, IRfNamedElement found) {
        if (searched == found && RfReferencesUtils.canBeReadOrWritten(searched)) {
            return true;
        }
        if (found instanceof IRfFieldElement && ((IRfFieldElement)found).isFunctionResultImplicit()) {
            return true;
        }
        return RfReferencesUtils.canBeReadOrWritten(searched) && RfReferencesUtils.canBeReadOrWritten(found);
    }

    public static boolean canBeReadOrWritten(IRfNamedElement namedElement) {
        if (!(namedElement instanceof IRfFieldElement)) {
            return false;
        }
        if (((IRfFieldElement)namedElement).isEvent()) {
            return true;
        }
        int fieldKind = ((IRfFieldElement)namedElement).getFieldKind();
        switch (fieldKind) {
            case 1: 
            case 2: 
            case 4: 
            case 128: 
            case 256: 
            case 512: 
            case 8192: 
            case 16384: 
            case 32768: 
            case 65536: 
            case 131072: 
            case 262144: 
            case 524288: 
            case 0x100000: 
            case 0x200000: {
                return true;
            }
        }
        return false;
    }

    public static RWKind getPortElementWriteType(IRfNamedElement element) {
        if (!RfSearchUtils.canBeReadOrWritten(element)) {
            return RWKind.NONE;
        }
        if (((IRfFieldElement)element).isInout()) {
            return RWKind.READ_WRITE;
        }
        if (((IRfFieldElement)element).isOutput()) {
            return RWKind.READ;
        }
        return RWKind.WRITE;
    }

    public static String getDefaultSearches() {
        HashMap result = new HashMap();
        ArrayList<FavoriteQuery> vlogQueries = new ArrayList<FavoriteQuery>();
        ArrayList<FavoriteQuery> vhdlQueries = new ArrayList<FavoriteQuery>();
        result.put("SystemVerilog", vlogQueries);
        result.put("VHDL", vhdlQueries);
        FavoriteQuery displayQuery = new FavoriteQuery(Arrays.asList("$display", "$displayb", "$displayo", "$displayh", "$write", "$writeb", "$writeo", "$writeh", "$strobe", "$strobeb", "$strobeh", "$strobeo", "$monitor", "$monitorb", "$monitorh", "$monitoro", "$monitoroff", "$monitoron"), "SystemVerilog", DISPLAY_SYSTEM_TASKS, false);
        FavoriteQuery printQuery = new FavoriteQuery(Arrays.asList("$stop", "$finish", "$exit"), "SystemVerilog", SIMULATION_CONTROL_TASKS, false);
        FavoriteQuery xvmMacroQuery = new FavoriteQuery(Arrays.asList("`uvm_fatal", "`uvm_error", "`uvm_warning", "`uvm_info", "`ovm_fatal", "`ovm_error", "`ovm_warning", "`ovm_info"), "SystemVerilog", UVM_REPORTING_MACROS, false);
        FavoriteQuery forceQeury = new FavoriteQuery(Arrays.asList(FORCE_ASSIGNMENTS_STRING), "SystemVerilog", FORCE_ASSIGNMENTS, false);
        FavoriteQuery commandLineQuery = new FavoriteQuery(Arrays.asList("$test$plusargs", "$value$plusargs"), "SystemVerilog", COMMAND_LINE_INPUT_SYSTEM_TASKS, false);
        FavoriteQuery uvmFactoryOverrides = new FavoriteQuery(Arrays.asList("uvm_pkg.uvm_component.set_type_override_by_type", "uvm_pkg.uvm_component.set_inst_override_by_type", "uvm_pkg.uvm_component.set_type_override", "uvm_pkg.uvm_component.set_inst_override", "uvm_pkg.uvm_factory.set_inst_override_by_type", "uvm_pkg.uvm_factory.set_inst_override_by_name", "uvm_pkg.uvm_factory.set_type_override_by_type", "uvm_pkg.uvm_factory.set_type_override_by_name", "uvm_pkg.uvm_component_registry.set_type_override", "uvm_pkg.uvm_component_registry.set_inst_override", "uvm_pkg.uvm_object_registry.set_type_override", "uvm_pkg.uvm_object_registry.set_inst_override", "ovm_pkg.ovm_component.set_type_override_by_type", "ovm_pkg.ovm_component.set_inst_override_by_type", "ovm_pkg.ovm_component.set_type_override", "ovm_pkg.ovm_component.set_inst_override", "ovm_pkg.ovm_factory.set_inst_override_by_type", "ovm_pkg.ovm_factory.set_inst_override_by_name", "ovm_pkg.ovm_factory.set_type_override_by_type", "ovm_pkg.ovm_factory.set_type_override_by_name", "ovm_pkg.ovm_component_registry.set_type_override", "ovm_pkg.ovm_component_registry.set_inst_override", "ovm_pkg.ovm_object_registry.set_type_override", "ovm_pkg.ovm_object_registry.set_inst_override"), "SystemVerilog", UVM_FACTORY_OVERRIDES, false);
        FavoriteQuery uvmConfigDBGetters = new FavoriteQuery(Arrays.asList("uvm.pkg::uvm_component.get_config_int", "uvm.pkg::uvm_component.get_config_string", "uvm.pkg::uvm_component.get_config_object", "uvm_pkg::uvm_config_db.get", "ovm.pkg::ovm_component.get_config_int", "ovm.pkg::ovm_component.get_config_string", "ovm.pkg::ovm_component.get_config_object", "ovm_pkg::ovm_config_db.get"), "SystemVerilog", UVM_CONDIF_DB_GETTERS, false);
        FavoriteQuery uvmConfigDBSetters = new FavoriteQuery(Arrays.asList("uvm.pkg::uvm_component.set_config_int", "uvm.pkg::uvm_component.set_config_string", "uvm.pkg::uvm_component.set_config_object", "uvm_pkg::uvm_config_db.set", "ovm.pkg::ovm_component.set_config_int", "ovm.pkg::ovm_component.set_config_string", "ovm.pkg::ovm_component.set_config_object", "ovm_pkg::ovm_config_db.set"), "SystemVerilog", UVM_CONDIF_DB_SETTERS, false);
        vlogQueries.add(printQuery);
        vlogQueries.add(displayQuery);
        vlogQueries.add(xvmMacroQuery);
        vlogQueries.add(forceQeury);
        vlogQueries.add(commandLineQuery);
        vlogQueries.add(uvmFactoryOverrides);
        vlogQueries.add(uvmConfigDBGetters);
        vlogQueries.add(uvmConfigDBSetters);
        FavoriteQuery forceQuery = new FavoriteQuery(Arrays.asList(FORCE_ASSIGNMENTS_STRING), "VHDL", FORCE_ASSIGNMENTS, false);
        FavoriteQuery reportQuery = new FavoriteQuery(Arrays.asList(REPORT_ASSIGNMENTS_STRING), "VHDL", REPORT_CLAUSES, false);
        FavoriteQuery simulationControlProcedures = new FavoriteQuery(Arrays.asList("std.env.stop", "std.env.finish"), "VHDL", SIMULATION_CONTROL_PROCEDURES, false);
        vhdlQueries.add(forceQuery);
        vhdlQueries.add(reportQuery);
        vhdlQueries.add(simulationControlProcedures);
        return RfFavoriteUtils.getSerializedPredefinedSearchQueries(result);
    }

    public static Set<ParserPath> getSearchedFiles(Map<IProject, Set<ParserPath>> parserPathMap) {
        if (parserPathMap == null || parserPathMap.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<ParserPath> result = new HashSet<ParserPath>();
        for (Set<ParserPath> parserPaths : parserPathMap.values()) {
            if (parserPaths == null || parserPaths.isEmpty()) continue;
            result.addAll(parserPaths);
        }
        return result;
    }

    public static String capitalize(String stringElement) {
        if (stringElement == null || stringElement.isEmpty()) {
            return stringElement;
        }
        return String.valueOf(stringElement.substring(0, 1).toUpperCase()) + stringElement.substring(1);
    }

    public static boolean isElaboratedInstance(IRfSingleLangProject rfSingleLangProject, IRfInstanceElement instance) {
        ELManager elManager = rfSingleLangProject.getELManager();
        if (elManager == null) {
            return true;
        }
        IELMemory memory = elManager.getMemory();
        if (memory == null) {
            return true;
        }
        List<ELInstance> instancesFor = memory.getInstancesFor(instance, 1);
        return instancesFor != null && !instancesFor.isEmpty();
    }

    public static Map<IRfInstanceElement, List<SearchHit>> getDotStarImplicitMatches(Set<SearchHit> matches) {
        HashMap<IRfInstanceElement, List<SearchHit>> matchesPerInstance = new HashMap<IRfInstanceElement, List<SearchHit>>();
        if (matches == null || matches.isEmpty()) {
            return matchesPerInstance;
        }
        for (SearchHit match : matches) {
            IRfInstanceElement instanceElement = match.getInstance();
            HitType hitType = match.getHitType();
            if (hitType != HitType.DOTSTAR && hitType != HitType.IMPLICIT) continue;
            ArrayList<SearchHit> matchesOfInstance = (ArrayList<SearchHit>)matchesPerInstance.get(instanceElement);
            if (matchesOfInstance == null) {
                matchesOfInstance = new ArrayList<SearchHit>();
                matchesPerInstance.put(instanceElement, matchesOfInstance);
            }
            matchesOfInstance.add(match);
        }
        return matchesPerInstance;
    }

    public static boolean isValidIndentifierName(String identifierName) {
        if (identifierName == null || identifierName.length() == 0) {
            return false;
        }
        char[] chs = identifierName.toCharArray();
        if (chs[0] == '\\') {
            return true;
        }
        if (!Character.isJavaIdentifierStart(chs[0]) || chs[0] == '$') {
            return false;
        }
        int i = 1;
        while (i < chs.length) {
            if (!Character.isJavaIdentifierPart(chs[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean shouldSkipReadersWritersUsages(RWSearchTypeEnum searchRWType, RWKind readWriteKind) {
        if (searchRWType == RWSearchTypeEnum.USAGES) {
            return false;
        }
        if (searchRWType == RWSearchTypeEnum.READERS && (readWriteKind == RWKind.READ || readWriteKind == RWKind.READ_WRITE)) {
            return false;
        }
        if (searchRWType == RWSearchTypeEnum.WRITERS && (readWriteKind == RWKind.WRITE || readWriteKind == RWKind.READ_WRITE)) {
            return false;
        }
        if (searchRWType == RWSearchTypeEnum.GETTERS && readWriteKind == RWKind.GETTER) {
            return false;
        }
        return searchRWType != RWSearchTypeEnum.SETTERS || readWriteKind != RWKind.SETTER;
    }

    public static void changeToPostConfigHit(IProject project, final IRfInstanceElement instanceScope, final SearchHit lineEntry) {
        IELMemory memory = RfMixedLangManager.getInstance().getELMemory(project);
        if (memory == null) {
            return;
        }
        final IRfNamedElement associatedType = instanceScope.getAssociatedType();
        if (associatedType == null) {
            return;
        }
        memory.visitBindings(new IELMemory.IELMemoryVisitor(){

            @Override
            public boolean visitBindings(ElementPath path, ELInstance instance) {
                if (instance.getDescription() != instanceScope) {
                    return true;
                }
                IRfNamedElement binding = instance.getBinding(true);
                if (binding != null && !(binding instanceof ErrorDesignElement) && !binding.checkEquals(associatedType)) {
                    lineEntry.setIsElaborationHit();
                    return false;
                }
                return true;
            }
        });
    }

    public static Map<IRfInstanceElement, List<BaseFileMatch>> getDotStarImplicitMatches(Match[] matches) {
        HashMap<IRfInstanceElement, List<BaseFileMatch>> matchesPerInstance = new HashMap<IRfInstanceElement, List<BaseFileMatch>>();
        if (matches == null || matches.length == 0) {
            return matchesPerInstance;
        }
        Match[] matchArray = matches;
        int n = matches.length;
        int n2 = 0;
        while (n2 < n) {
            Match match = matchArray[n2];
            BaseFileMatch fileMatch = (BaseFileMatch)match;
            IRfInstanceElement instanceElement = fileMatch.getInstance();
            if (fileMatch.isDotStarPortConnection() || fileMatch.isImplicitPortConnection()) {
                ArrayList<BaseFileMatch> matchesOfInstance = (ArrayList<BaseFileMatch>)matchesPerInstance.get(instanceElement);
                if (matchesOfInstance == null) {
                    matchesOfInstance = new ArrayList<BaseFileMatch>();
                    matchesPerInstance.put(instanceElement, matchesOfInstance);
                }
                matchesOfInstance.add(fileMatch);
            }
            ++n2;
        }
        return matchesPerInstance;
    }

    public static InsertEdit createCommentForMacroHit(BaseFileMatch fileMatch, String newName, IRfNamedElement namedElement) {
        String comment = " FIXME: Rename usage of " + namedElement.getKindName() + " '" + namedElement.getFullNameLabel() + "' to '" + newName + "' inside the macro call below";
        return RfReferencesUtils.createComment(fileMatch.getFile(), fileMatch.getOffset(), comment, namedElement);
    }

    public static InsertEdit createCommentForMacroHit(BaseFileMatch fileMatch, DVTRenameRefactorInfo renameInfo, IRfNamedElement namedElement) {
        return RfReferencesUtils.createCommentForMacroHit(fileMatch, renameInfo.getNewName(fileMatch.isEscaped()), namedElement);
    }

    public static Map<String, String> makeCommentSubstMap(IRfNamedElement namedElement) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("element-signature", DVTStringUtil.replaceAll(DVTStringUtil.UNICODE_NEW_LINE, namedElement.getSignature(), " "));
        return result;
    }

    public static InsertEdit createComment(IFile file, int offset, String comment, IRfNamedElement namedElement) {
        if (comment == null || comment.length() == 0) {
            return null;
        }
        if (namedElement != null) {
            comment = StrSubstitutor.replace((Object)comment, RfReferencesUtils.makeCommentSubstMap(namedElement));
        }
        try {
            IRegion prevLineInfo;
            String prevLineContent;
            IDocument doc = RfGUIReferencesUtils.getDocument(file);
            String whitespace = DVTDocumentUtils.getIndent(offset, doc);
            int line = doc.getLineOfOffset(offset);
            String suffix = "";
            if (line > 0 && (prevLineContent = doc.get((prevLineInfo = doc.getLineInformation(line - 1)).getOffset(), prevLineInfo.getLength())).endsWith("\\")) {
                suffix = "\\";
            }
            IRegion lineInfo = doc.getLineInformationOfOffset(offset);
            return new InsertEdit(lineInfo.getOffset(), String.valueOf(whitespace) + "//" + comment + suffix + doc.getLineDelimiter(0));
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    public static boolean isHierarchicalAccess(IRfNamedElementAndScope namedElementAndScope) {
        if (namedElementAndScope == null) {
            return false;
        }
        Deque<? extends IRfNamedElementAndScope> elementAndScopeStack = namedElementAndScope.getElementAndScopeStack();
        return elementAndScopeStack != null && !elementAndScopeStack.isEmpty() && elementAndScopeStack.getFirst() != null && elementAndScopeStack.getFirst().getIRfNamedElement() != null;
    }
}

