/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.IDVTFile;
import ro.amiq.dvt.model.reflection.DummyPort;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.ErrorDesignElement;
import ro.amiq.dvt.model.reflection.IR2LDummyElement;
import ro.amiq.dvt.model.reflection.IReportHitsListener;
import ro.amiq.dvt.model.reflection.IRfConfiguration;
import ro.amiq.dvt.model.reflection.IRfConfigurationRule;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorWrapper;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.model.reflection.util.PortConnectionUtils;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTFileStatusContext;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameDelegate;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameRefactorInfo;
import ro.amiq.dvt.ui.refactor.rename.NameConflictStatus;
import ro.amiq.dvt.ui.refactor.rename.RenameAcrossHierarchyInfo;
import ro.amiq.dvt.ui.refactor.rename.RenameConflictType;
import ro.amiq.dvt.ui.search.BaseFileMatch;
import ro.amiq.dvt.ui.search.FileSynchedAndAvailableManager;
import ro.amiq.dvt.ui.search.LeftRightHandSideOfOperatorEnum;
import ro.amiq.dvt.ui.search.PortSignalEnum;
import ro.amiq.dvt.ui.search.RWKind;
import ro.amiq.dvt.ui.search.SearchHit;
import ro.amiq.dvt.ui.trace.connections.model.TCConnSignal;
import ro.amiq.dvt.ui.views.ISearchContributor;
import ro.amiq.dvt.utils.SearchedElementWrapper;

public class RfSearchUtils {
    private static final String GENERATING_PREVIEW_DIAGRAM = "Generating preview diagram...";
    private static final String PREVIEW_DIAGRAM_JOB = "Preview diagram";
    private static final String IT_IS_RECOMMENDED_TO_USE_THE_DIAGRAM_PREVIEW_MESSAGE = "It is recommended to use the diagram preview.";
    public static final String VLOG = "SystemVerilog";
    public static final String VHDL = "VHDL";
    public static final String RENAME_ACROSS_HIERARCHY_TITLE = "Rename Port Across the Design Hierarchy";
    private static final int MAX_SEEN_DESIGN_SIZE = 100;

    protected static List<ISearchContributor> getEnabledContributors(IProject project) {
        return RfMixedLangManager.getInstance().getEnabledSearchContributors(project);
    }

    private static List<ISearchContributor> getAllContributors() {
        return RfMixedLangManager.getInstance().getAllSearchContributors();
    }

    public static IRfNamedElement getNamedElementFromString(IProject project, String elementString, String languageKind) {
        List<ISearchContributor> contributors = RfSearchUtils.getEnabledContributors(project);
        for (ISearchContributor contributor : contributors) {
            IRfNamedElement result;
            if (!contributor.getNature().equals(RfSearchUtils.transformInverseProjectNature(languageKind)) || (result = contributor.getElementFromString(project, elementString)) == null) continue;
            return result;
        }
        return null;
    }

    public static String transformProjectNature(String projectNature) {
        if ("ro.amiq.vlogdt.VlogNature".equals(projectNature)) {
            return VLOG;
        }
        if ("ro.amiq.vhdldt.VhdlNature".equals(projectNature)) {
            return VHDL;
        }
        return null;
    }

    public static String transformInverseProjectNature(String languageKind) {
        if (VLOG.equals(languageKind)) {
            return "ro.amiq.vlogdt.VlogNature";
        }
        if (VHDL.equals(languageKind)) {
            return "ro.amiq.vhdldt.VhdlNature";
        }
        return null;
    }

    public static boolean isInstantiable(IRfNamedElement element) {
        if (element == null) {
            return false;
        }
        IRfSingleLangProject rfProject = element.getRfProject();
        if (rfProject == null) {
            return false;
        }
        List<ISearchContributor> contributors = RfSearchUtils.getEnabledContributors(rfProject.getProject());
        for (ISearchContributor contributor : contributors) {
            boolean canShowInstances = contributor.isInstantiable(element);
            if (!canShowInstances) continue;
            return true;
        }
        return false;
    }

    public static void computeReferences(IReportHitsListener<SearchHit> reportHitsListener, IProject project, IRfNamedElement namedElement, IHidEvaluator evaluator, String searchedString, IProgressMonitor monitor, Map<IProject, Set<ParserPath>> searchedFiles, FileSynchedAndAvailableManager fileManager, boolean includeDeclarations, boolean forRefactoring, boolean isStrictVirtual, Map<Integer, List<SearchedElementWrapper>> searchedElementsRelativeDepthPairs, RenameAcrossHierarchyInfo renameWrapper, SearchedElementWrapper elementWrapper, boolean skipImplicitComponentEntityAssociation, boolean disableHitInMacroArgument) {
        RfMixedLangProject mixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false);
        if (mixedLangProject == null) {
            return;
        }
        List<ISearchContributor> contributors = RfSearchUtils.getEnabledContributors(project);
        for (ISearchContributor contributor : contributors) {
            IRfSingleLangProject singleLangProject = mixedLangProject.getSingleLangProject(contributor.getNature());
            if (singleLangProject == null) continue;
            contributor.reportReferenceMatches(reportHitsListener, monitor, singleLangProject, namedElement, evaluator, searchedString, searchedFiles, fileManager, includeDeclarations, forRefactoring, isStrictVirtual, searchedElementsRelativeDepthPairs, renameWrapper, elementWrapper, skipImplicitComponentEntityAssociation, disableHitInMacroArgument);
        }
    }

    public static boolean validContentType(IProject project, IDocument document, int offset) {
        List<ISearchContributor> contributors = RfSearchUtils.getEnabledContributors(project);
        for (ISearchContributor contributor : contributors) {
            if (!contributor.validContentType(document, offset)) continue;
            return true;
        }
        return false;
    }

    public static void computeReferences(IReportHitsListener<SearchHit> reportHitsListener, IProject project, IRfNamedElement namedElement, IHidEvaluator evaluator, String searchedString, IProgressMonitor monitor, Map<IProject, Set<ParserPath>> searchedFiles, FileSynchedAndAvailableManager fileManager, boolean includeDeclarations, boolean forRefactoring, boolean isStrictVirtual, boolean skipImplicitComponentEntityAssociation, boolean disableHitInMacroArgument) {
        RfSearchUtils.computeReferences(reportHitsListener, project, namedElement, evaluator, searchedString, monitor, searchedFiles, fileManager, includeDeclarations, forRefactoring, isStrictVirtual, new HashMap<Integer, List<SearchedElementWrapper>>(), null, null, skipImplicitComponentEntityAssociation, disableHitInMacroArgument);
    }

    public static void installPartitionerForFile(IProject project, IDocument document, ParserPath parserPath) {
        if (project == null) {
            return;
        }
        if (RfSearchUtils.hasValidPartitioner(project, document)) {
            return;
        }
        List<ISearchContributor> contributors = RfSearchUtils.getEnabledContributors(project);
        String nature = null;
        if (RfMixedLangManager.getInstance().isCompiledAs(project, parserPath, "ro.amiq.vhdldt.VhdlNature")) {
            nature = "ro.amiq.vhdldt.VhdlNature";
        } else if (RfMixedLangManager.getInstance().isCompiledAs(project, parserPath, "ro.amiq.vlogdt.VlogNature")) {
            nature = "ro.amiq.vlogdt.VlogNature";
        } else if (RfMixedLangManager.getInstance().isCompiledAs(project, parserPath, "ro.amiq.edt.enature")) {
            nature = "ro.amiq.edt.enature";
        } else if (RfMixedLangManager.getInstance().isCompiledAs(project, parserPath, "ro.amiq.slndt.slnnature")) {
            nature = "ro.amiq.slndt.slnnature";
        } else if (RfMixedLangManager.getInstance().isCompiledAs(project, parserPath, "ro.amiq.msdldt.msdlnature")) {
            nature = "ro.amiq.msdldt.msdlnature";
        } else if (RfMixedLangManager.getInstance().isCompiledAs(project, parserPath, "ro.amiq.pssdt.pssnature")) {
            nature = "ro.amiq.pssdt.pssnature";
        }
        if (nature != null) {
            for (ISearchContributor contributor : contributors) {
                if (!nature.equals(contributor.getNature())) continue;
                contributor.installPartitionerForFile(document);
                return;
            }
        }
    }

    public static boolean hasValidPartitioner(IProject project, IDocument document) {
        List<ISearchContributor> contributors = RfSearchUtils.getEnabledContributors(project);
        for (ISearchContributor contributor : contributors) {
            if (!contributor.hasValidPartitioner(document)) continue;
            return true;
        }
        return false;
    }

    private static String getScopeInfo(IProject project, ParserPath parserPath, int line, int offset) {
        List<ISearchContributor> contributors = RfSearchUtils.getEnabledContributors(project);
        for (ISearchContributor contributor : contributors) {
            String result = contributor.getScopeInfo(project, parserPath, line, offset);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static String getScopeInfo(IProject project, ParserPath parserPath, int line, int offset, boolean isPossibleMatch) {
        String scopeInfo = RfSearchUtils.getScopeInfo(project, parserPath, line, offset);
        if (scopeInfo == null || !isPossibleMatch) {
            return scopeInfo;
        }
        int leftBracketIndex = scopeInfo.indexOf("[");
        int rightBracketIndex = scopeInfo.indexOf("]");
        if (leftBracketIndex == -1 || rightBracketIndex == -1 || leftBracketIndex >= rightBracketIndex) {
            return scopeInfo;
        }
        String scope = scopeInfo.substring(leftBracketIndex + 1, rightBracketIndex);
        return " [Not resolved in context - " + scope + "]";
    }

    public static IRfDefElement getScope(IProject project, ParserPath parserPath, int line, int offset) {
        List<ISearchContributor> contributors = RfSearchUtils.getEnabledContributors(project);
        if (contributors == null || contributors.isEmpty()) {
            return null;
        }
        for (ISearchContributor contributor : contributors) {
            IRfDefElement result = contributor.getScope(project, parserPath, line, offset);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static DVTFileStatusContext getFileStatusContext(IProject project, LanguageKind languageKind) {
        List<ISearchContributor> contributors = RfSearchUtils.getEnabledContributors(project);
        if (contributors == null || contributors.isEmpty()) {
            return null;
        }
        for (ISearchContributor contributor : contributors) {
            DVTFileStatusContext result;
            if (languageKind == null || !languageKind.NATURE_ID.equals(contributor.getNature()) || (result = contributor.getFileStatusContext()) == null) continue;
            return result;
        }
        return null;
    }

    public static boolean isTypeElement(IRfNamedElement element, IProject project) {
        if (element == null || project == null) {
            return false;
        }
        List<ISearchContributor> contributors = RfSearchUtils.getEnabledContributors(project);
        for (ISearchContributor contributor : contributors) {
            boolean isType = contributor.isTypeElement(element);
            if (!isType) continue;
            return true;
        }
        return false;
    }

    public static PortSignalEnum getPortOrSignalEnum(IRfNamedElement namedElement, IProject project) {
        List<ISearchContributor> contributors = RfSearchUtils.getEnabledContributors(project);
        for (ISearchContributor contributor : contributors) {
            PortSignalEnum portSignalEnum = contributor.getPortOrSignalEnum(namedElement);
            if (!portSignalEnum.matches()) continue;
            return portSignalEnum;
        }
        return PortSignalEnum.NO_MATCH;
    }

    public static IDVTFile getIDVTFile(IFile file, IProject project) {
        List<ISearchContributor> contributors = RfSearchUtils.getEnabledContributors(project);
        if (contributors == null || contributors.isEmpty()) {
            return null;
        }
        for (ISearchContributor contributor : contributors) {
            IDVTFile dvtFile = contributor.getIDVTFile(file);
            if (dvtFile == null) continue;
            return dvtFile;
        }
        return null;
    }

    public static boolean hasPortConnections(IRfNamedElement namedElement, IProject project) {
        List<ISearchContributor> contributors = RfSearchUtils.getEnabledContributors(project);
        if (contributors == null || contributors.isEmpty()) {
            return false;
        }
        for (ISearchContributor contributor : contributors) {
            boolean hasPortConnecitons = contributor.hasPortConnections(namedElement, project);
            if (!hasPortConnecitons) continue;
            return hasPortConnecitons;
        }
        return false;
    }

    public static DVTRenameDelegate getRenameAcrossHierarchyDelegate(DVTRenameRefactorInfo refactorInfo) {
        List<ISearchContributor> contributors = RfSearchUtils.getEnabledContributors(refactorInfo.getProject());
        if (contributors == null || contributors.isEmpty()) {
            return null;
        }
        for (ISearchContributor contributor : contributors) {
            DVTRenameDelegate delegate = contributor.getRenameAcrossHierarchyDelegate(refactorInfo);
            if (delegate == null) continue;
            return delegate;
        }
        return null;
    }

    private static boolean overlappingScopes(IProject project, IRfScopeElement currentElementScope, IRfScopeElement elementScope) {
        List<ISearchContributor> contributors = RfSearchUtils.getEnabledContributors(project);
        if (contributors == null || contributors.isEmpty()) {
            return false;
        }
        for (ISearchContributor contributor : contributors) {
            boolean overlappingScopes = contributor.overlappingScopes(currentElementScope, elementScope);
            if (!overlappingScopes) continue;
            return overlappingScopes;
        }
        return false;
    }

    public static boolean allowOrderedConnections(IRfNamedElement namedElement) {
        if (namedElement instanceof IRfPortElement) {
            return true;
        }
        if (!(namedElement instanceof IRfFieldElement)) {
            return false;
        }
        IRfScopeElement enclosingScope = namedElement.getEnclosingScope();
        if (!(enclosingScope instanceof IRfDesignElement)) {
            return false;
        }
        IRfFieldElement fieldElement = (IRfFieldElement)namedElement;
        return fieldElement.getFieldKind() == 128 || fieldElement.getFieldKind() == 256 || fieldElement.getInterfaceKind() == 2;
    }

    public static boolean isAlreadyRenamedElementInSameEnclosingScope(RenameAcrossHierarchyInfo renameAcrossHierarchyWrapper, IProject project, Map<Integer, List<SearchedElementWrapper>> elements, IRfNamedElement currentElement, IRfInstanceElement instance) {
        if (currentElement == null || elements == null || elements.isEmpty()) {
            return false;
        }
        IRfScopeElement enclosingScope = currentElement.getEnclosingScope();
        if (enclosingScope == null) {
            return false;
        }
        boolean result = false;
        for (List<SearchedElementWrapper> elementRelativeDepthToRenamedElementPairs : elements.values()) {
            if (elementRelativeDepthToRenamedElementPairs == null || elementRelativeDepthToRenamedElementPairs.isEmpty()) continue;
            for (SearchedElementWrapper elementRelativeDepthToRenamedElementPair : elementRelativeDepthToRenamedElementPairs) {
                IRfNamedElement element = elementRelativeDepthToRenamedElementPair.getElement();
                if (element == null || element.equals(currentElement) || !RfSearchUtils.overlappingScopes(project, enclosingScope, element.getEnclosingScope())) continue;
                if (!elementRelativeDepthToRenamedElementPair.shouldBeRenamed()) {
                    renameAcrossHierarchyWrapper.addAmbiguityCases(enclosingScope, currentElement);
                    renameAcrossHierarchyWrapper.addAmbiguityCases(element.getEnclosingScope(), element);
                    renameAcrossHierarchyWrapper.addPreViewDiagramInstanceInfo(instance, currentElement, false, RenameConflictType.AMBIGUITY_CONFLICT, false, null);
                    renameAcrossHierarchyWrapper.addPreViewDiagramInstanceInfo(instance, element, true, false, RenameConflictType.AMBIGUITY_CONFLICT, false, null);
                    renameAcrossHierarchyWrapper.addPreViewDiagramInstanceInfo(elementRelativeDepthToRenamedElementPair.getInstance(), currentElement, true, false, RenameConflictType.AMBIGUITY_CONFLICT, false, null);
                    renameAcrossHierarchyWrapper.addPreViewDiagramInstanceInfo(elementRelativeDepthToRenamedElementPair.getInstance(), element, false, RenameConflictType.AMBIGUITY_CONFLICT, false, null);
                } else {
                    renameAcrossHierarchyWrapper.addAmbiguityCases(enclosingScope, currentElement);
                    renameAcrossHierarchyWrapper.addPreViewDiagramInstanceInfo(instance, currentElement, false, RenameConflictType.AMBIGUITY_CONFLICT, false, null);
                    renameAcrossHierarchyWrapper.addPreViewDiagramInstanceInfo(instance, element, true, false, RenameConflictType.AMBIGUITY_CONFLICT, false, null);
                }
                result = true;
            }
        }
        return result;
    }

    public static boolean shouldCollectRightElement(IRfNamedElement collectedElement, RenameAcrossHierarchyInfo renameWrapper, IProject project) {
        return renameWrapper.renameInParentInstaces() && RfSearchUtils.getPortOrSignalEnum(collectedElement, project).matches();
    }

    public static boolean shouldCollectLeftElement(IRfNamedElement collectedElement, RenameAcrossHierarchyInfo renameWrapper, IProject project) {
        return renameWrapper.renameInSubInstances() && RfSearchUtils.getPortOrSignalEnum(collectedElement, project).matches();
    }

    public static boolean scopeInsideDesignPath(RenameAcrossHierarchyInfo renameWrapper, IRfNamedElement scopeElement) {
        return renameWrapper != null && renameWrapper.getDesignInstances() != null && (renameWrapper.getDesignInstances().isEmpty() || renameWrapper.getDesignInstances().contains(scopeElement));
    }

    public static boolean isRenameAcrossHierarchyEnabled(RenameAcrossHierarchyInfo renameWrapper) {
        return renameWrapper != null;
    }

    public static void searchAcrossDesignHierarchy(IRfNamedElement namedElement, RenameAcrossHierarchyInfo renameAcrossDesignHierarchyWrapper, IReportHitsListener<SearchHit> listener, IProject fProject, IProgressMonitor progressMonitor, boolean includeDeclarations, boolean forRefactor, boolean isStrictVirtual) {
        if (renameAcrossDesignHierarchyWrapper == null) {
            return;
        }
        LinkedHashMap<Integer, List<SearchedElementWrapper>> searchedElementsRelativeDepthPairs = new LinkedHashMap<Integer, List<SearchedElementWrapper>>();
        ArrayList<SearchedElementWrapper> initialPairs = new ArrayList<SearchedElementWrapper>();
        List<IRfNamedElement> designInstances = renameAcrossDesignHierarchyWrapper.getDesignInstances();
        if (designInstances == null || designInstances.isEmpty()) {
            return;
        }
        SearchedElementWrapper initialSearchedElementWrapper = new SearchedElementWrapper(namedElement, 0, true, designInstances.get(designInstances.size() - 1));
        initialPairs.add(initialSearchedElementWrapper);
        searchedElementsRelativeDepthPairs.put(0, initialPairs);
        int renameAcrossHierarchyMaxLevel = renameAcrossDesignHierarchyWrapper.getRenameDepth();
        Set searchedElementsDepths = searchedElementsRelativeDepthPairs.keySet();
        ArrayList searchedElementsDepthsCopy = new ArrayList(searchedElementsDepths);
        HashMap<IProject, Set<ParserPath>> hashMap = new HashMap<IProject, Set<ParserPath>>();
        FileSynchedAndAvailableManager fileManager = new FileSynchedAndAvailableManager(RfReferencesUtils.getSearchedFiles(hashMap), progressMonitor);
        int i = 0;
        while (i < searchedElementsDepthsCopy.size()) {
            List searchedElementsWrappers;
            Integer relativeDepth = (Integer)searchedElementsDepthsCopy.get(i);
            int absRelativeLevel = Math.abs(relativeDepth);
            if (!(renameAcrossHierarchyMaxLevel > 0 && absRelativeLevel >= renameAcrossHierarchyMaxLevel || (searchedElementsWrappers = (List)searchedElementsRelativeDepthPairs.get(relativeDepth)) == null || searchedElementsWrappers.isEmpty())) {
                List<SearchedElementWrapper> newSearchedElementsWrappers = RfSearchUtils.getMatchesInsideSameScope(searchedElementsWrappers, renameAcrossDesignHierarchyWrapper);
                for (SearchedElementWrapper searchedElementWrapper : newSearchedElementsWrappers) {
                    List<IRfFieldElement> candidates;
                    IRfNamedElement element;
                    if (!searchedElementWrapper.shouldBeRenamed() || (element = searchedElementWrapper.getElement()) == null) continue;
                    IStatus conflicts = RfSearchUtils.getConflictingStatus(renameAcrossDesignHierarchyWrapper.getDiagramPreview().getNewName(), fProject, element, element.getEnclosingScope());
                    if (conflicts instanceof NameConflictStatus && (candidates = ((NameConflictStatus)conflicts).getCandidates()) != null && !candidates.contains(element)) {
                        renameAcrossDesignHierarchyWrapper.addConflictingCases(element, candidates);
                        searchedElementWrapper.setShouldBeRenamed(false);
                        renameAcrossDesignHierarchyWrapper.addPreViewDiagramInstanceInfo(searchedElementWrapper.getInstance(), element, false, RenameConflictType.DUPLICATE_CONFLICT, relativeDepth == 0, null);
                        continue;
                    }
                    RfSearchUtils.computeReferences(listener, fProject, element, null, element.getName(), progressMonitor, hashMap, fileManager, includeDeclarations, forRefactor, isStrictVirtual, searchedElementsRelativeDepthPairs, renameAcrossDesignHierarchyWrapper, searchedElementWrapper, false, false);
                }
                searchedElementsDepthsCopy = new ArrayList(searchedElementsRelativeDepthPairs.keySet());
            }
            ++i;
        }
    }

    private static List<SearchedElementWrapper> getMatchesInsideSameScope(List<SearchedElementWrapper> searchedElementsWrappers, RenameAcrossHierarchyInfo renameAcrossDesignHierarchyWrapper) {
        LinkedHashMap resultMap = new LinkedHashMap();
        HashSet<IRfScopeElement> forbiddenScopes = new HashSet<IRfScopeElement>();
        for (SearchedElementWrapper searchedElementWrapper : searchedElementsWrappers) {
            IRfNamedElement element = searchedElementWrapper.getElement();
            IRfScopeElement enclosingScope = element.getEnclosingScope();
            if (forbiddenScopes.contains(enclosingScope)) {
                searchedElementWrapper.setShouldBeRenamed(false);
                renameAcrossDesignHierarchyWrapper.addAmbiguityCases(enclosingScope, element);
                renameAcrossDesignHierarchyWrapper.addPreViewDiagramInstanceInfo(searchedElementWrapper.getInstance(), searchedElementWrapper.getElement(), false, RenameConflictType.AMBIGUITY_CONFLICT, searchedElementWrapper.getRelativeLevel() == 0, null);
                continue;
            }
            ArrayList<SearchedElementWrapper> wrappers = (ArrayList<SearchedElementWrapper>)resultMap.get(enclosingScope);
            if (wrappers == null) {
                wrappers = new ArrayList<SearchedElementWrapper>();
                resultMap.put(enclosingScope, wrappers);
                wrappers.add(searchedElementWrapper);
                continue;
            }
            for (SearchedElementWrapper wrapper : wrappers) {
                IRfNamedElement wrapperElement = wrapper.getElement();
                if (wrapperElement == null || wrapperElement.equals(searchedElementWrapper.getElement())) continue;
                resultMap.remove(enclosingScope);
                forbiddenScopes.add(enclosingScope);
                IRfScopeElement wrapperEnclosingScope = wrapperElement.getEnclosingScope();
                renameAcrossDesignHierarchyWrapper.addAmbiguityCases(wrapperEnclosingScope, wrapperElement);
                renameAcrossDesignHierarchyWrapper.addAmbiguityCases(wrapperEnclosingScope, searchedElementWrapper.getElement());
                renameAcrossDesignHierarchyWrapper.addPreViewDiagramInstanceInfo(wrapper.getInstance(), wrapper.getElement(), false, RenameConflictType.AMBIGUITY_CONFLICT, searchedElementWrapper.getRelativeLevel() == 0, null);
                renameAcrossDesignHierarchyWrapper.addPreViewDiagramInstanceInfo(searchedElementWrapper.getInstance(), searchedElementWrapper.getElement(), false, RenameConflictType.AMBIGUITY_CONFLICT, searchedElementWrapper.getRelativeLevel() == 0, null);
                renameAcrossDesignHierarchyWrapper.addPreViewDiagramInstanceInfo(wrapper.getInstance(), searchedElementWrapper.getElement(), true, false, RenameConflictType.AMBIGUITY_CONFLICT, searchedElementWrapper.getRelativeLevel() == 0, null);
                renameAcrossDesignHierarchyWrapper.addPreViewDiagramInstanceInfo(searchedElementWrapper.getInstance(), wrapper.getElement(), true, false, RenameConflictType.AMBIGUITY_CONFLICT, searchedElementWrapper.getRelativeLevel() == 0, null);
                searchedElementWrapper.setShouldBeRenamed(false);
                wrapper.setShouldBeRenamed(false);
            }
        }
        ArrayList<SearchedElementWrapper> result = new ArrayList<SearchedElementWrapper>();
        Collection values = resultMap.values();
        if (values == null || values.isEmpty()) {
            return result;
        }
        for (List list : values) {
            result.addAll(list);
        }
        return result;
    }

    public static String getPath(List<IRfNamedElement> renamedPath) {
        StringBuilder result = new StringBuilder();
        if (renamedPath == null || renamedPath.isEmpty()) {
            return result.toString();
        }
        for (IRfNamedElement path : renamedPath) {
            if (path == null) continue;
            result.append(String.valueOf(path.getName()) + ".");
        }
        return result.toString();
    }

    public static boolean containsSearchedElement(Map<Integer, List<SearchedElementWrapper>> searchedElementsRelativeToPairs, SearchedElementWrapper pair) {
        if (searchedElementsRelativeToPairs == null || searchedElementsRelativeToPairs.isEmpty()) {
            return false;
        }
        for (List<SearchedElementWrapper> searchedElements : searchedElementsRelativeToPairs.values()) {
            if (searchedElements == null || searchedElements.isEmpty() || !searchedElements.contains(pair)) continue;
            return true;
        }
        return false;
    }

    public static void addMatchesForRename(Map<IFile, List<BaseFileMatch>> renameAcrossHierarchyMatches, BaseFileMatch fileMatch, IFile file) {
        List<BaseFileMatch> matchesPerFile = renameAcrossHierarchyMatches.get(file);
        if (matchesPerFile == null) {
            matchesPerFile = new ArrayList<BaseFileMatch>();
            renameAcrossHierarchyMatches.put(file, matchesPerFile);
        }
        for (BaseFileMatch matchPerFile : matchesPerFile) {
            if (!matchPerFile.locationEquals(fileMatch)) continue;
            return;
        }
        matchesPerFile.add(fileMatch);
    }

    public static void collectNewSearchedElement(Map<Integer, List<SearchedElementWrapper>> searchedElementsWithRelativeDepthsInfo, int collectedRelativeLevel, SearchedElementWrapper pair) {
        List<SearchedElementWrapper> searchedElements = searchedElementsWithRelativeDepthsInfo.get(collectedRelativeLevel);
        if (searchedElements == null) {
            searchedElements = new ArrayList<SearchedElementWrapper>();
            searchedElementsWithRelativeDepthsInfo.put(collectedRelativeLevel, searchedElements);
        }
        searchedElements.add(pair);
    }

    public static String getRenameAcrossHierarchyAmbiguityMessage(IProject project, IRfNamedElement scopeElement, Set<IRfNamedElement> ambiguityElementsPerScope) {
        if (ambiguityElementsPerScope == null || ambiguityElementsPerScope.isEmpty()) {
            return null;
        }
        int size = ambiguityElementsPerScope.size();
        if (size > 1) {
            IRfNamedElement firstElementType = ambiguityElementsPerScope.iterator().next();
            String multiplePortsModuleMessage = "Multiple " + (Object)((Object)RfSearchUtils.getPortOrSignalEnum(firstElementType, project)) + "s of " + scopeElement.getKindName() + " '" + scopeElement.getFullNameLabel() + "' are connected to the renamed signal";
            StringBuilder ambiguousPortsMessage = new StringBuilder();
            int index = 0;
            for (IRfNamedElement element : ambiguityElementsPerScope) {
                ambiguousPortsMessage.append("'").append(element.getName()).append("'");
                if (index != size - 1) {
                    ambiguousPortsMessage.append(", ");
                }
                ++index;
            }
            return String.valueOf(multiplePortsModuleMessage) + " (" + ambiguousPortsMessage.toString() + "). " + IT_IS_RECOMMENDED_TO_USE_THE_DIAGRAM_PREVIEW_MESSAGE;
        }
        IRfNamedElement firstElementType = ambiguityElementsPerScope.iterator().next();
        String multiplePortsModuleMessage = "The " + (Object)((Object)RfSearchUtils.getPortOrSignalEnum(firstElementType, project)) + " " + firstElementType.getName() + " of " + scopeElement.getKindName() + " '" + scopeElement.getFullNameLabel() + "' will not be renamed";
        String explanation = " (another port of this " + scopeElement.getKindName() + " will be renamed). " + IT_IS_RECOMMENDED_TO_USE_THE_DIAGRAM_PREVIEW_MESSAGE;
        return String.valueOf(multiplePortsModuleMessage) + explanation;
    }

    public static void addPreviewInfo(IRfNamedElement instance, IRfNamedElement port, SearchedElementWrapper elementWrapper, RenameAcrossHierarchyInfo renameAcrossHierarchyInfo, LeftRightHandSideOfOperatorEnum leftRightHandSideOfOperatorEnum, boolean continueRename, RenameConflictType renameConflict, boolean isInitialElement, HidOperator portConnection) {
        renameAcrossHierarchyInfo.addPreViewDiagramInstanceInfo(instance, port, elementWrapper == null ? true : elementWrapper.shouldBeRenamed(), renameConflict, isInitialElement, portConnection);
    }

    public static List<IRfNamedElement> computeBreadcrumbPath(boolean upDirection, List<IRfNamedElement> breadcrumbInstances, IRfInstanceElement instance) {
        ArrayList<IRfNamedElement> result = new ArrayList<IRfNamedElement>(breadcrumbInstances);
        if (upDirection) {
            result.remove(instance);
        } else {
            result.add(instance);
        }
        return result;
    }

    public static boolean shouldContinueWithRefactoring(boolean renameUp, SearchedElementWrapper searchedElementWrapper) {
        return searchedElementWrapper.getRelativeLevel() == 0 || !(renameUp ? searchedElementWrapper.getRelativeLevel() <= 0 : searchedElementWrapper.getRelativeLevel() >= 0);
    }

    public static String getDuplicateElementsMessage(IRfNamedElement namedElementMatch, IProject project, List<IRfFieldElement> candidates) {
        if (namedElementMatch == null) {
            return null;
        }
        IRfScopeElement enclosingScope = namedElementMatch.getEnclosingScope();
        if (!(enclosingScope instanceof IRfNamedElement)) {
            return null;
        }
        IRfNamedElement enclosingNamedElement = (IRfNamedElement)enclosingScope;
        String firstPhase = "The " + (Object)((Object)RfSearchUtils.getPortOrSignalEnum(namedElementMatch, project)) + " '" + namedElementMatch.getName() + "' of " + enclosingNamedElement.getKindName() + " '" + enclosingNamedElement.getFullNameLabel() + "' will not be renamed ";
        if (candidates == null || candidates.isEmpty()) {
            return null;
        }
        int index = 0;
        StringBuilder str = new StringBuilder();
        for (IRfFieldElement rfField : candidates) {
            str.append((Object)((Object)RfSearchUtils.getPortOrSignalEnum(rfField, project)) + " '" + rfField.getName() + "'");
            if (index != candidates.size() - 1) {
                str.append(", ");
            }
            ++index;
        }
        return String.valueOf(firstPhase) + "(" + str.toString() + " already exists). " + IT_IS_RECOMMENDED_TO_USE_THE_DIAGRAM_PREVIEW_MESSAGE;
    }

    public static IStatus getConflictingStatus(String newName, IProject project, IRfNamedElement namedElement, IRfScopeElement enclosingScope) {
        List<ISearchContributor> contributors = RfSearchUtils.getEnabledContributors(project);
        if (contributors == null || contributors.isEmpty()) {
            return null;
        }
        for (ISearchContributor contributor : contributors) {
            IStatus delegate = contributor.getConflictingStatus(newName, project, namedElement, enclosingScope);
            if (delegate == Status.OK_STATUS) continue;
            return delegate;
        }
        return Status.OK_STATUS;
    }

    public static String getDesignPath(List<IRfNamedElement> designInstances) {
        String designPath = RfSearchUtils.getPath(designInstances);
        if (designPath.length() <= 100) {
            return designPath;
        }
        int indexOfDot = (designPath = designPath.substring(designPath.length() - 100)).indexOf(46);
        if (indexOfDot != -1 && indexOfDot < designPath.length() - 1) {
            designPath = designPath.substring(indexOfDot + 1);
        }
        designPath = "...".concat(designPath);
        return designPath;
    }

    public static RWKind computePortArgumentConnectionWriteAccess(IRfNamedElement leftHandElement, IRfNamedElement currentElement, boolean isSignalEquals, RWKind initialValue) {
        boolean searchForReadableWritableFieldElement;
        boolean bl = searchForReadableWritableFieldElement = RfSearchUtils.canBeReadOrWritten(leftHandElement) && RfSearchUtils.canBeReadOrWritten(currentElement);
        if (!searchForReadableWritableFieldElement) {
            return RWKind.NONE;
        }
        if (!isSignalEquals) {
            return initialValue;
        }
        IRfFieldElement portElement = (IRfFieldElement)leftHandElement;
        if (portElement.isInout() || portElement.isRef()) {
            return RWKind.READ_WRITE;
        }
        if (portElement.isOutput()) {
            return RWKind.WRITE;
        }
        return RWKind.READ;
    }

    public static boolean canBeReadOrWritten(IRfNamedElement namedElement) {
        if (!(namedElement instanceof IRfFieldElement)) {
            return false;
        }
        if (((IRfFieldElement)namedElement).isEvent()) {
            return true;
        }
        int fieldKind = ((IRfFieldElement)namedElement).getFieldKind();
        switch (fieldKind) {
            case 1: 
            case 2: 
            case 4: 
            case 128: 
            case 256: 
            case 512: 
            case 8192: 
            case 16384: 
            case 32768: 
            case 65536: 
            case 131072: 
            case 262144: 
            case 524288: 
            case 0x100000: 
            case 0x200000: {
                return true;
            }
        }
        return false;
    }

    public static boolean isPredefinedElement(IRfNamedElement namedElement, IProject project) {
        List<ISearchContributor> contributors = RfSearchUtils.getEnabledContributors(project);
        if (contributors == null || contributors.isEmpty()) {
            return false;
        }
        for (ISearchContributor contributor : contributors) {
            boolean isPredefinedElement = contributor.isPredefinedElement(namedElement);
            if (!isPredefinedElement) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrecompiledElement(IRfNamedElement namedElement, IProject project) {
        List<ISearchContributor> contributors = RfSearchUtils.getEnabledContributors(project);
        if (contributors == null || contributors.isEmpty()) {
            return false;
        }
        for (ISearchContributor contributor : contributors) {
            boolean isPredefinedElement = contributor.isPrecompiledElement(namedElement);
            if (!isPredefinedElement) continue;
            return true;
        }
        return false;
    }

    public static boolean isInvalidElement(IRfNamedElement namedElement) {
        return namedElement == null || namedElement instanceof IR2LDummyElement;
    }

    public static boolean isPortOrParameterElement(IRfNamedElement element) {
        if (element instanceof IRfPortElement) {
            return true;
        }
        return RfSearchUtils.isParameterElement(element);
    }

    public static boolean isParameterElement(IRfNamedElement element) {
        if (!(element instanceof IRfFieldElement)) {
            return false;
        }
        IRfFieldElement field = (IRfFieldElement)element;
        return field.isParameter() || field.getInterfaceKind() == 2;
    }

    public static boolean isDesignElementOrPortParameterElement(IRfNamedElement element) {
        return element instanceof IRfPortElement || RfSearchUtils.isParameterElement(element) || RfSearchUtils.isInstantiable(element);
    }

    public static IRfNamedElement getElementToSearch(IRfNamedElement namedElement, IRfScopeElement scope, DVTEditor editor, int offset) {
        IRfNamedElement parameter;
        Map<String, HidOperatorWrapper> parameterOverrides;
        List<HidOperatorWrapper> portConnections;
        if (namedElement instanceof IRfConfiguration) {
            return namedElement;
        }
        if (!(namedElement instanceof IRfPortElement || RfSearchUtils.isParameterElement(namedElement) || namedElement instanceof IRfDesignElement)) {
            return namedElement;
        }
        if (scope instanceof IRfDefElement) {
            scope = ((IRfDefElement)((Object)scope)).getNamedElement();
        }
        if (!(scope instanceof IRfInstanceElement)) {
            return namedElement;
        }
        if (((IRfInstanceElement)scope).isInstanceToBind()) {
            return namedElement;
        }
        IRfSingleLangProject rfProject = namedElement.getRfProject();
        if (rfProject == null) {
            return namedElement;
        }
        ELManager elManager = rfProject.getELManager();
        if (elManager == null) {
            return namedElement;
        }
        IELMemory memory = elManager.getMemory();
        if (memory == null) {
            return namedElement;
        }
        ElementPath designPath = DesignPathManager.getInstance().getPathFor(editor, offset, namedElement, scope, false, false);
        if (designPath == null || designPath == DesignPathManager.FROZEN_MANAGER_EL_PATH) {
            return namedElement;
        }
        ELInstance elInstance = memory.instanceFor(designPath);
        if (elInstance == null) {
            return namedElement;
        }
        IRfConfiguration elaborationConfig = elInstance.getElaborationConfig();
        IRfConfigurationRule elaborationConfigRule = elInstance.getElaborationRule();
        if ((elaborationConfig == null || elaborationConfig.isDummyConfig()) && elaborationConfigRule == null) {
            return namedElement;
        }
        IRfNamedElement binding = elInstance.getBinding(true);
        if (!(binding instanceof IRfDesignElement) || binding instanceof ErrorDesignElement) {
            return namedElement;
        }
        if (namedElement instanceof IRfDesignElement) {
            return binding;
        }
        if (elaborationConfigRule != null && (namedElement instanceof IRfPortElement ? (portConnections = elaborationConfigRule.getPortConnections(false, false)) != null && !portConnections.isEmpty() : RfSearchUtils.isParameterElement(namedElement) && (parameterOverrides = elaborationConfigRule.getParameterOverrides(false)) != null && !parameterOverrides.isEmpty())) {
            return namedElement;
        }
        int matchKind = ELUtils.isVHDL(elInstance.getDescription()) || ELUtils.isVHDL(binding) ? 9 : 1;
        IRfDesignElement designBinding = (IRfDesignElement)binding;
        if (namedElement instanceof IRfPortElement) {
            IRfPortElement port = designBinding.getPortWithPrefix(namedElement.getName(), matchKind);
            if (port != null) {
                return port;
            }
        } else if (RfSearchUtils.isParameterElement(namedElement) && (parameter = designBinding.getParameterWithPrefix(namedElement.getName(), matchKind)) != null) {
            return parameter;
        }
        return namedElement;
    }

    public static boolean isOutputPortInImplicitNamedConnection(IRfNamedElement namedElement, IRfScopeElement scopeElement, HidOperator context) {
        return namedElement instanceof IRfPortElement && (((IRfPortElement)namedElement).isOutput() || ((IRfPortElement)namedElement).isInout()) && scopeElement instanceof IRfInstanceElement && PortConnectionUtils.isImplicitNamedConnected(context);
    }

    public static boolean isInputPortInImplicitNamedConnection(IRfNamedElement namedElement, IRfScopeElement scopeElement, HidOperator context) {
        return namedElement instanceof IRfPortElement && (((IRfPortElement)namedElement).isInput() || ((IRfPortElement)namedElement).isInout()) && scopeElement instanceof IRfInstanceElement && PortConnectionUtils.isImplicitNamedConnected(context);
    }

    public static IRfNamedElement getImplicitNamedElement(IRfNamedElement namedElement, IRfInstanceElement scopeElement) {
        IRfNamedElement enclosingDesign;
        IRfNamedElement iRfNamedElement = scopeElement.isInstanceToBind() ? scopeElement.getBindInstanceScope() : (enclosingDesign = scopeElement.getEnclosingScope() instanceof IRfNamedElement ? (IRfNamedElement)scopeElement.getEnclosingScope() : null);
        if (enclosingDesign == null) {
            return namedElement;
        }
        HashMap<IRfInstanceElement, Set<DummyPort>> dummyPortCache = new HashMap<IRfInstanceElement, Set<DummyPort>>();
        Map<IRfPortElement, Set<TCConnSignal>> portsWithSignals = DesignUtils.mapInstancePortConnections(DesignUtils.DesignRequest.of(scopeElement), dummyPortCache, HidFlatteningOption.ALL_EXCLUDED);
        if (portsWithSignals == null || portsWithSignals.isEmpty()) {
            return namedElement;
        }
        for (Map.Entry<IRfPortElement, Set<TCConnSignal>> portWithSignals : portsWithSignals.entrySet()) {
            Set<TCConnSignal> signals = portWithSignals.getValue();
            if (signals == null || signals.isEmpty()) continue;
            for (TCConnSignal tcConnSignal : signals) {
                IRfNamedElement signal;
                if (tcConnSignal.statement.cacheImplicitPortConnection == null || !((signal = DesignUtils.resolveSignal(tcConnSignal.signal, DesignUtils.DesignRequest.of(enclosingDesign), null, dummyPortCache)) instanceof IRfFieldElement) || !signal.getName().equals(namedElement.getName())) continue;
                return signal;
            }
        }
        return namedElement;
    }
}

