/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection.views;

import de.cau.cs.kieler.core.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BCDvtInit;
import ro.amiq.dvt.buildconfig.BCFileInstance;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.buildconfig.BuildConfigToken;
import ro.amiq.dvt.buildconfig.LanguageElementFileInstance;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.views.BCLanguageElement;
import ro.amiq.dvt.model.reflection.views.BCTreeElementWrapper;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.symbolcollector.ISymbolCollectorPrerequisite;
import ro.amiq.dvt.symbolcollector.SymbolCollectorConfigurator;
import ro.amiq.dvt.ui.guifilters.DVTCompileOrderGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.views.BCLabelProvider;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.ViewsUtilsCommon;
import ro.amiq.dvt.ui.views.compileorder.BaseCompileOrderViewContributor;
import ro.amiq.dvt.ui.views.compileorder.CompileOrderViewInput;
import ro.amiq.dvt.ui.views.compileorder.CompileOrderViewInputConfigurator;
import ro.amiq.dvt.ui.views.inspect.DVTInspectViewUtils;
import ro.amiq.dvt.ui.views.inspect.InspectViewInput;
import ro.amiq.dvt.ui.views.lazy.views.compileorder.CompileOrderView;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.StringMatcher;

public abstract class BCCompileOrderViewContributorCommon
extends BaseCompileOrderViewContributor {
    private BCLabelProvider fLabelProvider = new BCLabelProvider();

    @Override
    public LanguageKind getLanguageKind() {
        return LanguageKind.BC;
    }

    @Override
    public boolean adaptsTo(Object adapted) {
        return adapted instanceof BCTreeElementWrapper || adapted instanceof BCFileInstance;
    }

    @Override
    public DVTBaseLabelProvider getLabelProvider(Object wrapper) {
        return this.fLabelProvider;
    }

    @Override
    public String getComment(Object wrapper) {
        return null;
    }

    @Override
    public boolean isSelectable(Object wrapper, Object referenceData, StringMatcher matcher) {
        if (!(wrapper instanceof BCTreeElementWrapper)) {
            return false;
        }
        Object rfElement = ((IDVTElementWrapper)wrapper).getRfElement();
        if (rfElement == null) {
            return false;
        }
        if (rfElement instanceof BCLanguageElement) {
            return false;
        }
        return matcher == null || ViewsUtils.matchCamelCaseOrRegex(matcher, this.fLabelProvider.getText(wrapper));
    }

    @Override
    public void gotoImport(IProject project, IDVTElementWrapper wrapper) {
    }

    @Override
    public boolean canShowGotoIncludeMenu(IDVTElementWrapper element) {
        if (!(element instanceof BCTreeElementWrapper)) {
            return false;
        }
        BCTreeElementWrapper bcElem = (BCTreeElementWrapper)element;
        Object fileInstance = bcElem.getRfElement();
        return fileInstance instanceof BCFileInstance;
    }

    @Override
    public boolean canShowGotoImportMenu(IDVTElementWrapper element) {
        return false;
    }

    private BCCompileOrderInfo getCompileOrderData(BCTreeElementWrapper root, Collection<BCFileInstance> fileInstances, ArrayList<BCDvtInit> invocations, CompileOrderViewInputConfigurator configurator, CompileOrderViewInput input) {
        BCCompileOrderInfo result = new BCCompileOrderInfo();
        this.toWrappers(root, fileInstances, invocations, result, configurator, input);
        return result;
    }

    private void toWrappers(BCTreeElementWrapper root, Collection<BCFileInstance> fileInstances, ArrayList<BCDvtInit> invocations, BCCompileOrderInfo result, CompileOrderViewInputConfigurator configurator, CompileOrderViewInput input) {
        try {
            BCTreeElementWrapper child;
            if (fileInstances == null) {
                return;
            }
            for (BCFileInstance instance : fileInstances) {
                if (instance == null) continue;
                ++result.nofTotal;
                if (configurator.isCanceled()) {
                    return;
                }
                child = new BCTreeElementWrapper(instance);
                child.setProject(configurator.getProject());
                String text = this.getLabelProvider(child).getText(child);
                DVTGUIFilterMatcher.ITextProvider textProvider = () -> text;
                DVTGUIFilterMatcher.GUIFilterResult filterElement = DVTCompileOrderGUIFilterMatcher.filterElement(ViewSet.ViewName.COMPILE_ORDER, configurator.getProject(), instance, textProvider);
                if (filterElement != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                    if (!input.hasSearchedElementFiltered()) {
                        if (ViewsUtils.matchesPath(child, configurator.getView())) {
                            input.setHasSearchedElementFiltered(true);
                        } else {
                            input.setHasSearchedElementFiltered(this.hasFilteredSearchedLocalMember(instance, configurator.getView()));
                        }
                    }
                    input.setHasGUIFilteredElements(true);
                    --result.nofTotal;
                    continue;
                }
                root.addChild(child);
                this.toWrappers(child, instance.getBCChildren(), instance.getInvocations(), result, configurator, input);
            }
            if (invocations == null) {
                return;
            }
            result.nofInvocs += invocations.size();
            for (BCDvtInit invocation : invocations) {
                if (invocation == null) continue;
                if (configurator.isCanceled()) {
                    return;
                }
                child = new BCTreeElementWrapper(invocation);
                child.setProject(configurator.getProject());
                root.addChild(child);
                Map<LanguageKind, Pair<Integer, Integer>> languageElements = invocation.getLanguageElements();
                if (languageElements == null) continue;
                for (Map.Entry<LanguageKind, Pair<Integer, Integer>> entry : languageElements.entrySet()) {
                    LanguageKind languageKind = entry.getKey();
                    Pair<Integer, Integer> indexInterval = entry.getValue();
                    BCTreeElementWrapper languageChild = new BCTreeElementWrapper(new LanguageElementFileInstance(languageKind, (Integer)indexInterval.getFirst(), (Integer)indexInterval.getSecond()));
                    child.addChild(languageChild);
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private boolean hasFilteredSearchedLocalMember(BCFileInstance parentInstance, IRfFilterableTreeAccessor view) {
        List<BCFileInstance> childInstances = parentInstance.getBCChildren();
        if (childInstances.isEmpty()) {
            return false;
        }
        for (BCFileInstance instance : childInstances) {
            if (ViewsUtilsCommon.matchesPath(new BCTreeElementWrapper(instance), view)) {
                return true;
            }
            if (!this.hasFilteredSearchedLocalMember(instance, view)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CompileOrderViewInput getInput(CompileOrderViewInputConfigurator configurator) {
        try {
            CompileOrderViewInput input = CompileOrderViewInput.emptyInput();
            IRfFilterableTreeAccessor view = configurator.getView();
            if (!(view instanceof CompileOrderView)) {
                return input;
            }
            if (!((CompileOrderView)view).getShowBuildConfigArgFiles()) {
                return input;
            }
            IProject project = configurator.getProject();
            if (project == null || !project.isAccessible()) {
                return input;
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F636F7265")) {
                return input;
            }
            RfMixedLangManager.getInstance().getRfMixedLangProject(project, true);
            Map<String, BCFileInstance> parsedBCFiles = configurator.getParsedBCFiles();
            if (parsedBCFiles == null) {
                return input;
            }
            BCFileInstance topBCFileInstance = parsedBCFiles.get("default");
            if (topBCFileInstance == null) {
                return input;
            }
            BCTreeElementWrapper root = new BCTreeElementWrapper();
            BCCompileOrderInfo compileInfo = this.getCompileOrderData(root, Arrays.asList(topBCFileInstance), null, configurator, input);
            if (compileInfo.nofTotal == 0) {
                return CompileOrderViewInput.emptyInput();
            }
            input.setElementCount(compileInfo.nofTotal);
            ViewsUtils.hierarchicalSearch(root, this.fLabelProvider, configurator.getUpdateJob(), configurator.getSearchSegments(), configurator.getSearchStrictness());
            if (configurator.getSearchSegments() != null && configurator.getSearchSegments().length != 0) {
                this.countElements(root, configurator, input);
            } else {
                input.setNotFilteredElementCount(input.getElementCount());
            }
            compileInfo.nofFiltered = input.getNotFilteredElementCount();
            input.setTableInfo(compileInfo.toString());
            if (root.getChildren() != null) {
                input.getElements().addAll(root.getChildren());
            }
            return input;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return CompileOrderViewInput.emptyInput();
        }
    }

    private void countElements(IDVTElementWrapper root, CompileOrderViewInputConfigurator configurator, CompileOrderViewInput input) {
        if (root == null) {
            return;
        }
        if (root.getRfElement() instanceof BCFileInstance && root.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.MATCH) != null) {
            input.incrementNotFilteredElementCount();
        }
        if (!root.hasChildren()) {
            return;
        }
        List children = root.getChildren();
        for (IDVTElementWrapper child : children) {
            if (configurator.isCanceled()) {
                return;
            }
            this.countElements(child, configurator, input);
        }
    }

    @Override
    public void gotoInclude(IProject project, IDVTElementWrapper wrapper) {
        if (!(wrapper instanceof BCTreeElementWrapper)) {
            return;
        }
        BCTreeElementWrapper selectedElement = (BCTreeElementWrapper)wrapper;
        if (!(selectedElement.getRfElement() instanceof BCFileInstance)) {
            return;
        }
        BCFileInstance fileInstance = (BCFileInstance)selectedElement.getRfElement();
        BCTreeElementWrapper parentWrapper = selectedElement.getParent();
        if (parentWrapper == null) {
            return;
        }
        if (!(parentWrapper.getRfElement() instanceof BCFileInstance)) {
            return;
        }
        BCFileInstance parentFileInstance = (BCFileInstance)parentWrapper.getRfElement();
        if (parentFileInstance == null) {
            return;
        }
        List includeProps = BuildConfigManager.getIncludeProperties(project).stream().filter(property -> Path.fromOSString((String)property.getValue()).toOSString().equals(fileInstance.getFilePath())).collect(Collectors.toList());
        if (includeProps == null || includeProps.isEmpty()) {
            return;
        }
        BuildConfigToken includePropToken = null;
        for (BuildConfigProperty includeProp : includeProps) {
            String tokenFilePath;
            String filePath;
            BuildConfigToken tokenConfigFile = (BuildConfigToken)includeProp.getAttributes().get("ATTRIBUTE_TOKEN");
            if (tokenConfigFile == null || (filePath = Path.fromOSString((String)parentFileInstance.getFilePath()).toOSString()) == null || (tokenFilePath = Path.fromOSString((String)tokenConfigFile.getFilename()).toOSString()) == null || !filePath.equals(tokenFilePath)) continue;
            includePropToken = tokenConfigFile;
            break;
        }
        if (includePropToken == null) {
            return;
        }
        IFile buildFile = this.getBuildFile(project, includePropToken.getFilename());
        if (buildFile == null) {
            return;
        }
        this.gotoTopFile(buildFile, includePropToken.getOffset(), includePropToken.getLength());
    }

    @Override
    public List<ISymbolCollectorPrerequisite> getSymbolsPrerequisites(SymbolCollectorConfigurator configurator) {
        return null;
    }

    public InspectViewInput getInspectContent(IDVTElementWrapper wrapper) {
        IFile file;
        block7: {
            Object elem;
            block6: {
                block5: {
                    try {
                        if (wrapper instanceof BCTreeElementWrapper) break block5;
                        return null;
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        return null;
                    }
                }
                elem = wrapper.getRfElement();
                if (elem instanceof BCFileInstance) break block6;
                return null;
            }
            BCFileInstance bcFileInstance = (BCFileInstance)elem;
            file = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(wrapper.getProject(), bcFileInstance.getFilePath());
            if (file != null) break block7;
            return null;
        }
        return DVTInspectViewUtils.getInstance().processFile(file);
    }

    protected abstract IFile getBuildFile(IProject var1, String var2);

    protected abstract void gotoTopFile(IFile var1, int var2, int var3);

    private static class BCCompileOrderInfo {
        private int nofTotal;
        private int nofFiltered;
        private int nofInvocs;

        private BCCompileOrderInfo() {
        }

        public String toString() {
            if (this.nofTotal != this.nofFiltered) {
                return "[" + this.nofFiltered + "/" + this.nofTotal + " file" + (this.nofTotal > 1 ? "s" : "") + ", " + this.nofInvocs + " invocation" + (this.nofInvocs > 1 ? "s" : "") + "]";
            }
            return "[" + this.nofTotal + " file" + (this.nofTotal > 1 ? "s" : "") + ", " + this.nofInvocs + " invocation" + (this.nofInvocs > 1 ? "s" : "") + "]";
        }
    }
}

