/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BCDvtInit;
import ro.amiq.dvt.buildconfig.BCFileInstance;
import ro.amiq.dvt.model.reflection.BindingRuleWrapper;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.utils.DVTFileUtils;

public class BCTreeElementWrapper
extends IDVTElementWrapper {
    private static final int INITIAL_CAPACITY = 4;
    protected List<BCTreeElementWrapper> fChildren;
    private boolean fOverlayStatus;
    private boolean fAccessDecoratorEnable;
    private BCTreeElementWrapper fSelected;
    private BCTreeElementWrapper fParent;
    private boolean fGrayIcon;
    private Object fItem;
    private int fExpanded;
    private long uniqueID;
    private String fTreeName;
    private IRfNamedElement fInstanceType;
    private IRfNamedElement fComponent;
    private BindingRuleWrapper fBindResult;
    private IRfNamedElement fEntity;
    private Object fGoToElement;

    @Override
    public void addChild(IDVTElementWrapper child) {
        if (this.fChildren == null) {
            this.fChildren = new ArrayList<BCTreeElementWrapper>(4);
        }
        ((BCTreeElementWrapper)child).setParent(this);
        this.fChildren.add((BCTreeElementWrapper)child);
    }

    public BCTreeElementWrapper(Object element, boolean access) {
        super(element);
        this.fElement = element;
        this.fAccessDecoratorEnable = access;
    }

    public BCTreeElementWrapper(Object element) {
        super(element);
        this.fElement = element;
        this.fAccessDecoratorEnable = false;
    }

    public BCTreeElementWrapper() {
        super(null);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IResource.class) {
            if (this.fElement instanceof BCFileInstance) {
                return DVTFileUtils.getInstance().findProjectFile(this.getProject(), ((BCFileInstance)this.fElement).getParserPath().path);
            }
            if (this.fElement instanceof BCDvtInit) {
                return DVTFileUtils.getInstance().findProjectFile(this.getProject(), ((BCDvtInit)this.fElement).getParserPath().path);
            }
        }
        return null;
    }

    @Override
    public boolean getOverlayStatus() {
        return this.fOverlayStatus;
    }

    @Override
    public void setOverlayStatus(boolean status) {
        this.fOverlayStatus = status;
    }

    @Override
    public boolean getAccessDecoratorEnable() {
        return this.fAccessDecoratorEnable;
    }

    @Override
    public BCTreeElementWrapper getSelectedElement() {
        return this.fSelected;
    }

    @Override
    public void setSelectedElement(Object selected) {
        if (selected == null || selected instanceof BCTreeElementWrapper) {
            this.fSelected = (BCTreeElementWrapper)selected;
        }
    }

    protected void setParent(BCTreeElementWrapper parent) {
        this.fParent = parent;
    }

    @Override
    public void setParent(IDVTElementWrapper parent) {
        if (parent instanceof BCTreeElementWrapper || parent == null) {
            this.setParent((BCTreeElementWrapper)parent);
        }
    }

    @Override
    public BCTreeElementWrapper getParent() {
        return this.fParent;
    }

    public void setGrayIcon(boolean grayIcon) {
        this.fGrayIcon = grayIcon;
    }

    @Override
    public boolean isGrayIcon() {
        return this.fGrayIcon;
    }

    @Override
    public void setItem(Object item) {
        this.fItem = item;
    }

    @Override
    public Object getItem() {
        return this.fItem;
    }

    @Override
    public void setExpanded(int expanded) {
        this.fExpanded = expanded;
    }

    @Override
    public int getExpanded() {
        return this.fExpanded;
    }

    @Override
    public void setInstanceType(IRfDesignElement instanceType) {
        this.fInstanceType = instanceType;
    }

    @Override
    public IRfNamedElement getInstanceType() {
        return this.fInstanceType;
    }

    @Override
    public void setUniqueID(long id) {
        this.uniqueID = id;
    }

    @Override
    public long getUniqueID() {
        return this.uniqueID;
    }

    @Override
    public void setAssociatedElements(IRfNamedElement component, BindingRuleWrapper bindResult, IRfNamedElement entity) {
        this.fComponent = component;
        this.fBindResult = bindResult;
        this.fEntity = entity;
    }

    @Override
    public IRfNamedElement getConnectComponent() {
        return this.fComponent;
    }

    @Override
    public BindingRuleWrapper getConnectBind() {
        return this.fBindResult;
    }

    @Override
    public IRfNamedElement getConnectDesign() {
        return this.fEntity;
    }

    @Override
    public IDVTElementWrapper create() {
        BCTreeElementWrapper element = new BCTreeElementWrapper(this.fElement);
        element.setInstanceType((IRfDesignElement)this.fInstanceType);
        return element;
    }

    @Override
    public void deepClean() {
        if (this.fChildren != null) {
            for (BCTreeElementWrapper child : this.fChildren) {
                child.deepClean();
            }
        }
        this.fChildren = null;
        this.fParent = null;
        this.fSelected = null;
        this.fBindResult = null;
        this.fAdditionalInfo = null;
        this.fComponent = null;
        this.fElement = null;
        this.fEntity = null;
        this.fItem = null;
        this.fInstanceType = null;
        this.fProject = null;
    }

    public void setTreeName(String treeName) {
        this.fTreeName = treeName;
    }

    public String getTreeName() {
        return this.fTreeName;
    }

    public List<BCTreeElementWrapper> getChildren() {
        return this.fChildren;
    }

    @Override
    public IDVTElementWrapper getFirstChild() {
        return this.fChildren == null || this.fChildren.isEmpty() ? null : (IDVTElementWrapper)this.fChildren.get(0);
    }

    @Override
    public <T extends IDVTElementWrapper> void addChildren(List<T> children) {
        if (children == null || children.isEmpty()) {
            return;
        }
        for (IDVTElementWrapper elementWrapper : children) {
            this.addChild(elementWrapper);
        }
    }

    @Override
    public <T extends IDVTElementWrapper> void setChildren(List<T> children) {
        this.fChildren = children;
    }

    @Override
    public boolean hasChildren() {
        return this.fChildren != null && !this.fChildren.isEmpty();
    }

    @Override
    public void removeChild(IDVTElementWrapper child) {
        if (!this.hasChildren()) {
            return;
        }
        this.fChildren.remove(child);
    }

    @Override
    public IProject getProject() {
        if (this.fProject != null) {
            return this.fProject;
        }
        return super.getProject();
    }

    public String toString() {
        Object rfElement = this.getRfElement();
        return rfElement != null ? rfElement.toString() : "";
    }

    public Object getGoToElement() {
        return this.fGoToElement;
    }

    public void setGoToElement(Object fgoToElement) {
        this.fGoToElement = fgoToElement;
    }

    @Override
    public LanguageKind getLanguageKind() {
        return LanguageKind.BC;
    }

    @Override
    public boolean shouldHaveCustomColor() {
        return this.fElement instanceof BCDvtInit;
    }

    @Override
    public int getCustomColor() {
        if (this.fElement instanceof BCDvtInit) {
            return 9;
        }
        return 0;
    }
}

