/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection.views;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfEntityComplement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.model.reflection.views.DVTQuickViewersUtilCommon;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.DVTViewEvent;
import ro.amiq.dvt.ui.views.ViewDataContainer;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.designhierarchy.DHViewMessages;
import ro.amiq.dvt.ui.views.designhierarchy.DHViewUtils;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTModel;
import ro.amiq.dvt.ui.views.lazy.tree.IELModel;
import ro.amiq.dvt.ui.views.lazy.tree.LazyELTrimModel;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.utils.TreePathUtils;
import ro.amiq.dvt.ui.views.lazy.views.compileorder.CompileOrderView;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.AbstractElDesignHierarchyModel;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.DVTDHLabelProvider;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.LazyDesignHierarchyView;

public class DVTQuickViewersUtil
extends DVTQuickViewersUtilCommon {
    public static void updateErrorsInCompileOrder(IProject project) {
        if (project == null) {
            return;
        }
        final DVTViewEvent event = new DVTViewEvent(DVTViewEvent.EventKind.CUSTOM, null, new ViewDataContainer(project, null));
        event.setOverrideView(false);
        event.setCustomImplementation(new DVTViewEvent.CustomEventImplementation(){

            @Override
            public void run() {
                if (!(this.view instanceof CompileOrderView)) {
                    return;
                }
                ViewsUtils.updateView((CompileOrderView)this.view, null, false);
            }
        });
        Utils.safeRunSynchInUIThread(new Runnable(){

            @Override
            public void run() {
                ViewsUtils.notifyAllViewsById("ro.amiq.dvt.ui.views.CompileOrderView", event, false);
            }
        });
    }

    public static void updateRenameInCompileOrder(IProject project) {
        if (project == null) {
            return;
        }
        final DVTViewEvent event = new DVTViewEvent(DVTViewEvent.EventKind.CUSTOM, null, new ViewDataContainer(project, null));
        event.setOverrideView(false);
        event.setCustomImplementation(new DVTViewEvent.CustomEventImplementation(){

            @Override
            public void run() {
                if (!(this.view instanceof CompileOrderView)) {
                    return;
                }
                ViewsUtils.updateView((CompileOrderView)this.view, BuildEvents.INCREMENTAL_BUILD, false);
            }
        });
        Utils.safeRunSynchInUIThread(new Runnable(){

            @Override
            public void run() {
                ViewsUtils.notifyAllViewsById("ro.amiq.dvt.ui.views.CompileOrderView", event, false);
            }
        });
    }

    public static void openDesignHierarchyForElementAtCursor() {
        IRfNamedElement namedElement = DesignUtils.toGenericDesignElement(RfMixedLangManager.getInstance().getElementAtExactCursor());
        if (namedElement == null || DesignUtils.getDesignKind(namedElement) == IRfNamedElement.ElementKind.VHDL_COMPONENT) {
            DHViewUtils.popDialog(2, DHViewMessages.fDHPopUpDialogText);
            return;
        }
        IRfSingleLangProject rfProject = namedElement.getRfProject();
        if (rfProject == null) {
            return;
        }
        namedElement = RfMixedLangManager.getInstance().getNamedElementForDH(namedElement);
        DVTQuickViewersUtil.updateNewDesignHierarchyViewer(namedElement);
    }

    public static void updateNewDesignHierarchyViewer(IRfNamedElement topNamedElement) {
        if (!(topNamedElement instanceof IRfDesignElement || topNamedElement instanceof IRfInstanceElement || topNamedElement instanceof IRfEntityComplement)) {
            DHViewUtils.popDialog(2, DHViewMessages.fDHPopUpDialogText);
            return;
        }
        IRfSingleLangProject rfProject = topNamedElement.getRfProject();
        if (rfProject == null) {
            return;
        }
        IProject project = rfProject.getProject();
        if (project == null) {
            return;
        }
        DVTQuickViewersUtilCommon.DHTopArguments computeTop = DVTQuickViewersUtilCommon.computeTopArguments(project, topNamedElement);
        DVTQuickViewersUtil.updateNewDesignHierarchyViewer(computeTop.top, computeTop.configName);
    }

    public static void updateNewDesignHierarchyViewer(TreePath treePath, String configName) {
        if (treePath == null) {
            DHViewUtils.popDialog(2, DHViewMessages.fDHPopUpDialogText);
            return;
        }
        LazyDesignHierarchyView view = (LazyDesignHierarchyView)ViewsUtils.getViewById("ro.amiq.dvt.ui.views.LazyDesignHierarchyView", true);
        if (view == null) {
            return;
        }
        IRfNamedElement topNamedElement = treePath.getNamedElement();
        if (!(topNamedElement instanceof IRfDesignElement || topNamedElement instanceof IRfInstanceElement || topNamedElement instanceof IRfEntityComplement)) {
            DHViewUtils.popDialog(2, DHViewMessages.fDHPopUpDialogText);
            view.clean();
            return;
        }
        view.resetForTop(treePath);
    }

    public static void revealInDesignHierarchyView(final TreePath treePath) {
        if (treePath == null) {
            DHViewUtils.popRevealDialog(2, DHViewMessages.fDHPopUpDialogText);
            return;
        }
        final LazyDesignHierarchyView view = (LazyDesignHierarchyView)ViewsUtils.getViewById("ro.amiq.dvt.ui.views.LazyDesignHierarchyView", true);
        if (view == null) {
            return;
        }
        final IRfNamedElement topNamedElement = treePath.getNamedElement();
        if (!(topNamedElement instanceof IRfDesignElement || topNamedElement instanceof IRfInstanceElement || topNamedElement instanceof IRfEntityComplement)) {
            DHViewUtils.popRevealDialog(2, DHViewMessages.fDHPopUpDialogText);
            view.clean();
            return;
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                boolean[] isSearchFilteredElement = DVTQuickViewersUtil.isSearchFilteredElement(treePath, view);
                boolean shouldStopRevealAction = isSearchFilteredElement[0];
                boolean showPopUp = isSearchFilteredElement[1];
                if (shouldStopRevealAction) {
                    if (showPopUp) {
                        DHViewUtils.popRevealDialog(2, DHViewMessages.fDHPopUpDialogSearchFilteredText);
                    }
                    return;
                }
                if (DVTQuickViewersUtil.isFilteredGenerate(treePath, topNamedElement, view)) {
                    DHViewUtils.popRevealDialog(2, DHViewMessages.fDHPopUpDialogGenerateFilteredText);
                    return;
                }
                Display.getDefault().asyncExec(() -> view.revealInDesignHierarchyView(treePath));
            }
        };
        thread.start();
    }

    private static boolean[] isSearchFilteredElement(TreePath treePath, LazyDesignHierarchyView view) {
        boolean[] resultElementNotFiltered = new boolean[2];
        boolean[] resultElementFiltered = new boolean[]{true, true};
        if (!view.isFiltered()) {
            return resultElementNotFiltered;
        }
        boolean matchesPath = ViewsUtils.matchesPath(treePath, view.getLabelProvider(), view.getTreeSearchSegments(), view.getTreeSearchStrictness(), null, view.getViewColumnCount());
        if (matchesPath) {
            return resultElementNotFiltered;
        }
        if (view.isMatched(treePath)) {
            return resultElementNotFiltered;
        }
        ElementPath elementPath = TreePathUtils.getElementPathFromTreePath(treePath);
        IProject project = view.getProject();
        if (project == null) {
            return resultElementFiltered;
        }
        RfMixedLangProject mixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false);
        if (mixedLangProject == null) {
            return resultElementFiltered;
        }
        ELManager manager = mixedLangProject.getELManager();
        if (manager == null) {
            return resultElementFiltered;
        }
        IELMemory elMemory = manager.getMemory();
        Map<ElementPath, ELInstance> nextElInstances = elMemory.subtreeOf(elementPath, true);
        if (nextElInstances == null || nextElInstances.isEmpty()) {
            return resultElementFiltered;
        }
        TreePath crtTreePath = treePath;
        long startTimeMillis = System.currentTimeMillis();
        boolean checkTimeout = true;
        for (ELInstance elInstance : nextElInstances.values()) {
            if (ViewsUtils.matchesPath(crtTreePath = TreePathUtils.getTreePathFromELInstance(crtTreePath, elInstance, manager, view.getModel(IELModel.class) instanceof LazyELTrimModel, (IProgressMonitor)new NullProgressMonitor()), view.getLabelProvider(), view.getTreeSearchSegments(), view.getTreeSearchStrictness(), null, view.getViewColumnCount())) {
                return resultElementNotFiltered;
            }
            if (!checkTimeout || System.currentTimeMillis() - startTimeMillis <= 500L) continue;
            AtomicBoolean shouldStop = new AtomicBoolean(false);
            Display.getDefault().syncExec(() -> {
                MessageDialog ms = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), DHViewMessages.fDHRevealPopUpDialogTitle, null, DHViewMessages.fDHPopUpDialogSearchMaybeFilteredText, 2, new String[]{IDialogConstants.CANCEL_LABEL, IDialogConstants.OK_LABEL}, 0);
                int option = ms.open();
                if (option == 0) {
                    shouldStop.set(true);
                    return;
                }
            });
            if (shouldStop.get()) {
                boolean[] blArray = new boolean[2];
                blArray[0] = true;
                return blArray;
            }
            checkTimeout = false;
        }
        return resultElementFiltered;
    }

    private static boolean isFilteredGenerate(TreePath treePath, IRfNamedElement topNamedElement, LazyDesignHierarchyView view) {
        boolean isGenerate;
        IProject project = view.getProject();
        if (project == null) {
            return false;
        }
        RfMixedLangProject mixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false);
        if (mixedLangProject == null) {
            return false;
        }
        IDVTModel model = view.getModel(IELModel.class);
        if (!(model instanceof AbstractElDesignHierarchyModel)) {
            return false;
        }
        ILabelProvider labelProvider = view.getLabelProvider();
        boolean hideGenerates = labelProvider instanceof DVTDHLabelProvider && ((DVTDHLabelProvider)labelProvider).getHideGenerates();
        boolean bl = isGenerate = topNamedElement instanceof IRfDesignElement && ((IRfDesignElement)topNamedElement).getKind() == IRfNamedElement.ElementKind.VLOG_GENERATE;
        return isGenerate && hideGenerates && !((AbstractElDesignHierarchyModel)model).hasInstanceChildren(treePath, mixedLangProject.getELManager());
    }
}

