/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.nature;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.nature.DVTNatureContributorAdapter;
import ro.amiq.dvt.nature.INatureContributor;
import ro.amiq.dvt.startup.core.DVTLogger;

public class NatureContributors {
    private static final String EXTENSION_POINT_ID = "ro.amiq.dvt.changeNatureContributors";
    private static final List<INatureContributor> CONTRIBUTORS;

    static {
        IConfigurationElement[] elements;
        CONTRIBUTORS = new LinkedList<INatureContributor>();
        CONTRIBUTORS.add(new DVTNatureContributorAdapter(LanguageKind.E));
        CONTRIBUTORS.add(new DVTNatureContributorAdapter(LanguageKind.VLOG));
        CONTRIBUTORS.add(new DVTNatureContributorAdapter(LanguageKind.VHDL));
        CONTRIBUTORS.add(new DVTNatureContributorAdapter(LanguageKind.SLN));
        CONTRIBUTORS.add(new DVTNatureContributorAdapter(LanguageKind.MSDL));
        CONTRIBUTORS.add(new DVTNatureContributorAdapter(LanguageKind.PSS));
        CONTRIBUTORS.add(new DVTNatureContributorAdapter(LanguageKind.PF));
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        if (extensionRegistry != null && (elements = extensionRegistry.getConfigurationElementsFor(EXTENSION_POINT_ID)) != null) {
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                Object contributor = null;
                try {
                    contributor = element.createExecutableExtension("class");
                    if (contributor != null && contributor instanceof INatureContributor) {
                        CONTRIBUTORS.add((INatureContributor)contributor);
                    }
                }
                catch (CoreException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                ++n2;
            }
        }
    }

    public static List<INatureContributor> getContributors() {
        return CONTRIBUTORS;
    }

    public static INatureContributor getContributor(LanguageKind languageKind) {
        if (languageKind == null) {
            return null;
        }
        for (INatureContributor contributor : CONTRIBUTORS) {
            if (!languageKind.toString().equals(contributor.getLangName())) continue;
            return contributor;
        }
        return null;
    }
}

