/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.node;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import ro.amiq.dvt.node.NodeBinaryProvider;
import ro.amiq.dvt.node.NodeJSConfiguration;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTDeleteOnExit;
import ro.amiq.dvt.utils.DVTUtilsCommon;

public class NodeJSThread
extends Thread {
    private Process nodeProcess;
    private NodeJSConfiguration config;
    private File logFile;
    private BufferedWriter bufferedLogWriter;
    private volatile boolean shouldStop;

    NodeJSThread(NodeJSConfiguration config) {
        super(config.getId());
        this.config = config;
    }

    @Override
    public void run() {
        try {
            ArrayList<String> arguments = new ArrayList<String>();
            arguments.add(NodeBinaryProvider.getPath());
            arguments.addAll(this.config.getArguments());
            if (this.config.getLogFilePath() != null) {
                this.logFile = new File(this.config.getLogFilePath());
            }
            this.registerShutdownHooks();
            boolean shouldAttemptRestart = true;
            int retryNumber = 0;
            while (!this.shouldStop && shouldAttemptRestart && retryNumber <= this.config.getMaxNofRestartRetries()) {
                this.exponentialBackoff(retryNumber);
                ProcessBuilder processBuilder = new ProcessBuilder(arguments).redirectErrorStream(true);
                this.nodeProcess = processBuilder.start();
                this.config.afterStart();
                this.processNodeOutput();
                int exitCode = this.nodeProcess.waitFor();
                if (exitCode == 0 || this.shouldStop) {
                    return;
                }
                shouldAttemptRestart = this.config.onKilled();
                if (this.bufferedLogWriter != null) {
                    this.bufferedLogWriter.flush();
                }
                ++retryNumber;
            }
        }
        catch (Exception ex) {
            this.config.onException(ex);
        }
    }

    private void exponentialBackoff(int retryNumber) {
        if (retryNumber <= 1) {
            return;
        }
        try {
            long retryDelay = 1 << retryNumber - 2;
            Thread.sleep(1000L * retryDelay);
        }
        catch (InterruptedException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void processNodeOutput() {
        try {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (BufferedReader outputReader = new BufferedReader(new InputStreamReader(this.nodeProcess.getInputStream(), StandardCharsets.UTF_8));){
                    String line;
                    if (this.logFile != null) {
                        this.bufferedLogWriter = new BufferedWriter(new FileWriter(this.logFile, true));
                    }
                    while ((line = outputReader.readLine()) != null && !this.shouldStop && this.nodeProcess.isAlive()) {
                        try {
                            this.config.processOutputLine(line);
                            if (this.bufferedLogWriter == null || this.config.shouldSkipLogLine(line)) continue;
                            this.bufferedLogWriter.write(line);
                            this.bufferedLogWriter.newLine();
                        }
                        catch (Exception e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                DVTUtilsCommon.INSTANCE.closeClosable(this.bufferedLogWriter);
                this.bufferedLogWriter = null;
            }
        }
        finally {
            DVTUtilsCommon.INSTANCE.closeClosable(this.bufferedLogWriter);
            this.bufferedLogWriter = null;
        }
    }

    private void registerShutdownHooks() {
        DVTDeleteOnExit.INSTANCE.registerFile(this.logFile);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                NodeJSThread.this.shouldStop = true;
                if (NodeJSThread.this.nodeProcess != null && NodeJSThread.this.nodeProcess.isAlive()) {
                    NodeJSThread.this.nodeProcess.destroyForcibly();
                }
            }
        });
    }

    public File getAndFlushLogFile() {
        if (this.bufferedLogWriter != null) {
            try {
                this.bufferedLogWriter.flush();
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return this.logFile;
    }
}

