/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.optimized.collections;

import java.util.Iterator;

public interface ListContainer<T>
extends Iterable<T> {
    public static final ListContainer EMPTY_CONTAINER = new ListContainer(){

        public Object internalThis() {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int size() {
            return 0;
        }

        public Object get(int index) {
            throw new RuntimeException("Unsupported opperation");
        }
    };

    default public boolean isEmpty() {
        return false;
    }

    @Override
    default public Iterator<T> iterator() {
        return new OneValueIterator<T>(this.internalThis());
    }

    public T internalThis();

    public static <K> ListContainer<K> emptyContainer() {
        return EMPTY_CONTAINER;
    }

    default public int size() {
        return 1;
    }

    default public T get(int index) {
        if (index < 0 || index > 0) {
            throw new RuntimeException("Unsupported opperation");
        }
        return this.internalThis();
    }

    public static class OneValueIterator<T>
    implements Iterator<T> {
        protected boolean hasNext;
        private T element;

        public OneValueIterator(T element) {
            this.element = element;
            this.hasNext = element != null;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public void remove() {
            throw new RuntimeException("Unsupported opperation");
        }

        @Override
        public T next() {
            if (!this.hasNext) {
                throw new RuntimeException("Unsupported opperation");
            }
            this.hasNext = false;
            return this.element;
        }
    }
}

