/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.optimized.collections.fast;

import java.util.Map;
import java.util.Objects;
import ro.amiq.dvt.optimized.collections.fast.AbstractHMap;

public class BaseHSet<V>
extends AbstractHMap<V, V> {
    private static final long serialVersionUID = 1L;

    public BaseHSet(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    AbstractHMap.Node<V, V> newNode(int hash, V key, V value, AbstractHMap.Node<V, V> next) {
        return new SetNode<V>(hash, key, value, next);
    }

    @Override
    AbstractHMap.Node<V, V> replacementNode(AbstractHMap.Node<V, V> p, AbstractHMap.Node<V, V> next) {
        return new SetNode(p.hash, p.getKey(), p.getValue(), next);
    }

    @Override
    AbstractHMap.TreeNode<V, V> newTreeNode(int hash, V key, V value, AbstractHMap.Node<V, V> next) {
        return new SetTreeNode<V>(hash, key, value, next);
    }

    @Override
    AbstractHMap.TreeNode<V, V> replacementTreeNode(AbstractHMap.Node<V, V> p, AbstractHMap.Node<V, V> next) {
        return new SetTreeNode(p.hash, p.getKey(), p.getValue(), next);
    }

    public static class SetNode<V>
    extends AbstractHMap.Node<V, V> {
        V value;

        SetNode(int hash, V key, V value, AbstractHMap.Node<V, V> next) {
            super(hash, key, value, next);
            this.value = value;
        }

        @Override
        public final V getKey() {
            return this.value;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        public final String toString() {
            return this.value + "=" + this.value;
        }

        @Override
        public final int hashCode() {
            return Objects.hashCode(this.value);
        }

        @Override
        public final V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            Map.Entry e;
            if (o == this) {
                return true;
            }
            return o instanceof Map.Entry && Objects.equals(this.value, (e = (Map.Entry)o).getValue());
        }
    }

    public static class SetTreeNode<V>
    extends AbstractHMap.TreeNode<V, V> {
        V value;

        SetTreeNode(int hash, V key, V value, AbstractHMap.Node<V, V> next) {
            super(hash, key, value, next);
            this.value = value;
        }

        @Override
        public final V getKey() {
            return this.value;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        public final String toString() {
            return this.value + "=" + this.value;
        }

        @Override
        public final int hashCode() {
            return Objects.hashCode(this.value);
        }

        @Override
        public final V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            Map.Entry e;
            if (o == this) {
                return true;
            }
            return o instanceof Map.Entry && Objects.equals(this.value, (e = (Map.Entry)o).getValue());
        }
    }
}

