/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.optimized.collections.fast;

import java.util.Map;
import java.util.Objects;
import ro.amiq.dvt.optimized.collections.fast.AbstractHMap;
import ro.amiq.dvt.optimized.collections.fast.AbstractLHMap;

public class BaseLinkedHSet<V>
extends AbstractLHMap<V, V> {
    private static final long serialVersionUID = 1L;

    public BaseLinkedHSet(int initialCapacity) {
        super(initialCapacity);
    }

    public V getLastValue() {
        return this.tail == null ? null : (V)this.tail.getValue();
    }

    @Override
    AbstractHMap.Node<V, V> newNode(int hash, V key, V value, AbstractHMap.Node<V, V> next) {
        KeylessNode<V> p = new KeylessNode<V>(hash, key, value, next);
        this.linkNodeLast(p);
        return p;
    }

    @Override
    AbstractHMap.Node<V, V> replacementNode(AbstractHMap.Node<V, V> p, AbstractHMap.Node<V, V> next) {
        AbstractLHMap.Entry q = (AbstractLHMap.Entry)p;
        KeylessNode t = new KeylessNode(q.hash, q.getKey(), q.getValue(), next);
        this.transferLinks(q, t);
        return t;
    }

    @Override
    AbstractHMap.TreeNode<V, V> newTreeNode(int hash, V key, V value, AbstractHMap.Node<V, V> next) {
        KeylessTreeNode<V> p = new KeylessTreeNode<V>(hash, key, value, next);
        this.linkNodeLast(p);
        return p;
    }

    @Override
    AbstractHMap.TreeNode<V, V> replacementTreeNode(AbstractHMap.Node<V, V> p, AbstractHMap.Node<V, V> next) {
        AbstractLHMap.Entry q = (AbstractLHMap.Entry)p;
        KeylessTreeNode t = new KeylessTreeNode(q.hash, q.getKey(), q.getValue(), next);
        this.transferLinks(q, t);
        return t;
    }

    public static class KeylessNode<V>
    extends AbstractLHMap.Entry<V, V> {
        V value;

        KeylessNode(int hash, V key, V value, AbstractHMap.Node<V, V> next) {
            super(hash, key, value, next);
            this.value = value;
        }

        @Override
        public final V getKey() {
            return this.value;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        public final String toString() {
            return this.value + "=" + this.value;
        }

        @Override
        public final int hashCode() {
            return Objects.hashCode(this.value);
        }

        @Override
        public final V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                if (Objects.equals(this.getKey(), e.getKey()) && Objects.equals(this.value, e.getValue())) {
                    return true;
                }
            }
            return false;
        }
    }

    public static class KeylessTreeNode<V>
    extends AbstractHMap.TreeNode<V, V> {
        V value;

        KeylessTreeNode(int hash, V key, V value, AbstractHMap.Node<V, V> next) {
            super(hash, key, value, next);
            this.value = value;
        }

        @Override
        public final V getKey() {
            return this.value;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        public final String toString() {
            return this.value + "=" + this.value;
        }

        @Override
        public final int hashCode() {
            return Objects.hashCode(this.value);
        }

        @Override
        public final V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                if (Objects.equals(this.getKey(), e.getKey()) && Objects.equals(this.value, e.getValue())) {
                    return true;
                }
            }
            return false;
        }
    }
}

