/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.optimized.collections.fast;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import ro.amiq.dvt.optimized.collections.ExtendedSet;
import ro.amiq.dvt.optimized.collections.fast.BaseHSet;

public class HSet<V>
implements ExtendedSet<V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private BaseHSet<V> set;

    public HSet(int initialCapacity) {
        this.set = new BaseHSet(initialCapacity);
    }

    @Override
    public V get(V key) {
        return this.set.get(key);
    }

    @Override
    public boolean add(V e) {
        return this.set.put(e, e) == null;
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        if (c == null || c.isEmpty()) {
            return false;
        }
        boolean result = false;
        for (V e : c) {
            result |= this.add(e);
        }
        return result;
    }

    @Override
    public boolean contains(Object o) {
        return this.set.containsKey(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.containsAll(c);
    }

    @Override
    public Iterator<V> iterator() {
        return this.set.keySet().iterator();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.set.keySet().removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.set.keySet().retainAll(c);
    }

    @Override
    public Object[] toArray() {
        return this.set.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.set.keySet().toArray(a);
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        return this.set.remove(o) != null;
    }

    @Override
    public int size() {
        return this.set.size();
    }

    public V addIfAbsent(V e) {
        V result = this.set.putIfAbsent(e, e);
        if (result != null) {
            return result;
        }
        return e;
    }
}

