/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.optimized.collections.fast;

import java.util.Map;
import java.util.Objects;
import ro.amiq.dvt.optimized.collections.fast.AbstractHMap;
import ro.amiq.dvt.utils.IDVTMapElement;

public class KHMap<K, V extends IDVTMapElement<K>>
extends AbstractHMap<K, V> {
    private static final long serialVersionUID = 1L;

    @Override
    AbstractHMap.Node<K, V> newNode(int hash, K key, V value, AbstractHMap.Node<K, V> next) {
        return new KeylessNode<K, V>(hash, key, value, next);
    }

    @Override
    AbstractHMap.Node<K, V> replacementNode(AbstractHMap.Node<K, V> p, AbstractHMap.Node<K, V> next) {
        return new KeylessNode(p.hash, p.getKey(), (IDVTMapElement)p.getValue(), next);
    }

    @Override
    AbstractHMap.TreeNode<K, V> newTreeNode(int hash, K key, V value, AbstractHMap.Node<K, V> next) {
        return new KeylessTreeNode<K, V>(hash, key, value, next);
    }

    @Override
    AbstractHMap.TreeNode<K, V> replacementTreeNode(AbstractHMap.Node<K, V> p, AbstractHMap.Node<K, V> next) {
        return new KeylessTreeNode(p.hash, p.getKey(), (IDVTMapElement)p.getValue(), next);
    }

    public static class KeylessNode<K, V extends IDVTMapElement<K>>
    extends AbstractHMap.Node<K, V> {
        V value;

        KeylessNode(int hash, K key, V value, AbstractHMap.Node<K, V> next) {
            super(hash, key, value, next);
            this.value = value;
        }

        @Override
        public final K getKey() {
            return this.value.getKey();
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        public final String toString() {
            return this.getKey() + "=" + this.value;
        }

        @Override
        public final int hashCode() {
            return Objects.hashCode(this.getKey()) ^ Objects.hashCode(this.value);
        }

        @Override
        public final V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            Map.Entry e;
            if (o == this) {
                return true;
            }
            return o instanceof Map.Entry && Objects.equals(this.value, (e = (Map.Entry)o).getValue());
        }
    }

    public static class KeylessTreeNode<K, V extends IDVTMapElement<K>>
    extends AbstractHMap.TreeNode<K, V> {
        V value;

        KeylessTreeNode(int hash, K key, V value, AbstractHMap.Node<K, V> next) {
            super(hash, key, value, next);
            this.value = value;
        }

        @Override
        public final K getKey() {
            return this.value.getKey();
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        public final String toString() {
            return this.getKey() + "=" + this.value;
        }

        @Override
        public final int hashCode() {
            return Objects.hashCode(this.getKey()) ^ Objects.hashCode(this.value);
        }

        @Override
        public final V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            Map.Entry e;
            if (o == this) {
                return true;
            }
            return o instanceof Map.Entry && Objects.equals(this.value, (e = (Map.Entry)o).getValue());
        }
    }
}

