/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.optimized.collections.fast;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import ro.amiq.dvt.optimized.collections.ExtendedSet;
import ro.amiq.dvt.optimized.collections.fast.BaseLinkedHSet;

public class LinkedHSet<V>
implements Set<V>,
ExtendedSet<V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private BaseLinkedHSet<V> set;

    public LinkedHSet(int initialCapacity) {
        this.set = new BaseLinkedHSet(initialCapacity);
    }

    @Override
    public V get(V key) {
        return (V)this.set.get(key);
    }

    @Override
    public boolean add(V e) {
        return this.set.put(e, e) == null;
    }

    public void removeAdd(V e) {
        int hash = this.set.hash(e);
        this.set.removeNode(hash, e, null, false, true);
        this.set.putVal(hash, e, e, false, true);
    }

    public void removeAddAll(Collection<? extends V> c) {
        if (c == null || c.isEmpty()) {
            return;
        }
        for (V e : c) {
            this.removeAdd(e);
        }
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        if (c == null || c.isEmpty()) {
            return false;
        }
        boolean result = false;
        for (V e : c) {
            result |= this.add(e);
        }
        return result;
    }

    @Override
    public boolean contains(Object o) {
        return this.set.containsKey(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.containsAll(c);
    }

    @Override
    public Iterator<V> iterator() {
        return this.set.keySet().iterator();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.set.keySet().removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.set.keySet().retainAll(c);
    }

    @Override
    public Object[] toArray() {
        return this.set.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.set.keySet().toArray(a);
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        return this.set.remove(o) != null;
    }

    @Override
    public int size() {
        return this.set.size();
    }
}

