/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.optimized.collections.fast;

import java.util.Map;
import java.util.Objects;
import ro.amiq.dvt.optimized.collections.fast.AbstractHMap;
import ro.amiq.dvt.optimized.collections.fast.AbstractLHMap;
import ro.amiq.dvt.utils.IDVTMapElement;

public class LinkedKHMap<K, V extends IDVTMapElement<K>>
extends AbstractLHMap<K, V> {
    private static final long serialVersionUID = 1L;

    public LinkedKHMap() {
    }

    public LinkedKHMap(int initialCapacity) {
        super(initialCapacity);
    }

    public LinkedKHMap(Map<? extends K, ? extends V> m) {
        super(m);
    }

    @Override
    AbstractHMap.Node<K, V> newNode(int hash, K key, V value, AbstractHMap.Node<K, V> e) {
        KeylessNode<K, V> p = new KeylessNode<K, V>(hash, key, value, e);
        this.linkNodeLast(p);
        return p;
    }

    @Override
    AbstractHMap.Node<K, V> replacementNode(AbstractHMap.Node<K, V> p, AbstractHMap.Node<K, V> next) {
        AbstractLHMap.Entry q = (AbstractLHMap.Entry)p;
        KeylessNode t = new KeylessNode(q.hash, q.getKey(), (IDVTMapElement)q.getValue(), next);
        this.transferLinks(q, t);
        return t;
    }

    @Override
    AbstractHMap.TreeNode<K, V> newTreeNode(int hash, K key, V value, AbstractHMap.Node<K, V> next) {
        KeylessTreeNode<K, V> p = new KeylessTreeNode<K, V>(hash, key, value, next);
        this.linkNodeLast(p);
        return p;
    }

    @Override
    AbstractHMap.TreeNode<K, V> replacementTreeNode(AbstractHMap.Node<K, V> p, AbstractHMap.Node<K, V> next) {
        AbstractLHMap.Entry q = (AbstractLHMap.Entry)p;
        KeylessTreeNode t = new KeylessTreeNode(q.hash, q.getKey(), (IDVTMapElement)q.getValue(), next);
        this.transferLinks(q, t);
        return t;
    }

    public static class KeylessNode<K, V extends IDVTMapElement<K>>
    extends AbstractLHMap.Entry<K, V> {
        V value;

        KeylessNode(int hash, K key, V value, AbstractHMap.Node<K, V> next) {
            super(hash, key, value, next);
            this.value = value;
        }

        @Override
        public final K getKey() {
            return this.value.getKey();
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        public final String toString() {
            return this.getKey() + "=" + this.value;
        }

        @Override
        public final int hashCode() {
            return Objects.hashCode(this.getKey()) ^ Objects.hashCode(this.value);
        }

        @Override
        public final V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                if (Objects.equals(this.getKey(), e.getKey()) && Objects.equals(this.value, e.getValue())) {
                    return true;
                }
            }
            return false;
        }
    }

    public static class KeylessTreeNode<K, V extends IDVTMapElement<K>>
    extends AbstractHMap.TreeNode<K, V> {
        V value;

        KeylessTreeNode(int hash, K key, V value, AbstractHMap.Node<K, V> next) {
            super(hash, key, value, next);
            this.value = value;
        }

        @Override
        public final K getKey() {
            return this.value.getKey();
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        public final String toString() {
            return this.getKey() + "=" + this.value;
        }

        @Override
        public final int hashCode() {
            return Objects.hashCode(this.getKey()) ^ Objects.hashCode(this.value);
        }

        @Override
        public final V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                if (Objects.equals(this.getKey(), e.getKey()) && Objects.equals(this.value, e.getValue())) {
                    return true;
                }
            }
            return false;
        }
    }
}

