/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.AutoLinkRoot;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.DVTPowerFormatBCInfo;
import ro.amiq.dvt.buildconfig.DVTPowerFormatKind;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.builders.DVTAutoLinkManager;
import ro.amiq.dvt.builders.DVTBuildConsole;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.core.DVTNature;
import ro.amiq.dvt.model.AbstractBuildContributor;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalNotificationTracker;
import ro.amiq.dvt.model.problems.DVTProblemCategory;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.problems.PFProblemCategories;
import ro.amiq.dvt.model.problems.TclProblemCategories;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.power.format.DVTPFInterp;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.power.format.cpf.DVTCPFInterp;
import ro.amiq.dvt.power.format.upf.DVTUPFInterp;
import ro.amiq.dvt.resources.properties.PropertiesManager;
import ro.amiq.dvt.resources.properties.PropertyTypes;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.decorators.DVTAbstractDecorator;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbUtils;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdater;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdaterRegistry;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.DVTViewManager;
import ro.amiq.dvt.ui.views.TreeViewContentProvider;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.LazyDesignHierarchyView;
import ro.amiq.dvt.ui.views.power.domain.PowerDomainView;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.benchmark.StopWatch;

public class DVTPFBuildContributor
extends AbstractBuildContributor {
    private static final String PF_BUILDER_CALLER_NAME = "Power Format Builder";
    private List<IFile> fParsedResources = new ArrayList<IFile>();
    private boolean fAutoLinkedResourcesEnable;
    private Map<String, AutoLinkRoot> fAutoLinkedRoots;
    private IProgressMonitor monitor;
    boolean hasPfChanged;

    static {
        DVTProblemsUiUpdaterRegistry.register(new DVTProblemsUiUpdater(PFProblemCategories.PF_PROBLEM));
        DVTProblemsUiUpdaterRegistry.register(new DVTProblemsUiUpdater(TclProblemCategories.TCL_PROBLEM));
    }

    @Override
    public IProject[] build(int kind, Map args, IProgressMonitor monitor, Map<LanguageKind, Set<FileCompileInfo>> changedFiles) throws CoreException {
        this.monitor = monitor;
        DVTPFModel pfmodel = this.getPfmodel();
        if (pfmodel != null) {
            pfmodel.setBuildKind(kind);
        }
        if (kind != 6) {
            this.cleanInternal(this.hasPfChanged);
            this.hasPfChanged = false;
        }
        return null;
    }

    @Override
    public void clean(IProgressMonitor monitor) throws CoreException {
        this.cleanInternal(true);
    }

    private void cleanInternal(boolean hasPfChanged) {
        DVTPFBuildContributor.deleteMarkersAndProperties(this.getProject(), hasPfChanged);
        try {
            DVTPFModel pfModel = this.getPfmodel();
            if (pfModel == null) {
                return;
            }
            pfModel.clear();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static void deleteMarkersAndProperties(IProject project, boolean hasPfChanged) {
        DVTPFBuildContributor.deleteMarkersAndProperties(project, PFProblemCategories.PF_PROBLEM);
        if (hasPfChanged) {
            DVTPFBuildContributor.deleteMarkersAndProperties(project, TclProblemCategories.TCL_PROBLEM);
        }
    }

    private static void deleteMarkersAndProperties(IProject project, DVTProblemCategory problemCategory) {
        try {
            DVTProblemsUiUpdaterRegistry.get(problemCategory.getId()).resetNofMarkers(project);
            project.deleteMarkers(problemCategory.getMarkerId(), true, 2);
            DVTProblemManager.getInstance().removeProblemsWithCategory(project, problemCategory);
            final ArrayList refreshList = new ArrayList();
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (PropertiesManager.getSessionProperty(resource, PropertyTypes.QN_IMPORTED_FILE) != null) {
                        refreshList.add(resource);
                        return true;
                    }
                    return false;
                }
            });
            DVTAbstractDecorator.refresh("ro.amiq.dvt.CompiledFileDecorator", refreshList.toArray());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void postMixedLangBuild(IProject project, int buildKind) {
        DVTBuildConsole console = DVTBuildConsoleRegistry.getConsole(project);
        String displayName = this.getDisplayName();
        if (6 == buildKind) {
            console.printSection("Start " + displayName + " build");
        }
        String stopwatchTag = "[BUILD] " + this.getDisplayName();
        StopWatch.reset(stopwatchTag).start();
        try {
            this.interpretAndExecute(project, buildKind);
            this.updateDHView();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        StopWatch.stop(stopwatchTag);
        String timeFormatted = StopWatch.timeFormatted(stopwatchTag);
        String message = "Done " + displayName + " build [" + timeFormatted + "]";
        if (6 == buildKind) {
            console.printSection(message);
        } else {
            DVTLogger.INSTANCE.logInfo("[POWER FORMAT] " + message);
        }
    }

    private void interpretAndExecute(IProject project, int buildKind) throws CoreException {
        if (project == null) {
            return;
        }
        DVTProblemManager.getInstance().removeProblemsWithCategory(this.getProject(), PFProblemCategories.PF_PROBLEM);
        RfMixedLangProject mixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false);
        if (mixedLangProject == null) {
            return;
        }
        List<IRfDesignElement> allTops = mixedLangProject.getAllSelectedTops();
        if (allTops == null || allTops.isEmpty()) {
            return;
        }
        DVTPFModel pfModel = null;
        try {
            try {
                pfModel = this.interpretAndExecuteInternal(allTops, buildKind);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                mixedLangProject.setPFModel(pfModel);
                return;
            }
        }
        catch (Throwable throwable) {
            mixedLangProject.setPFModel(pfModel);
            throw throwable;
        }
        mixedLangProject.setPFModel(pfModel);
        if (pfModel == null) {
            return;
        }
        FIncrementalNotificationTracker.INSTANCE.removePFDirtyReason(project);
        this.fAutoLinkedResourcesEnable = BuildConfigManager.isAutoLinkedResources(project);
        this.fAutoLinkedRoots = BuildConfigManager.getAutoLinkedRoots(project);
        this.markDirtyAutoLinked(this.fParsedResources);
        this.collectAndMarkParsedFiles(project, pfModel);
        DVTProblemsUiUpdaterRegistry.get(PFProblemCategories.PF_PROBLEM.getId()).update(project);
        DVTProblemsUiUpdaterRegistry.get(PFProblemCategories.PF_PROBLEM.getId()).scheduleObjectionsClear(project);
        DVTProblemsUiUpdaterRegistry.get(TclProblemCategories.TCL_PROBLEM.getId()).update(project);
        DVTProblemsUiUpdaterRegistry.get(TclProblemCategories.TCL_PROBLEM.getId()).scheduleObjectionsClear(project);
    }

    private DVTPFModel interpretAndExecuteInternal(List<IRfDesignElement> allTops, int buildKind) {
        Invocation powerFormatInvocation = BuildConfigManager.getPowerFormatInvocation(this.getProject());
        if (powerFormatInvocation == null) {
            return null;
        }
        DVTPowerFormatBCInfo powerFormatBCInfo = powerFormatInvocation.getState().fPowerFormatBCInfo;
        if (powerFormatBCInfo == null || powerFormatBCInfo.getPowerFormatFilePath() == null) {
            return null;
        }
        String pfFilePath = powerFormatBCInfo.getPowerFormatFilePath();
        DVTPowerFormatKind pfKind = powerFormatBCInfo.getKind();
        DVTPFModel powerFormatModel = new DVTPFModel(pfFilePath, allTops, pfKind, buildKind);
        DVTPFInterp interp = null;
        if (pfKind == DVTPowerFormatKind.CPF) {
            interp = new DVTCPFInterp(powerFormatModel, this.monitor);
        } else if (pfKind == DVTPowerFormatKind.UPF) {
            interp = new DVTUPFInterp(powerFormatModel, this.monitor);
        }
        if (interp == null) {
            return null;
        }
        interp.evalDVTScript(pfFilePath, powerFormatInvocation.getState().fCompilationRootConsideringMinusF, this.getProject());
        return powerFormatModel;
    }

    @Override
    public int analyzeDelta(IResourceDelta delta, IProgressMonitor monitor, Map<LanguageKind, Set<FileCompileInfo>> changedFiles) throws CoreException {
        LinkedHashSet<FileCompileInfo> changedFilesInfos = new LinkedHashSet<FileCompileInfo>();
        for (IFile pfParsedFile : this.fParsedResources) {
            int deltaFlags;
            IResourceDelta pDelta = delta.findMember(pfParsedFile.getProjectRelativePath());
            if (pDelta == null || (deltaFlags = pDelta.getFlags()) == 0x100000 || (deltaFlags & 0x100) == 0) continue;
            changedFilesInfos.add(new FileCompileInfo(pfParsedFile));
        }
        changedFiles.put(LanguageKind.TCL, changedFilesInfos);
        if (!changedFilesInfos.isEmpty()) {
            this.hasPfChanged = true;
            return changedFilesInfos.size();
        }
        Set<FileCompileInfo> vlogChangedFileInfos = changedFiles.get((Object)LanguageKind.VLOG);
        if (vlogChangedFileInfos != null && !vlogChangedFileInfos.isEmpty()) {
            return 1;
        }
        Set<FileCompileInfo> vhdlChangedFileInfos = changedFiles.get((Object)LanguageKind.VHDL);
        if (vhdlChangedFileInfos != null && !vhdlChangedFileInfos.isEmpty()) {
            return 1;
        }
        return 0;
    }

    public void postMixedLangIncrementalBuild(IProject project, Map<LanguageKind, Set<FileCompileInfo>> changedFiles) {
        try {
            if (changedFiles == null) {
                return;
            }
            ArrayList<FileCompileInfo> changedPfFileInfos = new ArrayList<FileCompileInfo>();
            Set<FileCompileInfo> tclFiles = changedFiles.get((Object)LanguageKind.TCL);
            changedPfFileInfos.addAll(tclFiles != null ? tclFiles : Collections.emptyList());
            Set<FileCompileInfo> pfFiles = changedFiles.get((Object)LanguageKind.PF);
            changedPfFileInfos.addAll(pfFiles != null ? pfFiles : Collections.emptyList());
            boolean pfChanged = !changedPfFileInfos.isEmpty();
            Set<FileCompileInfo> changedVlogFileInfos = changedFiles.get((Object)LanguageKind.VLOG);
            boolean designChanged = changedVlogFileInfos != null && !changedVlogFileInfos.isEmpty();
            Set<FileCompileInfo> changedVhdlFileInfos = changedFiles.get((Object)LanguageKind.VHDL);
            boolean bl = designChanged = designChanged || changedVhdlFileInfos != null && !changedVhdlFileInfos.isEmpty();
            if (!pfChanged && !designChanged) {
                return;
            }
            if (pfChanged) {
                this.postMixedLangBuild(this.getProject(), 10);
            } else if (designChanged) {
                DVTPFModel pfModel = this.getPfmodel();
                if (pfModel == null) {
                    return;
                }
                pfModel.executeAllCommands();
                DVTProblemsUiUpdaterRegistry.get(PFProblemCategories.PF_PROBLEM.getId()).update(project);
                DVTProblemsUiUpdaterRegistry.get(PFProblemCategories.PF_PROBLEM.getId()).scheduleObjectionsClear(project);
            }
            this.updateDHView();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void updateDHView() {
        Utils.getActiveShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DVTViewManager.getInstanceByCurrentWorkbenchWindow().updateViewLabels(new HashSet<Class>(Arrays.asList(LazyDesignHierarchyView.class)), EnumSet.of(TreeViewContentProvider.LabelUpdateKind.IMAGE, TreeViewContentProvider.LabelUpdateKind.TEXT));
                DVTViewManager.getInstanceByCurrentWorkbenchWindow().notifySelectedViewsWithBuildEvents(BuildEvents.FULL_BUILD, DVTPFBuildContributor.this.getProject(), new HashSet<Class>(Arrays.asList(PowerDomainView.class)));
                DHBreadcrumbUtils.updateBreadcrumbLabels();
            }
        });
    }

    private void collectAndMarkParsedFiles(IProject project, DVTPFModel pfModel) throws CoreException {
        this.fParsedResources.clear();
        if (pfModel == null) {
            return;
        }
        DVTAutoLinkManager.getInstance().modifyWorkspaceOperation(project, PF_BUILDER_CALLER_NAME, cachedLinksMap -> {
            Set<String> allPfFiles = pfModel.getParsedPfFileSet();
            if (allPfFiles == null) {
                return;
            }
            for (String parsedUpfFile : allPfFiles) {
                IFile resource;
                if (!Path.fromOSString((String)parsedUpfFile).isAbsolute() || (resource = this.createResource(Path.fromOSString((String)parsedUpfFile), cachedLinksMap)) == null) continue;
                PropertiesManager.addSessionProperty((IResource)resource, PropertyTypes.QN_IMPORTED_FILE, "ro.amiq.dvt.tcl.ui.editor.DVTTclEditor");
                IFile parent = resource;
                while ((parent = parent.getParent()) != null && PropertiesManager.getSessionProperty((IResource)parent, PropertyTypes.QN_IMPORTED_FILE) == null) {
                    PropertiesManager.addSessionProperty((IResource)parent, PropertyTypes.QN_IMPORTED_FILE, "ro.amiq.dvt.tcl.ui.editor.DVTTclEditor");
                }
                this.fParsedResources.add(resource);
            }
        }, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IFile createResource(IPath filePath, Map<IPath, LinkDescription> cachedLinksMap) {
        try {
            String parserPath = filePath.toOSString();
            IFile file = DVTFileUtils.getInstance().findProjectFileAndRegister(this.getProject(), parserPath, "createResource");
            if (file != null && file.exists() && file.getLocation() != null) {
                if (this.fAutoLinkedResourcesEnable) {
                    DVTAutoLinkManager.getInstance().validateAutoLink(this.getProject(), file);
                    return file;
                }
                if (!file.getProjectRelativePath().segment(0).equals("DVT Auto-Linked")) return file;
                return null;
            }
            if (!this.fAutoLinkedResourcesEnable) {
                return null;
            }
            IProject project = this.getProject();
            if (DVTAutoLinkManager.getInstance().hasError(project, 2)) return null;
            if (DVTAutoLinkManager.getInstance().hasError(this.getProject(), 1)) {
                return null;
            }
            file = DVTFileUtils.getInstance().findProjectFileAndRegister(project, parserPath, "createResource");
            if (file == null || file.getLocation() == null) {
                IFile projectFile = this.getProject().getFile(".project");
                boolean autolinkUsingLinks = DVTAutoLinkManager.getInstance().autolinkUsingLinksForProject(project);
                boolean readOnly = projectFile.getResourceAttributes().isReadOnly();
                if (readOnly && autolinkUsingLinks) {
                    DVTAutoLinkManager.getInstance().reportError(project, 1);
                } else {
                    file = DVTAutoLinkManager.getInstance().createAutoLink(this.getProject(), filePath, this.fAutoLinkedRoots, cachedLinksMap, true);
                }
            } else {
                DVTAutoLinkManager.getInstance().validateAutoLink(this.getProject(), file);
            }
            if (file == null) return file;
            String resourcePath = file.getProjectRelativePath().toOSString();
            PropertiesManager.addParser2ResourceMapProperty(this.getProject(), parserPath, resourcePath);
            return file;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            DVTAutoLinkManager.getInstance().reportError(this.getProject(), 2);
            return null;
        }
    }

    private void markDirtyAutoLinked(List<IFile> resources) throws CoreException {
        if (resources == null) {
            return;
        }
        for (IResource iResource : resources) {
            if (!iResource.exists()) continue;
            iResource.setSessionProperty(DVTAutoLinkManager.QN_DIRTY_AUTOLINKED_FILE, (Object)true);
        }
    }

    private DVTPFModel getPfmodel() {
        RfMixedLangProject mixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(this.getProject(), false);
        if (mixedLangProject == null) {
            return null;
        }
        return mixedLangProject.getPFModel();
    }

    @Override
    public String getDisplayName() {
        return "Power Format";
    }

    @Override
    public boolean isEnabled(IProject project) {
        return DVTNature.hasNature(project, "ro.amiq.dvt.pfnature");
    }

    @Override
    public IRfSingleLangProject getIRfProject() {
        return null;
    }

    @Override
    public boolean hasNothingToCompile() {
        return false;
    }

    @Override
    public boolean notifyAfterIncremental() {
        return true;
    }

    @Override
    public boolean hasNature(String natureID) {
        return "ro.amiq.dvt.pfnature".equals(natureID);
    }
}

