/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.graphics.RGB;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.problems.DVTProblem;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.problems.PFProblemKinds;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.GoToInfoWithPlainText;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.power.format.DVTPFInfo;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.power.format.DVTPFRetentionCellInfo;
import ro.amiq.dvt.power.format.DVTPFRetentionListInfo;
import ro.amiq.dvt.power.format.DVTPFRetentionRuleInfo;
import ro.amiq.dvt.power.format.DVTPFSupplyPortInfo;
import ro.amiq.dvt.power.format.PFDesignForPathStatus;
import ro.amiq.dvt.power.format.PFVersionType;
import ro.amiq.dvt.power.format.PfType;
import ro.amiq.dvt.power.format.cpf.CPFCommandType;
import ro.amiq.dvt.power.format.cpf.DVTCPFMacroModel;
import ro.amiq.dvt.power.format.utils.DVTPFUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.tcl.model.DVTCommandResult;
import ro.amiq.dvt.tcl.model.DVTDebugKind;
import ro.amiq.dvt.tcl.model.DVTTclCommand;
import ro.amiq.dvt.tcl.model.DVTTclCommandArg;
import ro.amiq.dvt.tcl.model.DVTTclInterp;
import ro.amiq.dvt.tcl.model.DVTTclUtils;
import ro.amiq.dvt.tcl.model.IDVTCommandType;
import ro.amiq.dvt.tcl.model.IDVTTclExecCommand;
import ro.amiq.dvt.ui.projectcolors.ProjectColorsRGBUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import tcl.lang.TclException;
import tcl.lang.TclObject;

public abstract class DVTPFCommand
extends DVTTclCommand
implements IDVTTclExecCommand {
    protected static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s+");
    private static final Pattern DOT_SEPARATOR_PATTERN = Pattern.compile("\\.");
    private static final Pattern DASH_SEPARATOR_PATTERN = Pattern.compile("\\\\");
    protected static final Pattern BRACKETS_PATTERN = Pattern.compile("\\{([^}]*)\\}");
    protected static final Pattern INDEX_PATTERN = Pattern.compile("\\[[0-9]+\\]");
    public static final Comparator<ElementPath> ELEMENT_PATH_COMPARATOR = (o1, o2) -> {
        String fieldName2;
        String fieldName1;
        ElementPath parent2;
        ElementPath parent1;
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        String lastSegment1 = o1.lastSegment();
        String lastSegment2 = o2.lastSegment();
        if (lastSegment1.contains("[") && lastSegment2.contains("[") && (parent1 = o1.removeLastSegment()).equals(parent2 = o2.removeLastSegment()) && (fieldName1 = lastSegment1.substring(0, lastSegment1.indexOf("["))).equals(fieldName2 = lastSegment2.substring(0, lastSegment2.indexOf("[")))) {
            String group;
            ArrayList<Integer> indexes1 = new ArrayList<Integer>();
            ArrayList<Integer> indexes2 = new ArrayList<Integer>();
            Matcher matcher = INDEX_PATTERN.matcher(lastSegment1);
            while (matcher.find()) {
                group = matcher.group(0);
                indexes1.add(Integer.parseInt(group.substring(group.indexOf("[") + 1, group.lastIndexOf("]"))));
            }
            matcher = INDEX_PATTERN.matcher(lastSegment2);
            while (matcher.find()) {
                group = matcher.group(0);
                indexes2.add(Integer.parseInt(group.substring(group.indexOf("[") + 1, group.lastIndexOf("]"))));
            }
            int i = 0;
            while (i < Math.min(indexes1.size(), indexes2.size())) {
                if (!((Integer)indexes1.get(i)).equals(indexes2.get(i))) {
                    return (Integer)indexes1.get(i) - (Integer)indexes2.get(i);
                }
                ++i;
            }
        }
        return o1.compareTo((ElementPath)o2);
    };
    protected DVTPFModel pfModel;

    public DVTPFCommand(IDVTCommandType type) {
        super(type);
    }

    @Override
    public void dvtCmdProc(DVTTclInterp interp, TclObject[] objv) throws TclException {
        if (this.pfModel == null) {
            return;
        }
        interp.printCmdProcToConsole(interp, "pfcmd", objv, DVTDebugKind.PF_DEBUG_INFO);
        try {
            DVTPFCommand pfComm = (DVTPFCommand)this.clone();
            this.pfModel.addPfCommand(pfComm);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected void resolveElements(IRfDesignElement topDesign, String powerDomainName, String elements, ElementPath currentScope, PfType pfType) {
        String hierarchySeparator = this.pfModel.getHierarchySeparator();
        if (elements == null || elements.isEmpty()) {
            return;
        }
        String[] elementsArray = elements.split("\\s+");
        if (elementsArray == null) {
            return;
        }
        DVTTclUtils.printToConsole("[PF] Resolving elements '" + elements + "' for PD '" + powerDomainName + "'", this.pfModel.getProject(), this.pfModel.getBuildKind(), DVTDebugKind.PF_DEBUG_INFO, this.pfModel.isDebugMode());
        String[] stringArray = elementsArray;
        int n = elementsArray.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (!element.trim().isEmpty()) {
                element = this.replaceSeparators(element, hierarchySeparator);
                RGB[] powerDomainColors = this.pfModel.getPowerDomainColor(powerDomainName);
                if (powerDomainColors == null || powerDomainColors.length != 2) {
                    RGB powerDomainBgColor = ProjectColorsRGBUtils.makeBackgroundRGB(powerDomainName);
                    RGB powerDomainFgColor = ProjectColorsRGBUtils.makeForegroundRGB(powerDomainName);
                    powerDomainColors = new RGB[]{powerDomainBgColor, powerDomainFgColor};
                    this.pfModel.addPowerDomainColor(powerDomainName, powerDomainColors);
                }
                DVTPFInfo info = this.pfModel.getPDInfoForPDName(powerDomainName) != null ? this.pfModel.getPDInfoForPDName(powerDomainName) : new DVTPFInfo(powerDomainName, this.pfModel.getCurrentParsedPfFile(), this.args[0].getArgLine(), this.args[this.args.length - 1].getArgLine(), powerDomainColors[0], powerDomainColors[1]);
                String currMacroModel = this.pfModel.getCurrMacroModel();
                if (this.getType() instanceof CPFCommandType && currMacroModel != null) {
                    DVTCPFMacroModel macroModel = this.pfModel.getMacroModel(currMacroModel);
                    macroModel.addPFInfo(info);
                } else {
                    this.pfModel.addPfInfo(powerDomainName, info);
                }
                if (currMacroModel != null) {
                    return;
                }
                if (".".equals(element) && currentScope != null) {
                    this.resolveElement(topDesign, currentScope, currentScope.toString(hierarchySeparator), powerDomainName, false, info);
                } else {
                    this.resolveElement(topDesign, currentScope, element, powerDomainName, false, info);
                }
            }
            ++n2;
        }
    }

    public void resolveElement(IRfDesignElement topDesign, ElementPath currentScope, String element, String pdName, boolean excludeElements, DVTPFInfo info) {
        if (this.pfModel == null) {
            return;
        }
        String hierarchySeparator = this.pfModel.getHierarchySeparator();
        ElementPath instancePath = ElementPath.from(element, hierarchySeparator);
        ElementPath instanceFullPath = null;
        instanceFullPath = element.equals(currentScope.toString(hierarchySeparator)) || currentScope.endsWith(instancePath) ? currentScope : (currentScope.isPrefixOf(instancePath) ? instancePath : ElementPath.join(currentScope, Arrays.asList(instancePath.getSegments())));
        if (instanceFullPath == null) {
            return;
        }
        DesignForPathResult result = this.getDesignForPath(topDesign, topDesign.getName(), instanceFullPath, 0);
        if (result == null || result.getStatus() == PFDesignForPathStatus.ERROR || result.getStatus() == PFDesignForPathStatus.NOT_IN_PATH) {
            DVTProblem prob = new DVTProblem(this.pfModel.getProject(), PFProblemKinds.PF_UNRESOLVED_PATH, this.args[0].getArgFile(), false, this.args[0].getArgLine(), this.pfModel.getPfKind().toString(), this.pfModel.getUPFVersion().toNiceString(), instanceFullPath.toString());
            if (this.pfModel.reportErrorsToConsole()) {
                prob.setToConsole(true);
            }
            DVTProblemManager.getInstance().reportProblem(prob);
            return;
        }
        if (result.getStatus() == PFDesignForPathStatus.UNDECLARED && !excludeElements) {
            this.pfModel.addInstanceToPD(instanceFullPath, pdName);
            info.addInstance(instanceFullPath);
            return;
        }
        if (excludeElements) {
            this.pfModel.addExcludedInstance(instanceFullPath, pdName);
        } else {
            this.pfModel.addInstanceToPD(instanceFullPath, pdName);
            info.addInstance(instanceFullPath);
            ElementPath parent = instanceFullPath.removeLastSegment();
            DVTPFInfo parentDomain = this.pfModel.getPDInfoForInstance(parent);
            if (parentDomain == null || !parentDomain.getPowerDomainName().equals(info.getPowerDomainName())) {
                info.addUpperBoundaryInstance(instanceFullPath);
            }
            if (parentDomain != null && !parentDomain.getPowerDomainName().equals(info.getPowerDomainName())) {
                parentDomain.addLowerBoundaryInstance(parent);
            }
        }
        if (excludeElements) {
            return;
        }
        IRfDesignElement design = result.getDesignElement();
        if (design == null) {
            return;
        }
        IRfSingleLangProject rfProject = design.getRfProject();
        if (rfProject == null) {
            return;
        }
        ELManager elManager = rfProject.getELManager();
        Map<ElementPath, ELInstance> subtreeOf = elManager.getMemory().subtreeOf(instanceFullPath, false);
        if (subtreeOf == null || subtreeOf.isEmpty()) {
            return;
        }
        for (Map.Entry<ElementPath, ELInstance> child : subtreeOf.entrySet()) {
            ElementPath childPath = child.getKey();
            if (!instanceFullPath.isDirectParentOf(childPath) || this.pfModel.isInstanceInPD(childPath)) continue;
            ElementPath childInstancePath = ElementPath.from(childPath.toString(hierarchySeparator), hierarchySeparator);
            this.pfModel.addInstanceToPD(childInstancePath, pdName);
            if (elManager.getMemory().isGenerateBlock(childInstancePath)) continue;
            info.addInstance(childInstancePath);
        }
    }

    protected DesignForPathResult getDesignForPath(IRfDesignElement design, String instanceName, ElementPath path, int depth) {
        if (path == null || depth > path.length() - 1 || instanceName == null) {
            return new DesignForPathResult(PFDesignForPathStatus.ERROR, null);
        }
        if (design == null) {
            return depth == path.length() - 1 ? new DesignForPathResult(PFDesignForPathStatus.UNDECLARED, null) : new DesignForPathResult(PFDesignForPathStatus.ERROR, null);
        }
        IRfSingleLangProject rfProject = design.getRfProject();
        if (rfProject == null) {
            return new DesignForPathResult(PFDesignForPathStatus.ERROR, null);
        }
        ELManager elManager = rfProject.getELManager();
        ELInstance instanceFor = elManager.getMemory().instanceFor(path);
        if (instanceFor == null) {
            return new DesignForPathResult(PFDesignForPathStatus.NOT_IN_PATH, null);
        }
        return new DesignForPathResult(PFDesignForPathStatus.FOUND, design);
    }

    protected DesignForPathResult getDesignInstanceForDesign(IRfDesignElement bcTop, String designName) {
        Collection<? extends IRfBlockElement> collection;
        if (designName == null || bcTop == null) {
            return new DesignForPathResult(PFDesignForPathStatus.ERROR, null);
        }
        Collection<? extends IRfInstanceElement> localInstances = bcTop.getLocalInstances();
        if (localInstances != null) {
            for (IRfInstanceElement iRfInstanceElement : localInstances) {
                IRfDesignElement instanceDesign = DesignUtils.getDesign(DesignUtils.DesignRequest.of((IRfNamedElement)iRfInstanceElement, true));
                if (!(instanceDesign instanceof IRfDesignElement) || !designName.equals(instanceDesign.getName())) continue;
                DesignForPathResult designForPathResult = new DesignForPathResult(PFDesignForPathStatus.FOUND, instanceDesign);
                designForPathResult.setInstance(iRfInstanceElement);
                return designForPathResult;
            }
        }
        if ((collection = bcTop.getLocalGenerateBlocks()) == null) {
            return null;
        }
        for (IRfBlockElement iRfBlockElement : collection) {
            IRfDesignElement generDesign = DesignUtils.getDesign(DesignUtils.DesignRequest.of((IRfNamedElement)iRfBlockElement, true));
            DesignForPathResult result = this.getDesignInstanceForDesign(generDesign, designName);
            if (result == null || result.getStatus() == PFDesignForPathStatus.NOT_IN_PATH || result.getStatus() == PFDesignForPathStatus.ERROR) continue;
            return result;
        }
        return null;
    }

    protected void resolveExcludeElements(IRfDesignElement topDesign, String excludeElements, ElementPath currentScope) {
        if (excludeElements == null || excludeElements.isEmpty()) {
            return;
        }
        String[] excludeElementsArray = excludeElements.split("\\s+");
        if (excludeElementsArray == null) {
            return;
        }
        String[] stringArray = excludeElementsArray;
        int n = excludeElementsArray.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (!element.trim().isEmpty()) {
                this.resolveElement(topDesign, currentScope, element, null, true, null);
            }
            ++n2;
        }
    }

    protected IRfDesignElement computeDesignTop(ElementPath currentScope) {
        List<IRfDesignElement> designTops = this.pfModel.getAllTops();
        if (designTops == null) {
            return null;
        }
        String currentScopeRoot = currentScope.getSegment(0);
        for (IRfDesignElement designTop : designTops) {
            if (!currentScopeRoot.equals(designTop.getName())) continue;
            return designTop;
        }
        return null;
    }

    protected IRfDesignElement getBCTop(String topName) {
        List<IRfDesignElement> designTops = this.pfModel.getAllTops();
        if (designTops == null || designTops.isEmpty()) {
            return null;
        }
        if (topName != null) {
            for (IRfDesignElement design : designTops) {
                if (!topName.equals(design.getName())) continue;
                return design;
            }
        }
        return designTops.get(0);
    }

    protected String[] getPortList(String portName, DVTCommandResult commandArgs) {
        String portList = commandArgs.getOptionValue(portName);
        if (portList == null) {
            return null;
        }
        return DVTStringUtil.split(WHITESPACE_PATTERN, portList);
    }

    protected String getInfoFromString(String[] info, boolean getPortName) {
        if (info == null || info.length == 0) {
            return null;
        }
        if (getPortName) {
            return info[0];
        }
        if (info.length < 2) {
            return null;
        }
        return info[1];
    }

    protected DVTPFModel.UPFVersionType getUPFVersionFromString(String version) {
        if (version == null || version.isEmpty()) {
            return null;
        }
        if ("1.0".equals(version)) {
            return DVTPFModel.UPFVersionType.v1_0;
        }
        if ("2.0".equals(version)) {
            return DVTPFModel.UPFVersionType.v2_0;
        }
        if ("2.1".equals(version)) {
            return DVTPFModel.UPFVersionType.v2_1;
        }
        if ("2.2".equals(version)) {
            return DVTPFModel.UPFVersionType.v2_2;
        }
        if ("3.0".equals(version)) {
            return DVTPFModel.UPFVersionType.v3_0;
        }
        return null;
    }

    protected DVTPFModel.CPFVersionType getCPFVersionFromString(String version) {
        if (version == null || version.isEmpty()) {
            return null;
        }
        if ("1.0".equals(version)) {
            return DVTPFModel.CPFVersionType.v1_0;
        }
        if ("1.1".equals(version)) {
            return DVTPFModel.CPFVersionType.v1_1;
        }
        if ("2.0".equals(version)) {
            return DVTPFModel.CPFVersionType.v2_0;
        }
        if ("2.1".equals(version)) {
            return DVTPFModel.CPFVersionType.v2_1;
        }
        return null;
    }

    protected boolean checkInitialConditions(boolean checkVersion, IRfDesignElement topDesign, ElementPath scope, PFVersionType version, String currentParsedPfFile, String hierarchySeparator) {
        if (this.pfModel == null) {
            return false;
        }
        if (this.args != null && this.args.length != 0 && scope != null && topDesign != null && hierarchySeparator != null && currentParsedPfFile != null) {
            if (checkVersion) {
                if (version != null) {
                    return true;
                }
            } else {
                return true;
            }
        }
        String message = "[PF] One or more mandatory null elements. [";
        message = String.valueOf(message) + (this.pfModel.getScope() == null ? "Current scope is null. " : "");
        message = String.valueOf(message) + (this.pfModel.getTopDesign() == null ? "Current top design is null. " : "");
        message = String.valueOf(message) + (this.pfModel.getHierarchySeparator() == null ? "Hierarchy separator is null. " : "");
        message = String.valueOf(message) + (this.pfModel.getPfFilePath() == null ? "PF file path is null. " : "");
        message = String.valueOf(message) + (this.pfModel.getAllTops() == null ? "Top config is null. " : "");
        message = String.valueOf(message) + "]";
        DVTTclUtils.printToConsole("[PF] " + message, this.pfModel.getProject(), this.pfModel.getBuildKind(), DVTDebugKind.PF_DEBUG_INFO, this.pfModel.isDebugMode());
        return false;
    }

    protected boolean transformCommandOptionInBoolean(String optionName, DVTCommandResult commandArgs) {
        return "true".equals(commandArgs.getOptionValue(optionName));
    }

    protected Object clone() throws CloneNotSupportedException {
        DVTPFCommand clone = (DVTPFCommand)super.clone();
        clone.args = (DVTTclCommandArg[])this.args.clone();
        return clone;
    }

    protected void addControlSignalGotoInfo(IRfDesignElement design, String signalPath, String currHierarchySeparator, DVTPFSupplyPortInfo controlPort, String labelPattern) {
        if (design == null) {
            return;
        }
        ElementPath controlPath = ElementPath.from(signalPath, currHierarchySeparator);
        String portName = controlPath.lastSegment();
        controlPath = controlPath.removeLastSegment();
        IRfDefElement declaration = design.getDeclaration();
        if (declaration == null) {
            return;
        }
        IRfFileDef defFile = declaration.getDefFile();
        if (defFile == null) {
            return;
        }
        String filePath = defFile.getParserPath().path;
        if (filePath == null) {
            return;
        }
        IRfNamedElement port = design.getMember(portName, null, null, false, false, false, false, false);
        if (!(port instanceof IRfPortElement)) {
            return;
        }
        controlPort.addGoToInfo(new GoToInfoWithPlainText("Control signal: " + signalPath + "\n"));
        controlPort.addGoToInfo(filePath, port.getLine(), port.getLine(), port.getLanguageKind());
        if (controlPath.length() > 2) {
            String controlPortLeafInstance = controlPath.getSegment(controlPath.length() - 1);
            String netName = String.valueOf(controlPortLeafInstance) + currHierarchySeparator + portName;
            controlPort.setLabel(MessageFormat.format(labelPattern, netName));
        }
    }

    public void setPfModel(DVTPFModel pfModel) {
        this.pfModel = pfModel;
    }

    protected String replaceSeparators(String element, String hierarchySeparator) {
        if (!".".equals(element) && element.contains(".")) {
            element = DVTStringUtil.replaceAll(DOT_SEPARATOR_PATTERN, element, hierarchySeparator);
        }
        if (!"\\".equals(hierarchySeparator) && element.contains("\\")) {
            element = DVTStringUtil.replaceAll(DASH_SEPARATOR_PATTERN, element, "");
        }
        return element;
    }

    protected void computeRetentionElementsFromList(String[] elementsArray, DVTPFRetentionRuleInfo retentionRule, ElementPath currentScope, IRfDesignElement currTopDesign, boolean excludeElements) {
        if (elementsArray == null || this.pfModel == null) {
            return;
        }
        String hierarchySeparator = this.pfModel.getHierarchySeparator();
        DVTTclUtils.printToConsole("[PF] Resolving retention elements '" + elementsArray + "' for retention rule '" + retentionRule.getRuleName() + "'", this.pfModel.getProject(), this.pfModel.getBuildKind(), DVTDebugKind.PF_DEBUG_INFO, this.pfModel.isDebugMode());
        String[] stringArray = elementsArray;
        int n = elementsArray.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (!element.trim().isEmpty()) {
                element = this.replaceSeparators(element, hierarchySeparator);
                this.computeRetentionElement(element, retentionRule, currTopDesign, currentScope, excludeElements);
            }
            ++n2;
        }
    }

    protected void computeRetentionElement(String element, DVTPFRetentionRuleInfo retentionRule, IRfDesignElement currTopDesign, ElementPath currentScope, boolean excludeElements) {
        Map<ElementPath, ELInstance> subtreeOf;
        ElementPath hierarchyPath;
        IELMemory memory;
        if (this.pfModel.getRetentionListByName(element) != null) {
            DVTPFRetentionListInfo retentionList = this.pfModel.getRetentionListByName(element);
            this.computeRetentionElementsFromList(retentionList.getElements(), retentionRule, currentScope, currTopDesign, false);
            this.computeRetentionElementsFromList(retentionList.getExcludeElements(), retentionRule, currentScope, currTopDesign, true);
            return;
        }
        ElementPath instanceFullPath = this.computeInstancePathFromElement(element, currentScope);
        if (instanceFullPath == null) {
            return;
        }
        boolean isSearchSignal = false;
        DesignForPathResult result = this.getDesignForPath(currTopDesign, currTopDesign.getName(), instanceFullPath, 0);
        if (result == null || result.getStatus() == PFDesignForPathStatus.NOT_IN_PATH) {
            result = this.getDesignForPath(currTopDesign, currTopDesign.getName(), instanceFullPath.removeLastSegment(), 0);
            isSearchSignal = true;
        }
        if ((memory = this.computeElaborationMemory(hierarchyPath = isSearchSignal ? instanceFullPath.removeLastSegment() : instanceFullPath, result)) == null) {
            return;
        }
        ELInstance currentInstance = memory.instanceFor(hierarchyPath);
        if (currentInstance != null) {
            if (isSearchSignal && this.pfModel.isInstanceInPD(instanceFullPath.removeLastSegment())) {
                IRfInstanceElement instance = currentInstance.getDescription();
                if (instance == null) {
                    return;
                }
                IRfNamedElement module = instance.getAssociatedType();
                if (module == null) {
                    return;
                }
                IRfNamedElement field = DesignUtils.getFieldOrInstanceByName(instanceFullPath.lastSegment(), DesignUtils.DesignRequest.of(module));
                if (field instanceof IRfInstanceElement) {
                    DVTPFUtils.addPfProblem(PFProblemKinds.PF_UNRESOLVED_PATH, this.pfModel, this.pfModel.getCurrentParsedPfFile(), this.args[0].getArgLine(), element);
                    return;
                }
                if (!this.isValidRetentionElement(field)) {
                    return;
                }
                if (excludeElements) {
                    retentionRule.excludeElement(instanceFullPath);
                    return;
                }
                retentionRule.addElement(instanceFullPath);
                return;
            }
            this.computeRetentionElementsForInstance(currentInstance, retentionRule, instanceFullPath, excludeElements);
        }
        if ((subtreeOf = memory.subtreeOf(instanceFullPath, false)) == null || subtreeOf.isEmpty()) {
            return;
        }
    }

    private void computeRetentionElementsForInstance(ELInstance elInstance, DVTPFRetentionRuleInfo retentionRule, ElementPath instancePath, boolean excludeElements) {
        if (!this.pfModel.isInstanceInPD(instancePath)) {
            return;
        }
        if (!excludeElements) {
            retentionRule.addElement(instancePath);
        } else {
            retentionRule.excludeElement(instancePath);
        }
    }

    protected String computeSignalPath(ElementPath instancePath, String hierarchySeparator, IRfFieldElement signal) {
        StringBuilder signalPath = new StringBuilder();
        String[] stringArray = instancePath.getSegments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            signalPath.append(segment).append(hierarchySeparator);
            ++n2;
        }
        signalPath.append(signal.getName());
        return signalPath.toString();
    }

    protected boolean isValidRetentionElement(IRfNamedElement signal) {
        return signal instanceof IRfFieldElement;
    }

    protected ElementPath computeInstancePathFromElement(String element, ElementPath currentScope) {
        String hierarchySeparator = this.pfModel.getHierarchySeparator();
        ElementPath instancePath = ElementPath.from(element, hierarchySeparator);
        if (element.equals(currentScope.toString(hierarchySeparator)) || currentScope.endsWith(instancePath)) {
            return currentScope;
        }
        if (currentScope.isPrefixOf(instancePath)) {
            return instancePath;
        }
        return ElementPath.join(currentScope, Arrays.asList(instancePath.getSegments()));
    }

    protected IELMemory computeElaborationMemory(ElementPath instancePath, DesignForPathResult result) {
        if (result == null || result.getStatus() == PFDesignForPathStatus.ERROR || result.getStatus() == PFDesignForPathStatus.NOT_IN_PATH) {
            DVTProblem prob = new DVTProblem(this.pfModel.getProject(), PFProblemKinds.PF_UNRESOLVED_PATH, this.args[0].getArgFile(), false, this.args[0].getArgLine(), this.pfModel.getPfKind().toString(), this.pfModel.getUPFVersion().toNiceString(), instancePath.toString());
            if (this.pfModel.reportErrorsToConsole()) {
                prob.setToConsole(true);
            }
            DVTProblemManager.getInstance().reportProblem(prob);
            return null;
        }
        IRfDesignElement design = result.getDesignElement();
        if (design == null) {
            return null;
        }
        IRfSingleLangProject rfProject = design.getRfProject();
        if (rfProject == null) {
            return null;
        }
        ELManager elManager = rfProject.getELManager();
        if (elManager == null) {
            return null;
        }
        return elManager.getMemory();
    }

    protected void addRetentionSignal(String signalOption, DVTPFRetentionRuleInfo retentionRule, DVTCommandResult commandArgs, DVTPFModel pfModel, DVTPFRetentionRuleInfo.SIGNAL_TYPE type, int line) {
        DesignForPathResult result;
        String[] controlPortList = this.getPortList(signalOption, commandArgs);
        if (controlPortList == null || controlPortList.length < 2) {
            return;
        }
        String hierarchySeparator = pfModel.getHierarchySeparator();
        IRfDesignElement topDesign = pfModel.getTopDesign();
        String controlPortName = String.valueOf(pfModel.getScope().toString(hierarchySeparator)) + hierarchySeparator + this.getInfoFromString(controlPortList, true);
        ElementPath signalFullPath = ElementPath.from(controlPortName, hierarchySeparator);
        if (signalFullPath.isEmpty()) {
            return;
        }
        String level = this.getInfoFromString(controlPortList, false);
        if (level == null || level.isEmpty()) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_MISSING_RETENTION_CONDITION, pfModel, pfModel.getCurrentParsedPfFile(), line, signalOption);
            return;
        }
        ElementPath instancePath = signalFullPath.removeLastSegment();
        IELMemory memory = this.computeElaborationMemory(instancePath, result = this.getDesignForPath(topDesign, topDesign.getName(), instancePath, 0));
        if (memory == null) {
            return;
        }
        ELInstance currentInstance = memory.instanceFor(instancePath);
        if (currentInstance == null) {
            return;
        }
        IRfInstanceElement description = currentInstance.getDescription();
        if (description == null) {
            return;
        }
        IRfNamedElement module = description.getAssociatedType();
        if (!(module instanceof IRfDesignElement)) {
            return;
        }
        IRfNamedElement field = DesignUtils.getFieldOrInstanceByName(signalFullPath.lastSegment(), DesignUtils.DesignRequest.of(module));
        retentionRule.setSignal(field, DVTPFRetentionCellInfo.ActiveState.from(level, pfModel, pfModel.getCurrentParsedPfFile(), line, signalOption), type);
    }

    protected static class DesignForPathResult {
        private PFDesignForPathStatus status;
        private IRfDesignElement design;
        private IRfInstanceElement instance;

        public DesignForPathResult(PFDesignForPathStatus status, IRfDesignElement design) {
            this.status = status;
            this.design = design;
        }

        public PFDesignForPathStatus getStatus() {
            return this.status;
        }

        public IRfDesignElement getDesignElement() {
            return this.design;
        }

        public void setInstance(IRfInstanceElement instance) {
            this.instance = instance;
        }

        public IRfInstanceElement getInstance() {
            return this.instance;
        }
    }
}

