/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.swt.graphics.RGB;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.power.format.DVTPFIsolationStrategyInfo;
import ro.amiq.dvt.power.format.DVTPFLibModelInfo;
import ro.amiq.dvt.power.format.DVTPFRetentionRuleInfo;
import ro.amiq.dvt.power.format.DVTPFSupplyPortInfo;
import ro.amiq.dvt.power.format.upf.DVTUPFSupplyNetInfo;
import ro.amiq.dvt.power.format.upf.DVTUPFSupplyPortInfo;
import ro.amiq.dvt.utils.DVTStringUtil;

public class DVTPFInfo {
    private String powerDomainName;
    private RGB powerDomainBgRGB;
    private RGB powerDomainFgRGB;
    private String filePath;
    private int startLine;
    private int endLine;
    private DVTPFSupplyPortInfo primaryPowerSupply;
    private DVTPFSupplyPortInfo primaryGroundSupply;
    private Set<ElementPath> upperBoundaryInstances;
    private Set<ElementPath> lowerBoundaryInstances;
    private Map<ElementPath, String> retentionRulesByElements;
    private Map<ElementPath, String> isolationStrategiesByElements;
    private Map<String, DVTPFRetentionRuleInfo> retentionRulesByName;
    private Map<String, DVTPFIsolationStrategyInfo> isolationStrategiesByName;
    private Map<String, DVTPFLibModelInfo> libModelsByName;
    private List<String> cpfMappedPDLabels;
    private DVTPFSupplyPortInfo cpfShutOffPort;
    private Set<ElementPath> instances;

    public DVTPFInfo(String powerDomainName, String path, int startLine, int endLine, RGB powerDomainBgRGB, RGB powerDomainFgRGB) {
        this.powerDomainName = powerDomainName;
        this.filePath = path;
        this.startLine = startLine;
        this.endLine = endLine;
        this.powerDomainBgRGB = powerDomainBgRGB;
        this.powerDomainFgRGB = powerDomainFgRGB;
        this.instances = new LinkedHashSet<ElementPath>();
        this.upperBoundaryInstances = new HashSet<ElementPath>();
        this.lowerBoundaryInstances = new HashSet<ElementPath>();
        this.retentionRulesByName = new HashMap<String, DVTPFRetentionRuleInfo>();
        this.libModelsByName = new HashMap<String, DVTPFLibModelInfo>();
        this.isolationStrategiesByName = new HashMap<String, DVTPFIsolationStrategyInfo>();
        this.retentionRulesByElements = new HashMap<ElementPath, String>();
        this.isolationStrategiesByElements = new HashMap<ElementPath, String>();
    }

    public String getPowerDomainName() {
        return this.powerDomainName;
    }

    public RGB getPowerDomainBgRGB() {
        return this.powerDomainBgRGB;
    }

    public RGB getPowerDomainFgRGB() {
        return this.powerDomainFgRGB;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public Collection<DVTUPFSupplyPortInfo> getSupplyPorts() {
        return Collections.emptyList();
    }

    public Collection<DVTUPFSupplyNetInfo> getSuppyNets() {
        return Collections.emptyList();
    }

    public DVTPFSupplyPortInfo getPrimaryGroundSupply() {
        return this.primaryGroundSupply;
    }

    public void setPrimaryGroundSupply(DVTPFSupplyPortInfo primaryGroundSupply) {
        this.primaryGroundSupply = primaryGroundSupply;
    }

    public DVTPFSupplyPortInfo getPrimaryPowerSupply() {
        return this.primaryPowerSupply;
    }

    public void setPrimaryPowerSupply(DVTPFSupplyPortInfo primaryPowerSupply) {
        this.primaryPowerSupply = primaryPowerSupply;
    }

    public void setName(String name) {
        this.powerDomainName = name;
    }

    public void addMappedCPFPdLabel(String label) {
        if (this.cpfMappedPDLabels == null) {
            this.cpfMappedPDLabels = new ArrayList<String>();
        }
        this.cpfMappedPDLabels.add(label);
    }

    public String getMappedDomainLabel() {
        if (this.cpfMappedPDLabels == null || this.cpfMappedPDLabels.isEmpty()) {
            return "";
        }
        return DVTStringUtil.join(this.cpfMappedPDLabels, "\n");
    }

    public boolean hasMappedDomains() {
        return this.cpfMappedPDLabels != null && !this.cpfMappedPDLabels.isEmpty();
    }

    public String getFullLabel() {
        return String.valueOf(this.powerDomainName) + "\n" + this.getMappedDomainLabel();
    }

    public void setCpfShutoffPort(DVTPFSupplyPortInfo shutOffPort) {
        this.cpfShutOffPort = shutOffPort;
    }

    public DVTPFSupplyPortInfo getCpfShutoffPort() {
        return this.cpfShutOffPort;
    }

    public boolean hasCpfShutoffCondition() {
        return this.getCpfShutoffPort() != null;
    }

    public DVTPFRetentionRuleInfo getRetentionRuleByName(String name) {
        return this.retentionRulesByName.get(name);
    }

    public void addRetentionRule(DVTPFRetentionRuleInfo retentionRule) {
        this.retentionRulesByName.put(retentionRule.getRuleName(), retentionRule);
    }

    public void addElementToRetention(ElementPath instance, String retentionRule) {
        if (this.retentionRulesByElements == null) {
            this.retentionRulesByElements = new HashMap<ElementPath, String>();
        }
        this.retentionRulesByElements.put(instance, retentionRule);
    }

    public void addLibModelByName(String libModelName, Map<String, String> mappedPorts) {
        DVTPFLibModelInfo dvtpfLibModelInfo = this.libModelsByName.get(libModelName);
        if (dvtpfLibModelInfo == null) {
            dvtpfLibModelInfo = new DVTPFLibModelInfo(libModelName, mappedPorts);
        }
        this.libModelsByName.put(libModelName, dvtpfLibModelInfo);
    }

    public DVTPFIsolationStrategyInfo getIsolationStrategyByName(String name) {
        return this.isolationStrategiesByName.get(name);
    }

    public void addIsolationStrategy(DVTPFIsolationStrategyInfo strategy) {
        this.isolationStrategiesByName.put(strategy.getStrategyName(), strategy);
    }

    public void addElementToIsolation(ElementPath instance, String isolationStrategy) {
        if (this.isolationStrategiesByElements == null) {
            this.isolationStrategiesByElements = new HashMap<ElementPath, String>();
        }
        this.isolationStrategiesByElements.put(instance, isolationStrategy);
    }

    public void addUpperBoundaryInstance(ElementPath instancePath) {
        this.upperBoundaryInstances.add(instancePath);
    }

    public boolean isUpperBoundaryInstance(ElementPath instancePath) {
        return this.upperBoundaryInstances.contains(instancePath);
    }

    public void addLowerBoundaryInstance(ElementPath instancePath) {
        this.lowerBoundaryInstances.add(instancePath);
    }

    public boolean isLowerBoundaryInstance(ElementPath instancePath) {
        return this.lowerBoundaryInstances.contains(instancePath);
    }

    public Set<ElementPath> getUpperBoundaryInstances() {
        return this.upperBoundaryInstances;
    }

    public Set<ElementPath> getLowerBoundaryInstances() {
        return this.lowerBoundaryInstances;
    }

    public String getIsolationStrategyByElement(ElementPath portPath) {
        if (this.isolationStrategiesByElements == null) {
            return null;
        }
        return this.isolationStrategiesByElements.get(portPath);
    }

    public String getRetentionRuleByElement(ElementPath portPath) {
        if (this.retentionRulesByElements == null) {
            return null;
        }
        return this.retentionRulesByElements.get(portPath);
    }

    public void addInstance(ElementPath instanceFullPath) {
        this.instances.add(instanceFullPath);
    }

    public Set<ElementPath> getInstances() {
        return this.instances;
    }

    public boolean hasIsolationStrategy() {
        return !this.isolationStrategiesByName.isEmpty();
    }

    public boolean hasRetentionRules() {
        return !this.retentionRulesByName.isEmpty();
    }

    public Set<String> getRetentionRules() {
        return new TreeSet<String>(this.retentionRulesByName.keySet());
    }

    public Set<String> getIsolationStategies() {
        return new TreeSet<String>(this.isolationStrategiesByName.keySet());
    }
}

