/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format;

import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.model.problems.DVTProblem;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.problems.PFProblemKinds;
import ro.amiq.dvt.model.problems.TclProblemKinds;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.power.format.utils.DVTPFUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.tcl.model.DVTDebugKind;
import ro.amiq.dvt.tcl.model.DVTTclInterp;
import ro.amiq.dvt.tcl.model.DVTTclUtils;

public abstract class DVTPFInterp
extends DVTTclInterp {
    protected DVTPFModel pfModel;

    public DVTPFInterp(DVTPFModel pfModel, IProgressMonitor monitor) {
        super(monitor);
        this.pfModel = pfModel;
    }

    @Override
    protected boolean validateInitialConditions() {
        if (this.pfModel == null || this.pfModel.getScope() == null || this.pfModel.getTopDesign() == null || this.pfModel.getHierarchySeparator() == null || this.pfModel.getPfFilePath() == null || this.pfModel.getAllTops() == null) {
            if (this.pfModel == null) {
                DVTLogger.INSTANCE.logDebug("[PF] Power format model is null");
            } else {
                String message = "[PF] One or more mandatory null elements. [";
                message = String.valueOf(message) + (this.pfModel.getScope() == null ? "Current scope is null. " : "");
                message = String.valueOf(message) + (this.pfModel.getTopDesign() == null ? "Current top design is null. " : "");
                message = String.valueOf(message) + (this.pfModel.getHierarchySeparator() == null ? "Hierarchy separator is null. " : "");
                message = String.valueOf(message) + (this.pfModel.getPfFilePath() == null ? "PF file path is null. " : "");
                message = String.valueOf(message) + (this.pfModel.getAllTops() == null ? "Top config is null. " : "");
                message = String.valueOf(message) + "]";
                DVTTclUtils.printToConsole("[PF] " + message, this.pfModel.getProject(), this.pfModel.getBuildKind(), DVTDebugKind.PF_DEBUG_INFO, this.pfModel.isDebugMode());
            }
            return false;
        }
        return true;
    }

    @Override
    protected void postEvalScriptActions() {
        if (this.pfModel == null) {
            return;
        }
        this.pfModel.executeAllCommands();
    }

    @Override
    protected void addTCLProblem(String message, int lineNumber, String fileName) {
        if (this.pfModel == null) {
            return;
        }
        DVTProblem prob = new DVTProblem(this.pfModel.getProject(), TclProblemKinds.TCL_GENERIC, fileName, false, lineNumber + 1, message);
        if (this.pfModel.reportErrorsToConsole()) {
            prob.setToConsole(true);
        }
        DVTProblemManager.getInstance().reportProblem(prob);
    }

    @Override
    public IProject getProject() {
        if (this.pfModel == null) {
            return null;
        }
        return this.pfModel.getProject();
    }

    @Override
    public int getBuildKind() {
        if (this.pfModel == null) {
            return -1;
        }
        return this.pfModel.getBuildKind();
    }

    @Override
    public void handleException(Exception e, String filePath, int errorLine, String message) {
        if (e instanceof MissingArgumentException) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_MISSING_ARG, this.pfModel, filePath, errorLine, ((MissingArgumentException)e).getOption().getOpt(), message);
        } else if (e instanceof UnrecognizedOptionException) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_NON_EXISTING_ARGUMENT, this.pfModel, filePath, errorLine, ((UnrecognizedOptionException)e).getOption(), message);
        }
        DVTLogger.INSTANCE.logError((Throwable)e);
    }

    @Override
    public boolean isDebugMode() {
        return this.pfModel == null ? false : this.pfModel.isDebugMode();
    }
}

