/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.power.format.DVTPFCommand;
import ro.amiq.dvt.power.format.DVTPFInfo;
import ro.amiq.dvt.power.format.DVTPFIsolationCellInfo;
import ro.amiq.dvt.power.format.DVTPFSupplyNetInfo;
import ro.amiq.dvt.power.format.upf.DVTUPFSupplySet;

public class DVTPFIsolationStrategyInfo {
    private String strategyName;
    private String domainName;
    private String filePath;
    private int startLine;
    private int endLine;
    private Map<ElementPath, Set<DVTPFIsolationCellInfo>> elementPaths;
    private Map<ElementPath, UPFIsolationSense> isolationSignals;
    private boolean noIsolation;
    private String clampValue;
    private boolean forceIsolation;
    private Map<CPFControlType, String> isolationControl;

    public DVTPFIsolationStrategyInfo(String strategyName, String domainName, String fileName, int startLine, int endLine) {
        this.strategyName = strategyName;
        this.domainName = domainName;
        this.filePath = fileName;
        this.startLine = startLine;
        this.endLine = endLine;
        this.elementPaths = new TreeMap<ElementPath, Set<DVTPFIsolationCellInfo>>();
        this.isolationSignals = new HashMap<ElementPath, UPFIsolationSense>();
        this.isolationControl = new EnumMap<CPFControlType, String>(CPFControlType.class);
        this.forceIsolation = false;
        this.noIsolation = false;
    }

    public void addElement(ElementPath fullPath) {
        this.elementPaths.put(fullPath, null);
    }

    public TreeSet<ElementPath> getElements() {
        TreeSet<ElementPath> result = new TreeSet<ElementPath>(DVTPFCommand.ELEMENT_PATH_COMPARATOR);
        result.addAll(this.elementPaths.keySet());
        return result;
    }

    public void mapIsolationCells(ElementPath element, Set<DVTPFIsolationCellInfo> cellsInfo) {
    }

    public void excludeElement(ElementPath fullPath) {
        this.elementPaths.remove(fullPath);
    }

    public String getStrategyName() {
        return this.strategyName;
    }

    public void setSource(String source) {
    }

    public void setSink(String sink) {
    }

    public void setDiffSupplyOnly(boolean diffSupplyOnly) {
    }

    public void setUseEquivalence(boolean useEquivalence) {
    }

    public void addIsolationSupply(DVTUPFSupplySet supplySet) {
    }

    public void setNoIsolation() {
        this.noIsolation = true;
    }

    public boolean isNoIsolation() {
        return this.noIsolation;
    }

    public boolean isForceIsolation() {
        return this.forceIsolation;
    }

    public void setForceIsolation() {
    }

    public void setLocation(UPFIsolationLocation location) {
    }

    public void addInstance(ElementPath instanceFullPath, String port) {
    }

    public void setPowerNet(DVTPFSupplyNetInfo supplyNet) {
    }

    public void setGroundNet(DVTPFSupplyNetInfo groundNet) {
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setNamePrefix(String namePrefix) {
    }

    public void setNameSufix(String nameSufix) {
    }

    public void setClampValue(String clampValue) {
        this.clampValue = clampValue;
    }

    public String getClampValue() {
        return this.clampValue;
    }

    public void addIsolationSignal(ElementPath signalFullPath, UPFIsolationSense isolationSense) throws IllegalArgumentException {
        if (this.isolationSignals.containsKey(signalFullPath)) {
            throw new IllegalArgumentException("Signal ''" + signalFullPath + "'' already specified in '-isolation_signal' agument list");
        }
        this.isolationSignals.put(signalFullPath, isolationSense);
    }

    public void setSecondaryDomain(DVTPFInfo secondaryPD) {
    }

    public void setNoCondition() {
    }

    public void setTarget(CPFIsolationTarget target) {
    }

    public void setIsolationCondition(String isolationCondition) {
    }

    public void addIsolationControl(CPFControlType convertedType, String expr) {
        if (this.isolationControl.containsKey((Object)convertedType)) {
            throw new IllegalArgumentException("Control type ''" + (Object)((Object)convertedType) + "'' already specified in '-isolation_control' agument list");
        }
        this.isolationControl.put(convertedType, expr);
    }

    public void setUseModel() {
    }

    public void setMappedPort(HashMap<String, String> mappedPorts) {
    }

    public void setOpenSourcePinsOnly() {
    }

    public void setWithinHierarchyInstance(String withinHierarchyInstance) {
    }

    public void setCPFLocation(CPFValidLocation location) {
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public void setStartLine(int startLine) {
        this.startLine = startLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public static enum CPFClampValue {
        HIGH,
        LOW,
        HOLD,
        TRISTATE;

    }

    public static enum CPFControlType {
        SYNC_ENABLE,
        SET,
        RESET;

    }

    public static enum CPFIsolationTarget {
        FROM,
        TO;

    }

    public static enum CPFValidLocation {
        FROM,
        TO,
        PARENT,
        SELF,
        AUTOMATIC,
        ANY;

    }

    public static enum UPFAppliesToClampValue {
        ZERO,
        ONE,
        ANY,
        Z,
        LATCH,
        NONE;

    }

    public static enum UPFBoundary {
        LOWER,
        UPPER,
        BOTH;

    }

    public static enum UPFIsolationLocation {
        SELF,
        OTHER,
        PARENT,
        FANOUT;

    }

    public static enum UPFIsolationSense {
        HIGH,
        LOW;

    }

    public static enum UPFPortDirection {
        INPUTS,
        OUTPUTS,
        BOTH;

    }
}

