/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.graphics.RGB;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.DVTPowerFormatKind;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.power.format.DVTPFInfo;
import ro.amiq.dvt.power.format.DVTPFInterfaceCellInfo;
import ro.amiq.dvt.power.format.DVTPFIsolationCellInfo;
import ro.amiq.dvt.power.format.DVTPFIsolationStrategyInfo;
import ro.amiq.dvt.power.format.DVTPFParsedFiles;
import ro.amiq.dvt.power.format.DVTPFRetentionCellInfo;
import ro.amiq.dvt.power.format.DVTPFRetentionListInfo;
import ro.amiq.dvt.power.format.DVTPFRetentionRuleInfo;
import ro.amiq.dvt.power.format.DVTPFSupplyNetInfo;
import ro.amiq.dvt.power.format.DVTPFSupplyPortInfo;
import ro.amiq.dvt.power.format.PFVersionType;
import ro.amiq.dvt.power.format.cpf.DVTCPFMacroModel;
import ro.amiq.dvt.power.format.cpf.DVTCPFSupplyPortInfo;
import ro.amiq.dvt.power.format.upf.DVTUPFPowerSwitchInfo;
import ro.amiq.dvt.power.format.upf.DVTUPFSupplyPortInfo;
import ro.amiq.dvt.power.format.upf.DVTUPFSupplySet;
import ro.amiq.dvt.power.format.utils.DVTPFUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.tcl.model.IDVTTclExecCommand;

public class DVTPFModel {
    private Map<String, String> powerDomainsByInstances;
    private Map<String, String> powerDomainsByExcludedInstances;
    private Map<String, RGB[]> powerDomainsByColor;
    private List<IDVTTclExecCommand> allPFCommands;
    private List<DVTPFParsedFiles> pfParsedFiles;
    private Set<String> pfParsedFilePaths;
    private Map<String, DVTPFInfo> powerDomainInfoByName;
    private Map<String, DVTPFSupplyNetInfo> allSupplyNetsbyName;
    private Map<String, DVTPFSupplyPortInfo> allExplicitlyDeclaredPortsbyName;
    private Map<String, DVTPFSupplyPortInfo> allImplicitlyDeclaredPortsbyName;
    private Map<String, List<DVTPFSupplyPortInfo>> netConnections;
    private Map<String, DVTPFRetentionCellInfo> retentionCellByName;
    private Map<String, Set<DVTPFRetentionCellInfo>> retentionCellsByType;
    private Map<String, DVTPFIsolationCellInfo> isolationCellByName;
    private Map<String, DVTPFInterfaceCellInfo> interfaceCellsByName;
    private Map<String, DVTUPFPowerSwitchInfo> allPowerSwitches;
    private Map<String, DVTUPFSupplySet> allSupplySets;
    private Map<String, DVTPFRetentionListInfo> retentionListByName;
    private Map<String, List<String>> baseDomains;
    private Map<String, DVTPFRetentionRuleInfo> retentionRulesByName;
    private Map<String, DVTPFIsolationStrategyInfo> isolationStrategiesByName;
    private String macroModel;
    private Map<String, DVTCPFMacroModel> macroModels;
    private Deque<UPFVersionType> upfVersions;
    protected String rootPfFile;
    private Deque<CPFVersionType> cpfVersions;
    private IRfDesignElement topDesign;
    private Deque<ElementPath> scopes;
    private String hierarchySeparator;
    private String currentParsedPfFile;
    private DVTPowerFormatKind pfKind;
    private int buildKind;
    private List<IRfDesignElement> allTops;

    public DVTPFModel(String pfFilePath, List<IRfDesignElement> allTops, DVTPowerFormatKind kind, int buildKind) {
        this.rootPfFile = pfFilePath;
        this.currentParsedPfFile = pfFilePath;
        this.allTops = new ArrayList<IRfDesignElement>();
        for (IRfDesignElement top : allTops) {
            if (top == null) continue;
            if (top.getKind() == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE) {
                top = ((IRfBlockElement)top).getEntity();
            }
            this.allTops.add(top);
        }
        this.pfKind = kind;
        this.buildKind = buildKind;
        this.scopes = new ArrayDeque<ElementPath>();
        this.upfVersions = new ArrayDeque<UPFVersionType>();
        this.cpfVersions = new ArrayDeque<CPFVersionType>();
        this.initDefaultElements();
    }

    private void initDefaultElements() {
        this.powerDomainsByInstances = new HashMap<String, String>();
        this.powerDomainsByColor = new HashMap<String, RGB[]>();
        this.powerDomainsByExcludedInstances = new HashMap<String, String>();
        this.pfParsedFiles = new ArrayList<DVTPFParsedFiles>();
        this.allPFCommands = new ArrayList<IDVTTclExecCommand>();
        this.pfParsedFilePaths = new LinkedHashSet<String>();
        this.allExplicitlyDeclaredPortsbyName = new HashMap<String, DVTPFSupplyPortInfo>();
        this.allImplicitlyDeclaredPortsbyName = new HashMap<String, DVTPFSupplyPortInfo>();
        this.allSupplyNetsbyName = new HashMap<String, DVTPFSupplyNetInfo>();
        this.allPowerSwitches = new HashMap<String, DVTUPFPowerSwitchInfo>();
        this.powerDomainInfoByName = new HashMap<String, DVTPFInfo>();
        this.baseDomains = new HashMap<String, List<String>>();
        this.macroModels = new HashMap<String, DVTCPFMacroModel>();
        this.allSupplySets = new HashMap<String, DVTUPFSupplySet>();
        this.netConnections = new HashMap<String, List<DVTPFSupplyPortInfo>>();
        this.retentionRulesByName = new HashMap<String, DVTPFRetentionRuleInfo>();
        this.retentionListByName = new HashMap<String, DVTPFRetentionListInfo>();
        this.retentionCellByName = new HashMap<String, DVTPFRetentionCellInfo>();
        this.retentionCellsByType = new HashMap<String, Set<DVTPFRetentionCellInfo>>();
        this.isolationStrategiesByName = new HashMap<String, DVTPFIsolationStrategyInfo>();
        this.isolationCellByName = new HashMap<String, DVTPFIsolationCellInfo>();
        this.interfaceCellsByName = new HashMap<String, DVTPFInterfaceCellInfo>();
        DVTPFParsedFiles pfParsedFile = new DVTPFParsedFiles();
        pfParsedFile.included = this.rootPfFile;
        this.pfParsedFiles.add(pfParsedFile);
        this.pfParsedFilePaths.add(this.rootPfFile);
        this.hierarchySeparator = this.getSeparator(this.pfKind);
        this.upfVersions.push(UPFVersionType.v1_0);
        this.cpfVersions.push(CPFVersionType.v1_0);
        List<IRfDesignElement> designTops = this.allTops;
        if (designTops == null) {
            DVTLogger.INSTANCE.logDebug("POWER FORMAT: No design top selected!");
            return;
        }
        IRfDesignElement firstDesign = designTops.get(0);
        if (firstDesign == null) {
            DVTLogger.INSTANCE.logDebug("Power Format: Current design is null!");
            return;
        }
        if (firstDesign.getKind() == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE) {
            firstDesign = ((IRfBlockElement)firstDesign).getEntity();
        }
        if (firstDesign.isDirtyElement()) {
            return;
        }
        this.topDesign = firstDesign;
        ElementPath currentScope = ElementPath.from(this.topDesign.getName(), this.hierarchySeparator);
        if (currentScope == null || currentScope.isEmpty()) {
            DVTLogger.INSTANCE.logDebug("Power Format: Current scope is null!");
            return;
        }
        this.scopes.push(currentScope);
    }

    public ElementPath getScope() {
        if (this.scopes.isEmpty()) {
            return null;
        }
        return this.scopes.peek();
    }

    public void popScope() {
        if (this.scopes.isEmpty()) {
            return;
        }
        this.scopes.pop();
    }

    public void addPowerDomainColor(String powerDomainName, RGB[] powerDomainColors) {
        if (this.powerDomainsByColor == null) {
            this.powerDomainsByColor = new HashMap<String, RGB[]>();
        }
        this.powerDomainsByColor.put(powerDomainName, powerDomainColors);
    }

    public void addInstanceToPD(ElementPath instance, String pdName) {
        if (this.powerDomainsByInstances == null) {
            this.powerDomainsByInstances = new HashMap<String, String>();
        }
        this.powerDomainsByInstances.put(instance.toString("/"), pdName);
    }

    public void addExcludedInstance(ElementPath excludedInstance, String pdName) {
        if (this.powerDomainsByExcludedInstances == null) {
            this.powerDomainsByExcludedInstances = new HashMap<String, String>();
        }
        this.powerDomainsByExcludedInstances.put(excludedInstance.toString("/"), pdName);
    }

    public void addPfCommand(IDVTTclExecCommand pfCommand) {
        if (this.allPFCommands == null) {
            this.allPFCommands = new ArrayList<IDVTTclExecCommand>();
        }
        this.allPFCommands.add(pfCommand);
    }

    public List<IDVTTclExecCommand> getPfCommands() {
        if (this.allPFCommands == null) {
            return new ArrayList<IDVTTclExecCommand>();
        }
        return this.allPFCommands;
    }

    public List<String> getAllPDForInstance(String name) {
        if (this.powerDomainsByInstances == null || this.powerDomainsByInstances.isEmpty()) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String elem : this.powerDomainsByInstances.keySet()) {
            DVTPFInfo dvtupfInfo;
            String lastSegment;
            IPath elemPath = Path.fromPortableString((String)elem);
            if (elem == null || (lastSegment = elemPath.lastSegment()) == null || !lastSegment.equals(name) || (dvtupfInfo = this.getPDInfoForInstance(elem)) == null) continue;
            result.add(String.valueOf(String.format("%1$-50s", elem)) + " [" + dvtupfInfo.getPowerDomainName() + "]");
        }
        return result.isEmpty() ? null : result;
    }

    public DVTPFInfo getPDInfoForInstance(ElementPath path) {
        if (path == null) {
            return null;
        }
        return this.getPDInfoForInstance(path.toString("/"));
    }

    public DVTPFInfo getPDInfoForInstance(String path) {
        if (this.powerDomainsByInstances == null) {
            return null;
        }
        String pdName = this.powerDomainsByInstances.get(path);
        if (pdName == null) {
            return null;
        }
        return this.powerDomainInfoByName.get(pdName);
    }

    public List<String> getPDForPathTooltip(ElementPath path) {
        if (this.powerDomainsByInstances == null || this.powerDomainsByInstances.isEmpty()) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        DVTPFInfo dvtupfInfo = this.getPDInfoForInstance(path);
        if (dvtupfInfo == null) {
            return null;
        }
        result.add(String.format("[PD : " + dvtupfInfo.getPowerDomainName() + "] " + "%1$-50s", path.toString("/")));
        return result;
    }

    public String getPDNameForPath(ElementPath pathToTop) {
        if (pathToTop == null) {
            return null;
        }
        DVTPFInfo upfInfo = this.getPDInfoForInstance(pathToTop);
        if (upfInfo == null) {
            return null;
        }
        return upfInfo.getPowerDomainName();
    }

    public RGB getPDBgRGBForPath(ElementPath pathToTop) {
        if (pathToTop == null) {
            return null;
        }
        String pathString = pathToTop.toString("/");
        if (pathString == null || pathString.isEmpty()) {
            return null;
        }
        DVTPFInfo upfInfo = this.getPDInfoForInstance(pathToTop);
        if (upfInfo == null) {
            return null;
        }
        return upfInfo.getPowerDomainBgRGB();
    }

    public String getPfFilePath() {
        return this.rootPfFile;
    }

    public List<IRfDesignElement> getAllTops() {
        return this.allTops;
    }

    public String getHierarchySeparator() {
        return this.hierarchySeparator;
    }

    public void setHierarchySeparator(String hierarchySeparator) {
        this.hierarchySeparator = hierarchySeparator;
    }

    public RGB[] getPowerDomainColor(String powerDomainName) {
        if (this.powerDomainsByColor == null || this.powerDomainsByColor.isEmpty()) {
            return null;
        }
        return this.powerDomainsByColor.get(powerDomainName);
    }

    public Set<String> getExcludedInstances() {
        if (this.powerDomainsByExcludedInstances == null) {
            this.powerDomainsByExcludedInstances = new HashMap<String, String>();
        }
        return this.powerDomainsByExcludedInstances.keySet();
    }

    public void removeInstanceFromPD(String instanceName) {
        if (this.powerDomainsByInstances == null) {
            return;
        }
        this.powerDomainsByInstances.remove(instanceName);
    }

    public boolean isInstanceInPD(ElementPath instance) {
        if (this.powerDomainsByInstances == null) {
            return false;
        }
        return this.powerDomainsByInstances.containsKey(instance.toString("/"));
    }

    public boolean hasPowerDomains() {
        return this.powerDomainsByInstances != null && !this.powerDomainsByInstances.keySet().isEmpty();
    }

    public void clear() {
        if (this.powerDomainsByInstances != null) {
            this.powerDomainsByInstances.clear();
        } else {
            this.powerDomainsByInstances = new HashMap<String, String>();
        }
        if (this.powerDomainsByColor != null) {
            this.powerDomainsByColor.clear();
        } else {
            this.powerDomainsByColor = new HashMap<String, RGB[]>();
        }
        if (this.powerDomainsByExcludedInstances != null) {
            this.powerDomainsByExcludedInstances.clear();
        } else {
            this.powerDomainsByExcludedInstances = new HashMap<String, String>();
        }
        if (this.getBuildKind() == 6) {
            if (this.allPFCommands != null) {
                this.allPFCommands.clear();
            } else {
                this.allPFCommands = new ArrayList<IDVTTclExecCommand>();
            }
            if (this.pfParsedFiles != null) {
                this.pfParsedFiles.clear();
            } else {
                this.pfParsedFiles = new ArrayList<DVTPFParsedFiles>();
            }
            if (this.pfParsedFilePaths != null) {
                this.pfParsedFilePaths.clear();
            } else {
                this.pfParsedFilePaths = new LinkedHashSet<String>();
            }
        }
    }

    public List<DVTPFParsedFiles> getAllParsedPfFiles() {
        if (this.pfParsedFiles == null) {
            return Collections.emptyList();
        }
        return this.pfParsedFiles;
    }

    public Set<String> getParsedPfFileSet() {
        if (this.pfParsedFilePaths == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.pfParsedFilePaths);
    }

    public void addPfParsedFile(DVTPFParsedFiles pfParsedFile) {
        this.pfParsedFiles.add(pfParsedFile);
        this.pfParsedFilePaths.add(pfParsedFile.included);
    }

    public UPFVersionType getUPFVersion() {
        if (this.upfVersions.isEmpty()) {
            return UPFVersionType.v1_0;
        }
        return this.upfVersions.peek();
    }

    public CPFVersionType getCPFVersion() {
        if (this.cpfVersions.isEmpty()) {
            return CPFVersionType.v1_0;
        }
        return this.cpfVersions.peek();
    }

    public void setUpfVersion(UPFVersionType version) {
        this.upfVersions.push(version);
    }

    public void setCpfVersion(CPFVersionType version) {
        this.cpfVersions.push(version);
    }

    public void popUpfVersion() {
        if (this.upfVersions.isEmpty()) {
            return;
        }
        this.upfVersions.pop();
    }

    public IRfDesignElement getTopDesign() {
        return this.topDesign;
    }

    public void setTopDesign(IRfDesignElement topDesign) {
        if (topDesign != null && topDesign.getKind() == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE) {
            topDesign = ((IRfBlockElement)topDesign).getEntity();
        }
        this.topDesign = topDesign;
    }

    public void addScope(ElementPath scopePath) {
        scopePath = DVTPFUtils.replaceGenBlocksHierarchicalDelim(this.hierarchySeparator, scopePath);
        this.scopes.push(scopePath);
    }

    public DVTPowerFormatKind getPfKind() {
        return this.pfKind;
    }

    private String getSeparator(DVTPowerFormatKind kind) {
        switch (kind) {
            case CPF: {
                return ".";
            }
            case UPF: {
                return "/";
            }
        }
        return "/";
    }

    public void executeAllCommands() {
        if (this.allPFCommands == null || this.allPFCommands.isEmpty()) {
            return;
        }
        for (IDVTTclExecCommand command : this.allPFCommands) {
            command.executeCommand();
        }
        for (String excludedInstance : this.getExcludedInstances()) {
            if (!this.isInstanceInPD(ElementPath.from(excludedInstance, "/"))) continue;
            this.removeInstanceFromPD(excludedInstance);
        }
        if (this.getPfKind() == DVTPowerFormatKind.CPF) {
            this.resolveMacroModels();
            this.resolveCPFSupplyConnectionsBasedOnBaseDomains();
        }
    }

    public IProject getProject() {
        if (this.topDesign == null) {
            return null;
        }
        if (this.topDesign.getRfProject() == null) {
            return null;
        }
        return this.topDesign.getRfProject().getProject();
    }

    public String getCurrentParsedPfFile() {
        return this.currentParsedPfFile;
    }

    public void setCurrentParsedPfFile(String currentParsedPfFile) {
        this.currentParsedPfFile = currentParsedPfFile;
    }

    public void setBuildKind(int buildKind) {
        this.buildKind = buildKind;
    }

    public int getBuildKind() {
        return this.buildKind;
    }

    public boolean reportErrorsToConsole() {
        boolean isPfDebugEnabled = BuildConfigManager.isPfDebug(this.getProject());
        if (isPfDebugEnabled) {
            return true;
        }
        return this.buildKind == 6;
    }

    public DVTPFInfo getPDInfoForPDName(String pdName) {
        return this.powerDomainInfoByName.get(pdName);
    }

    public void addPfInfo(String pdName, DVTPFInfo info) {
        this.powerDomainInfoByName.put(pdName, info);
    }

    public Collection<DVTPFInfo> getAllPDInfo() {
        return this.powerDomainInfoByName.values();
    }

    public void addSupplyNet(DVTPFSupplyNetInfo supplyNetInfo) {
        if (supplyNetInfo == null) {
            return;
        }
        this.allSupplyNetsbyName.put(supplyNetInfo.getName(), supplyNetInfo);
    }

    public Collection<DVTPFSupplyNetInfo> getAllSupplyNetInfo() {
        if (this.allSupplyNetsbyName == null) {
            return Collections.emptySet();
        }
        return this.allSupplyNetsbyName.values();
    }

    public DVTPFSupplyNetInfo getSupplyNetInfo(String supplyNetName) {
        if (supplyNetName == null) {
            return null;
        }
        return this.allSupplyNetsbyName.get(supplyNetName);
    }

    public DVTUPFPowerSwitchInfo getPowerSwitchInfo(String powerSwitchName) {
        if (powerSwitchName == null) {
            return null;
        }
        return this.allPowerSwitches.get(powerSwitchName);
    }

    public Collection<DVTUPFPowerSwitchInfo> getPowerSwitchInfos() {
        if (this.allPowerSwitches == null) {
            return Collections.emptyList();
        }
        return this.allPowerSwitches.values();
    }

    public void addExplicityCreatedSupplyPort(DVTPFSupplyPortInfo supplyPortInfo) {
        if (supplyPortInfo == null) {
            return;
        }
        this.allExplicitlyDeclaredPortsbyName.put(supplyPortInfo.getNetName(), supplyPortInfo);
    }

    public DVTPFSupplyPortInfo getExplicityCreatedSupplyPort(String name) {
        return this.allExplicitlyDeclaredPortsbyName.get(name);
    }

    public DVTPFSupplyPortInfo getImpltcitlyCreatedSupplyPort(String name) {
        return this.allImplicitlyDeclaredPortsbyName.get(name);
    }

    public void addImplicitSupplyPort(DVTPFSupplyPortInfo supplyPortInfo) {
        if (supplyPortInfo == null) {
            return;
        }
        this.allImplicitlyDeclaredPortsbyName.put(supplyPortInfo.getNetName(), supplyPortInfo);
    }

    public Collection<DVTPFSupplyPortInfo> getAllExplicitlyDeclaredPorts() {
        return this.allExplicitlyDeclaredPortsbyName.values();
    }

    public DVTPFSupplyPortInfo getSupplyPortInfo(String portName) {
        DVTPFSupplyPortInfo supplyPortInfo = this.allExplicitlyDeclaredPortsbyName.get(portName);
        if (supplyPortInfo == null) {
            return this.allImplicitlyDeclaredPortsbyName.get(portName);
        }
        return supplyPortInfo;
    }

    public Collection<RGB[]> getColors() {
        return this.powerDomainsByColor.values();
    }

    public void addPowerSwitch(DVTUPFPowerSwitchInfo powerSwitchInfo) {
        if (powerSwitchInfo == null) {
            return;
        }
        this.allPowerSwitches.put(powerSwitchInfo.getName(), powerSwitchInfo);
    }

    public void addToBaseDomain(String baseDomain, String childDomain) {
        if (!this.baseDomains.containsKey(baseDomain)) {
            this.baseDomains.put(baseDomain, new ArrayList());
        }
        this.baseDomains.get(baseDomain).add(childDomain);
    }

    public void addToBaseDomain(String baseDomain, List<String> domains) {
        if (domains == null) {
            return;
        }
        if (!this.baseDomains.containsKey(baseDomain)) {
            this.baseDomains.put(baseDomain, domains);
        }
        this.baseDomains.get(baseDomain).addAll(domains);
    }

    public List<String> getDomainsForBaseDomain(String domainName) {
        return this.baseDomains.get(domainName);
    }

    public void resolveCPFSupplyConnectionsBasedOnBaseDomains() {
        for (Map.Entry<String, List<String>> entry : this.baseDomains.entrySet()) {
            String baseDomain = entry.getKey();
            DVTPFInfo pdInfo = this.getPDInfoForPDName(baseDomain);
            if (pdInfo == null) continue;
            for (String childDomain : entry.getValue()) {
                this.addPrimarySupplyNets(pdInfo, childDomain, true);
                this.addPrimarySupplyNets(pdInfo, childDomain, false);
            }
        }
    }

    public void resolveMacroModels() {
        for (String macroModelName : this.macroModels.keySet()) {
            DVTCPFMacroModel macroModel = this.getMacroModel(macroModelName);
            if (macroModel == null) continue;
            macroModel.resolveMacroModel(this);
        }
    }

    private void addPrimarySupplyNets(DVTPFInfo pdInfo, String domain, boolean isGround) {
        DVTPFSupplyPortInfo primarySupplyPort;
        DVTPFInfo domainInfo = this.getPDInfoForPDName(domain);
        if (domainInfo == null) {
            return;
        }
        if (isGround && domainInfo.getPrimaryGroundSupply() != null) {
            return;
        }
        if (!isGround && domainInfo.getPrimaryPowerSupply() != null) {
            return;
        }
        DVTPFSupplyPortInfo dVTPFSupplyPortInfo = primarySupplyPort = isGround ? pdInfo.getPrimaryGroundSupply() : pdInfo.getPrimaryPowerSupply();
        if (primarySupplyPort == null) {
            return;
        }
        DVTPFSupplyNetInfo primarySupplyNet = this.getSupplyNetInfo(primarySupplyPort.getNetName());
        if (primarySupplyNet == null) {
            return;
        }
        String direction = isGround ? "out" : "in";
        DVTCPFSupplyPortInfo domainPrimaryPort = new DVTCPFSupplyPortInfo(primarySupplyPort.getNetName(), primarySupplyPort.getPortName(), primarySupplyPort.getNetName(), direction, domain);
        domainPrimaryPort.setGotoInfos(primarySupplyPort.getGotoInfos());
        if (isGround) {
            domainInfo.setPrimaryGroundSupply(domainPrimaryPort);
        } else {
            domainInfo.setPrimaryPowerSupply(domainPrimaryPort);
        }
        primarySupplyNet.connectToPort(domainPrimaryPort);
    }

    public Map<String, List<String>> getBaseDomains() {
        if (this.baseDomains == null) {
            return Collections.emptyMap();
        }
        return this.baseDomains;
    }

    public String removeFromBaseDomain(String pdName) {
        if (this.baseDomains == null) {
            return null;
        }
        String foundInDomain = null;
        for (Map.Entry<String, List<String>> entry : this.baseDomains.entrySet()) {
            String domain = entry.getKey();
            if (!entry.getValue().contains(pdName)) continue;
            foundInDomain = domain;
            break;
        }
        if (foundInDomain == null) {
            return null;
        }
        this.baseDomains.get(foundInDomain).remove(pdName);
        return foundInDomain;
    }

    public void setCurrMacroModel(String macroModel) {
        this.macroModel = macroModel;
    }

    public String getCurrMacroModel() {
        return this.macroModel;
    }

    public void addCPFMacroModel(DVTCPFMacroModel cpfMacroModel) {
        if (cpfMacroModel == null || cpfMacroModel.getMacroModelName() == null) {
            return;
        }
        String macroModelName = cpfMacroModel.getMacroModelName();
        if (!this.macroModels.containsKey(macroModelName)) {
            this.macroModels.put(macroModelName, cpfMacroModel);
        }
    }

    public DVTCPFMacroModel getMacroModel(String macroModelName) {
        return this.macroModels.get(macroModelName);
    }

    public void addSupplySet(DVTUPFSupplySet supplySet) {
        if (supplySet == null) {
            return;
        }
        String supplySetName = supplySet.getName();
        if (supplySetName == null) {
            return;
        }
        this.allSupplySets.put(supplySetName, supplySet);
    }

    public DVTUPFSupplySet getSupplySet(String name) {
        return this.allSupplySets.get(name);
    }

    public DVTPFSupplyPortInfo getExplicitPort(String name) {
        return this.allExplicitlyDeclaredPortsbyName.get(name);
    }

    public void addPortsToNetConnection(String netName, List<String> ports, String domainName) {
        if (ports == null) {
            return;
        }
        if (!this.netConnections.containsKey(netName)) {
            this.netConnections.put(netName, new ArrayList());
        }
        for (String port : ports) {
            DVTPFSupplyPortInfo supplyPortInfo = this.getSupplyPortInfo(port);
            DVTUPFSupplyPortInfo portInfo = null;
            if (supplyPortInfo == null) {
                portInfo = new DVTUPFSupplyPortInfo(port, port, port, "in", domainName);
                portInfo.addGoToInfo("Implicit port", -1, -1);
            } else {
                portInfo = new DVTUPFSupplyPortInfo(supplyPortInfo.getNetName(), supplyPortInfo.getPortName(), supplyPortInfo.getLabel(), supplyPortInfo.getDirection(), domainName);
                portInfo.setGotoInfos(supplyPortInfo.getGotoInfos());
            }
            this.netConnections.get(netName).add(portInfo);
        }
    }

    public DVTPFSupplyPortInfo getPortConnectionForNetName(String netName, String domainName) {
        if (this.netConnections == null) {
            return null;
        }
        if (!this.netConnections.containsKey(netName)) {
            return null;
        }
        for (DVTPFSupplyPortInfo port : this.netConnections.get(netName)) {
            if (port.getDomainName() != null && !port.getDomainName().equals(domainName)) continue;
            return port;
        }
        return null;
    }

    public boolean isDebugMode() {
        return BuildConfigManager.isPfDebug(this.getProject());
    }

    public DVTPFRetentionListInfo getRetentionListByName(String name) {
        return this.retentionListByName.get(name);
    }

    public void addRetentionListByName(String name, DVTPFRetentionListInfo retentionList) {
        this.retentionListByName.put(name, retentionList);
    }

    public DVTPFRetentionCellInfo getRetentionCellByName(String cell) {
        return this.retentionCellByName.get(cell);
    }

    public void addRetentionCellByName(String cell, DVTPFRetentionCellInfo cellInfo) {
        this.retentionCellByName.put(cell, cellInfo);
    }

    public void addRetentionCellsByType(String cellType, DVTPFRetentionCellInfo cellInfo) {
        Set<DVTPFRetentionCellInfo> cellsSet = this.retentionCellsByType.get(cellType);
        if (cellsSet == null) {
            cellsSet = new HashSet<DVTPFRetentionCellInfo>();
        }
        cellsSet.add(cellInfo);
        this.retentionCellsByType.put(cellType, cellsSet);
    }

    public Set<DVTPFRetentionCellInfo> getRetentionCellsByType(String cellType) {
        return this.retentionCellsByType.get(cellType);
    }

    public void addIsolationCellByName(String cell, DVTPFIsolationCellInfo cellInfo) {
        this.isolationCellByName.put(cell, cellInfo);
    }

    public DVTPFIsolationCellInfo getIsolationCellByName(String cell) {
        return this.isolationCellByName.get(cell);
    }

    public void addInterfaceCellByName(String interfaceName, DVTPFInterfaceCellInfo interfaceCell) {
        this.interfaceCellsByName.put(interfaceName, interfaceCell);
    }

    public DVTPFInterfaceCellInfo getInterfaceCellsByName(String interfaceName) {
        return this.interfaceCellsByName.get(interfaceName);
    }

    public void addRetentionRuleByName(String retentionRuleName, DVTPFRetentionRuleInfo retentionRule) {
        this.retentionRulesByName.put(retentionRuleName, retentionRule);
    }

    public DVTPFRetentionRuleInfo getRetentionRuleByName(String name) {
        return this.retentionRulesByName.get(name);
    }

    public void addIsolationStrategyByName(String retentionRuleName, DVTPFIsolationStrategyInfo retentionRule) {
        this.isolationStrategiesByName.put(retentionRuleName, retentionRule);
    }

    public DVTPFIsolationStrategyInfo getIsolationStrategyByName(String name) {
        return this.isolationStrategiesByName.get(name);
    }

    public static enum CPFVersionType implements PFVersionType
    {
        v1_0,
        v1_1,
        v2_0,
        v2_1;


        @Override
        public String toNiceString() {
            return this.toString().replace('_', '.');
        }
    }

    public static enum UPFVersionType implements PFVersionType
    {
        v1_0,
        v2_0,
        v2_1,
        v2_2,
        v3_0;


        @Override
        public String toNiceString() {
            return this.toString().replace('_', '.');
        }
    }
}

