/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format;

import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.model.problems.PFProblemKinds;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.power.format.utils.DVTPFUtils;

public class DVTPFRetentionCellInfo {
    private String name;

    public DVTPFRetentionCellInfo(String name, String powerPin, String groundPin) {
        this.name = name;
        this.setHoldCheck(new ArrayList<String>());
        this.setAlwaysOnComponents(new ArrayList<IRfNamedElement>());
    }

    public String getName() {
        return this.name;
    }

    public void setAlwaysOnPins(List<String> alwaysOnPins) {
    }

    public void setRestoreFunction(String pin, ActiveState state) {
    }

    public void setSaveFunction(String pin, ActiveState state) {
    }

    public void setRestoreCheck(String restoreCheck) {
    }

    public void setSaveCheck(String saveCheck) {
    }

    public void setRetentionCheck(String retentionCheck) {
    }

    public void setHoldCheck(List<String> holdCheck) {
    }

    public void setAlwaysOnComponents(List<IRfNamedElement> alwaysOnComponents) {
    }

    public void setSwitchablePowerPin(String switchablePowerPin) {
    }

    public void setSwitchableGroundPin(String switchableGroundPin) {
    }

    public void setClockPin(String clockPin) {
    }

    public static enum ActiveState {
        HIGH("high"),
        LOW("low"),
        POSEDGE("posedge"),
        NEGEDGE("negedge");

        private String name;

        private ActiveState(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static ActiveState from(String level, DVTPFModel pfModel, String currParsedPfFile, int errorLine, String command) {
            ActiveState[] activeStateArray = ActiveState.values();
            int n = activeStateArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActiveState state = activeStateArray[n2];
                if (state.getName().equalsIgnoreCase(level)) {
                    return state;
                }
                ++n2;
            }
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_INVALID_VALUE, pfModel, currParsedPfFile, errorLine, level, command);
            return null;
        }
    }

    private static class CellFunction {
        String pin;
        ActiveState state;

        public CellFunction(String pin, ActiveState state) {
            this.pin = pin;
            this.state = state;
        }
    }
}

