/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.power.format.DVTPFCommand;
import ro.amiq.dvt.power.format.DVTPFInfo;
import ro.amiq.dvt.power.format.DVTPFRetentionCellInfo;
import ro.amiq.dvt.power.format.DVTPFSupplyNetInfo;
import ro.amiq.dvt.power.format.upf.DVTUPFSupplySet;

public class DVTPFRetentionRuleInfo {
    private String ruleName;
    private String domainName;
    private String filePath;
    private int startLine;
    private int endLine;
    private Map<ElementPath, Set<DVTPFRetentionCellInfo>> elementPaths;
    private boolean noRetention;

    public DVTPFRetentionRuleInfo(String ruleName, String domainName, String fileName, int startLine, int endLine) {
        this.ruleName = ruleName;
        this.domainName = domainName;
        this.filePath = fileName;
        this.startLine = startLine;
        this.endLine = endLine;
        this.elementPaths = new TreeMap<ElementPath, Set<DVTPFRetentionCellInfo>>();
        this.noRetention = false;
    }

    public void addElement(ElementPath fullPath) {
        this.elementPaths.put(fullPath, null);
    }

    public TreeSet<ElementPath> getElements() {
        TreeSet<ElementPath> result = new TreeSet<ElementPath>(DVTPFCommand.ELEMENT_PATH_COMPARATOR);
        result.addAll(this.elementPaths.keySet());
        return result;
    }

    public void mapRetentionCells(ElementPath element, Set<DVTPFRetentionCellInfo> cellsInfo) {
        Set<DVTPFRetentionCellInfo> retentionCells = this.elementPaths.get(element);
        if (retentionCells == null) {
            retentionCells = new HashSet<DVTPFRetentionCellInfo>();
        }
        retentionCells.addAll(cellsInfo);
        this.elementPaths.put(element, retentionCells);
    }

    public void excludeElement(ElementPath fullPath) {
        this.elementPaths.remove(fullPath);
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public void setNoRetention() {
        this.noRetention = true;
    }

    public boolean isNoRetention() {
        return this.noRetention;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public void setStartLine(int startLine) {
        this.startLine = startLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public void setRetentionSupplySet(DVTUPFSupplySet retentionSupplySet) {
    }

    public void setPowerNet(DVTPFSupplyNetInfo supplyNet) {
    }

    public void setGroundNet(DVTPFSupplyNetInfo groundNet) {
    }

    public void setRetentionCondition(String retentionCondition) {
    }

    public void setSaveCondition(String saveCondition) {
    }

    public void setRestoreCondition(String restoreCondition) {
    }

    public void setAssertRMutex(RetentionSignal assertRMutex) {
    }

    public void setAssertSMutex(RetentionSignal assertSMutex) {
    }

    public void setAssertRSMutex(RetentionSignal assertRSMutex) {
    }

    public void setUseRetentionAsPrimary() {
    }

    public void setRetentionSupplyCorruption(RetentionParameters retentionSupplyCorruption) {
    }

    public void setSaveRestoreCorruptionOption(RetentionParameters saveRestoreCorruptionOption) {
    }

    public void addInstance(ElementPath instanceFullPath) {
    }

    public void setRequired(boolean required) {
    }

    public void setSaveEdge(String saveEdge) {
    }

    public void setRestoreEdge(String restoreEdge) {
    }

    public void setSaveLevel(String saveLevel) {
    }

    public void setRestoreLevel(String restoreLevel) {
    }

    public void seTargetType(TargetType targetType) {
    }

    public void setSecondaryDomain(DVTPFInfo secondaryPD) {
    }

    public void setUseSecondary() {
    }

    public void setResetControl() {
    }

    public void setUseModel() {
    }

    public void setMappedPort(HashMap<String, String> mappedPorts) {
    }

    public void setSignal(IRfNamedElement signal, DVTPFRetentionCellInfo.ActiveState level, SIGNAL_TYPE type) {
    }

    public static enum RetentionParameters {
        RET_SUP_COR,
        NO_RET_SUP_COR,
        SAV_RES_COR,
        NO_SAV_RES_COR;

    }

    public static class RetentionSignal {
        private IRfFieldElement signal;
        private DVTPFRetentionCellInfo.ActiveState level;
        private SIGNAL_TYPE type;

        public RetentionSignal(IRfFieldElement signal, DVTPFRetentionCellInfo.ActiveState level, SIGNAL_TYPE type) {
            this.signal = signal;
            this.level = level;
            this.type = type;
        }

        public IRfFieldElement getSignal() {
            return this.signal;
        }

        public DVTPFRetentionCellInfo.ActiveState getLevel() {
            return this.level;
        }

        public SIGNAL_TYPE getType() {
            return this.type;
        }
    }

    public static enum SIGNAL_TYPE {
        SAVE,
        RESTORE,
        ASSERT_R_MUTEX,
        ASSERT_S_MUTEX,
        ASSERT_RS_MUTEX;

    }

    public static enum TargetType {
        FLOP,
        LATCH,
        BOTH;

    }
}

