/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format;

import java.io.File;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.model.problems.PFProblemKinds;
import ro.amiq.dvt.power.format.DVTPFCommand;
import ro.amiq.dvt.power.format.DVTPFParsedFiles;
import ro.amiq.dvt.power.format.DVTPFSetCurrentFileDummyCommand;
import ro.amiq.dvt.power.format.utils.DVTPFUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.tcl.model.DVTDebugKind;
import ro.amiq.dvt.tcl.model.DVTTclCommandArg;
import ro.amiq.dvt.tcl.model.DVTTclUtils;
import ro.amiq.dvt.tcl.model.IDVTCommandType;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclObject;

public class DVTPFSourceCommand
extends DVTPFCommand {
    public DVTPFSourceCommand(IDVTCommandType type) {
        super(type);
    }

    @Override
    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        try {
            String loadedFile = "";
            int offset = interp.getOffset(objv[0]);
            super.cmdProc(interp, objv);
            if (this.pfModel == null) {
                return;
            }
            int i = 0;
            while (i < this.args.length) {
                String argName;
                DVTTclCommandArg currentArg = this.args[i];
                if (currentArg != null && (argName = currentArg.getArgName()) != null && !argName.isEmpty() && "source".equals(argName)) {
                    if (++i > this.args.length - 1) {
                        DVTPFUtils.addPfProblem(PFProblemKinds.PF_MISSING_ARG, this.pfModel, interp.scriptFile, currentArg.getArgLine(), "filename", "source");
                        return;
                    }
                    DVTTclCommandArg nextArg = this.args[i];
                    loadedFile = nextArg.getArgName();
                    break;
                }
                ++i;
            }
            if (loadedFile == null || loadedFile.isEmpty()) {
                DVTPFUtils.addPfProblem(PFProblemKinds.PF_MISSING_ARG, this.pfModel, interp.scriptFile, this.args[0].getArgLine(), "filename", "source");
                return;
            }
            if (!Path.fromOSString((String)loadedFile).isAbsolute()) {
                loadedFile = new File(interp.getWorkingDir(), loadedFile).getAbsolutePath();
            }
            DVTPFParsedFiles pfInclude = new DVTPFParsedFiles();
            pfInclude.including = interp.scriptFile;
            pfInclude.included = loadedFile;
            pfInclude.offset = offset;
            pfInclude.includeCommand = this.args[0].getArgName();
            this.pfModel.addPfParsedFile(pfInclude);
            this.pfModel.addPfCommand(new DVTPFSetCurrentFileDummyCommand(loadedFile, this.pfModel));
            String message = "    TCL source " + pfInclude.including + " @ " + this.args[0].getArgLine() + " : sourcing " + pfInclude.included;
            DVTTclUtils.printToConsole(message, this.pfModel.getProject(), this.pfModel.getBuildKind(), DVTDebugKind.TCL_DEBUG_INFO, this.pfModel.isDebugMode());
            interp.evalFile(loadedFile);
            this.pfModel.addPfCommand(new DVTPFSetCurrentFileDummyCommand(interp.scriptFile, this.pfModel));
        }
        catch (TclException e) {
            throw e;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void executeCommand() {
    }
}

