/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.power.format.DVTPFSupplyPortInfo;

public abstract class DVTPFSupplyNetInfo {
    private List<GoToInfo> gotoInfos;
    private List<DVTPFSupplyPortInfo> connectedPorts;
    private String name;

    public DVTPFSupplyNetInfo(String name) {
        this.name = name;
        this.connectedPorts = new ArrayList<DVTPFSupplyPortInfo>();
        this.gotoInfos = new ArrayList<GoToInfo>();
    }

    public List<DVTPFSupplyPortInfo> getConnectedPorts() {
        return this.connectedPorts;
    }

    public void connectToPort(DVTPFSupplyPortInfo port) {
        if (port == null) {
            return;
        }
        this.getConnectedPorts().add(port);
    }

    public void addGoToInfo(String filePath, int startLine, int endLine) {
        if (startLine < 0 || endLine < 0 || filePath.isEmpty()) {
            this.gotoInfos.add(GoToInfo.dummyOf(filePath, -1, -1, startLine, endLine, this.name, LanguageKind.PF));
        } else {
            this.gotoInfos.add(GoToInfo.of(filePath, -1, -1, startLine, endLine, this.name, LanguageKind.PF));
        }
    }

    public Collection<GoToInfo> getGotoInfos() {
        return this.gotoInfos;
    }

    public String getName() {
        return this.name;
    }
}

