/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format;

import java.util.ArrayList;
import java.util.Collection;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.GoToInfo;

public abstract class DVTPFSupplyPortInfo {
    private String netName;
    private String direction;
    private String domainName;
    private String portName;
    private String label;
    private Collection<GoToInfo> gotoInfos;

    public DVTPFSupplyPortInfo(String netName, String portName, String label, String direction, String domainName) {
        this.netName = netName;
        this.direction = direction;
        this.domainName = domainName;
        this.portName = portName;
        this.label = label;
        this.gotoInfos = new ArrayList<GoToInfo>();
    }

    public String getNetName() {
        return this.netName;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String directionName) {
        this.direction = directionName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void addGoToInfo(String filePath, int startLine, int endLine) {
        this.addGoToInfo(filePath, startLine, endLine, LanguageKind.PF);
    }

    public void addGoToInfo(String filePath, int startLine, int endLine, LanguageKind languageKind) {
        if (startLine < 0 || endLine < 0 || filePath.isEmpty()) {
            this.gotoInfos.add(GoToInfo.dummyOf(filePath, -1, -1, startLine, endLine, this.portName, languageKind));
        } else {
            this.gotoInfos.add(GoToInfo.of(filePath, -1, -1, startLine, endLine, this.portName, languageKind));
        }
    }

    public void addGoToInfo(GoToInfo goToInfo) {
        if (goToInfo == null) {
            return;
        }
        this.gotoInfos.add(goToInfo);
    }

    public Collection<GoToInfo> getGotoInfos() {
        return this.gotoInfos;
    }

    public void setGotoInfos(Collection<GoToInfo> gotoInfos) {
        this.gotoInfos = gotoInfos;
    }
}

