/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format.cpf;

import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.power.format.DVTPFCommand;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.power.format.DVTPFSupplyNetInfo;
import ro.amiq.dvt.power.format.cpf.DVTCPFSupplyNetInfo;
import ro.amiq.dvt.tcl.model.DVTCommandResult;
import ro.amiq.dvt.tcl.model.IDVTCommandType;

public class CPFCreateGroundNetsCommand
extends DVTPFCommand {
    protected String currHierarchySeparator;
    protected IRfDesignElement currTopDesign;
    protected ElementPath currScope;
    protected DVTPFModel.CPFVersionType currVersion;
    protected String currParsedPfFile;

    public CPFCreateGroundNetsCommand(IDVTCommandType type) {
        super(type);
    }

    @Override
    public void executeCommand() {
        if (this.pfModel == null || this.args == null || this.args.length == 0) {
            return;
        }
        this.args[0].getArgLine();
        this.currHierarchySeparator = this.pfModel.getHierarchySeparator();
        this.currTopDesign = this.pfModel.getTopDesign();
        this.currScope = this.pfModel.getScope();
        this.currVersion = this.pfModel.getCPFVersion();
        this.currParsedPfFile = this.pfModel.getCurrentParsedPfFile();
        if (!this.checkInitialConditions(true, this.currTopDesign, this.currScope, this.currVersion, this.currParsedPfFile, this.currHierarchySeparator)) {
            return;
        }
        DVTCommandResult commandArgs = this.parseCommandArguments(this.currParsedPfFile);
        if (commandArgs == null) {
            return;
        }
        String nets = commandArgs.getOptionValue("nets");
        if (nets == null) {
            return;
        }
        String[] netsArray = nets.split("\\s+");
        if (netsArray == null) {
            return;
        }
        String[] stringArray = netsArray;
        int n = netsArray.length;
        int n2 = 0;
        while (n2 < n) {
            String netName = stringArray[n2];
            if (!netName.trim().isEmpty()) {
                DVTPFSupplyNetInfo supplyNetInfo = this.pfModel.getSupplyNetInfo(netName);
                if (supplyNetInfo == null) {
                    supplyNetInfo = new DVTCPFSupplyNetInfo(netName, "ground");
                    this.pfModel.addSupplyNet(supplyNetInfo);
                }
                if (!(supplyNetInfo instanceof DVTCPFSupplyNetInfo)) {
                    return;
                }
                supplyNetInfo.addGoToInfo(this.currParsedPfFile, this.args[0].getArgLine(), this.args[this.args.length - 1].getArgLine());
            }
            ++n2;
        }
    }
}

