/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format.cpf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.problems.PFProblemKinds;
import ro.amiq.dvt.model.reflection.DummyPort;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.model.reflection.util.PortConnectionUtils;
import ro.amiq.dvt.power.format.DVTPFCommand;
import ro.amiq.dvt.power.format.DVTPFInfo;
import ro.amiq.dvt.power.format.DVTPFIsolationStrategyInfo;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.power.format.PFDesignForPathStatus;
import ro.amiq.dvt.power.format.utils.DVTPFUtils;
import ro.amiq.dvt.tcl.model.DVTCommandResult;
import ro.amiq.dvt.tcl.model.DVTDebugKind;
import ro.amiq.dvt.tcl.model.DVTTclUtils;
import ro.amiq.dvt.tcl.model.IDVTCommandType;
import ro.amiq.dvt.ui.actions.CanceledTraceException;
import ro.amiq.dvt.ui.trace.connections.model.TCNode;
import ro.amiq.dvt.ui.trace.connections.model.TCPathChain;
import ro.amiq.dvt.ui.trace.connections.utils.TCConfiguration;
import ro.amiq.dvt.ui.trace.connections.utils.TCUtils;
import ro.amiq.dvt.utils.DVTStringUtil;

public class CPFCreateIsolationRuleCommand
extends DVTPFCommand {
    protected String currHierarchySeparator;
    protected IRfDesignElement currTopDesign;
    protected ElementPath currScope;
    protected DVTPFModel.CPFVersionType currVersion;
    protected String currParsedPfFile;

    public CPFCreateIsolationRuleCommand(IDVTCommandType type) {
        super(type);
    }

    @Override
    public void executeCommand() {
        String isolationControl;
        String excludeElements;
        String elements;
        String noCondition;
        if (this.pfModel == null || this.args == null || this.args.length == 0) {
            return;
        }
        int errorLine = this.args[0].getArgLine();
        this.currHierarchySeparator = this.pfModel.getHierarchySeparator();
        this.currTopDesign = this.pfModel.getTopDesign();
        this.currScope = this.pfModel.getScope();
        this.currVersion = this.pfModel.getCPFVersion();
        this.currParsedPfFile = this.pfModel.getCurrentParsedPfFile();
        if (!this.checkInitialConditions(true, this.currTopDesign, this.currScope, this.currVersion, this.currParsedPfFile, this.currHierarchySeparator)) {
            return;
        }
        DVTCommandResult commandArgs = this.parseCommandArguments(this.currParsedPfFile);
        if (commandArgs == null) {
            return;
        }
        String name = commandArgs.getOptionValue("name");
        if (name == null) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_MISSING_ARG, this.pfModel, this.currParsedPfFile, errorLine, "name", "create_isolation_rule");
            return;
        }
        DVTPFIsolationStrategyInfo isolationStrategy = new DVTPFIsolationStrategyInfo(name, null, this.currParsedPfFile, this.args[0].getArgLine(), this.args[this.args.length - 1].getArgLine());
        String force = commandArgs.getOptionValue("force");
        if (force != null) {
            isolationStrategy.setForceIsolation();
        }
        if ((noCondition = commandArgs.getOptionValue("no_condition")) != null) {
            isolationStrategy.setNoCondition();
        }
        DVTPFIsolationStrategyInfo.CPFClampValue clampValue = DVTPFIsolationStrategyInfo.CPFClampValue.LOW;
        String isolationOutput = commandArgs.getOptionValue("isolation_output");
        if (isolationOutput != null) {
            try {
                clampValue = DVTPFIsolationStrategyInfo.CPFClampValue.valueOf(isolationOutput.toUpperCase());
            }
            catch (Exception exception) {
                DVTPFUtils.addPfProblem(PFProblemKinds.PF_INVALID_VALUE, this.pfModel, this.currParsedPfFile, errorLine, isolationOutput, "isolation_output");
            }
        }
        isolationStrategy.setClampValue(clampValue.toString());
        ArrayList<DVTPFInfo> fromPDList = new ArrayList<DVTPFInfo>();
        String fromOption = commandArgs.getOptionValue("from");
        if (fromOption != null) {
            String[] stringArray = DVTStringUtil.split(WHITESPACE_PATTERN, fromOption);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String powerDomainName = stringArray[n2];
                if (powerDomainName.length() != 0) {
                    DVTPFInfo pdInfoForPDName = this.pfModel.getPDInfoForPDName(powerDomainName);
                    if (pdInfoForPDName == null) {
                        DVTPFUtils.addPfProblem(PFProblemKinds.PF_UNDEFINED_PD, this.pfModel, this.currParsedPfFile, errorLine, powerDomainName);
                        return;
                    }
                    fromPDList.add(pdInfoForPDName);
                }
                ++n2;
            }
        }
        ArrayList<DVTPFInfo> toPDList = new ArrayList<DVTPFInfo>();
        String toOption = commandArgs.getOptionValue("to");
        if (toOption != null) {
            String[] stringArray = DVTStringUtil.split(WHITESPACE_PATTERN, toOption);
            int pdInfoForPDName = stringArray.length;
            int n = 0;
            while (n < pdInfoForPDName) {
                String powerDomainName = stringArray[n];
                if (powerDomainName.length() != 0) {
                    DVTPFInfo pdInfoForPDName2 = this.pfModel.getPDInfoForPDName(powerDomainName.trim());
                    if (pdInfoForPDName2 == null) {
                        DVTPFUtils.addPfProblem(PFProblemKinds.PF_UNDEFINED_PD, this.pfModel, this.currParsedPfFile, errorLine, powerDomainName);
                        return;
                    }
                    toPDList.add(pdInfoForPDName2);
                }
                ++n;
            }
        }
        if ((elements = commandArgs.getOptionValue("pins")) != null && !elements.isEmpty()) {
            this.computeStrategyElementsFromList(DVTStringUtil.split(WHITESPACE_PATTERN, elements), isolationStrategy, this.currScope, this.currTopDesign, false, fromPDList, toPDList);
        }
        if ((excludeElements = commandArgs.getOptionValue("exclude")) != null && !excludeElements.isEmpty()) {
            this.computeStrategyElementsFromList(DVTStringUtil.split(WHITESPACE_PATTERN, excludeElements), isolationStrategy, this.currScope, this.currTopDesign, true, fromPDList, toPDList);
        }
        String secondaryDomain = commandArgs.getOptionValue("secondary_domain");
        DVTPFInfo secondaryPD = this.pfModel.getPDInfoForPDName(secondaryDomain);
        if (secondaryDomain != null && secondaryPD == null) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_UNDEFINED_PD, this.pfModel, this.currParsedPfFile, errorLine, secondaryDomain);
            return;
        }
        if (secondaryPD != null) {
            isolationStrategy.setSecondaryDomain(secondaryPD);
        }
        DVTPFIsolationStrategyInfo.CPFIsolationTarget target = DVTPFIsolationStrategyInfo.CPFIsolationTarget.FROM;
        String isolationTarget = commandArgs.getOptionValue("isolation_target");
        if (isolationTarget != null) {
            try {
                target = DVTPFIsolationStrategyInfo.CPFIsolationTarget.valueOf(isolationTarget.toUpperCase());
            }
            catch (Exception exception) {
                DVTPFUtils.addPfProblem(PFProblemKinds.PF_INVALID_VALUE, this.pfModel, this.currParsedPfFile, errorLine, isolationTarget, "isolation_target");
            }
        }
        isolationStrategy.setTarget(target);
        String isolationCondition = commandArgs.getOptionValue("isolation_condition");
        if (isolationCondition != null) {
            isolationStrategy.setIsolationCondition(isolationCondition);
        }
        if ((isolationControl = commandArgs.getOptionValue("isolation_control")) != null && !this.computeIsolationControl(isolationControl, clampValue, isolationStrategy)) {
            return;
        }
        String domainName = isolationStrategy.getDomainName();
        DVTPFInfo pdInfoForPDName = this.pfModel.getPDInfoForPDName(domainName);
        if (pdInfoForPDName != null) {
            for (ElementPath element : isolationStrategy.getElements()) {
                pdInfoForPDName.addElementToIsolation(element, name);
                String lastSegment = element.lastSegment();
                ElementPath path = element.removeLastSegment();
                int indexOf = lastSegment.indexOf("[");
                if (indexOf >= 0) {
                    lastSegment = lastSegment.substring(0, indexOf);
                }
                pdInfoForPDName.addElementToIsolation(ElementPath.join(path, lastSegment), name);
            }
        }
        this.pfModel.addIsolationStrategyByName(name, isolationStrategy);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean computeIsolationControl(String isolationControl, DVTPFIsolationStrategyInfo.CPFClampValue clampValue, DVTPFIsolationStrategyInfo isolationStrategy) {
        String controlType = null;
        try {
            Matcher matcher = BRACKETS_PATTERN.matcher(isolationControl);
            while (true) {
                if (!matcher.find()) {
                    return true;
                }
                String pair = matcher.group(1);
                String[] elements = DVTStringUtil.split(WHITESPACE_PATTERN, pair);
                if (elements.length != 2) continue;
                controlType = elements[0];
                String expr = elements[1];
                DVTPFIsolationStrategyInfo.CPFControlType convertedType = DVTPFIsolationStrategyInfo.CPFControlType.valueOf(controlType.toUpperCase());
                if (DVTPFIsolationStrategyInfo.CPFControlType.SYNC_ENABLE.equals((Object)convertedType) && !DVTPFIsolationStrategyInfo.CPFClampValue.HIGH.equals((Object)clampValue) && !DVTPFIsolationStrategyInfo.CPFClampValue.LOW.equals((Object)clampValue)) {
                    DVTPFUtils.addPfProblem(PFProblemKinds.PF_INVALID_PARAMETERS_COMBINATION, this.pfModel, this.currParsedPfFile, this.args[0].getArgLine(), "sync_enable", "isolation_output hold/tristate");
                    return false;
                }
                if ((DVTPFIsolationStrategyInfo.CPFControlType.SET.equals((Object)convertedType) || DVTPFIsolationStrategyInfo.CPFControlType.RESET.equals((Object)convertedType)) && !DVTPFIsolationStrategyInfo.CPFClampValue.HOLD.equals((Object)clampValue)) {
                    DVTPFUtils.addPfProblem(PFProblemKinds.PF_MANDATORY_PARAMETERS_COMBINATION, this.pfModel, this.currParsedPfFile, this.args[0].getArgLine(), convertedType.toString().toLowerCase(), "isolation_output hold");
                    return false;
                }
                isolationStrategy.addIsolationControl(convertedType, expr);
            }
        }
        catch (Exception exception) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_INVALID_VALUE, this.pfModel, this.currParsedPfFile, this.args[0].getArgLine(), controlType, "isolation_control");
            return false;
        }
    }

    protected void computeStrategyElementsFromList(String[] elementsArray, DVTPFIsolationStrategyInfo isolationStrategy, ElementPath currentScope, IRfDesignElement currTopDesign, boolean excludeElements, List<DVTPFInfo> fromPDList, List<DVTPFInfo> toPDList) {
        if (elementsArray == null || this.pfModel == null) {
            return;
        }
        String hierarchySeparator = this.pfModel.getHierarchySeparator();
        DVTTclUtils.printToConsole("[PF] Resolving retention elements '" + elementsArray + "' for retention rule '" + isolationStrategy.getStrategyName() + "'", this.pfModel.getProject(), this.pfModel.getBuildKind(), DVTDebugKind.PF_DEBUG_INFO, this.pfModel.isDebugMode());
        String[] stringArray = elementsArray;
        int n = elementsArray.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (!element.trim().isEmpty()) {
                element = this.replaceSeparators(element, hierarchySeparator);
                this.computeIsolationElement(element, isolationStrategy, currTopDesign, currentScope, excludeElements, fromPDList, toPDList);
            }
            ++n2;
        }
    }

    protected void computeIsolationElement(String element, DVTPFIsolationStrategyInfo isolationStrategy, IRfDesignElement currTopDesign, ElementPath currentScope, boolean excludeElements, List<DVTPFInfo> fromPDList, List<DVTPFInfo> toPDList) {
        Map<ElementPath, ELInstance> subtreeOf;
        ElementPath hierarchyPath;
        IELMemory memory;
        ElementPath instanceFullPath = this.computeInstancePathFromElement(element, currentScope);
        if (instanceFullPath == null) {
            return;
        }
        boolean isSearchSignal = false;
        DVTPFCommand.DesignForPathResult result = this.getDesignForPath(currTopDesign, currTopDesign.getName(), instanceFullPath, 0);
        if (result == null || result.getStatus() == PFDesignForPathStatus.NOT_IN_PATH) {
            result = this.getDesignForPath(currTopDesign, currTopDesign.getName(), instanceFullPath.removeLastSegment(), 0);
            isSearchSignal = true;
        }
        if ((memory = this.computeElaborationMemory(hierarchyPath = isSearchSignal ? instanceFullPath.removeLastSegment() : instanceFullPath, result)) == null) {
            return;
        }
        ELInstance currentInstance = memory.instanceFor(hierarchyPath);
        if (currentInstance != null) {
            if (isSearchSignal && this.pfModel.getPDInfoForInstance(hierarchyPath) != null) {
                IRfInstanceElement instance = currentInstance.getDescription();
                if (instance == null) {
                    return;
                }
                IRfNamedElement module = instance.getAssociatedType();
                if (module == null) {
                    return;
                }
                String portName = instanceFullPath.lastSegment();
                portName = portName.contains("[") ? portName.substring(0, portName.indexOf("[")) : portName;
                IRfNamedElement field = DesignUtils.getFieldOrInstanceByName(portName, DesignUtils.DesignRequest.of(module));
                if (!this.isValidIsolationElement(field)) {
                    return;
                }
                if (excludeElements) {
                    isolationStrategy.excludeElement(instanceFullPath);
                    return;
                }
                this.filterIsolationDomainTo(field, toPDList, isolationStrategy, memory);
                this.filterIsolationDomainFrom(field, instance, fromPDList, isolationStrategy, hierarchyPath);
                isolationStrategy.addElement(instanceFullPath);
                return;
            }
            this.computeIsolationElementsForInstance(currentInstance, isolationStrategy, hierarchyPath, excludeElements, memory, fromPDList, toPDList);
        }
        if ((subtreeOf = memory.subtreeOf(instanceFullPath, false)) == null || subtreeOf.isEmpty()) {
            return;
        }
        for (Map.Entry<ElementPath, ELInstance> child : subtreeOf.entrySet()) {
            ElementPath childPath = child.getKey();
            ELInstance elInstance = child.getValue();
            this.computeIsolationElementsForInstance(elInstance, isolationStrategy, childPath, excludeElements, memory, fromPDList, toPDList);
        }
    }

    private void filterIsolationDomainTo(IRfNamedElement field, List<DVTPFInfo> toPDList, DVTPFIsolationStrategyInfo isolationStrategy, IELMemory memory) {
        block0: for (DVTPFInfo domain : toPDList) {
            Set<ElementPath> upperBoundaryInstances = domain.getUpperBoundaryInstances();
            for (ElementPath upperBoundaryInstance : upperBoundaryInstances) {
                IRfNamedElement instField;
                ELInstance domainInstance = memory.instanceFor(upperBoundaryInstance);
                IRfInstanceElement inst = domainInstance.getDescription();
                if (inst == null) continue;
                List<IHidOperator> hidOperators = inst.getHidOperators(ELConstants.PORT_AND_GENERIC_VALUES_QUALIFIERS_ARRAY, true);
                String name = null;
                for (IHidOperator portConnection : hidOperators) {
                    IHidObject signal = PortConnectionUtils.getSignal(portConnection);
                    if (signal == null || !field.getName().equals(HidUtils.getHidFrom(signal).getName())) continue;
                    name = PortConnectionUtils.getPortName(portConnection);
                }
                IRfNamedElement mod = inst.getAssociatedType();
                if (mod == null || (instField = DesignUtils.getFieldOrInstanceByName(name == null ? field.getName() : name, DesignUtils.DesignRequest.of(mod))) == null) continue;
                domain.addIsolationStrategy(isolationStrategy);
                isolationStrategy.setDomainName(domain.getPowerDomainName());
                continue block0;
            }
        }
    }

    private void filterIsolationDomainFrom(IRfNamedElement field, IRfInstanceElement instance, List<DVTPFInfo> fromPDList, DVTPFIsolationStrategyInfo isolationStrategy, ElementPath hierarchyPath) {
        if (fromPDList.isEmpty()) {
            return;
        }
        DVTPFInfo instancePowerDomain = this.pfModel.getPDInfoForInstance(hierarchyPath);
        if (!fromPDList.contains(instancePowerDomain) || isolationStrategy.getDomainName() != null) {
            return;
        }
        ElementPath parentPath = hierarchyPath.length() == 1 ? hierarchyPath : hierarchyPath.removeLastSegment();
        List<TCNode> trace = this.trace(instance, (IRfPortElement)field, parentPath);
        List<IHidOperator> hidOperators = instance.getHidOperators(ELConstants.PORT_AND_GENERIC_VALUES_QUALIFIERS_ARRAY, true);
        if (hidOperators == null && hierarchyPath.length() == 1) {
            for (TCNode tracedInstance : trace) {
                DVTPFInfo pdInfoForInstance;
                List<IRfNamedElement> hotPorts = tracedInstance.getHotSignals();
                if (hotPorts == null || !hotPorts.contains(field) || (pdInfoForInstance = this.pfModel.getPDInfoForInstance(tracedInstance.getElementPath())) == null || !pdInfoForInstance.isLowerBoundaryInstance(tracedInstance.getElementPath())) continue;
                pdInfoForInstance.addIsolationStrategy(isolationStrategy);
                isolationStrategy.setDomainName(pdInfoForInstance.getPowerDomainName());
                return;
            }
        }
        if (hidOperators == null) {
            return;
        }
        for (IHidOperator portConnection : hidOperators) {
            IHid signalHid;
            IHidObject signal;
            IHid portHid = PortConnectionUtils.getPortHid(portConnection);
            if (portHid == null || field.getName() == null || !field.getName().equals(portHid.getName()) || (signal = PortConnectionUtils.getSignal(portConnection)) == null || (signalHid = HidUtils.getHidFrom(signal)) == null) continue;
            IRfNamedElement connectedSignal = signalHid.getElement();
            for (TCNode tracedInstance : trace) {
                ElementPath elementPath;
                DVTPFInfo pdInfoForInstance;
                List<IRfNamedElement> hotPorts = tracedInstance.getHotSignals();
                if (hotPorts == null || !hotPorts.contains(connectedSignal) || (pdInfoForInstance = this.pfModel.getPDInfoForInstance(elementPath = ElementPath.join(parentPath.removeLastSegment(), tracedInstance.getElementPath()))) == null || !pdInfoForInstance.isLowerBoundaryInstance(elementPath)) continue;
                if (connectedSignal instanceof IRfPortElement && ((IRfPortElement)connectedSignal).isInput()) {
                    instancePowerDomain.addIsolationStrategy(isolationStrategy);
                    isolationStrategy.setDomainName(instancePowerDomain.getPowerDomainName());
                } else {
                    pdInfoForInstance.addIsolationStrategy(isolationStrategy);
                    isolationStrategy.setDomainName(pdInfoForInstance.getPowerDomainName());
                }
                return;
            }
            return;
        }
    }

    private void computeIsolationElementsForInstance(ELInstance elInstance, DVTPFIsolationStrategyInfo isolationStrategy, ElementPath instancePath, boolean excludeElements, IELMemory memory, List<DVTPFInfo> fromPDList, List<DVTPFInfo> toPDList) {
        IRfInstanceElement instance = elInstance.getDescription();
        if (instance == null) {
            return;
        }
        IRfNamedElement module = instance.getAssociatedType();
        if (!(module instanceof IRfDesignElement)) {
            return;
        }
        Collection<? extends IRfFieldElement> localSignals = ((IRfDesignElement)module).getLocalSignals();
        if (localSignals == null) {
            return;
        }
        String hierarchySeparator = this.pfModel.getHierarchySeparator();
        for (IRfFieldElement iRfFieldElement : localSignals) {
            if (!this.isValidIsolationElement(iRfFieldElement)) continue;
            this.filterIsolationDomainTo(iRfFieldElement, toPDList, isolationStrategy, memory);
            this.filterIsolationDomainFrom(iRfFieldElement, instance, fromPDList, isolationStrategy, instancePath);
            String signalPath = this.computeSignalPath(instancePath, hierarchySeparator, iRfFieldElement);
            ElementPath signalElementPath = ElementPath.from(signalPath, hierarchySeparator);
            if (!excludeElements) {
                isolationStrategy.addElement(signalElementPath);
                continue;
            }
            isolationStrategy.excludeElement(signalElementPath);
        }
    }

    private boolean isValidIsolationElement(IRfNamedElement field) {
        return field instanceof IRfPortElement;
    }

    private List<TCNode> trace(IRfInstanceElement instance, IRfPortElement port, ElementPath elementPath) {
        HashMap<IRfInstanceElement, Set<DummyPort>> dummyPortMap = new HashMap<IRfInstanceElement, Set<DummyPort>>();
        IRfSingleLangProject rfProject = this.pfModel.getTopDesign().getRfProject();
        TCNode traceInstanceTreeRoot = TCUtils.makeDesignHierarchyElabMode(rfProject, elementPath, dummyPortMap);
        TCNode selectedTraceNode = this.select(traceInstanceTreeRoot, instance);
        TCPathChain causedBy = new TCPathChain();
        try {
            EnumSet<TCConfiguration> options = EnumSet.allOf(TCConfiguration.class);
            TCUtils.traceSignalInFullHierarchy(selectedTraceNode, port, causedBy, options, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CanceledTraceException canceledTraceException) {
            return new ArrayList<TCNode>();
        }
        ArrayList<TCNode> listTraceNodes = new ArrayList<TCNode>();
        listTraceNodes.add(traceInstanceTreeRoot);
        this.flattenTraceTreeChildren(instance, traceInstanceTreeRoot, listTraceNodes, port, ElementPath.from(elementPath.lastSegment(), this.currHierarchySeparator));
        return listTraceNodes;
    }

    private TCNode select(TCNode root, IRfNamedElement elem) {
        if (root == null) {
            return null;
        }
        if (root.namedElement == elem) {
            return root;
        }
        for (TCNode child : root.getChildren()) {
            TCNode sel = this.select(child, elem);
            if (sel == null) continue;
            return sel;
        }
        return null;
    }

    private void flattenTraceTreeChildren(IRfInstanceElement instance, TCNode root, List<TCNode> nodes, IRfPortElement port, ElementPath parentElementPath) {
        if (root == null) {
            return;
        }
        for (TCNode child : root.getChildren()) {
            if (child.getHotSignals() == null || child.getHotSignals().isEmpty() || !parentElementPath.isDirectParentOf(child.getElementPath())) continue;
            if (instance != child.getInstance()) {
                nodes.add(child);
            }
            this.flattenTraceTreeChildren(instance, child, nodes, port, parentElementPath);
        }
    }
}

