/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format.cpf;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.power.format.DVTPFCommand;
import ro.amiq.dvt.power.format.DVTPFInfo;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.power.format.PfType;
import ro.amiq.dvt.power.format.cpf.DVTCPFSupplyPortInfo;
import ro.amiq.dvt.power.format.utils.DVTPFUtils;
import ro.amiq.dvt.tcl.model.DVTCommandResult;
import ro.amiq.dvt.tcl.model.DVTDebugKind;
import ro.amiq.dvt.tcl.model.DVTTclUtils;
import ro.amiq.dvt.tcl.model.IDVTCommandType;

public class CPFCreatePowerDomainCommand
extends DVTPFCommand {
    protected String currHierarchySeparator;
    protected IRfDesignElement currTopDesign;
    protected ElementPath currScope;
    protected DVTPFModel.CPFVersionType currVersion;
    protected String currParsedPfFile;

    protected CPFCreatePowerDomainCommand(IDVTCommandType type) {
        super(type);
    }

    @Override
    public void executeCommand() {
        if (this.pfModel == null || this.args == null || this.args.length == 0) {
            return;
        }
        this.args[0].getArgLine();
        PfType cpf = PfType.CPF;
        this.currHierarchySeparator = this.pfModel.getHierarchySeparator();
        this.currTopDesign = this.pfModel.getTopDesign();
        this.currScope = this.pfModel.getScope();
        this.currVersion = this.pfModel.getCPFVersion();
        this.currParsedPfFile = this.pfModel.getCurrentParsedPfFile();
        if (!this.checkInitialConditions(true, this.currTopDesign, this.currScope, this.currVersion, this.currParsedPfFile, this.currHierarchySeparator)) {
            return;
        }
        DVTCommandResult commandArgs = this.parseCommandArguments(this.currParsedPfFile);
        if (commandArgs == null) {
            return;
        }
        String powerDomainName = commandArgs.getOptionValue("name");
        if (powerDomainName == null) {
            return;
        }
        boolean isDefault = this.transformCommandOptionInBoolean("default", commandArgs);
        String instances = commandArgs.getOptionValue("instances");
        String excludeInstances = commandArgs.getOptionValue("exclude_instances");
        String baseDomains = commandArgs.getOptionValue("base_domains");
        this.resolveBaseDomains(powerDomainName, baseDomains);
        StringBuilder message = new StringBuilder("create_power_domain -name ").append(powerDomainName).append(" ...");
        DVTTclUtils.printToConsole("[PF (CPF)] " + message, this.pfModel.getProject(), this.pfModel.getBuildKind(), DVTDebugKind.PF_DEBUG_INFO, this.pfModel.isDebugMode());
        if (isDefault) {
            this.resolveElements(this.currTopDesign, powerDomainName, ".", this.currScope, cpf);
        }
        if (instances == null) {
            instances = ".";
        }
        this.resolveElements(this.currTopDesign, powerDomainName, instances, this.currScope, cpf);
        this.resolveExcludeElements(this.currTopDesign, excludeInstances, this.currScope);
        String shutoffCondition = this.computeShutoffCondition(commandArgs);
        if (shutoffCondition == null) {
            return;
        }
        DVTPFInfo pdInfo = this.pfModel.getPDInfoForPDName(powerDomainName);
        if (pdInfo == null) {
            return;
        }
        DVTCPFSupplyPortInfo shutoffPort = new DVTCPFSupplyPortInfo(shutoffCondition, shutoffCondition, shutoffCondition, "out", powerDomainName);
        int shutoffArgLine = DVTPFUtils.getArgLine(this.args, "shutoff_condition");
        shutoffPort.addGoToInfo(this.currParsedPfFile, shutoffArgLine, shutoffArgLine);
        this.addControlSignalGotoInfo(this.currTopDesign, shutoffCondition, this.currHierarchySeparator, shutoffPort, "{0}\n(shutoff_condition)");
        pdInfo.setCpfShutoffPort(shutoffPort);
    }

    private String computeShutoffCondition(DVTCommandResult commandArgs) {
        String conditionString = commandArgs.getOptionValue("shutoff_condition");
        if (conditionString == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Matcher matcher = Pattern.compile("([\\w\\[\\]\\/\\\\]+)").matcher(conditionString);
        while (matcher.find()) {
            int start = matcher.start(0);
            int end = matcher.end(0);
            if (start < 0 || end > conditionString.length()) continue;
            String group = matcher.group(0);
            sb.append(conditionString.subSequence(0, start)).append(this.currScope.toString(this.currHierarchySeparator)).append(this.currHierarchySeparator).append(group).append(conditionString.substring(end, conditionString.length()));
        }
        return sb.toString();
    }

    private void resolveBaseDomains(String powerDomainName, String baseDomains) {
        if (baseDomains == null) {
            return;
        }
        Map<String, List<String>> baseDomainsMap = this.pfModel.getBaseDomains();
        String[] baseDomainsArray = baseDomains.split("\\s+");
        if (baseDomainsArray == null) {
            return;
        }
        String[] stringArray = baseDomainsArray;
        int n = baseDomainsArray.length;
        int n2 = 0;
        while (n2 < n) {
            String baseDomain = stringArray[n2];
            if (!baseDomain.trim().isEmpty()) {
                boolean nestedBaseDomains = false;
                String correctBaseDomain = powerDomainName;
                for (Map.Entry<String, List<String>> entry : baseDomainsMap.entrySet()) {
                    String key = entry.getKey();
                    List<String> value = entry.getValue();
                    if (!value.contains(baseDomain)) continue;
                    nestedBaseDomains = true;
                    correctBaseDomain = key;
                    break;
                }
                if (nestedBaseDomains) {
                    this.pfModel.addToBaseDomain(correctBaseDomain, powerDomainName);
                    break;
                }
                this.pfModel.addToBaseDomain(baseDomain, powerDomainName);
                break;
            }
            ++n2;
        }
    }
}

