/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format.cpf;

import ro.amiq.dvt.model.problems.PFProblemKinds;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.power.format.DVTPFCommand;
import ro.amiq.dvt.power.format.DVTPFInfo;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.power.format.DVTPFRetentionRuleInfo;
import ro.amiq.dvt.power.format.utils.DVTPFUtils;
import ro.amiq.dvt.tcl.model.DVTCommandResult;
import ro.amiq.dvt.tcl.model.IDVTCommandType;
import ro.amiq.dvt.utils.DVTStringUtil;

public class CPFCreateStateRetentionRuleCommand
extends DVTPFCommand {
    private String currHierarchySeparator;
    private IRfDesignElement currTopDesign;
    private ElementPath currScope;
    private DVTPFModel.UPFVersionType currVersion;
    private String currParsedPfFile;

    public CPFCreateStateRetentionRuleCommand(IDVTCommandType type) {
        super(type);
    }

    @Override
    public void executeCommand() {
        String useSecondary;
        String retentionPrecondition;
        String restorePreconition;
        String savePreconition;
        String restoreLevel;
        String saveLevel;
        String restoreEdge;
        String saveEdge;
        String required;
        String excludeElements;
        if (this.pfModel == null || this.args == null || this.args.length == 0) {
            return;
        }
        int errorLine = this.args[0].getArgLine();
        this.currHierarchySeparator = this.pfModel.getHierarchySeparator();
        this.currTopDesign = this.pfModel.getTopDesign();
        this.currScope = this.pfModel.getScope();
        this.currVersion = this.pfModel.getUPFVersion();
        this.currParsedPfFile = this.pfModel.getCurrentParsedPfFile();
        if (!this.checkInitialConditions(true, this.currTopDesign, this.currScope, this.currVersion, this.currParsedPfFile, this.currHierarchySeparator)) {
            return;
        }
        DVTCommandResult commandArgs = this.parseCommandArguments(this.currParsedPfFile);
        if (commandArgs == null) {
            return;
        }
        String retentionRuleName = commandArgs.getOptionValue("name");
        if (retentionRuleName == null) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_MISSING_ARG, this.pfModel, this.currParsedPfFile, errorLine, "name", "set_retention");
            return;
        }
        String pdName = commandArgs.getOptionValue("domain");
        DVTPFInfo pdInfoForPDName = pdName != null ? this.pfModel.getPDInfoForPDName(pdName) : null;
        DVTPFRetentionRuleInfo retentionRule = new DVTPFRetentionRuleInfo(retentionRuleName, pdName, this.currParsedPfFile, this.args[0].getArgLine(), this.args[this.args.length - 1].getArgLine());
        String elements = commandArgs.getOptionValue("instances");
        if (elements != null && !elements.isEmpty()) {
            this.computeRetentionElementsFromList(DVTStringUtil.split(WHITESPACE_PATTERN, elements), retentionRule, this.currScope, this.currTopDesign, false);
        }
        if ((excludeElements = commandArgs.getOptionValue("exclude")) != null && !excludeElements.isEmpty()) {
            this.computeRetentionElementsFromList(DVTStringUtil.split(WHITESPACE_PATTERN, excludeElements), retentionRule, this.currScope, this.currTopDesign, true);
        }
        if ((required = commandArgs.getOptionValue("required")) != null) {
            retentionRule.setRequired(true);
        }
        if ((saveEdge = commandArgs.getOptionValue("save_edge")) != null) {
            retentionRule.setSaveEdge(saveEdge);
        }
        if ((restoreEdge = commandArgs.getOptionValue("restore_edge")) != null) {
            retentionRule.setRestoreEdge(restoreEdge);
        }
        if ((saveLevel = commandArgs.getOptionValue("save_level")) != null) {
            retentionRule.setSaveLevel(saveLevel);
        }
        if ((restoreLevel = commandArgs.getOptionValue("restore_level")) != null) {
            retentionRule.setRestoreLevel(restoreLevel);
        }
        if ((savePreconition = commandArgs.getOptionValue("save_precondition")) != null) {
            retentionRule.setSaveCondition(savePreconition);
        }
        if ((restorePreconition = commandArgs.getOptionValue("restore_precondition")) != null) {
            retentionRule.setRestoreCondition(restorePreconition);
        }
        if ((retentionPrecondition = commandArgs.getOptionValue("retention_precondition")) != null) {
            retentionRule.setRetentionCondition(retentionPrecondition);
        }
        DVTPFRetentionRuleInfo.TargetType targetType = DVTPFRetentionRuleInfo.TargetType.FLOP;
        String targetTypeOption = commandArgs.getOptionValue("target_type");
        if (targetTypeOption != null) {
            try {
                targetType = DVTPFRetentionRuleInfo.TargetType.valueOf(targetTypeOption.toUpperCase());
            }
            catch (Exception exception) {
                DVTPFUtils.addPfProblem(PFProblemKinds.PF_INVALID_VALUE, this.pfModel, this.currParsedPfFile, errorLine, targetTypeOption, "target_type");
            }
        }
        retentionRule.seTargetType(targetType);
        String secondaryDomainName = commandArgs.getOptionValue("secondary_domain");
        if (secondaryDomainName != null) {
            DVTPFInfo secondaryPD = this.pfModel.getPDInfoForPDName(secondaryDomainName);
            if (secondaryPD == null) {
                DVTPFUtils.addPfProblem(PFProblemKinds.PF_UNDEFINED_PD, this.pfModel, this.currParsedPfFile, errorLine, secondaryDomainName);
                return;
            }
            retentionRule.setSecondaryDomain(secondaryPD);
        }
        if ((useSecondary = commandArgs.getOptionValue("use_secondary_for_output")) != null) {
            retentionRule.setUseSecondary();
        }
        if (pdInfoForPDName != null) {
            pdInfoForPDName.addRetentionRule(retentionRule);
            for (ElementPath element : retentionRule.getElements()) {
                pdInfoForPDName.addElementToRetention(element, retentionRuleName);
            }
        }
        this.pfModel.addRetentionRuleByName(retentionRuleName, retentionRule);
    }
}

