/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format.cpf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import ro.amiq.dvt.model.problems.PFProblemKinds;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.power.format.DVTPFCommand;
import ro.amiq.dvt.power.format.DVTPFIsolationCellInfo;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.power.format.utils.DVTPFUtils;
import ro.amiq.dvt.tcl.model.DVTCommandResult;
import ro.amiq.dvt.tcl.model.IDVTCommandType;
import ro.amiq.dvt.utils.DVTStringUtil;

public class CPFDefineIsolationCellCommand
extends DVTPFCommand {
    private String currHierarchySeparator;
    private IRfDesignElement currTopDesign;
    private ElementPath currScope;
    private DVTPFModel.UPFVersionType currVersion;
    private String currParsedPfFile;

    public CPFDefineIsolationCellCommand(IDVTCommandType type) {
        super(type);
    }

    @Override
    public void executeCommand() {
        String validLocationOption;
        String power;
        if (this.pfModel == null || this.args == null || this.args.length == 0) {
            return;
        }
        int errorLine = this.args[0].getArgLine();
        this.currHierarchySeparator = this.pfModel.getHierarchySeparator();
        this.currTopDesign = this.pfModel.getTopDesign();
        this.currScope = this.pfModel.getScope();
        this.currVersion = this.pfModel.getUPFVersion();
        this.currParsedPfFile = this.pfModel.getCurrentParsedPfFile();
        if (!this.checkInitialConditions(true, this.currTopDesign, this.currScope, this.currVersion, this.currParsedPfFile, this.currHierarchySeparator)) {
            return;
        }
        DVTCommandResult commandArgs = this.parseCommandArguments(this.currParsedPfFile);
        if (commandArgs == null) {
            return;
        }
        String cells = commandArgs.getOptionValue("cells");
        if (cells == null) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_MISSING_ARG, this.pfModel, this.currParsedPfFile, errorLine, "cells");
            return;
        }
        DVTPFIsolationCellInfo.UPFClampValue cellType = DVTPFIsolationCellInfo.UPFClampValue.UNDEFINED;
        String clampCell = commandArgs.getOptionValue("clamp");
        if (clampCell != null) {
            try {
                cellType = DVTPFIsolationCellInfo.UPFClampValue.valueOf(clampCell.toUpperCase());
            }
            catch (Exception exception) {
                DVTPFUtils.addPfProblem(PFProblemKinds.PF_INVALID_VALUE, this.pfModel, this.currParsedPfFile, errorLine, clampCell, "clamp");
            }
        }
        if ((power = commandArgs.getOptionValue("power")) != null && DVTPFIsolationCellInfo.UPFClampValue.LOW.equals((Object)cellType)) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_INVALID_PARAMETERS_COMBINATION, this.pfModel, this.currParsedPfFile, errorLine, "power", "clamp_cell low");
            return;
        }
        if (power == null) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_MISSING_ARG, this.pfModel, this.currParsedPfFile, errorLine, "power");
            return;
        }
        String ground = commandArgs.getOptionValue("ground");
        if (ground != null && DVTPFIsolationCellInfo.UPFClampValue.HIGH.equals((Object)cellType)) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_INVALID_PARAMETERS_COMBINATION, this.pfModel, this.currParsedPfFile, errorLine, "ground", "clamp_cell high");
            return;
        }
        if (ground == null) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_MISSING_ARG, this.pfModel, this.currParsedPfFile, errorLine, "ground");
            return;
        }
        String enable = commandArgs.getOptionValue("enable");
        String noEnable = commandArgs.getOptionValue("no_enable");
        if (noEnable != null) {
            if (enable != null) {
                DVTPFUtils.addPfProblem(PFProblemKinds.PF_INVALID_PARAMETERS_COMBINATION, this.pfModel, this.currParsedPfFile, errorLine, "enable", "no_enable");
                return;
            }
            try {
                DVTPFIsolationCellInfo.UPFNoEnableValue.valueOf(noEnable.toUpperCase());
            }
            catch (Exception exception) {
                DVTPFUtils.addPfProblem(PFProblemKinds.PF_INVALID_VALUE, this.pfModel, this.currParsedPfFile, errorLine, noEnable, "no_enable");
            }
        }
        HashSet<String> usedPins = new HashSet<String>();
        ArrayList<DVTPFIsolationCellInfo.PinGroup> pinGroupsList = new ArrayList<DVTPFIsolationCellInfo.PinGroup>();
        String pinGroups = commandArgs.getOptionValue("pin_groups");
        if (pinGroups != null) {
            Matcher matcher = BRACKETS_PATTERN.matcher(pinGroups);
            while (matcher.find()) {
                String pair = matcher.group(1);
                String[] elements = DVTStringUtil.split(WHITESPACE_PATTERN, pair.trim());
                if (elements.length < 2 || elements.length > 3) {
                    DVTPFUtils.addPfProblem(PFProblemKinds.PF_PARSING_FAILED, this.pfModel, this.currParsedPfFile, errorLine, "pin_groups");
                    continue;
                }
                if (usedPins.contains(elements[0])) {
                    DVTPFUtils.addPfProblem(PFProblemKinds.PF_PIN_ALREADY_SPECIFIED, this.pfModel, this.currParsedPfFile, errorLine, elements[0]);
                    continue;
                }
                if (usedPins.contains(elements[1])) {
                    DVTPFUtils.addPfProblem(PFProblemKinds.PF_PIN_ALREADY_SPECIFIED, this.pfModel, this.currParsedPfFile, errorLine, elements[1]);
                    continue;
                }
                String inputPin = elements[0];
                String outputPin = elements[1];
                usedPins.add(inputPin);
                usedPins.add(outputPin);
                String enableSignal = elements.length > 2 ? elements[2] : null;
                pinGroupsList.add(new DVTPFIsolationCellInfo.PinGroup(inputPin, outputPin, enableSignal));
            }
        }
        if ((validLocationOption = commandArgs.getOptionValue("valid_location")) != null) {
            try {
                if ("FROM".equalsIgnoreCase(validLocationOption)) {
                    validLocationOption = "SOURCE";
                }
                if ("TO".equalsIgnoreCase(validLocationOption)) {
                    validLocationOption = "SINK";
                }
                DVTPFIsolationCellInfo.UPFValidLocation.valueOf(validLocationOption.toUpperCase());
            }
            catch (Exception exception) {
                DVTPFUtils.addPfProblem(PFProblemKinds.PF_INVALID_VALUE, this.pfModel, this.currParsedPfFile, errorLine, validLocationOption, "valid_location");
            }
        }
    }

    private void createIsolationCell(DVTCommandResult commandArgs, String cells, DVTPFIsolationCellInfo.UPFClampValue cellType, String power, String ground, String enable, DVTPFIsolationCellInfo.UPFNoEnableValue noEnableValue, List<DVTPFIsolationCellInfo.PinGroup> pinGroupsList, DVTPFIsolationCellInfo.UPFValidLocation validLocation) {
        ArrayList<String> alwaysOnPinsList = new ArrayList();
        String alwaysOnPins = commandArgs.getOptionValue("always_on_pins");
        if (alwaysOnPins != null) {
            alwaysOnPinsList = Arrays.asList(DVTStringUtil.split(WHITESPACE_PATTERN, alwaysOnPins));
        }
        ArrayList<String> auxEnablesList = new ArrayList();
        String auxEnables = commandArgs.getOptionValue("aux_enables");
        if (auxEnables != null) {
            auxEnablesList = Arrays.asList(DVTStringUtil.split(WHITESPACE_PATTERN, auxEnables));
        }
        String switchablePowerPin = commandArgs.getOptionValue("power_switchable");
        String switchableGroundPin = commandArgs.getOptionValue("ground_switchable");
        String nonDedicated = commandArgs.getOptionValue("non_dedicated");
        String[] stringArray = DVTStringUtil.split(WHITESPACE_PATTERN, cells);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String cell = stringArray[n2];
            if (!cell.trim().isEmpty()) {
                DVTPFIsolationCellInfo cellInfo = new DVTPFIsolationCellInfo(cell, power, ground);
                if (enable != null) {
                    cellInfo.setEnablePin(enable);
                }
                if (noEnableValue != null) {
                    cellInfo.setNoEnable(noEnableValue);
                }
                cellInfo.setPinGroups(pinGroupsList);
                cellInfo.setClampCell(cellType);
                cellInfo.setAlwaysOnPins(alwaysOnPinsList);
                cellInfo.setAuxEnables(auxEnablesList);
                cellInfo.setSwitchableGroundPin(switchableGroundPin);
                cellInfo.setSwitchablePowerPin(switchablePowerPin);
                cellInfo.setValidLocation(validLocation);
                cellInfo.setNonDedicated(nonDedicated != null);
                this.pfModel.addIsolationCellByName(cell, cellInfo);
            }
            ++n2;
        }
    }
}

