/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format.cpf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.problems.PFProblemKinds;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.power.format.DVTPFCommand;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.power.format.DVTPFRetentionCellInfo;
import ro.amiq.dvt.power.format.PFDesignForPathStatus;
import ro.amiq.dvt.power.format.utils.DVTPFUtils;
import ro.amiq.dvt.tcl.model.DVTCommandResult;
import ro.amiq.dvt.tcl.model.IDVTCommandType;
import ro.amiq.dvt.utils.DVTStringUtil;

public class CPFDefineStateRetentionCellCommand
extends DVTPFCommand {
    private String currHierarchySeparator;
    private IRfDesignElement currTopDesign;
    private ElementPath currScope;
    private DVTPFModel.UPFVersionType currVersion;
    private String currParsedPfFile;

    public CPFDefineStateRetentionCellCommand(IDVTCommandType type) {
        super(type);
    }

    @Override
    public void executeCommand() {
        if (this.pfModel == null || this.args == null || this.args.length == 0) {
            return;
        }
        int errorLine = this.args[0].getArgLine();
        this.currHierarchySeparator = this.pfModel.getHierarchySeparator();
        this.currTopDesign = this.pfModel.getTopDesign();
        this.currScope = this.pfModel.getScope();
        this.currVersion = this.pfModel.getUPFVersion();
        this.currParsedPfFile = this.pfModel.getCurrentParsedPfFile();
        if (!this.checkInitialConditions(true, this.currTopDesign, this.currScope, this.currVersion, this.currParsedPfFile, this.currHierarchySeparator)) {
            return;
        }
        DVTCommandResult commandArgs = this.parseCommandArguments(this.currParsedPfFile);
        if (commandArgs == null) {
            return;
        }
        String cells = commandArgs.getOptionValue("cells");
        if (cells == null) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_MISSING_ARG, this.pfModel, this.currParsedPfFile, errorLine, "cells");
            return;
        }
    }

    private void createRetentionCells(int errorLine, DVTCommandResult commandArgs, String cells) {
        String[] savePinAndFunction;
        String[] restorePinAndFunction;
        String power = commandArgs.getOptionValue("power");
        String ground = commandArgs.getOptionValue("ground");
        ArrayList<String> alwaysOnPinsList = new ArrayList();
        String alwaysOnPins = commandArgs.getOptionValue("always_on_pins");
        if (alwaysOnPins != null) {
            alwaysOnPinsList = Arrays.asList(DVTStringUtil.split(WHITESPACE_PATTERN, alwaysOnPins));
        }
        String restore = commandArgs.getOptionValue("restore_function");
        String restorePin = null;
        DVTPFRetentionCellInfo.ActiveState restoreState = null;
        if (restore != null && (restorePinAndFunction = DVTStringUtil.split(WHITESPACE_PATTERN, restore)) != null && restorePinAndFunction.length == 2) {
            restorePin = restorePinAndFunction[0];
            restoreState = DVTPFRetentionCellInfo.ActiveState.from(restorePinAndFunction[1], this.pfModel, this.currParsedPfFile, errorLine, "restore_function");
        }
        String save = commandArgs.getOptionValue("save_function");
        String savePin = null;
        DVTPFRetentionCellInfo.ActiveState saveState = null;
        if (save != null && (savePinAndFunction = DVTStringUtil.split(WHITESPACE_PATTERN, save)) != null && savePinAndFunction.length == 2) {
            savePin = savePinAndFunction[0];
            saveState = DVTPFRetentionCellInfo.ActiveState.from(savePinAndFunction[1], this.pfModel, this.currParsedPfFile, errorLine, "save_function");
        }
        String restoreCheck = commandArgs.getOptionValue("restore_check");
        String saveCheck = commandArgs.getOptionValue("save_check");
        String retentionCheck = commandArgs.getOptionValue("retention_check");
        String switchablePowerPin = commandArgs.getOptionValue("power_switchable");
        String switchableGroundPin = commandArgs.getOptionValue("ground_switchable");
        ArrayList<IRfNamedElement> alwaysOnComponents = new ArrayList<IRfNamedElement>();
        String alwaysOnComponentsValue = commandArgs.getOptionValue("always_on_components");
        if (alwaysOnComponentsValue != null) {
            this.addAlwaysOnComponents(alwaysOnComponents, this.pfModel.getHierarchySeparator(), alwaysOnComponentsValue);
        }
        String cellType = commandArgs.getOptionValue("cell_type");
        String clockPin = commandArgs.getOptionValue("clock_pin");
        String[] stringArray = DVTStringUtil.split(WHITESPACE_PATTERN, cells);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String cell = stringArray[n2];
            if (!cell.trim().isEmpty()) {
                DVTPFRetentionCellInfo cellInfo = new DVTPFRetentionCellInfo(cell, power, ground);
                cellInfo.setAlwaysOnPins(alwaysOnPinsList);
                cellInfo.setRestoreFunction(restorePin, restoreState);
                cellInfo.setSaveFunction(savePin, saveState);
                cellInfo.setRestoreCheck(restoreCheck);
                cellInfo.setSaveCheck(saveCheck);
                cellInfo.setRetentionCheck(retentionCheck);
                cellInfo.setClockPin(clockPin);
                cellInfo.setSwitchableGroundPin(switchableGroundPin);
                cellInfo.setSwitchablePowerPin(switchablePowerPin);
                cellInfo.setAlwaysOnComponents(alwaysOnComponents);
                if (cellType != null && !cellType.isEmpty()) {
                    this.pfModel.addRetentionCellsByType(cellType, cellInfo);
                } else {
                    this.pfModel.addRetentionCellByName(cell, cellInfo);
                }
            }
            ++n2;
        }
    }

    private void addAlwaysOnComponents(List<IRfNamedElement> alwaysOnComponents, String hierarchySeparator, String allwaysOnComponentsValue) {
        String[] components = DVTStringUtil.split(WHITESPACE_PATTERN, allwaysOnComponentsValue);
        if (components == null || components.length == 0) {
            return;
        }
        String[] stringArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            ElementPath instanceFullPath;
            String element = stringArray[n2];
            if (!element.trim().isEmpty() && (instanceFullPath = this.computeInstancePathFromElement(element = this.replaceSeparators(element, hierarchySeparator), this.currScope)) != null) {
                IRfInstanceElement instance;
                ELInstance currentInstance;
                ElementPath hierarchyPath;
                IELMemory memory;
                boolean searchForReg = false;
                DVTPFCommand.DesignForPathResult result = this.getDesignForPath(this.currTopDesign, this.currTopDesign.getName(), instanceFullPath, 0);
                if (result == null || result.getStatus() == PFDesignForPathStatus.NOT_IN_PATH) {
                    result = this.getDesignForPath(this.currTopDesign, this.currTopDesign.getName(), instanceFullPath.removeLastSegment(), 0);
                    searchForReg = true;
                }
                if ((memory = this.computeElaborationMemory(hierarchyPath = searchForReg ? instanceFullPath.removeLastSegment() : instanceFullPath, result)) != null && (currentInstance = memory.instanceFor(instanceFullPath)) != null && (instance = currentInstance.getDescription()) != null) {
                    if (!searchForReg) {
                        alwaysOnComponents.add(instance);
                    } else {
                        IRfNamedElement module = instance.getAssociatedType();
                        if (module != null) {
                            IRfNamedElement field = DesignUtils.getFieldOrInstanceByName(instanceFullPath.lastSegment(), DesignUtils.DesignRequest.of(module));
                            alwaysOnComponents.add(field);
                        }
                    }
                }
            }
            ++n2;
        }
    }
}

