/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format.cpf;

import java.io.File;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.power.format.DVTPFCommand;
import ro.amiq.dvt.power.format.DVTPFParsedFiles;
import ro.amiq.dvt.power.format.DVTPFSetCurrentFileDummyCommand;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.tcl.model.DVTCommandResult;
import ro.amiq.dvt.tcl.model.DVTDebugKind;
import ro.amiq.dvt.tcl.model.DVTTclUtils;
import ro.amiq.dvt.tcl.model.IDVTCommandType;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclObject;

public class CPFIncludeFileCommand
extends DVTPFCommand {
    private String currParsedPfFile;

    public CPFIncludeFileCommand(IDVTCommandType type) {
        super(type);
    }

    @Override
    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        try {
            super.cmdProc(interp, objv);
            if (this.pfModel == null || this.args == null || this.args.length == 0) {
                return;
            }
            this.args[0].getArgLine();
            this.currParsedPfFile = this.pfModel.getCurrentParsedPfFile();
            DVTCommandResult commandArgs = this.parseCommandArguments(this.currParsedPfFile);
            if (commandArgs == null) {
                return;
            }
            String includedFile = commandArgs.getCommandArg();
            if (includedFile == null) {
                return;
            }
            if (!Path.fromOSString((String)includedFile).isAbsolute()) {
                includedFile = new File(interp.getWorkingDir(), includedFile).getAbsolutePath();
            }
            DVTPFParsedFiles pfInclude = new DVTPFParsedFiles();
            pfInclude.including = interp.scriptFile;
            pfInclude.included = includedFile;
            pfInclude.offset = interp.getOffset(objv[0]);
            pfInclude.includeCommand = this.args[0].getArgName();
            this.pfModel.addPfParsedFile(pfInclude);
            this.pfModel.addPfCommand(new DVTPFSetCurrentFileDummyCommand(includedFile, this.pfModel));
            String message = "    TCL include " + pfInclude.including + " @ " + this.args[0].getArgLine() + " : sourcing " + pfInclude.included;
            DVTTclUtils.printToConsole(message, this.pfModel.getProject(), this.pfModel.getBuildKind(), DVTDebugKind.TCL_DEBUG_INFO, this.pfModel.isDebugMode());
            interp.evalFile(includedFile);
            this.pfModel.addPfCommand(new DVTPFSetCurrentFileDummyCommand(interp.scriptFile, this.pfModel));
        }
        catch (TclException e) {
            throw e;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void executeCommand() {
    }
}

