/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format.cpf;

import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.power.format.DVTPFCommand;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.tcl.model.DVTCommandResult;
import ro.amiq.dvt.tcl.model.IDVTCommandType;

public class CPFSetDesignCommand
extends DVTPFCommand {
    protected String currHierarchySeparator;
    protected IRfDesignElement currTopDesign;
    protected ElementPath currScope;
    protected DVTPFModel.CPFVersionType currVersion;
    protected String currParsedPfFile;

    public CPFSetDesignCommand(IDVTCommandType type) {
        super(type);
    }

    @Override
    public void executeCommand() {
        if (this.pfModel == null || this.args == null || this.args.length == 0) {
            return;
        }
        this.args[0].getArgLine();
        this.currHierarchySeparator = this.pfModel.getHierarchySeparator();
        this.currTopDesign = this.pfModel.getTopDesign();
        this.currScope = this.pfModel.getScope();
        this.currVersion = this.pfModel.getCPFVersion();
        this.currParsedPfFile = this.pfModel.getCurrentParsedPfFile();
        if (!this.checkInitialConditions(true, this.currTopDesign, this.currScope, this.currVersion, this.currParsedPfFile, this.currHierarchySeparator)) {
            return;
        }
        DVTCommandResult commandArgs = this.parseCommandArguments(this.currParsedPfFile);
        if (commandArgs == null) {
            return;
        }
        String topName = this.getTopDependingOnVersion(commandArgs);
        if (topName == null) {
            return;
        }
        IRfDesignElement bcTop = this.getBCTop(topName);
        if (bcTop == null) {
            return;
        }
        ElementPath topPath = ElementPath.from(bcTop + this.currHierarchySeparator, this.currHierarchySeparator);
        this.pfModel.addScope(topPath);
        this.pfModel.setTopDesign(bcTop);
        this.currScope = topPath;
    }

    private String getTopDependingOnVersion(DVTCommandResult commandArgs) {
        if (this.currVersion == DVTPFModel.CPFVersionType.v1_0 || this.currVersion == DVTPFModel.CPFVersionType.v1_1) {
            return commandArgs.getCommandArg();
        }
        String modulesString = commandArgs.getOptionValue("modules");
        if (modulesString == null) {
            return null;
        }
        return "";
    }
}

